/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISlotModel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitType;
import cerent.cms.ocm.DccTunnel;
import cerent.cms.ocm.IOhCircuitState;
import cerent.cms.ocm.IpEncapsulatedTunnel;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.helper.SlotHelper;
import cerent.util.ColorUtil;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class OhCircuitColumnRenderer
extends AbstractColumnRenderer {
    public static final int NAME = 0;
    public static final int TYPE = 1;
    public static final int STATE = 2;
    public static final int SOURCE = 3;
    public static final int DEST = 4;
    public static final int SPANS = 5;
    static final int BY_NAME = 0;
    static final int[][] columns = new int[][]{{0, 1, 2, 3, 4, 5}};
    public static Color ACTIVE_BG = Color.green;
    public static Color ACTIVE_FG = Color.black;
    public static Color STANDBY_BG = new Color(128, 0, 192);
    public static Color STANDBY_FG = Color.white;
    public static String PREFS_CIRCUITS = "ctc.circuits";
    public static String PREFS_ACTIVE_SPAN = "activespan";
    public static String PREFS_STANDBY_SPAN = "standbyspan";
    private JLabel label;
    private JTextArea textArea;
    private int mode;
    private static int EBW;
    private static EmptyBorder emptyBorder;
    private static final SDebug db;

    public static void loadColors() {
        ACTIVE_BG = OhCircuitColumnRenderer.getColorPreference(PREFS_ACTIVE_SPAN, ACTIVE_BG);
        STANDBY_BG = OhCircuitColumnRenderer.getColorPreference(PREFS_STANDBY_SPAN, STANDBY_BG);
        ACTIVE_FG = ACTIVE_BG.getGreen() >= 127 ? Color.black : Color.white;
        STANDBY_FG = STANDBY_BG.getGreen() >= 127 ? Color.black : Color.white;
    }

    private static void preferenceCleanup() {
        String string = "activespan.fg";
        String string2 = "activespan.bg";
        String string3 = "standbyspan.fg";
        String string4 = "standbyspan.bg";
        Preferences preferences = Preferences.instance();
        preferences.removeProperty(PREFS_CIRCUITS, string);
        preferences.removeProperty(PREFS_CIRCUITS, string3);
        String string5 = preferences.getProperty(PREFS_CIRCUITS, string2, null);
        String string6 = preferences.getProperty(PREFS_CIRCUITS, PREFS_ACTIVE_SPAN, null);
        if (string5 != null) {
            if (string6 == null) {
                preferences.setProperty(PREFS_CIRCUITS, PREFS_ACTIVE_SPAN, string5);
            }
            preferences.removeProperty(PREFS_CIRCUITS, string2);
        }
        string5 = preferences.getProperty(PREFS_CIRCUITS, string4, null);
        string6 = preferences.getProperty(PREFS_CIRCUITS, PREFS_STANDBY_SPAN, null);
        if (string5 != null) {
            if (string6 == null) {
                preferences.setProperty(PREFS_CIRCUITS, PREFS_STANDBY_SPAN, string5);
            }
            preferences.removeProperty(PREFS_CIRCUITS, string4);
        }
    }

    private static Color getColorPreference(String string, Color color) {
        String string2 = Preferences.instance().getProperty(PREFS_CIRCUITS, string, null);
        Color color2 = ColorUtil.getColor(string2);
        if (color2 == null) {
            color2 = color;
            String string3 = ColorUtil.getRGBString(color2);
            Preferences.instance().setProperty(PREFS_CIRCUITS, string, string3);
        }
        return color2;
    }

    public OhCircuitColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.textArea = new JTextArea();
        this.textArea.setOpaque(true);
        this.textArea.setForeground(Color.black);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        this.textArea.setLineWrap(true);
        this.label.setBorder(emptyBorder);
        this.textArea.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = this.label;
        this.label.setText("");
        OhCircuit ohCircuit = (OhCircuit)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        try {
            switch (this.mode) {
                case 0: {
                    this.label.setText(ohCircuit.getCircuitName());
                    break;
                }
                case 1: {
                    OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)ohCircuit.getCircuitType());
                    this.label.setText(ohCircuitType == null ? "" : ohCircuitType.getLongName());
                    if (!OhCircuitColumnRenderer.db.on) break;
                    db.finer("Type: " + this.textArea.getText());
                    break;
                }
                case 2: {
                    if (ohCircuit.getState() == 1) {
                        this.label.setText("DISCOVERED");
                        break;
                    }
                    if (ohCircuit.getState() == 4) {
                        this.label.setText("PARTIAL");
                        break;
                    }
                    this.label.setText(EnumStrings.getString((Class)IOhCircuitState.class, (int)ohCircuit.getState()));
                    break;
                }
                case 3: {
                    IOhCircuitEnd[] iOhCircuitEndArray = new IOhCircuitEnd[]{ohCircuit.getSource()};
                    jComponent = this.textArea;
                    this.textArea.setText(OhCircuitColumnRenderer.getEndpoints(iOhCircuitEndArray, ohCircuit, true));
                    if (!OhCircuitColumnRenderer.db.on) break;
                    db.finer("Source: " + this.textArea.getText());
                    break;
                }
                case 4: {
                    IOhCircuitEnd[] iOhCircuitEndArray = ohCircuit.getDestinations().toArray(new IOhCircuitEnd[0]);
                    jComponent = this.textArea;
                    this.textArea.setText(OhCircuitColumnRenderer.getEndpoints(iOhCircuitEndArray, ohCircuit, false));
                    if (!OhCircuitColumnRenderer.db.on) break;
                    db.finer("Destination: " + this.textArea.getText());
                    break;
                }
                case 5: {
                    String string = "  ";
                    string = ohCircuit.getCircuitType() == 6 ? "N/A" : Integer.toString(ohCircuit.numOfSpansUsed());
                    if (OhCircuitColumnRenderer.db.on) {
                        db.finer("Spans: " + this.label.getText());
                    }
                    this.label.setText(string);
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        ((Component)jComponent).setForeground(color);
        ((Component)jComponent).setBackground(color2);
        if (jComponent == this.textArea) {
            int n3 = this.textArea.getPreferredSize().height;
            int n4 = jTable.getRowHeight();
            if (n4 < n3) {
                if (OhCircuitColumnRenderer.db.on) {
                    db.finer("Increasing table row height from " + n4 + " to " + n3);
                }
                jTable.setRowHeight(n3);
            }
        }
        return jComponent;
    }

    public int compareColumn(Object object, Object object2, int n) {
        OhCircuit ohCircuit = (OhCircuit)object;
        OhCircuit ohCircuit2 = (OhCircuit)object2;
        int n2 = 0;
        try {
            switch (this.mode) {
                case 0: {
                    n2 = ohCircuit.getCircuitName().compareTo(ohCircuit2.getCircuitName());
                    break;
                }
                case 1: {
                    n2 = ComparisonUtil.compare((int)ohCircuit.getCircuitType(), (int)ohCircuit2.getCircuitType());
                    break;
                }
                case 2: {
                    n2 = ComparisonUtil.compare((int)ohCircuit.getState(), (int)ohCircuit2.getState());
                    break;
                }
                case 3: {
                    String string = OhCircuitColumnRenderer.getEndpoints(new IOhCircuitEnd[]{ohCircuit.getSource()}, ohCircuit, true);
                    String string2 = OhCircuitColumnRenderer.getEndpoints(new IOhCircuitEnd[]{ohCircuit2.getSource()}, ohCircuit2, true);
                    n2 = string.compareTo(string2);
                    break;
                }
                case 4: {
                    if (ohCircuit.getDestinations().size() == 0 || ohCircuit2.getDestinations().size() == 0) {
                        n2 = ComparisonUtil.compare((int)ohCircuit.getDestinations().size(), (int)ohCircuit2.getDestinations().size());
                        break;
                    }
                    String string = OhCircuitColumnRenderer.getEndpoints(new IOhCircuitEnd[]{ohCircuit.getFirstDestination()}, ohCircuit, false);
                    String string3 = OhCircuitColumnRenderer.getEndpoints(new IOhCircuitEnd[]{ohCircuit2.getFirstDestination()}, ohCircuit2, false);
                    n2 = string.compareTo(string3);
                    break;
                }
                case 5: {
                    n2 = ComparisonUtil.compare((int)ohCircuit.numOfSpansUsed(), (int)ohCircuit2.numOfSpansUsed());
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        return n2;
    }

    public static String getEndpoints(IOhCircuitEnd[] iOhCircuitEndArray, OhCircuit ohCircuit, boolean bl) {
        if (iOhCircuitEndArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        Network network = Network.instance();
        for (int i = 0; i < iOhCircuitEndArray.length; ++i) {
            IOhCircuitEnd iOhCircuitEnd = iOhCircuitEndArray[i];
            if (iOhCircuitEnd == null || iOhCircuitEnd.getNodeId() == 0) continue;
            if (i > 0) {
                stringBuffer.append("\n");
            }
            INetElement iNetElement = network.findNetElem(iOhCircuitEnd.getNodeId());
            stringBuffer.append(OhCircuitColumnRenderer.getEndpoint(iNetElement, iOhCircuitEnd, ohCircuit, bl, true));
        }
        return stringBuffer.toString();
    }

    public static String getEndpoint(INetElement iNetElement, IOhCircuitEnd iOhCircuitEnd, OhCircuit ohCircuit, boolean bl, boolean bl2) {
        IPortModel iPortModel;
        IEntityModel iEntityModel;
        String string;
        String string2 = string = iNetElement != null ? iNetElement.getName() : "<unknown>";
        if (!bl2 || iNetElement == null || iOhCircuitEnd.getPort() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(string);
        stringBuffer.append("/");
        INodeModel iNodeModel = iNetElement.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iEntityTableModel == null) {
            stringBuffer.append("unavailable");
            return stringBuffer.toString();
        }
        try {
            iEntityModel = iEntityTableModel.getEntityModelByIndex(iOhCircuitEnd.getPort());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            stringBuffer.append("unavailable");
            return stringBuffer.toString();
        }
        OhCircuitColumnRenderer.checkToAddShelfInfo(iNodeModel, iEntityModel, stringBuffer);
        OhCircuitColumnRenderer.checkToAddSlotInfo(iNodeModel, iEntityModel, stringBuffer);
        if (iEntityModel instanceof IPortModel) {
            iPortModel = (IPortModel)iEntityModel;
            if (iPortModel.isOptical()) {
                stringBuffer.append("p" + CircuitEndCellRenderer.getPortString(iEntityModel, false, false));
            } else {
                stringBuffer.append(iPortModel.toString());
            }
        }
        if (ohCircuit.getCircuitType() == 4) {
            iPortModel = OhChannelType.getOhChannelTypeObj((int)(bl ? ((DccTunnel)ohCircuit).getSourceChannelType() : ((DccTunnel)ohCircuit).getDestinationChannelType()));
            stringBuffer.append("/" + iPortModel);
        } else if (ohCircuit.getCircuitType() == 6) {
            iPortModel = ((IpEncapsulatedTunnel)ohCircuit).getChannelType();
            stringBuffer.append("/" + iPortModel);
        }
        return stringBuffer.toString();
    }

    static ColumnRenderer[] createTableRenderers(int n) {
        if (n < 0 || n >= columns.length) {
            return null;
        }
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columns[n].length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = OhCircuitColumnRenderer.createOhCircuitColumnRenderer(columns[n][i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createOhCircuitColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Circuit Name";
                n3 = 140;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Type";
                n3 = 130;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Status";
                n3 = 110;
                bl = true;
                n2 = 0;
                break;
            }
            case 3: {
                string = "Source";
                n3 = 185;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Destination";
                n3 = 185;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Spans";
                n3 = 40;
                bl = false;
                n2 = 0;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new OhCircuitColumnRenderer(n, string, n3, bl, n2);
    }

    private static void checkToAddShelfInfo(INodeModel iNodeModel, IEntityModel iEntityModel, StringBuffer stringBuffer) {
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            stringBuffer.append(SlotHelper.getShelfString((IEntityModel)iEntityModel, (String)"sh"));
            stringBuffer.append("/");
        }
    }

    private static void checkToAddSlotInfo(INodeModel iNodeModel, IEntityModel iEntityModel, StringBuffer stringBuffer) {
        IEntityModel iEntityModel2 = iEntityModel;
        while (!(iEntityModel2 instanceof ISlotModel) && iEntityModel2.getEqType() != 237) {
            iEntityModel2 = iEntityModel2.getParent();
        }
        if (iEntityModel2.getEqType() == 237) {
            stringBuffer.append("s" + iEntityModel2.toString() + "/");
        } else {
            stringBuffer.append("s" + iEntityModel2.getPositionInParent() + "/");
        }
    }

    static {
        OhCircuitColumnRenderer.preferenceCleanup();
        EBW = 2;
        emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
        db = new SDebug("OhCircuitColumnRenderer");
    }
}

