/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.model.Attribute;
import cerent.cms.model.LinkModel;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.cms.ui.span.ISpanUpgrade;
import cerent.cms.ui.span.SdEndpointInfo;
import cerent.cms.ui.span.SdEndpointSide;
import cerent.cms.ui.span.SdPpmEndpointSide;
import cerent.cms.ui.span.SpanUpgradeDialog;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public abstract class SdAbstractPane
extends WizardPane
implements ISpanUpgrade {
    protected static int OLD_EQUIPMENT = 0;
    protected static int NEW_EQUIPMENT = 1;
    protected SpanUpgradeDialog parent;
    protected JComboBox portRateCB;
    protected JComboBox srcEqTypeCB;
    protected JComboBox dstEqTypeCB;
    protected JLabel srcLabel;
    protected JLabel dstLabel;
    protected JLabel bigLabel;
    protected LinkModel linkModel;
    protected int step;
    protected static final SDebug db = new SDebug("SdAbstractPane");

    public SdAbstractPane(String string, SpanUpgradeDialog spanUpgradeDialog, int n) {
        super(string, spanUpgradeDialog);
        this.parent = spanUpgradeDialog;
        this.step = n;
        this.linkModel = spanUpgradeDialog.getLinkModel();
        if (n == this.getFirstPageNum()) {
            this.setFirstPane();
        } else {
            this.setNextPane();
        }
    }

    protected abstract int getFirstPageNum();

    protected abstract int getLastPageNum();

    protected JPanel getSelectionPane() {
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.add(new JLabel("Port Rate: "));
        this.portRateCB = new JComboBox(this.parent.getCommonPortRates());
        jPanel.add(this.portRateCB);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        jPanel2.setBorder(BorderFactory.createTitledBorder("New Equipment"));
        this.srcLabel = new JLabel(this.parent.srcInfo.getNodeName() + ": ");
        jPanel2.add(this.srcLabel);
        this.srcEqTypeCB = new JComboBox();
        jPanel2.add(this.srcEqTypeCB);
        this.dstLabel = new JLabel(this.parent.dstInfo.getNodeName() + ": ");
        jPanel2.add(this.dstLabel);
        this.dstEqTypeCB = new JComboBox();
        jPanel2.add(this.dstEqTypeCB);
        this.portRateCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SdAbstractPane.this.retrieveUpgradeEqTypes();
            }
        });
        this.retrieveUpgradeEqTypes();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(jPanel3);
        return jPanel4;
    }

    private void retrieveUpgradeEqTypes() {
        Attribute attribute = (Attribute)this.portRateCB.getSelectedItem();
        Vector vector = this.parent.getAvailEquipmentsA(attribute.getIntValue());
        Vector vector2 = this.parent.getAvailEquipmentsB(attribute.getIntValue());
        this.srcEqTypeCB.setModel(new DefaultComboBoxModel(vector));
        this.dstEqTypeCB.setModel(new DefaultComboBoxModel(vector2));
    }

    protected JPanel getTopPane() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = this.getTopMessage();
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    protected abstract String getTopMessage();

    protected String getSrcUpgradeEqTypeString() {
        if (this.parent.getSrcUpgradeType() == SpanUpgradeDialog.PPM_2_PPM_UPGRADE) {
            return "port rate";
        }
        return "card";
    }

    protected String getDstUpgradeEqTypeString() {
        if (this.parent.getDstUpgradeType() == SpanUpgradeDialog.PPM_2_PPM_UPGRADE) {
            return "port rate";
        }
        return "card";
    }

    private JPanel getBottomPane() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "When you are ready, click the Next button.";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private void setFirstPane() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.getTopPane());
        this.add(this.getSelectionPane());
        this.add(this.getBottomPane());
    }

    private void setNextPane() {
        this.setLayout(new FlowLayout(0));
        this.add(this.getDescPane());
    }

    public JPanel getDescPane() {
        JPanel jPanel = new JPanel();
        this.bigLabel = new JLabel();
        this.bigLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(this.bigLabel);
        return jPanel;
    }

    protected abstract String getDesc();

    public void refresh() {
        this.parent.setObserverPane(this);
        this.parent.setBackEnabled(this.step == 2);
        if (this.bigLabel != null) {
            this.bigLabel.setText(this.getDesc());
        }
        if (this.step == this.getLastPageNum()) {
            this.parent.setFinishEnabled(true);
            this.parent.setCancelEnabled(false);
        }
    }

    protected String getStatusText() {
        return this.parent.getStatusText();
    }

    protected String getWorkingSlotString(SdEndpointInfo sdEndpointInfo) {
        return this.getWorkingSlotString(sdEndpointInfo, "");
    }

    protected String getWorkingSlotString(SdEndpointInfo sdEndpointInfo, String string) {
        return string + sdEndpointInfo.getSlotString(1);
    }

    protected String getProtectSlotString(SdEndpointInfo sdEndpointInfo) {
        return this.getProtectSlotString(sdEndpointInfo, "");
    }

    protected String getProtectSlotString(SdEndpointInfo sdEndpointInfo, String string) {
        if (sdEndpointInfo.existProtectSide()) {
            return string + sdEndpointInfo.getSlotString(2);
        }
        return "";
    }

    protected String getSlotString(SdEndpointInfo sdEndpointInfo) {
        return this.getSlotString(sdEndpointInfo, "");
    }

    protected String getSlotString(SdEndpointInfo sdEndpointInfo, String string) {
        String string2 = this.getWorkingSlotString(sdEndpointInfo, string);
        if (sdEndpointInfo.existProtectSide()) {
            string2 = string2 + "\n" + this.getProtectSlotString(sdEndpointInfo, string);
        }
        return string2;
    }

    protected boolean bothNodesInitiated() {
        return this.parent.srcInfo.getNodeModel().isInited() && this.parent.dstInfo.getNodeModel().isInited();
    }

    protected void checkNodeInitiations() throws Exception {
        if (!this.bothNodesInitiated()) {
            throw new Exception("A system or network condition is preventing Span Upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
        }
    }

    private Map getAffectedEquipmentMapInChange(boolean bl, List list) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ArrayList<String> arrayList;
            String string;
            SdEndpointSide sdEndpointSide = (SdEndpointSide)iterator.next();
            if (db.on()) {
                db.fine("old=" + sdEndpointSide.getOldEquipmentType());
                db.fine("forNewEquipment=" + bl);
            }
            String string2 = EqTypeHelper.getPortRateString((TDMTerminology)this.parent.terms, (int)(bl ? sdEndpointSide.getNewEquipmentType() : sdEndpointSide.getOldEquipmentType()));
            if (sdEndpointSide instanceof SdPpmEndpointSide) {
                string = "PPM";
                if (bl) {
                    string = string2 + " supported " + string;
                }
            } else {
                string = string2;
            }
            if (db.on()) {
                db.fine("keyString=" + string);
            }
            if ((arrayList = (ArrayList<String>)hashMap.get(string)) == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(sdEndpointSide.getSlotString());
        }
        return hashMap;
    }

    protected String getEquipmentChangeString(int n, int n2, String string, String string2) {
        boolean bl = n == NEW_EQUIPMENT;
        List list = this.parent.getAllEndpointSidesNeedEqUpgrade(n2);
        Map map = this.getAffectedEquipmentMapInChange(bl, list);
        return this.getEquipmentChangeString(map, string, string2);
    }

    protected String getEquipmentChangeString(int n, String string, String string2) {
        boolean bl = n == NEW_EQUIPMENT;
        List list = this.parent.getAllEndpointSidesNeedEqUpgrade();
        Map map = this.getAffectedEquipmentMapInChange(bl, list);
        return this.getEquipmentChangeString(map, string, string2);
    }

    private String getEquipmentChangeString(Map map, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(string);
            String string3 = (String)iterator.next();
            List list = (List)map.get(string3);
            if (string3.indexOf("PPM") != -1) {
                stringBuffer.append(" " + PluralisationUtil.pluralise(string3, list.size()) + " ");
            } else {
                stringBuffer.append(" " + string3 + " " + PluralisationUtil.pluralise("card", list.size()) + " ");
            }
            stringBuffer.append(string2 + " " + PluralisationUtil.pluralise("slot", list.size()) + ":\n \n");
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append((String)iterator2.next() + "\n");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" \n");
        }
        return stringBuffer.toString();
    }

    protected String getStringForAffectedSlots(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.parent.getAllEndpointSidesNeedEqUpgrade().iterator();
        while (iterator.hasNext()) {
            SdEndpointSide sdEndpointSide = (SdEndpointSide)iterator.next();
            stringBuffer.append(string + sdEndpointSide.getSlotString() + "\n");
        }
        return stringBuffer.toString();
    }

    public int getNextStepNum() throws Exception {
        return this.step + 1;
    }
}

