/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tl1;

import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.text.BadLocationException;

class HistoryItem {
    private static final SDebug db = new SDebug("Tl1PasswordHiding");
    private final StringBuffer _value;
    private String _hidden;
    private static final String actUserCmd = "act-user";
    private static final String actUserHelp = "act-user:[tid]:[string]:ctag::[string]";
    private static final String edPidCmd = "ed-pid";
    private static final String edPidHelp = "ed-pid:[tid]:<uid>:[ctag]::<oldpid>,<newpid>";
    private static final String edUserSecuCmd = "ed-user-secu";
    private static final String edUserSecuHelp = "ed-user-secu:[tid]:<uid>:[ctag]::[<newuid>],[<newpid>],,[<uap>]:";
    private static final String entUserSecuCmd = "ent-user-secu";
    private static final String entUserSecuHelp = "ent-user-secu:[tid]:<uid>:[ctag]::<pid>,,<uap>:";
    private static final String urlParam = "://";

    HistoryItem(String string) {
        String string2 = HistoryItem.hideActUser(string.toLowerCase(), string, true);
        string2 = HistoryItem.hideEdPid(string2.toLowerCase(), string2, true);
        string2 = HistoryItem.hideEdUserSecu(string2.toLowerCase(), string2, true);
        string2 = HistoryItem.hideEntUserSecu(string2.toLowerCase(), string2, true);
        string2 = HistoryItem.hideUrlPasswords(string2.toLowerCase(), string2, true);
        this._value = new StringBuffer(string2);
        this._hidden = null;
    }

    void insertString(int n, String string) throws BadLocationException {
        try {
            this._value.insert(n, string);
            this._hidden = null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new BadLocationException(stringIndexOutOfBoundsException.getMessage(), n);
        }
    }

    void remove(int n, int n2) throws BadLocationException {
        try {
            this._value.delete(n, n + n2);
            this._hidden = null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new BadLocationException(stringIndexOutOfBoundsException.getMessage(), n);
        }
    }

    String value() {
        return this._value.toString();
    }

    boolean savable() {
        return this._value.toString().equals(this.toString());
    }

    public String toString() {
        if (this._hidden == null) {
            this._hidden = HistoryItem.hidePasswords(this._value.toString());
        }
        return this._hidden;
    }

    private static int indexOf(String string, int n, char c, int n2) {
        int n3 = 0;
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) != c || ++n3 != n2) continue;
            return i;
        }
        return -1;
    }

    private static String replacePassword(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        for (int i = n; i <= n2; ++i) {
            stringBuffer.append("*");
        }
        stringBuffer.append(string.substring(n2 + 1));
        return stringBuffer.toString();
    }

    private static String replacePassword(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        stringBuffer.append(string.substring(0, n));
        for (int i = n; i < n2; ++i) {
            stringBuffer.append("*");
        }
        return stringBuffer.toString();
    }

    private static String removePassword(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string.substring(n2 + 1));
        return stringBuffer.toString();
    }

    private static String removePassword(String string, int n) {
        return string.substring(0, n);
    }

    private static void addCmdEnd(ArrayList arrayList, String string, char c, int n) {
        int n2 = string.indexOf(c, n);
        if (n2 != -1) {
            arrayList.add(new Integer(n2));
        }
    }

    private static void addCmdEnd(ArrayList arrayList, String string, String string2, int n) {
        int n2 = string.indexOf(string2, n);
        if (n2 != -1) {
            arrayList.add(new Integer(n2));
        }
    }

    private static int findCmdEnd(String string, int n) {
        ArrayList arrayList = new ArrayList();
        HistoryItem.addCmdEnd(arrayList, string, ';', n);
        HistoryItem.addCmdEnd(arrayList, string, '?', n);
        HistoryItem.addCmdEnd(arrayList, string, "\n>", n);
        HistoryItem.addCmdEnd(arrayList, string, "\nsyntax:", n);
        HistoryItem.addCmdEnd(arrayList, string, "\nmessages:", n);
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            return (Integer)arrayList.get(0);
        }
        return -1;
    }

    private static int findDelimiter(String string, int n, String string2) {
        int n2 = HistoryItem.findCmdEnd(string, n);
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n3 = string.indexOf(c, n);
            if (n2 != -1) {
                if (n3 == -1) continue;
                n2 = Math.min(n2, n3);
                continue;
            }
            n2 = n3;
        }
        return n2;
    }

    private static String hideActUser(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = string.indexOf(actUserCmd, n);
        if (n2 != -1) {
            String string3 = string.substring(n2);
            if (db.on()) {
                db.println("found ACT-USER");
            }
            if (!string3.startsWith(actUserHelp)) {
                int n3 = HistoryItem.indexOf(string, n2, ':', 5);
                if (db.on()) {
                    db.println(" not ACT-USER help string");
                }
                if (n3 != -1) {
                    int n4 = HistoryItem.findCmdEnd(string, n2);
                    if (db.on()) {
                        db.println(" found 5th ':' at " + n3);
                    }
                    if (n4 != -1) {
                        if (db.on()) {
                            db.println(" found cmdend at " + n4);
                        }
                        if (n3 < n4) {
                            if (db.on()) {
                                db.println(" replacing " + (n3 + 1) + " to " + (n4 - 1));
                            }
                            string2 = bl ? HistoryItem.removePassword(string2, n3 + 1, n4 - 1) : HistoryItem.replacePassword(string2, n3 + 1, n4 - 1);
                        } else if (db.on()) {
                            db.println(" start after cmdend, ignoring");
                        }
                    } else {
                        if (db.on()) {
                            db.println(" no cmdend, replacing to end");
                        }
                        string2 = bl ? HistoryItem.removePassword(string2, n3 + 1) : HistoryItem.replacePassword(string2, n3 + 1);
                    }
                } else if (db.on()) {
                    db.println(" no 5th ':'");
                }
            } else if (db.on()) {
                db.println(" found ACT-USER help string");
            }
        }
        return string2;
    }

    private static String hideEdPid(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = string.indexOf(edPidCmd, n);
        if (n2 != -1) {
            String string3 = string.substring(n2);
            if (db.on()) {
                db.println("found ED-PID");
            }
            if (!string3.startsWith(edPidHelp)) {
                int n3 = HistoryItem.indexOf(string, n2, ':', 5);
                if (db.on()) {
                    db.println(" not ED-PID help string");
                }
                if (n3 != -1) {
                    int n4 = HistoryItem.findCmdEnd(string, n2);
                    int n5 = string.indexOf(44, n2);
                    if (db.on()) {
                        db.println(" found 5th ':' at " + n3);
                    }
                    if (n5 != -1) {
                        if (db.on()) {
                            db.println(" found ',' for oldpid at " + n5);
                        }
                        if (n4 == -1 || n3 < n4 && n5 < n4) {
                            if (db.on()) {
                                db.println(" replacing oldpid " + (n3 + 1) + " to " + (n5 - 1));
                            }
                            string2 = bl ? HistoryItem.removePassword(string2, n3 + 1, n5 - 1) : HistoryItem.replacePassword(string2, n3 + 1, n5 - 1);
                        } else if (db.on()) {
                            db.println(" couldn't find oldpid's ','");
                        }
                        n3 = n5;
                        if (n4 != -1) {
                            if (db.on()) {
                                db.println(" found cmdend at " + n4);
                            }
                            if (n3 < n4) {
                                if (db.on()) {
                                    db.println(" replacing newpid " + (n3 + 1) + " to " + (n4 - 1));
                                }
                                if (bl) {
                                    n3 = string2.indexOf(44, n2);
                                    n4 = HistoryItem.findCmdEnd(string2, n2);
                                    string2 = HistoryItem.removePassword(string2, n3 + 1, n4 - 1);
                                } else {
                                    string2 = HistoryItem.replacePassword(string2, n3 + 1, n4 - 1);
                                }
                            } else if (db.on()) {
                                db.println(" start after cmdend, ignoring");
                            }
                        } else {
                            if (db.on()) {
                                db.println(" no cmdend, replacing to end");
                            }
                            if (bl) {
                                n3 = string2.indexOf(44, n2);
                                string2 = HistoryItem.removePassword(string2, n3 + 1);
                            } else {
                                string2 = HistoryItem.replacePassword(string2, n3 + 1);
                            }
                        }
                    } else if (n4 != -1) {
                        if (db.on()) {
                            db.println(" no ',', replacing " + (n3 + 1) + " to " + (n4 - 1));
                        }
                        string2 = bl ? HistoryItem.removePassword(string2, n3 + 1, n4 - 1) : HistoryItem.replacePassword(string2, n3 + 1, n4 - 1);
                    } else {
                        if (db.on()) {
                            db.println(" no ',', replacing to end");
                        }
                        string2 = bl ? HistoryItem.removePassword(string2, n3 + 1) : HistoryItem.replacePassword(string2, n3 + 1);
                    }
                } else if (db.on()) {
                    db.println(" no 5th ':'");
                }
            } else if (db.on()) {
                db.println(" found ED-PID help string");
            }
        }
        return string2;
    }

    private static String hideEdUserSecu(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = string.indexOf(edUserSecuCmd, n);
        if (n2 != -1) {
            String string3 = string.substring(n2);
            if (db.on()) {
                db.println("found ED-USER-SECU");
            }
            if (!string3.startsWith(edUserSecuHelp)) {
                int n3 = HistoryItem.indexOf(string, n2, ':', 5);
                if (db.on()) {
                    db.println(" not ED-USER-SECU help string");
                }
                if (n3 != -1) {
                    int n4 = HistoryItem.findCmdEnd(string, n2);
                    int n5 = string.indexOf("password", n3);
                    int n6 = -1;
                    if (db.on()) {
                        db.println(" found 5th ':' at " + n3);
                    }
                    if (n5 != -1) {
                        n5 = string.indexOf(61, n5);
                        if (db.on()) {
                            db.println(" lnc syntax");
                        }
                        if (n5 != -1) {
                            n6 = string.indexOf(44, n5);
                        }
                    } else {
                        n5 = string.indexOf(44, n2);
                        if (db.on()) {
                            db.println(" mmx syntax");
                        }
                        if (n5 != -1) {
                            n6 = HistoryItem.indexOf(string, n2, ',', 2);
                        }
                    }
                    if (n5 != -1 && (n4 == -1 || n5 < n4)) {
                        if (n6 != -1 && (n4 == -1 || n6 < n4)) {
                            if (db.on()) {
                                db.println(" start&end replacing " + (n5 + 1) + " to " + (n6 - 1));
                            }
                            string2 = bl ? HistoryItem.removePassword(string2, n5 + 1, n6 - 1) : HistoryItem.replacePassword(string2, n5 + 1, n6 - 1);
                        } else if (n4 != -1) {
                            if (db.on()) {
                                db.println(" cmdend replacing " + (n5 + 1) + " to " + (n6 - 1));
                            }
                            string2 = bl ? HistoryItem.removePassword(string2, n5 + 1, n4 - 1) : HistoryItem.replacePassword(string2, n5 + 1, n4 - 1);
                        } else {
                            if (db.on()) {
                                db.println(" keyend replacing " + (n5 + 1) + " to " + (n6 - 1));
                            }
                            string2 = bl ? HistoryItem.removePassword(string2, n5 + 1) : HistoryItem.replacePassword(string2, n5 + 1);
                        }
                    } else if (db.on()) {
                        db.println(" no keystart, skipping");
                    }
                } else if (db.on()) {
                    db.println(" no 5th ':'");
                }
            } else if (db.on()) {
                db.println(" found ED-USER-SECU help string");
            }
        }
        return string2;
    }

    private static String hideEntUserSecu(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = string.indexOf(entUserSecuCmd, n);
        if (n2 != -1) {
            String string3 = string.substring(n2);
            if (db.on()) {
                db.println("found ENT-USER-SECU");
            }
            if (!string3.startsWith(entUserSecuHelp)) {
                int n3 = HistoryItem.indexOf(string, n2, ':', 5);
                if (db.on()) {
                    db.println(" not ENT-USER-SECU help string");
                }
                if (n3 != -1) {
                    int n4 = HistoryItem.findCmdEnd(string, n2);
                    int n5 = string.indexOf(44, n2);
                    if (db.on()) {
                        db.println(" found 5th ':' at " + n3);
                    }
                    if (n5 != -1) {
                        if (db.on()) {
                            db.println(" found ','");
                        }
                        if (n4 == -1 || n3 < n4) {
                            if (db.on()) {
                                db.println(" replacing " + (n3 + 1) + " to " + (n5 - 1));
                            }
                            string2 = bl ? HistoryItem.removePassword(string2, n3 + 1, n5 - 1) : HistoryItem.replacePassword(string2, n3 + 1, n5 - 1);
                        } else if (db.on()) {
                            db.println(" start after cmdend, ignoring");
                        }
                    } else if (n4 != -1) {
                        if (db.on()) {
                            db.println(" no ',', replacing " + (n3 + 1) + " to " + (n4 - 1));
                        }
                        string2 = bl ? HistoryItem.removePassword(string2, n3 + 1, n4 - 1) : HistoryItem.replacePassword(string2, n3 + 1, n4 - 1);
                    } else {
                        if (db.on()) {
                            db.println(" no ',', replacing " + (n3 + 1) + " to end");
                        }
                        string2 = bl ? HistoryItem.removePassword(string2, n3 + 1) : HistoryItem.replacePassword(string2, n3 + 1);
                    }
                } else if (db.on()) {
                    db.println(" no 5th ':'");
                }
            } else if (db.on()) {
                db.println(" found ENT-USER-SECU help string");
            }
        }
        return string2;
    }

    private static String hideUrlPasswords(String string, String string2, boolean bl) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf(urlParam, n2)) != -1) {
            int n3;
            if (db.on()) {
                db.println("found URL");
            }
            if ((n3 = string.indexOf(58, n + urlParam.length())) != -1) {
                int n4 = HistoryItem.findDelimiter(string, n3 + 1, "@/\",");
                if (db.on()) {
                    db.println(" found ':' at " + n3);
                }
                if (n3 < n4) {
                    if (db.on()) {
                        db.println(" replacing " + (n3 + 1) + " to " + (n4 - 1));
                    }
                    if (bl) {
                        string2 = HistoryItem.removePassword(string2, n3 + 1, n4 - 1);
                        string = HistoryItem.removePassword(string, n3 + 1, n4 - 1);
                    } else {
                        string2 = HistoryItem.replacePassword(string2, n3 + 1, n4 - 1);
                    }
                }
                if (n4 != -1) {
                    if (db.on()) {
                        db.println(" start after cmdend, ignoring");
                    }
                } else {
                    if (db.on()) {
                        db.println(" no cmdend, replacing to end");
                    }
                    if (bl) {
                        string2 = HistoryItem.removePassword(string2, n3 + 1);
                        string = HistoryItem.removePassword(string, n3 + 1);
                    } else {
                        string2 = HistoryItem.replacePassword(string2, n3 + 1);
                    }
                }
            } else if (db.on()) {
                db.println(" no ':'");
            }
            n2 = n + urlParam.length();
        }
        return string2;
    }

    static String hidePasswords(String string) {
        String string2 = string.toLowerCase();
        if (db.on()) {
            db.println("-=-=-=-=-=-=-=-=-=-=-\n" + string + "\n-=-=-=-=-=-=-=-=-=-=-\n");
        }
        string = HistoryItem.hideActUser(string2, string, false);
        string = HistoryItem.hideEdPid(string2, string, false);
        string = HistoryItem.hideEdUserSecu(string2, string, false);
        string = HistoryItem.hideEntUserSecu(string2, string, false);
        string = HistoryItem.hideUrlPasswords(string2, string, false);
        return string;
    }
}

