/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tl1;

import cerent.cms.ui.tl1.HistoryBox;
import cerent.cms.ui.tl1.HistoryItem;
import cerent.cms.ui.tl1.MessageBox;
import cerent.cms.ui.tl1.RequestBox;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KEMC;
import cerent.util.SDebug;
import cerent.util.gui.UFrame;
import cerent.util.terminal.IDataProcessor;
import cerent.util.terminal.IReaderThread;
import cerent.util.terminal.SshReaderThread;
import cerent.util.terminal.TelnetReaderThread;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;

public class TL1ClientPanel
extends JPanel
implements IDataProcessor,
WindowListener {
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private HistoryBox tl1History;
    private MessageBox tl1Message;
    private RequestBox tl1Request;
    private String host;
    private int port;
    private IReaderThread readerThread;
    private String activeCmd;
    private boolean connected = false;
    private boolean secure;
    private static boolean debug = false;
    private static SDebug db = new SDebug("TL1ClientPanel");
    private final byte IAC = (byte)-1;
    private final byte WILL = (byte)-5;
    private final byte DO = (byte)-4;
    private final byte WONT = (byte)-3;
    private final byte DONT = (byte)-2;

    public TL1ClientPanel(String string, int n, boolean bl) {
        this.host = string;
        this.port = n;
        this.secure = bl;
        this.tl1History = new HistoryBox(this);
        this.tl1Message = new MessageBox(this);
        this.tl1Request = new RequestBox(this);
        this.displayComponent();
    }

    private void displayComponent() {
        this.tl1History.display();
        this.tl1Message.display();
        this.tl1Request.display();
        this.setLayout(this.gbl);
        Insets insets = new Insets(0, 3, 0, 3);
        Insets insets2 = new Insets(3, 3, 3, 3);
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.5;
        this.gbc.gridwidth = 10;
        this.gbc.insets = insets;
        this.add((Component)this.tl1History.getClientPanel(), this.gbc);
        this.gbc.fill = 1;
        this.gbc.gridy = 1;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 10;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = insets2;
        this.add((Component)this.tl1Message.getClientPanel(), this.gbc);
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.gridy = 2;
        this.gbc.gridx = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = 10;
        this.gbc.insets = insets;
        this.add((Component)this.tl1Request.getClientPanel(), this.gbc);
    }

    public void disposed(Object object) {
        this.disconnect();
    }

    public void setTl1RequestText(HistoryItem historyItem) {
        this.tl1Request.setTl1RequestText(historyItem);
    }

    public void execCommand(String string) {
        this.tl1Request.executeCommand(string);
    }

    public void appendToHistoryLog(String string) {
        this.tl1History.addToHistory(string, true);
    }

    public void appendToMessageLog(String string) {
        this.tl1Message.appendText(string);
    }

    public void loadHistory(File file) {
        this.tl1History.loadHistory(file);
    }

    public void appendToSummaryLog(String string) {
        this.tl1Message.appendSummary(string);
    }

    public synchronized void write(String string) {
        if (!this.connected) {
            this.printlnError("\nTry to connect...");
            try {
                this.connect();
            }
            catch (Exception exception) {
                db.println("Exeception: " + exception);
                this.printlnError("\nFailed to connect.");
                return;
            }
        }
        if (this.connected && this.readerThread != null) {
            try {
                String string2 = string + this.tl1Request.getReqEnd();
                if (string.length() > 0) {
                    this.readerThread.write(string2);
                    db.fine("Wrote '" + string2 + "' to readerThread");
                    this.setTl1RequestText(null);
                }
            }
            catch (IOException iOException) {
                this.printlnError("\nError: " + iOException.toString());
                this.disconnect();
            }
        } else {
            this.printlnError("\nNot Connected yet");
            this.disconnect();
        }
    }

    public void printlnError(String string) {
        this.tl1Message.appendText(string + '\n');
    }

    public void incomingData(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        this.appendToMessageLog(new String(byArray, 0, n));
        db.fine("Read '" + new String(byArray, 0, n) + "' from readerThread");
    }

    public void terminated(Object object) {
        this.disconnect();
    }

    public synchronized void connect() throws IOException {
        if (this.readerThread == null) {
            try {
                this.readerThread = this.secure ? new SshReaderThread() : new TelnetReaderThread();
                this.readerThread.connect(this.host, this.port, "", "", (IDataProcessor)this, true);
                this.tl1Request.setConnectButtonEnabled(false);
                this.tl1Request.setDisconnectButtonEnabled(true);
                this.connected = true;
            }
            catch (IOException iOException) {
                this.disconnect();
                throw iOException;
            }
        }
    }

    public synchronized void disconnect() {
        if (this.readerThread != null) {
            this.connected = false;
            try {
                this.readerThread.disconnect();
                this.readerThread = null;
            }
            catch (IOException iOException) {
                ErrorMsg.displayError((Component)this, (EID)KEMC.EID_TERMINAL_DISCONNECT_EXCEPTION, (Object)"TL1");
            }
        }
        this.tl1Request.setConnectButtonEnabled(true);
        this.tl1Request.setDisconnectButtonEnabled(false);
    }

    public static void main(String[] stringArray) {
        String string;
        String string2;
        boolean bl;
        if (stringArray.length < 2) {
            db.println("Wrong parameters [-s] <hostname> <port> [history-fil]");
            System.exit(-1);
        }
        String string3 = null;
        int n = 0;
        if (stringArray.length > 2 && stringArray[0].equalsIgnoreCase("-s")) {
            bl = true;
            string2 = stringArray[1];
            string = stringArray[2];
            if (stringArray.length > 3) {
                string3 = stringArray[3];
            }
        } else {
            bl = false;
            string2 = stringArray[0];
            string = stringArray[1];
            if (stringArray.length > 2) {
                string3 = stringArray[2];
            }
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            db.println("Wrong type of parameter");
            System.exit(-2);
        }
        File file = null;
        file = string3 != null ? new File(string3) : null;
        TL1ClientPanel tL1ClientPanel = new TL1ClientPanel(string2, n, bl);
        UFrame uFrame = new UFrame(tL1ClientPanel, "TL1ClientPanel: " + string2, true);
        uFrame.setSize(790, 600);
        uFrame.show();
        try {
            tL1ClientPanel.connect();
        }
        catch (IOException iOException) {
            tL1ClientPanel.printlnError("createTL1Panel: tcp.connect() raised " + iOException.toString());
        }
        tL1ClientPanel.loadHistory(file);
        uFrame.validate();
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (db.on()) {
            db.println("activated");
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (db.on()) {
            db.println("closed");
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (db.on()) {
            db.println("closing");
        }
        this.disconnect();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if (db.on()) {
            db.println("deactivated");
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (db.on()) {
            db.println("deiconified");
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        if (db.on()) {
            db.println("iconified");
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
        if (db.on()) {
            db.println("opened");
        }
    }
}

