/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IVlanModel;
import cerent.cms.topo.ITopology;
import cerent.cms.topo.Network;
import cerent.cms.ui.NetVlanInfoCellRenderer;
import cerent.cms.ui.vlan.VlanCreationDialog;
import cerent.cms.vlan.NetVlanInfo;
import cerent.cms.vlan.NetVlanInfoComparator;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class VlanSetDialog
extends UDialog
implements ActionListener,
Observer {
    public static final String TITLE = "All VLANs";
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    public static final String CLOSE = "Close";
    private JButton createButton;
    private JButton deleteButton;
    private JButton closeButton;
    private static VlanSetManager vsm = VlanSetManager.instance();
    private DefaultListModel vlanListModel;
    private JList vlanList;
    private static int LIST_ROW_COUNT = 6;

    public static VlanSetDialog instance(Frame frame) {
        return new VlanSetDialog(frame);
    }

    private VlanSetDialog(Frame frame) {
        super(frame, TITLE, true);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.getMainPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        vsm.addObserver(this);
        this.refreshList();
    }

    private JComponent getMainPanel() {
        this.vlanListModel = new DefaultListModel();
        this.vlanList = new JList(this.vlanListModel);
        this.vlanList.setCellRenderer(new NetVlanInfoCellRenderer());
        this.vlanList.setPrototypeCellValue("Administration (42)");
        this.vlanList.setVisibleRowCount(LIST_ROW_COUNT);
        return new UScrollPane((Component)this.vlanList);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.createButton = this.makeActionButton(CREATE);
        jPanel.add(this.createButton);
        this.deleteButton = this.makeActionButton(DELETE);
        jPanel.add(this.deleteButton);
        this.closeButton = this.makeActionButton(CLOSE);
        jPanel.add(this.closeButton);
        return jPanel;
    }

    private void refreshList() {
        TreeSet treeSet = new TreeSet(new NetVlanInfoComparator());
        treeSet.addAll(VlanSetManager.instance().allNetVlansList());
        this.vlanListModel.setSize(treeSet.size());
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.vlanListModel.setElementAt(iterator.next(), n++);
        }
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createButton) {
            VlanCreationDialog.instance((Component)((Object)this)).show();
        } else if (object == this.deleteButton) {
            this.deleteSelectedVlans();
        } else if (object == this.closeButton) {
            this.dispose();
        }
    }

    public void dispose() {
        vsm.deleteObserver(this);
        super.dispose();
    }

    private void deleteSelectedVlans() {
        ListSelectionModel listSelectionModel = this.vlanList.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_VLANS_SELECTED);
            return;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Really delete selected VLAN" + (n < n2 ? "s?" : "?")), (String)"Delete VLANs")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            NetVlanInfo netVlanInfo = (NetVlanInfo)this.vlanListModel.getElementAt(i);
            IVlanModel iVlanModel = netVlanInfo.vlan;
            if (iVlanModel.getId() == VlanSetManager.DEFAULT_VLAN_ID) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_DELETE_DEFAULT_VLAN);
                continue;
            }
            try {
                Map map = Network.instance().getTopologyMap();
                ITopology iTopology = (ITopology)map.get(new Integer(netVlanInfo.topoId));
                vsm.deleteVlan(iVlanModel, iTopology);
                this.vlanListModel.removeElementAt(i);
                --i;
                continue;
            }
            catch (Exception exception) {
                stringBuffer.append(NetVlanInfoCellRenderer.getString(netVlanInfo, false));
                stringBuffer.append(": ");
                stringBuffer.append(exception.getMessage());
                stringBuffer.append("\n");
            }
        }
        if (stringBuffer.length() > 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_DELETING_VLANS_PARAM_1, (Object)stringBuffer.toString());
        }
        listSelectionModel.clearSelection();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof VlanSetManager) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VlanSetDialog.this.refreshList();
                }
            });
        }
    }
}

