/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DebugManager;
import cerent.util.SDebug;
import cerent.util.gui.UFrame;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JPanel;

public class ImageCanvas
extends JPanel {
    protected Image myImage;
    protected int myHeight;
    protected int myWidth;
    protected static final int MARGIN = 5;
    private static final SDebug db = new SDebug("ImageCanvas");

    public ImageCanvas(String string) {
        URL uRL = ImageCanvas.class.getResource(string);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.myImage = toolkit.getImage(uRL);
        this.pullImageBits();
    }

    public ImageCanvas(Image image) {
        this.myImage = image;
        this.pullImageBits();
    }

    protected void pullImageBits() {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.myImage, 99);
        try {
            mediaTracker.waitForID(99);
            this.myWidth = this.myImage.getWidth(this) + 10;
            this.myHeight = this.myImage.getHeight(this) + 10;
            if (db.on()) {
                db.println("showAltImage: " + this.myWidth + " x " + this.myHeight);
            }
            this.setSize(this.myWidth, this.myHeight);
        }
        catch (Exception exception) {
            DebugManager.instance();
            DebugManager.printStackTrace((Throwable)exception);
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.myImage, 5, 5, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.myWidth + 5, this.myHeight + 5);
    }

    public static void main(String[] stringArray) {
        String string = "/images/cisco.gif";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            ImageCanvas imageCanvas = new ImageCanvas(string);
            UFrame uFrame = new UFrame(imageCanvas, "ImageCanvas unit test", true);
            uFrame.display();
        }
        catch (Exception exception) {
            DebugManager.instance();
            DebugManager.printStackTrace((Throwable)exception);
        }
    }
}

