/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Slider
extends JPanel
implements ChangeListener {
    private JSlider slider;
    private JLabel titleLabel;
    private JLabel valueLabel;
    private String prefix;
    private String suffix;
    private int divider;
    private JPanel labelPanel;

    public Slider(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(new BorderLayout());
        this.prefix = string2;
        this.suffix = string3;
        if (this.prefix == null) {
            this.prefix = "";
        }
        if (this.suffix == null) {
            this.suffix = "";
        }
        this.divider = 1;
        while (n7 > 0) {
            this.divider *= 10;
            --n7;
        }
        this.valueLabel = new JLabel("", 0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont(1));
        this.valueLabel.setToolTipText(string4);
        this.slider = new JSlider(n, n3, n4, n2);
        this.setValue(n3);
        Dimension dimension = this.valueLabel.getPreferredSize();
        this.setValue(n4);
        Dimension dimension2 = this.valueLabel.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        this.valueLabel.setPreferredSize(dimension3);
        this.valueLabel.setMinimumSize(dimension3);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMajorTickSpacing(n6);
        this.slider.setMinorTickSpacing(n5);
        this.slider.setToolTipText(string4);
        this.slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.slider.addChangeListener(this);
        if (string != null) {
            this.labelPanel = new JPanel(new GridLayout(2, 1));
            this.titleLabel = new JLabel(string, 0);
            this.labelPanel.add(this.titleLabel);
        } else {
            this.labelPanel = new JPanel(new GridLayout(1, 1));
        }
        this.labelPanel.add(this.valueLabel);
        this.add((Component)this.labelPanel, "North");
        this.add(this.slider);
        this.setValue(n2);
        if (this.divider > 1) {
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            for (int i = n3; i <= n4; ++i) {
                if ((i - n3) % n6 != 0) continue;
                hashtable.put(new Integer(i), new JLabel(this.getDisplay(i)));
            }
            this.slider.setLabelTable(hashtable);
        }
    }

    private String getDisplay(int n) {
        if (n == 0) {
            return " 0";
        }
        double d = n;
        d /= (double)this.divider;
        if (n > 0) {
            return " " + Double.toString(d);
        }
        return Double.toString(d);
    }

    public void setLabelsBackground(Color color) {
        if (color != null) {
            this.labelPanel.setOpaque(true);
            this.labelPanel.setBackground(color);
        } else {
            this.labelPanel.setOpaque(false);
        }
        this.labelPanel.revalidate();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setLabelValue(this.slider.getValue());
    }

    public void setOrientation(int n) {
        this.slider.setOrientation(n);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    private void setLabelValue(int n) {
        if (n >= 0) {
            this.valueLabel.setText(this.prefix + "+" + this.getDisplay(n) + this.suffix);
        } else {
            this.valueLabel.setText(this.prefix + this.getDisplay(n) + this.suffix);
        }
        this.valueLabel.revalidate();
        this.repaint();
    }

    public void setValue(int n) {
        this.slider.setValue(n);
        this.setLabelValue(n);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.slider.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.slider.removeChangeListener(changeListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.valueLabel.setEnabled(bl);
        if (this.titleLabel != null) {
            this.titleLabel.setEnabled(bl);
        }
    }

    public void setSnapToTicks(boolean bl) {
        this.slider.setSnapToTicks(bl);
    }

    public void resizeSlider(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.prefix = string2;
        this.suffix = string3;
        if (this.prefix == null) {
            this.prefix = "";
        }
        if (this.suffix == null) {
            this.suffix = "";
        }
        this.valueLabel.setToolTipText(string4);
        this.slider.setOrientation(n);
        this.slider.setMinimum(n3);
        this.slider.setMaximum(n4);
        this.slider.setValue(n2);
        this.slider.setMajorTickSpacing(n6);
        this.slider.setMinorTickSpacing(n5);
        if (this.titleLabel != null) {
            this.titleLabel.setText(string);
        } else {
            this.titleLabel.setText("");
        }
        this.setValue(n2);
        this.divider = 1;
        while (n7 > 0) {
            this.divider *= 10;
            --n7;
        }
        if (this.divider > 1) {
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            for (int i = n3; i <= n4; ++i) {
                if ((i - n3) % n6 != 0) continue;
                hashtable.put(new Integer(i), new JLabel(this.getDisplay(i)));
            }
            this.slider.setLabelTable(hashtable);
        }
    }
}

