/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.stats;

import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.UiToolkit;
import cerent.util.Preferences;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.gui.TableCSVWriter;
import cerent.util.gui.TableHTMLWriter;
import cerent.util.gui.UFrame;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.RowTableModel;
import cerent.util.gui.row.SortableRowTableModel;
import cerent.util.stats.HistoryColumnRenderer;
import cerent.util.stats.HistoryEntry;
import cerent.util.stats.StatsBin;
import cerent.util.stats.StatsColumnRenderer;
import cerent.util.stats.StatsMgr;
import cerent.util.stats.StatsWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class StatsFrame
extends UFrame
implements ActionListener,
TableModelListener,
ChangeListener {
    private static StatsFrame _instance;
    private static final String PREF_CTC = "ctc.stats";
    private static final String PREF_HTML_FORMAT = "save.html";
    private static final String[] TABLE_NAME;
    private JTable[] tables = new JTable[3];
    private RowTableModel summaryOkRtm;
    private RowTableModel summaryFailRtm;
    private RowTableModel historyRtm;
    private JTabbedPane tabbedPane;
    private boolean started;
    private JButton startButton = new JButton("Start");
    private JButton stopButton = new JButton("Stop");
    private JButton resetButton = new JButton("Reset");
    private JButton clearButton = new JButton("Clear");
    private JButton closeButton = new JButton("Close");
    private JButton saveButton = new JButton("Save...");
    private boolean inited = false;

    private StatsFrame(String string) {
        super(string);
    }

    private synchronized void init() {
        if (!this.inited) {
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            container.add(this.tabbedPane);
            JPanel jPanel = new JPanel(new BorderLayout());
            this.summaryOkRtm = new SortableRowTableModel(StatsMgr.instance().getOkSummary(), StatsColumnRenderer.createTableRenderers(), StatsBin.class);
            this.tables[0] = this.initTab(jPanel, this.summaryOkRtm, "stats-ok");
            this.tabbedPane.addTab("Summary OK", jPanel);
            jPanel = new JPanel(new BorderLayout());
            this.summaryFailRtm = new SortableRowTableModel(StatsMgr.instance().getFailSummary(), StatsColumnRenderer.createTableRenderers(), StatsBin.class);
            this.tables[1] = this.initTab(jPanel, this.summaryFailRtm, "stats-fail");
            this.tabbedPane.addTab("Summary Failures", jPanel);
            jPanel = new JPanel(new BorderLayout());
            this.historyRtm = new RowTableModel(StatsMgr.instance().getHistory(), HistoryColumnRenderer.createTableRenderers(), HistoryEntry.class);
            this.tables[2] = this.initTab(jPanel, this.historyRtm, "stats-history");
            this.tabbedPane.addTab("History", jPanel);
            this.historyRtm.addTableModelListener((TableModelListener)this);
            this.tabbedPane.addChangeListener(this);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(5));
            box.add(this.saveButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.clearButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.resetButton);
            box.add(Box.createVerticalStrut(35));
            box.add(Box.createHorizontalGlue());
            box.add(this.stopButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.startButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.closeButton);
            box.add(Box.createHorizontalStrut(5));
            container.add((Component)box, "South");
            this.syncButtons();
            this.startButton.addActionListener(this);
            this.stopButton.addActionListener(this);
            this.closeButton.addActionListener(this);
            this.resetButton.addActionListener(this);
            this.clearButton.addActionListener(this);
            this.saveButton.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.inited = true;
        }
    }

    private JTable initTab(JPanel jPanel, RowTableModel rowTableModel, String string) {
        JTable jTable = new JTable((TableModel)rowTableModel);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        rowTableModel.initTable(jTable);
        jTable.setName(string);
        TablePropertyMgr.getColumnPrefs(jTable, jTable.getName());
        jPanel.add(jScrollPane);
        jTable.setAutoResizeMode(0);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        return jTable;
    }

    public static synchronized StatsFrame instance() {
        if (_instance == null) {
            if (Preferences.instance().propertyExist("ctc", "boot.debug.name")) {
                StatsWindow.statsWindowName = StatsWindow.statsWindowName.concat(" : " + Preferences.instance().getProperty("ctc", "boot.debug.name", ""));
            }
            _instance = new StatsFrame(StatsWindow.statsWindowName);
        }
        return _instance;
    }

    public synchronized void dispose() {
        WindowHelper.persistBounds((Component)this, (String)PREF_CTC);
        if (this.inited) {
            for (int i = 0; i < this.tables.length; ++i) {
                TablePropertyMgr.setColumnPrefs(this.tables[i], this.tables[i].getName());
            }
        }
        StatsMgr.instance().stop();
        StatsMgr.instance().clearOk();
        StatsMgr.instance().clearFail();
        StatsMgr.instance().clearHistory();
        super.dispose();
    }

    public void display() {
        this.init();
        this.pack();
        super.display();
        this.start();
    }

    protected Rectangle getDefaultBounds() {
        return WindowHelper.getPersistedBounds((String)PREF_CTC, (Rectangle)new Rectangle(20, 20, 640, 425));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.startButton) {
            this.start();
        } else if (object == this.stopButton) {
            StatsMgr.instance().stop();
            this.started = false;
            this.syncButtons();
        } else if (object == this.clearButton) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n == 0) {
                StatsMgr.instance().clearOk();
            } else if (n == 1) {
                StatsMgr.instance().clearFail();
            } else {
                StatsMgr.instance().clearHistory();
            }
        } else if (object == this.resetButton) {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                StatsMgr.instance().resetOk();
            } else {
                StatsMgr.instance().resetFail();
            }
        } else if (object == this.saveButton) {
            this.save();
        } else if (object == this.closeButton) {
            this.dispose();
        }
    }

    private final void start() {
        StatsMgr.instance().start();
        this.started = true;
        this.syncButtons();
    }

    private void syncButtons() {
        this.startButton.setEnabled(!this.started);
        this.stopButton.setEnabled(this.started);
        this.resetButton.setVisible(this.tabbedPane.getSelectedIndex() != 2);
    }

    private void save() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Select file format"));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = Preferences.instance().getBoolean(PREF_CTC, PREF_HTML_FORMAT, false);
        JRadioButton jRadioButton = new JRadioButton("HTML", bl);
        JRadioButton jRadioButton2 = new JRadioButton("CSV (Comma Separated Values)", !bl);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        jRadioButton.setSelected(bl);
        jPanel.add((Component)jPanel2, "West");
        File file = PersistentFileChooserDialog.getFile((Component)this, (String)"Select destination file", (Object)jPanel, (byte)2, (String)PREF_CTC, (String)"save", (int)5);
        bl = jRadioButton.isSelected();
        Preferences.instance().setBoolean(PREF_CTC, PREF_HTML_FORMAT, bl);
        if (file != null) {
            JTable jTable = this.tables[this.tabbedPane.getSelectedIndex()];
            if (bl) {
                TableHTMLWriter tableHTMLWriter = new TableHTMLWriter((IUiToolkit)UiToolkit.instance(), jTable, true, TABLE_NAME[this.tabbedPane.getSelectedIndex()]);
                tableHTMLWriter.writeFile(file.getAbsolutePath());
            } else {
                TableCSVWriter tableCSVWriter = new TableCSVWriter((IUiToolkit)UiToolkit.instance(), jTable, true, null);
                tableCSVWriter.writeFile(file.getAbsolutePath());
            }
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        long l = StatsMgr.instance().getHistoryCount();
        this.tabbedPane.setTitleAt(2, "History (" + l + ")");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.syncButtons();
    }

    static {
        TABLE_NAME = new String[]{"CTC CORBA STATS SUMMARY (successful operations)", "CTC CORBA STATS SUMMARY (failed operations)", "CTC CORBA HISTORY"};
        boolean bl = Preferences.instance().getBoolean(PREF_CTC, "autostart", false);
        if (bl) {
            _instance = StatsFrame.instance();
            _instance.display();
            _instance.start();
        }
    }
}

