/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.version.AbstractInterfaceVersion;
import cerent.version.AbstractJarBuildInformation;
import cerent.version.Compatibility;
import cerent.version.IBuildInformation;
import cerent.version.InternalLayerVersion;
import cerent.version.InvalidScopeException;

public class NetInterfaceVersion
extends AbstractInterfaceVersion {
    IBuildInformation buildInformation;
    InternalLayerVersion version;
    boolean forceIncompat = false;

    public NetInterfaceVersion() {
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass("cerent.version.AbstractJarBuildInformation");
            this.buildInformation = new NetBuildInformation();
            this.version = new InternalLayerVersion("net", this.buildInformation);
            this.forceIncompat = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.buildInformation = null;
            this.version = new InternalLayerVersion("net", Integer.MIN_VALUE);
            this.forceIncompat = true;
        }
    }

    public Object getVersion() {
        return this.version;
    }

    public IBuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    public boolean isNewerThan(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        return this.version.getLayerVersion() > internalLayerVersion.getLayerVersion();
    }

    public boolean isSameVersionAs(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        return this.version.getLayerVersion() == internalLayerVersion.getLayerVersion();
    }

    public Compatibility getCompatibilityWith(AbstractInterfaceVersion abstractInterfaceVersion) {
        if (this.forceIncompat) {
            return Compatibility.FORCE_INCOMPATIBLE;
        }
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        Compatibility compatibility = Compatibility.UNKNOWN;
        if (this.version.getLayerVersion() >= internalLayerVersion.getLayerVersion()) {
            compatibility = Compatibility.COMPATIBLE;
        }
        return compatibility;
    }

    private final class NetBuildInformation
    extends AbstractJarBuildInformation {
        public NetBuildInformation() {
            super("network");
        }
    }
}

