/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.launcher.CachedJar;
import cerent.util.BuildInfo;
import cerent.util.DetailedLog;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.version.Ngrp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class NetworkVersionMonitor
implements IObserver {
    private String latestVersionAvailable;
    private String latestVersionUpgraded;
    private HashMap networkElementVersions;
    private HashMap allNetworkElements;
    private final NetVersionMonitorDebug db = new NetVersionMonitorDebug("NetworkVersionMonitor");
    private static NetworkVersionMonitor instance;

    public NetworkVersionMonitor() {
        this.latestVersionUpgraded = this.latestVersionAvailable = this.getCurrentVersion();
        this.networkElementVersions = new HashMap();
        this.allNetworkElements = new HashMap();
    }

    public static NetworkVersionMonitor instance() {
        if (instance == null) {
            instance = new NetworkVersionMonitor();
        }
        return instance;
    }

    public void initialize() {
        if (this.isVersionMonitoringSupported()) {
            Network.instance().addNetElementCreationObserver(this);
        }
    }

    public boolean isVersionMonitoringSupported() {
        return CachedJar.isDownloadingPermitted();
    }

    public void setLatestVersionUpgraded(String string) {
        this.latestVersionUpgraded = string;
    }

    public String getLatestVersionUpgraded() {
        return this.latestVersionUpgraded;
    }

    public String getLatestVersionAvailable() {
        return this.latestVersionAvailable;
    }

    public ArrayList getLatestVersionElements() {
        ArrayList arrayList = (ArrayList)this.networkElementVersions.get(this.latestVersionAvailable);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public boolean isLaterVersionAvailable() {
        boolean bl = this.isLaterVersion(this.latestVersionAvailable, this.getCurrentVersion());
        return bl && this.isLaterVersion(this.latestVersionAvailable, this.latestVersionUpgraded);
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof Network.NetElementCreationNotifier && object instanceof NetElement) {
            this.newNetworkElementFound((NetElement)object, ((NetElement)object).getSwVersion());
        } else if (iObservable instanceof NetElement && object instanceof Integer) {
            this.networkElementUpdate((NetElement)iObservable, (Integer)object);
        } else {
            if (this.db.on()) {
                this.db.println("Error in update - non NetElement notification received - aborting.");
            }
            return;
        }
    }

    private void networkElementUpdate(NetElement netElement, Integer n) {
        if (n == ModelUpdateType.DELETED) {
            this.allNetworkElements.remove(netElement);
            String string = netElement.getSwVersion();
            ArrayList arrayList = (ArrayList)this.networkElementVersions.get(string);
            if (arrayList != null) {
                arrayList.remove(netElement);
            }
            this.evaluateForLatestVersionLost(string);
            if (this.db.on()) {
                this.db.println("Received DELETED notification for " + netElement.getHostName() + ". Removed this element from the version lists.");
            }
            netElement.deleteObserver(this);
        } else if (n == ModelUpdateType.CHANGED) {
            String string = (String)this.allNetworkElements.get(netElement);
            String string2 = netElement.getSwVersion();
            if (!(string == null || string.equals("") || string2.equals("") || string.equals(string2))) {
                ArrayList arrayList = (ArrayList)this.networkElementVersions.get(string);
                if (arrayList != null) {
                    arrayList.remove(netElement);
                    this.allNetworkElements.put(netElement, string2);
                }
                this.addElementToVersionMappedList(netElement, string2);
                this.evaluateForLatestVersionFound(string2);
                this.evaluateForLatestVersionLost(string);
                if (this.db.on()) {
                    this.db.println("Upon CHANGED notification, moved " + netElement.getHostName() + " from the " + string + " to the " + string2 + " list.");
                }
            }
        }
    }

    private void addElementToVersionMappedList(NetElement netElement, String string) {
        ArrayList<NetElement> arrayList = (ArrayList<NetElement>)this.networkElementVersions.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<NetElement>();
            arrayList.add(netElement);
            this.networkElementVersions.put(string, arrayList);
        } else {
            arrayList.add(netElement);
        }
    }

    private void evaluateForLatestVersionFound(String string) {
        if (this.isLaterVersion(string, this.latestVersionAvailable)) {
            this.latestVersionAvailable = string;
            if (this.isLaterVersion(string, this.getCurrentVersion())) {
                String string2 = Ngrp.getAbbreviatedCustomerVisibleFormat((String)this.latestVersionAvailable);
                String string3 = Ngrp.getAbbreviatedCustomerVisibleFormat((String)this.getCurrentVersion());
                String string4 = "You are currently running Software Release " + string3 + " of the Cisco Transport Controller (CTC).\n" + "A network element running R" + string2 + " has been discovered but cannot be managed from this CTC session.\n" + "If you would like to manage this network element, you must download " + "and install CTC R" + string2 + " on your computer.\n" + "To do so, please select \"Update CTC\" from the Tools menu.";
                DetailedLog detailedLog = new DetailedLog(1, string4);
                EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            }
        }
    }

    private void evaluateForLatestVersionLost(String string) {
        ArrayList arrayList;
        if (string.equals(this.latestVersionAvailable) && (arrayList = (ArrayList)this.networkElementVersions.get(string)).isEmpty()) {
            Iterator iterator = this.networkElementVersions.keySet().iterator();
            String string2 = "";
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!this.isLaterVersion(string3, string2) || ((ArrayList)this.networkElementVersions.get(string3)).isEmpty()) continue;
                string2 = string3;
            }
            if (!string2.equals("")) {
                this.latestVersionAvailable = string2;
            }
        }
    }

    private void newNetworkElementFound(NetElement netElement, String string) {
        this.allNetworkElements.put(netElement, string);
        this.addElementToVersionMappedList(netElement, string);
        netElement.addObserver(this);
        if (this.db.on()) {
            this.db.println("newNetworkElementFound - adding node: " + netElement.getHostName() + "with version: " + string + " to known versions.");
        }
        this.evaluateForLatestVersionFound(string);
    }

    private boolean isLaterVersion(String string, String string2) {
        return string.compareTo(string2) > 0;
    }

    private String getCurrentVersion() {
        return BuildInfo.version.substring(0, 5);
    }

    public class NetVersionMonitorDebug
    extends SDebug {
        public NetVersionMonitorDebug(String string) {
            super(string);
        }

        public final void dumpLatestVersion() {
            NetworkVersionMonitor.this.db.println("Latest Version Available: " + NetworkVersionMonitor.this.latestVersionAvailable);
            NetworkVersionMonitor.this.db.println("Latest Version Upgraded: " + NetworkVersionMonitor.this.latestVersionUpgraded);
            NetworkVersionMonitor.this.db.println("Current Running Version: " + NetworkVersionMonitor.this.getCurrentVersion());
        }

        public final void dump() {
            NetworkVersionMonitor.this.db.println("================================");
            Iterator iterator = NetworkVersionMonitor.this.networkElementVersions.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                NetworkVersionMonitor.this.db.println("");
                NetworkVersionMonitor.this.db.println("Version " + string + " nodes");
                NetworkVersionMonitor.this.db.println("-----------------------------");
                ArrayList arrayList = (ArrayList)NetworkVersionMonitor.this.networkElementVersions.get(string);
                if (arrayList == null) continue;
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    NetworkVersionMonitor.this.db.println(((NetElement)iterator2.next()).getHostName());
                }
            }
            NetworkVersionMonitor.this.db.println("================================");
        }
    }
}

