/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapLinkStyle;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class DetailedMapLink
extends MapLink {
    private static final SDebug db = new SDebug("DetailedMapLink");
    protected int MAX_STYLES = 2;
    protected ArrayList styleList = new ArrayList();
    private boolean biDirectionalExternal = true;
    private MapPort sourcePort;
    private MapPort targetPort;

    public DetailedMapLink(MapToolkit mapToolkit, MapNode mapNode, MapNode mapNode2, String string) {
        super(mapToolkit, mapNode, mapNode2, string);
    }

    protected void reassessLineWidth() {
        int n = 1;
        if (this.styleList.size() > 1) {
            n = 15;
        }
        this.setLineThickness(n);
    }

    public void addStyle(DetailedMapLinkStyle detailedMapLinkStyle) {
        if (this.styleList.size() >= this.MAX_STYLES) {
            db.println("Detailed link cannot have more than " + this.MAX_STYLES + " styles.");
            return;
        }
        this.styleList.add(detailedMapLinkStyle);
        this.reassessLineWidth();
        this.reDraw();
    }

    public void clearStyles() {
        this.styleList.clear();
        this.reassessLineWidth();
        this.reDraw();
    }

    public int getNumStyles() {
        return this.styleList.size();
    }

    public DetailedMapLinkStyle getStyle(int n) {
        if (n >= this.styleList.size()) {
            return null;
        }
        DetailedMapLinkStyle detailedMapLinkStyle = (DetailedMapLinkStyle)this.styleList.get(n);
        return detailedMapLinkStyle;
    }

    public MapPort getSourcePort() {
        return this.sourcePort;
    }

    public MapPort getTargetPort() {
        return this.targetPort;
    }

    public void setSourcePort(MapPort mapPort) {
        this.sourcePort = mapPort;
    }

    public void setTargetPort(MapPort mapPort) {
        this.targetPort = mapPort;
    }

    public boolean isBiDirectionalExternal() {
        return this.biDirectionalExternal;
    }

    public void setBiDirectionalExternal(boolean bl) {
        this.biDirectionalExternal = bl;
    }

    protected void renderLink(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4, int n5) {
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        int n6 = 0;
        int n7 = this.styleList.size();
        DetailedMapLinkStyle detailedMapLinkStyle = null;
        DetailedMapLinkStyle detailedMapLinkStyle2 = null;
        if (n7 == 0 || n7 == 1) {
            int n8 = 0;
            Color color2 = DetailedMapLinkStyle.UNKNOWN_COLOR;
            if (n7 == 1) {
                detailedMapLinkStyle = (DetailedMapLinkStyle)this.styleList.get(0);
                n8 = detailedMapLinkStyle.getDirection();
                color2 = detailedMapLinkStyle.getColor();
            }
            graphics2D.setStroke(MapGraphicsUtil.DETAILSTROKE[n6]);
            graphics2D.setColor(bl ? color2.darker() : color2);
            Line2D.Double double_ = new Line2D.Double(n2, n3, n4, n5);
            graphics2D.draw(double_);
            if (bl) {
                graphics2D.setColor(color2.brighter());
                graphics2D.setStroke(MapGraphicsUtil.INNERDETAILSTROKE[n6]);
                double_ = new Line2D.Double(n2, n3, n4, n5);
                graphics2D.draw(double_);
                graphics2D.setStroke(MapGraphicsUtil.DETAILSTROKE[n6]);
            }
            if (n8 == 1 || n8 == 3) {
                graphics2D.setColor(bl ? color2.darker() : color2);
                MapGraphicsUtil.drawArrow(graphics2D, n2, n3, n4, n5);
            }
            if (n8 == 2 || n8 == 3) {
                graphics2D.setColor(bl ? color2.darker() : color2);
                MapGraphicsUtil.drawArrow(graphics2D, n4, n5, n2, n3);
            }
        } else {
            int n9 = 0;
            int n10 = 0;
            if (n == 1 || n == -1) {
                n9 = 4;
            } else {
                n10 = 4;
            }
            int n11 = 0;
            Color color3 = DetailedMapLinkStyle.UNKNOWN_COLOR;
            int n12 = 0;
            Color color4 = DetailedMapLinkStyle.UNKNOWN_COLOR;
            detailedMapLinkStyle = (DetailedMapLinkStyle)this.styleList.get(0);
            n11 = detailedMapLinkStyle.getDirection();
            color3 = detailedMapLinkStyle.getColor();
            detailedMapLinkStyle2 = (DetailedMapLinkStyle)this.styleList.get(1);
            n12 = detailedMapLinkStyle2.getDirection();
            color4 = detailedMapLinkStyle2.getColor();
            graphics2D.setStroke(MapGraphicsUtil.DETAILSTROKE[n6]);
            Line2D.Double double_ = new Line2D.Double(n2 - n9, n3 - n10, n4 - n9, n5 - n10);
            Color color5 = color3;
            graphics2D.setColor(bl ? color5.darker() : color5);
            graphics2D.draw(double_);
            if (bl) {
                graphics2D.setColor(color5.brighter());
                graphics2D.setStroke(MapGraphicsUtil.INNERDETAILSTROKE[n6]);
                double_ = new Line2D.Double(n2 - n9, n3 - n10, n4 - n9, n5 - n10);
                graphics2D.draw(double_);
                graphics2D.setStroke(MapGraphicsUtil.DETAILSTROKE[n6]);
            }
            Line2D.Double double_2 = new Line2D.Double(n2 + n9, n3 + n10, n4 + n9, n5 + n10);
            color5 = color4;
            graphics2D.setColor(bl ? color5.darker() : color5);
            graphics2D.draw(double_2);
            if (bl) {
                graphics2D.setColor(color5.brighter());
                graphics2D.setStroke(MapGraphicsUtil.INNERDETAILSTROKE[n6]);
                double_2 = new Line2D.Double(n2 + n9, n3 + n10, n4 + n9, n5 + n10);
                graphics2D.draw(double_2);
                graphics2D.setStroke(MapGraphicsUtil.DETAILSTROKE[n6]);
            }
            if (n11 == 1 || n11 == 3) {
                color5 = color3;
                graphics2D.setColor(bl ? color5.darker() : color5);
                MapGraphicsUtil.drawArrow(graphics2D, n2 - n9, n3 - n10, n4 - n9, n5 - n10);
            }
            if (n12 == 1 || n12 == 3) {
                color5 = color4;
                graphics2D.setColor(bl ? color5.darker() : color5);
                MapGraphicsUtil.drawArrow(graphics2D, n2 + n9, n3 + n10, n4 + n9, n5 + n10);
            }
            if (n11 == 2 || n11 == 3) {
                color5 = color3;
                graphics2D.setColor(bl ? color5.darker() : color5);
                MapGraphicsUtil.drawArrow(graphics2D, n4 - n9, n5 - n10, n2 - n9, n3 - n10);
            }
            if (n12 == 2 || n12 == 3) {
                color5 = color4;
                graphics2D.setColor(bl ? color5.darker() : color5);
                MapGraphicsUtil.drawArrow(graphics2D, n4 + n9, n5 + n10, n2 + n9, n3 + n10);
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    public void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        if (this.mtk.isDetailed()) {
            this.drawDetailed(graphics2D, mapTransformer);
            super.drawAnnotations(graphics2D, mapTransformer);
        } else {
            super.drawMe(graphics2D, mapTransformer);
        }
    }

    protected void drawDetailed(Graphics2D graphics2D, MapTransformer mapTransformer) {
        MapLinkConnector mapLinkConnector = this.getSourceConnector();
        MapLinkConnector mapLinkConnector2 = this.getTargetConnector();
        if (mapLinkConnector == null || mapLinkConnector2 == null) {
            super.drawMe(graphics2D, mapTransformer);
            return;
        }
        MapPort mapPort = this.getSourcePort();
        MapPort mapPort2 = this.getTargetPort();
        Point2D point2D = mapLinkConnector.getWorldPoint(mapTransformer);
        Point2D point2D2 = mapLinkConnector2.getWorldPoint(mapTransformer);
        int n = (int)point2D.getX();
        int n2 = (int)point2D.getY();
        int n3 = (int)point2D2.getX();
        int n4 = (int)point2D2.getY();
        int n5 = 5;
        int n6 = this.mtk.getZoomCount();
        if (n6 > 0) {
            n5 = 5 + n6;
        }
        boolean bl = this.isSelected();
        if (mapPort == null || mapPort2 == null) {
            boolean bl2;
            int n7 = 0;
            if (mapPort == null) {
                n7 = mapPort.getSide();
            }
            if (mapPort2 == null) {
                n7 = mapPort2.getSide();
            }
            boolean bl3 = bl2 = mapPort != null;
            if (!bl2 && n7 == -1 || bl2 && n7 == 1) {
                n2 -= n5;
                n4 += n5;
            }
            if (!bl2 && n7 == 1 || bl2 && n7 == -1) {
                n2 += n5;
                n4 -= n5;
            }
            if (!bl2 && n7 == -2 || bl2 && n7 == 2) {
                n += n5;
                n3 -= n5;
            }
            if (!bl2 && n7 == 2 || bl2 && n7 == -2) {
                n -= n5;
                n3 += n5;
            }
            this.renderLink(graphics2D, bl, n7, n, n2, n3, n4);
            return;
        }
        int n8 = 0;
        int n9 = 0;
        n8 = mapPort.getSide();
        n9 = mapPort2.getSide();
        if (n8 == 1) {
            n2 -= n5;
            n4 += n5;
        }
        if (n8 == -1) {
            n2 += n5;
            n4 -= n5;
        }
        if (n8 == 2) {
            n += n5;
            n3 -= n5;
        }
        if (n8 == -2) {
            n -= n5;
            n3 += n5;
        }
        this.renderLink(graphics2D, bl, n8, n, n2, n3, n4);
    }

    public String toString() {
        if (this.getSrc() == null) {
            return this.getSourceNode().getName() + "/" + this.getTargetNode().getName();
        }
        String string = "[" + this.getSrc().getName() + "," + this.getDst().getName() + "] key=" + this.getUserObject();
        string = string + "\n" + this.dumpStyleString();
        return string;
    }

    public String dumpStyleString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.styleList.isEmpty()) {
            stringBuffer.append("No Styles present.");
        } else {
            for (int i = 0; i < this.styleList.size(); ++i) {
                stringBuffer.append("Style #" + i + "\t" + this.styleList.get(i).toString() + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

