/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.MapLine;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapSelector;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import com.cisco.ctc.util.map.Node;
import ilog.views.IlvGraphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DetailedMapNode
extends MapNode {
    public static final int NODE_IS_NOT_IN_LINK = 0;
    public static final int NODE_IS_LINK_SOURCE = 1;
    public static final int NODE_IS_LINK_TARGET = 2;
    private static final SDebug db = new SDebug("DetailedMapNode");
    static final int LINE_INTERSECTION = 1;
    static final int PIVOT_INTERSECTION = 2;
    static final int OBJECT_INTERSECTION = 10;
    HashMap portToLinkMap = new HashMap();
    private LinkedList internalPGs = new LinkedList();

    protected DetailedMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    public void init(Object object, double d, double d2, Object object2) {
        super.init(object, d, d2, object2);
    }

    protected int getNodeRoleInLink(MapLink mapLink) {
        DetailedMapNode detailedMapNode = (DetailedMapNode)mapLink.getSource();
        if (this == detailedMapNode) {
            return 1;
        }
        detailedMapNode = (DetailedMapNode)mapLink.getTarget();
        if (this == detailedMapNode) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkAdded(MapLink mapLink) {
        if (this.mtk.isDetailed()) {
            if (mapLink == null) {
                if (db.on()) {
                    db.println("DMN " + this + " received a linkAdded() " + "with a newLink of NULL.");
                }
                return;
            }
            DetailedMapLink detailedMapLink = (DetailedMapLink)mapLink;
            int n = this.getNodeRoleInLink(detailedMapLink);
            if (n == 0) {
                if (db.on()) {
                    db.println("linkAdded() called on link " + detailedMapLink + "did not have DMN " + this + " as either " + "source or target! Not creating a port.");
                }
                return;
            }
            DetailedMapNode detailedMapNode = n == 1 ? (DetailedMapNode)detailedMapLink.getTarget() : (DetailedMapNode)detailedMapLink.getSource();
            MapLinkConnector mapLinkConnector = this.createLinkConnector(0.0f, 0.0f);
            MapPort mapPort = this.addPort(mapLink, mapLinkConnector);
            int n2 = 0;
            n2 = this.returnPortsRelatedTo(detailedMapNode).size();
            mapPort.setCreateOrder(n2);
            mapLinkConnector.attach(mapLink);
            if (n == 1) {
                detailedMapLink.setSourceConnector(mapLinkConnector);
                detailedMapLink.setSourcePort(mapPort);
            } else {
                detailedMapLink.setTargetConnector(mapLinkConnector);
                detailedMapLink.setTargetPort(mapPort);
            }
            MapLinkConnector[] mapLinkConnectorArray = this;
            synchronized (this) {
                Object v = this.portToLinkMap.get(mapPort);
                if (v != null) {
                    LinkedList<Object> linkedList = null;
                    if (v instanceof LinkedList) {
                        linkedList = (LinkedList<Object>)v;
                    } else {
                        linkedList = new LinkedList<Object>();
                        linkedList.add(v);
                    }
                    linkedList.add(mapLink);
                    this.portToLinkMap.put(mapPort, linkedList);
                } else {
                    this.portToLinkMap.put(mapPort, mapLink);
                }
                // ** MonitorExit[var8_8] (shouldn't be in output)
                if (db.on()) {
                    db.println("created map port " + mapPort);
                    mapLinkConnectorArray = mapPort.getConnectors();
                    for (int i = 0; i < mapLinkConnectorArray.length; ++i) {
                        db.println("\tconnector#" + (i + 1) + " = " + (Object)((Object)mapLinkConnectorArray[i]));
                    }
                    db.println("\tParent node = " + mapPort.getParentNode());
                }
                this.updatePortSides(new HashSet());
            }
        } else {
            super.linkAdded(mapLink);
        }
    }

    public DetailedMapLink[] getLinks(MapPort mapPort) {
        LinkedList linkedList;
        Object v = this.portToLinkMap.get(mapPort);
        if (v instanceof DetailedMapLink) {
            linkedList = new LinkedList();
            linkedList.add(v);
        } else {
            linkedList = v != null ? (LinkedList)v : new LinkedList();
        }
        return linkedList.toArray(new DetailedMapLink[0]);
    }

    public MapPort getPort(DetailedMapLink detailedMapLink) {
        Iterator iterator = this.portToLinkMap.keySet().iterator();
        while (iterator.hasNext()) {
            MapPort mapPort = (MapPort)iterator.next();
            DetailedMapLink[] detailedMapLinkArray = this.getLinks(mapPort);
            for (int i = 0; i < detailedMapLinkArray.length; ++i) {
                if (detailedMapLinkArray[i] != detailedMapLink) continue;
                return mapPort;
            }
        }
        return null;
    }

    private ArrayList returnPortsRelatedTo(DetailedMapNode detailedMapNode) {
        ArrayList<MapPort> arrayList = new ArrayList<MapPort>();
        MapPort[] mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (int i = 0; i < mapPortArray.length; ++i) {
                MapPort mapPort = mapPortArray[i];
                DetailedMapLink[] detailedMapLinkArray = this.getLinks(mapPort);
                for (int j = 0; j < detailedMapLinkArray.length; ++j) {
                    DetailedMapLink detailedMapLink = detailedMapLinkArray[j];
                    if (detailedMapLink.getSource() != detailedMapNode && detailedMapLink.getTarget() != detailedMapNode) continue;
                    arrayList.add(mapPort);
                }
            }
        }
        return arrayList;
    }

    public MapPort getPortWithUserObject(Object object) {
        MapPort[] mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (int i = 0; i < mapPortArray.length; ++i) {
                MapPort mapPort = mapPortArray[i];
                if (!mapPort.getUserObject().equals(object)) continue;
                return mapPort;
            }
        }
        return null;
    }

    public MapPort[] getTargetPorts(MapPort mapPort) {
        String string = null;
        DetailedMapLink[] detailedMapLinkArray = this.getLinks(mapPort);
        LinkedList<MapPort> linkedList = new LinkedList<MapPort>();
        for (int i = 0; i < detailedMapLinkArray.length; ++i) {
            DetailedMapLink detailedMapLink = detailedMapLinkArray[i];
            DetailedMapNode detailedMapNode = null;
            int n = this.getNodeRoleInLink(detailedMapLink);
            if (n == 1) {
                detailedMapNode = (DetailedMapNode)detailedMapLink.getTarget();
            } else if (n == 2) {
                detailedMapNode = (DetailedMapNode)detailedMapLink.getSource();
            } else {
                string = "getTargetPort() could not find the role of " + this + " on link " + detailedMapLink;
            }
            if (detailedMapNode == null) continue;
            MapPort mapPort2 = detailedMapNode.getPort(detailedMapLink);
            if (mapPort2 != null) {
                linkedList.add(mapPort2);
                continue;
            }
            string = null;
        }
        if (string != null && db.on()) {
            db.println(string);
        }
        return linkedList.toArray(new MapPort[0]);
    }

    public void addInternalPorts() {
        if (this.hasInternalPorts()) {
            if (db.on()) {
                db.println("Already defined internal ports.");
            }
            return;
        }
        for (int i = 0; i < 2; ++i) {
            MapPort mapPort = this.addPort(null, null);
        }
    }

    protected int numInternalPorts() {
        MapPort[] mapPortArray = this.getInternalPorts();
        if (mapPortArray != null) {
            return mapPortArray.length;
        }
        return 0;
    }

    public boolean hasInternalPorts() {
        MapPort[] mapPortArray = this.getInternalPorts();
        if (mapPortArray != null) {
            return mapPortArray.length > 0;
        }
        return false;
    }

    public MapPort getFirstInternalPort() {
        return this.getInternalPort(0);
    }

    public MapPort getSecondInternalPort() {
        return this.getInternalPort(1);
    }

    public MapPort getInternalPort(int n) {
        MapPort[] mapPortArray = this.getInternalPorts();
        if (mapPortArray != null && mapPortArray.length > n) {
            return mapPortArray[n];
        }
        return null;
    }

    protected MapSelector createSelector() {
        return new MapSelector(this);
    }

    public int getNumSelectors() {
        MapSelector[] mapSelectorArray = this.getSelectors();
        if (mapSelectorArray == null) {
            return 0;
        }
        return mapSelectorArray.length;
    }

    protected MapLine getMapLine(IMapLineEndpoint iMapLineEndpoint, IMapLineEndpoint iMapLineEndpoint2) {
        MapLine[] mapLineArray = this.getLines();
        if (mapLineArray != null) {
            for (int i = 0; i < mapLineArray.length; ++i) {
                MapLine mapLine = mapLineArray[i];
                IMapLineEndpoint iMapLineEndpoint3 = mapLine.getStartPoint();
                IMapLineEndpoint iMapLineEndpoint4 = mapLine.getFinishPoint();
                if ((iMapLineEndpoint3 != iMapLineEndpoint || iMapLineEndpoint4 != iMapLineEndpoint2) && (iMapLineEndpoint3 != iMapLineEndpoint2 || iMapLineEndpoint4 != iMapLineEndpoint)) continue;
                return mapLine;
            }
        }
        return null;
    }

    protected void adjustNodeSize() {
        int n = this.getAdjustedNodeHeight();
        int n2 = this.getAdjustedNodeWidth();
        this.setSize(n2, n);
    }

    protected int getAdjustedNodeHeight() {
        int n = Math.max(this.returnPortsOnSide(2).size(), this.returnPortsOnSide(-2).size());
        int n2 = (int)Math.max((double)(n * 2 + 1) * 10.0, this.DEFAULT_HEIGHT);
        return n2;
    }

    protected int getAdjustedNodeWidth() {
        int n = Math.max(this.returnPortsOnSide(1).size(), this.returnPortsOnSide(-1).size());
        int n2 = (int)Math.max((double)(n * 2 + 1) * 10.0, this.DEFAULT_WIDTH);
        return n2;
    }

    public void setCoordinates(double d, double d2, boolean bl) {
        super.setCoordinates(d, d2, bl);
        if (this.mtk.isDetailed()) {
            this.updatePortSides(new HashSet());
        }
    }

    private HashSet updatePortSides(HashSet hashSet) {
        ActionListener actionListener;
        int n;
        ArrayList<DetailedMapNode> arrayList = new ArrayList<DetailedMapNode>();
        MapPort[] mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (n = 0; n < mapPortArray.length; ++n) {
                actionListener = mapPortArray[n];
                MapPort[] mapPortArray2 = this.getTargetPorts((MapPort)actionListener);
                for (int i = 0; i < mapPortArray2.length; ++i) {
                    MapPort mapPort = mapPortArray2[i];
                    DetailedMapNode detailedMapNode = mapPort.getParentNode();
                    arrayList.add(detailedMapNode);
                    int n2 = DetailedMapNode.computeSide(detailedMapNode, this);
                    ((MapPort)actionListener).setSide(n2);
                }
            }
        }
        this.computeSideSpacing(1);
        this.computeSideSpacing(-1);
        this.computeSideSpacing(2);
        this.computeSideSpacing(-2);
        this.adjustNodeSize();
        mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (n = 0; n < mapPortArray.length; ++n) {
                actionListener = mapPortArray[n];
                ((MapPort)actionListener).updatePositionInNode();
            }
        }
        this.updateSelectorsAndInternalPorts();
        hashSet.add(this);
        for (n = 0; n < arrayList.size(); ++n) {
            actionListener = (DetailedMapNode)arrayList.get(n);
            if (hashSet.contains(actionListener)) continue;
            hashSet = super.updatePortSides(hashSet);
        }
        return hashSet;
    }

    protected int leastPopulatedSide(boolean[] blArray) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (blArray != null && blArray.length == 4) {
            bl = blArray[0];
            bl2 = blArray[1];
            bl3 = blArray[2];
            bl4 = blArray[3];
            if (bl && bl2 && bl3 && bl4) {
                bl4 = false;
                bl3 = false;
                bl2 = false;
                bl = false;
            }
        }
        int n2 = 9999;
        int n3 = 2;
        if (!bl3 && (n = this.returnPortsOnSide(2).size()) < n2) {
            n2 = n;
            n3 = 2;
        }
        if (!bl4 && (n = this.returnPortsOnSide(-2).size()) < n2) {
            n2 = n;
            n3 = -2;
        }
        if (!bl && (n = this.returnPortsOnSide(1).size()) < n2) {
            n2 = n;
            n3 = 1;
        }
        if (!bl2 && (n = this.returnPortsOnSide(-1).size()) < n2) {
            n2 = n;
            n3 = -1;
        }
        return n3;
    }

    protected ArrayList returnPortsOnSide(int n) {
        ArrayList<MapPort> arrayList = new ArrayList<MapPort>();
        MapPort[] mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (int i = 0; i < mapPortArray.length; ++i) {
                MapPort mapPort = mapPortArray[i];
                int n2 = mapPort.getSide();
                if (n2 != n) continue;
                arrayList.add(mapPort);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void computeSideSpacing(int n) {
        ArrayList arrayList = this.returnPortsOnSide(n);
        int n2 = arrayList.size();
        if (n2 == 1) {
            MapPort mapPort = (MapPort)arrayList.get(0);
            if (n == 1 || n == -1) {
                mapPort.setSideOffset(0.4375);
            } else {
                mapPort.setSideOffset(0.4375);
            }
            return;
        }
        int n3 = 2 * n2 + 1;
        double d = 1.0 / (double)n3;
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            MapPort mapPort = (MapPort)arrayList.get(i);
            double d2 = (double)n4 * d;
            mapPort.setSideOffset(d2);
            n4 += 2;
        }
    }

    private static int computeSide(Node node, Node node2) {
        double d;
        double d2 = node2.getCenterX() - node.getCenterX();
        double d3 = node2.getCenterY() - node.getCenterY();
        int n = d2 == 0.0 ? (d3 > 0.0 ? 1 : -1) : ((d = Math.abs(d3 / d2)) > 1.0 ? (d3 > 0.0 ? 1 : -1) : (d2 > 0.0 ? -2 : 2));
        return n;
    }

    protected void updateInternalsOnly() {
        this.updateSelectorsAndInternalPorts();
    }

    protected void updateSelectorsAndInternalPorts() {
        int n;
        this.updateInternalPGs();
        MapSelector[] mapSelectorArray = this.getSelectors();
        int n2 = n = mapSelectorArray == null ? 0 : mapSelectorArray.length;
        if (n == 0) {
            this.updateZeroSelectors();
            this.updateInternalLines();
        } else if (n == 1) {
            this.updateOneSelector();
            this.updateInternalLines();
        } else if (n == 2) {
            this.updateTwoSelectors();
        }
    }

    protected void updateZeroSelectors() {
        if (this.hasInternalPorts()) {
            MapPort mapPort = this.getFirstInternalPort();
            MapPort mapPort2 = this.getSecondInternalPort();
            mapPort.setSide(0);
            if (mapPort2 != null) {
                mapPort.setSide(1);
                mapPort2.setSide(2);
                mapPort2.updatePositionInNode();
            }
            mapPort.updatePositionInNode();
        }
    }

    protected void updateOneSelector() {
        MapPort mapPort;
        MapSelector[] mapSelectorArray = this.getSelectors();
        MapSelector mapSelector = mapSelectorArray == null && mapSelectorArray.length > 0 ? null : mapSelectorArray[0];
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        Iterator iterator = mapSelector.getPorts().iterator();
        while (iterator.hasNext()) {
            mapPort = (MapPort)iterator.next();
            int n = mapPort.getSide();
            if (n == 2) {
                bl = false;
                continue;
            }
            if (n == 1) {
                bl3 = false;
                continue;
            }
            if (n == -2) {
                bl2 = false;
                continue;
            }
            bl4 = false;
        }
        int n = bl ? 5 : (bl4 ? 7 : (bl2 ? 6 : 8));
        if (this.hasInternalPorts()) {
            mapPort = this.getFirstInternalPort();
            MapPort mapPort2 = this.getSecondInternalPort();
            mapPort.setSide(0);
            if (mapPort2 != null) {
                if (n == 5) {
                    n = 9;
                    mapPort2.setSide(6);
                } else if (n == 6) {
                    n = 10;
                    mapPort2.setSide(5);
                } else if (n == 7) {
                    n = 11;
                    mapPort2.setSide(8);
                } else {
                    n = 12;
                    mapPort2.setSide(7);
                }
                mapPort2.updatePositionInNode();
            }
            mapPort.updatePositionInNode();
        }
        mapSelector.setSide(n);
        mapSelector.updatePositionInNode();
    }

    private void updateTwoSelectors() {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        MapSelector[] mapSelectorArray = this.getSelectors();
        int n = mapSelectorArray == null ? 0 : mapSelectorArray.length;
        MapSelector mapSelector = n > 0 ? mapSelectorArray[0] : null;
        MapSelector mapSelector2 = n > 1 ? mapSelectorArray[1] : null;
        MapPort mapPort = null;
        MapPort mapPort2 = null;
        if (this.hasInternalPorts()) {
            mapPort = this.getFirstInternalPort();
            mapPort2 = this.getSecondInternalPort();
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        if (this.hasInternalPorts()) {
            nArray2[1] = 13;
            nArray[0] = 13;
            nArray2[0] = 14;
            nArray[1] = 14;
            nArray2[3] = 15;
            nArray[2] = 15;
            nArray2[2] = 16;
            nArray[3] = 16;
            nArray4[1] = 1;
            nArray3[0] = 1;
            nArray4[0] = 2;
            nArray3[1] = 2;
            nArray4[3] = 3;
            nArray3[2] = 3;
            nArray4[2] = 4;
            nArray3[3] = 4;
        } else {
            nArray2[1] = 1;
            nArray[0] = 1;
            nArray2[0] = 2;
            nArray[1] = 2;
            nArray2[3] = 3;
            nArray[2] = 3;
            nArray2[2] = 4;
            nArray[3] = 4;
            for (int i = 0; i < 4; ++i) {
                nArray4[i] = 0;
                nArray3[i] = 0;
            }
        }
        Collection collection = mapSelector.getPorts();
        int n2 = 0;
        MapPort[] mapPortArray = new MapPort[collection.size()];
        MapPort[] mapPortArray2 = collection.iterator();
        while (mapPortArray2.hasNext()) {
            mapPortArray[n2] = (MapPort)mapPortArray2.next();
            ++n2;
        }
        collection = mapSelector2.getPorts();
        n2 = 0;
        mapPortArray2 = new MapPort[collection.size()];
        HashMap<MapLine, ArrayList<Cloneable>> hashMap = collection.iterator();
        while (hashMap.hasNext()) {
            mapPortArray2[n2] = (MapPort)hashMap.next();
            ++n2;
        }
        hashMap = new HashMap();
        int n3 = 9999;
        int n4 = -1;
        for (int i = 0; i < 4; ++i) {
            int n5;
            Point2D.Double double_;
            Cloneable cloneable2;
            double d;
            double d2;
            double d3;
            double d4;
            int n6;
            int n7 = 0;
            mapSelector.setSide(nArray[i]);
            mapSelector2.setSide(nArray2[i]);
            mapSelector.updatePositionInNode();
            mapSelector2.updatePositionInNode();
            if (mapPort != null && mapPort2 != null) {
                mapPort.setSide(nArray3[i]);
                mapPort2.setSide(nArray4[i]);
                mapPort.updatePositionInNode();
                mapPort2.updatePositionInNode();
            }
            Line2D[] line2DArray = new Line2D[mapPortArray.length];
            object3 = new Line2D[mapPortArray2.length];
            object2 = new MapLine[mapPortArray.length];
            object = new MapLine[mapPortArray2.length];
            Rectangle2D.Float float_ = mapSelector.getBounds();
            cloneable = mapSelector2.getBounds();
            HashMap<Object, Point2D.Double> hashMap2 = new HashMap<Object, Point2D.Double>();
            for (n6 = 0; n6 < mapPortArray.length; ++n6) {
                object2[n6] = this.getMapLine(mapSelector, mapPortArray[n6]);
                d4 = mapPortArray[n6].getCenterX();
                d3 = mapPortArray[n6].getCenterY();
                d2 = float_.getCenterX();
                d = float_.getCenterY();
                line2DArray[n6] = new Line2D.Double(d4, d3, d2, d);
            }
            for (n6 = 0; n6 < mapPortArray2.length; ++n6) {
                object[n6] = this.getMapLine(mapSelector2, mapPortArray2[n6]);
                d4 = mapPortArray2[n6].getCenterX();
                d3 = mapPortArray2[n6].getCenterY();
                d2 = ((RectangularShape)cloneable).getCenterX();
                d = ((RectangularShape)cloneable).getCenterY();
                object3[n6] = new Line2D.Double(d4, d3, d2, d);
            }
            for (n6 = 0; n6 < line2DArray.length; ++n6) {
                int n8;
                Line2D line2D = line2DArray[n6];
                if (line2D == null) continue;
                for (int j = 0; j < ((Object)object3).length; ++j) {
                    if (object3[j] == null || !line2D.intersectsLine((Line2D)object3[j])) continue;
                    ++n7;
                }
                cloneable2 = new ArrayList<Cloneable>();
                cloneable2.add(cloneable);
                if (mapPort != null) {
                    cloneable2.add(mapPort.getBounds());
                }
                if (mapPort2 != null) {
                    cloneable2.add(mapPort2.getBounds());
                }
                if ((n8 = this.getIntersectScore(line2D, (Collection)((Object)cloneable2))) > 5) {
                    double_ = i == 0 || i == 1 ? new Point2D.Double(this.getCenterX(), this.getCenterY() - 15.0) : new Point2D.Double(this.getCenterX() - 15.0, this.getCenterY());
                    Line2D.Double double_2 = new Line2D.Double(line2D.getX1(), line2D.getY1(), ((Point2D)double_).getX(), ((Point2D)double_).getY());
                    n5 = this.getIntersectScore(double_2, (Collection)((Object)cloneable2));
                    Line2D.Double double_3 = new Line2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), line2D.getX2(), line2D.getY2());
                    n5 = this.getIntersectScore(double_3, (Collection)((Object)cloneable2));
                    if ((n5 += 2) < n8) {
                        hashMap2.put(object2[n6], double_);
                        n8 = n5;
                    }
                }
                n7 += n8;
            }
            for (n6 = 0; n6 < ((Object)object3).length; ++n6) {
                int n9;
                Object object4 = object3[n6];
                if (object4 == null) continue;
                cloneable2 = new ArrayList();
                cloneable2.add(float_);
                if (mapPort != null) {
                    cloneable2.add(mapPort.getBounds());
                }
                if (mapPort2 != null) {
                    cloneable2.add(mapPort2.getBounds());
                }
                if ((n9 = this.getIntersectScore((Line2D)object4, (Collection)((Object)cloneable2))) > 5) {
                    double_ = i == 0 || i == 1 ? new Point2D.Double(this.getCenterX(), this.getCenterY() - 15.0) : new Point2D.Double(this.getCenterX() - 15.0, this.getCenterY());
                    Line2D.Double double_4 = new Line2D.Double(((Line2D)object4).getX1(), ((Line2D)object4).getY1(), ((Point2D)double_).getX(), ((Point2D)double_).getY());
                    n5 = this.getIntersectScore(double_4, (Collection)((Object)cloneable2));
                    Line2D.Double double_5 = new Line2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Line2D)object4).getX2(), ((Line2D)object4).getY2());
                    n5 = this.getIntersectScore(double_5, (Collection)((Object)cloneable2));
                    if ((n5 += 2) < n9) {
                        hashMap2.put(object[n6], double_);
                        n9 = n5;
                    }
                }
                n7 += n9;
            }
            if (n7 >= n3) continue;
            n3 = n7;
            n4 = i;
            hashMap = new HashMap<MapLine, ArrayList<Cloneable>>();
            Iterator iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                MapLine mapLine = (MapLine)((Object)iterator.next());
                cloneable2 = (Point2D)hashMap2.get((Object)mapLine);
                hashMap.put(mapLine, (ArrayList<Cloneable>)cloneable2);
            }
        }
        mapSelector.setSide(nArray[n4]);
        mapSelector2.setSide(nArray2[n4]);
        mapSelector.updatePositionInNode();
        mapSelector2.updatePositionInNode();
        if (mapPort != null && mapPort2 != null) {
            mapPort.setSide(nArray3[n4]);
            mapPort2.setSide(nArray4[n4]);
            mapPort.updatePositionInNode();
            mapPort2.updatePositionInNode();
        }
        Set set = hashMap.keySet();
        MapLine[] mapLineArray = this.getLines();
        if (mapLineArray != null) {
            for (int i = 0; i < mapLineArray.length; ++i) {
                object3 = mapLineArray[i];
                ((MapLine)((Object)object3)).initLocationChange();
                object2 = ((MapLine)((Object)object3)).getStartPoint();
                object = ((MapLine)((Object)object3)).getFinishPoint();
                int n10 = ((MapLine)((Object)object3)).getPointCount();
                ((MapLine)((Object)object3)).addPoint(object2.getEndpoint());
                if (set.contains(object3)) {
                    cloneable = (Point2D)hashMap.get(object3);
                    ((MapLine)((Object)object3)).addPoint((Point2D)cloneable);
                }
                ((MapLine)((Object)object3)).addPoint(object.getEndpoint());
                ((MapLine)((Object)object3)).removePoints(n10);
            }
        }
    }

    private void updateInternalPGs() {
        AbstractInternalPG[] abstractInternalPGArray = this.getInternalPGs();
        for (int i = 0; i < abstractInternalPGArray.length; ++i) {
            abstractInternalPGArray[i].updatePositionInNode();
        }
    }

    private int getIntersectScore(Line2D line2D, Collection collection) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Rectangle2D rectangle2D = (Rectangle2D)e;
            if (!line2D.intersects(rectangle2D)) continue;
            n += 10;
        }
        return n;
    }

    private void updateInternalLines() {
        MapLine[] mapLineArray = this.getLines();
        if (mapLineArray != null) {
            for (int i = 0; i < mapLineArray.length; ++i) {
                MapLine mapLine = mapLineArray[i];
                mapLine.initLocationChange();
                IMapLineEndpoint iMapLineEndpoint = mapLine.getStartPoint();
                IMapLineEndpoint iMapLineEndpoint2 = mapLine.getFinishPoint();
                int n = mapLine.getPointCount();
                mapLine.addPoint(iMapLineEndpoint.getEndpoint());
                mapLine.addPoint(iMapLineEndpoint2.getEndpoint());
                mapLine.removePoints(n);
                if (!db.on()) continue;
                db.println("updateInternalLines()");
                db.println("\tp1= " + iMapLineEndpoint.getEndpoint().getX() + ", " + iMapLineEndpoint.getEndpoint().getY());
                db.println("p2= " + iMapLineEndpoint2.getEndpoint().getX() + ", " + iMapLineEndpoint2.getEndpoint().getY());
                db.println("lineX1= " + mapLine.getPoint(0).getX() + " " + "Y1= " + mapLine.getPoint(0).getY() + ". X2= " + mapLine.getPoint(1).getX() + " Y2= " + mapLine.getPoint(1).getY());
            }
        }
    }

    protected void clicked() {
        super.clicked();
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    void onInitPopupMenu(UPopupMenu uPopupMenu) {
        super.onInitPopupMenu(uPopupMenu);
    }

    protected void initPopupMenu(Object object, ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
        this.mtk.initPopupMenu(object, actionOrganizer, uPopupMenu);
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.drawMe(graphics2D, mapTransformer);
        if (this.mtk.isDetailed()) {
            this.drawDetailed(graphics2D, mapTransformer);
        }
    }

    protected void drawDetailed(Graphics2D graphics2D, MapTransformer mapTransformer) {
        MapSelector[] mapSelectorArray;
        int n;
        Color color = graphics2D.getColor();
        Rectangle2D rectangle2D = this.getBounds(mapTransformer);
        double d = 10.0;
        double d2 = 10.0;
        MapPort[] mapPortArray = this.getPorts();
        if (mapPortArray != null && mapPortArray.length > 0) {
            d = mapPortArray[0].getBounds(mapTransformer).getWidth();
            d2 = mapPortArray[0].getBounds(mapTransformer).getHeight();
        }
        int n2 = n = (mapSelectorArray = this.getSelectors()) == null ? 0 : mapSelectorArray.length;
        if (n > 0) {
            int n3 = this.getContentObjectType();
            double d3 = rectangle2D.getX();
            double d4 = rectangle2D.getY();
            double d5 = rectangle2D.getWidth();
            double d6 = rectangle2D.getHeight();
            graphics2D.setColor(Color.white);
            if (n3 == 1) {
                graphics2D.fillOval((int)(d3 + d), (int)(d4 + d2), (int)(d5 - 2.0 * d), (int)(d6 - 2.0 * d2));
                graphics2D.setColor(Color.black);
                graphics2D.drawOval((int)(d3 + d), (int)(d4 + d2), (int)(d5 - 2.0 * d), (int)(d6 - 2.0 * d2));
            } else {
                graphics2D.fillRect((int)(d3 + d), (int)(d4 + d2), (int)(d5 - 2.0 * d), (int)(d6 - 2.0 * d2));
                graphics2D.setColor(Color.black);
                graphics2D.drawRect((int)(d3 + d), (int)(d4 + d2), (int)(d5 - 2.0 * d), (int)(d6 - 2.0 * d2));
            }
            graphics2D.setColor(color);
        }
    }

    public MapPort[] getPorts() {
        return this.getPorts(false);
    }

    public MapPort[] getPorts(boolean bl) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            MapPort mapPort;
            if (!(objectArray[i] instanceof MapPort) || !bl && ((mapPort = (MapPort)objectArray[i]).isInternalPort() || mapPort.getInternalPG() != null)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapPort[0]);
    }

    public MapPort[] getInternalPorts() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof MapPort) || !((MapPort)objectArray[i]).isInternalPort()) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapPort[0]);
    }

    public MapLine[] getLines() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof MapLine)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapLine[0]);
    }

    public MapSelector[] getSelectors() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof MapSelector)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapSelector[0]);
    }

    public AbstractInternalPG[] getInternalPGs() {
        return this.internalPGs.toArray(new AbstractInternalPG[0]);
    }

    public MapPort addPort(MapLink mapLink, MapLinkConnector mapLinkConnector) {
        MapPort mapPort = this.createMapPort(this, mapLink, mapLinkConnector);
        this.addComponent((IlvGraphic)mapPort, 7);
        mapPort.setSelectable(false);
        if (mapPort.isInternalPort()) {
            this.updateInternalsOnly();
        }
        return mapPort;
    }

    public final MapSelector addSelector() {
        MapSelector mapSelector = this.createMapSelector(this);
        this.addComponent((IlvGraphic)mapSelector, 6);
        mapSelector.setSelectable(false);
        mapSelector.setColor(Color.white);
        this.updateInternalsOnly();
        return mapSelector;
    }

    public final AbstractInternalPG addInternalPG(Object object) {
        AbstractInternalPG abstractInternalPG = this.createInternalPG(object);
        if (abstractInternalPG != null) {
            this.internalPGs.add(abstractInternalPG);
            abstractInternalPG.updatePositionInNode();
        }
        return abstractInternalPG;
    }

    public final MapLine addMapLine(IMapLineEndpoint iMapLineEndpoint, IMapLineEndpoint iMapLineEndpoint2, Object object) {
        if (iMapLineEndpoint == null || iMapLineEndpoint2 == null) {
            if (db.on()) {
                db.println("not adding mapline because p1= " + iMapLineEndpoint + " and p2= " + iMapLineEndpoint2 + " and neither can be null");
            }
            return null;
        }
        MapLine mapLine = this.createMapLine(this, iMapLineEndpoint, iMapLineEndpoint2);
        mapLine.init(object);
        this.addComponent((IlvGraphic)mapLine, 5);
        mapLine.setSelectable(true);
        mapLine.setMovable(false);
        this.updateInternalsOnly();
        return mapLine;
    }

    protected MapPort createMapPort(DetailedMapNode detailedMapNode, MapLink mapLink, MapLinkConnector mapLinkConnector) {
        return new MapPort(detailedMapNode, mapLinkConnector);
    }

    protected MapSelector createMapSelector(DetailedMapNode detailedMapNode) {
        return new MapSelector(detailedMapNode);
    }

    protected AbstractInternalPG createInternalPG(Object object) {
        return null;
    }

    protected MapLine createMapLine(DetailedMapNode detailedMapNode, IMapLineEndpoint iMapLineEndpoint, IMapLineEndpoint iMapLineEndpoint2) {
        return new MapLine(detailedMapNode, iMapLineEndpoint, iMapLineEndpoint2);
    }

    public void destroy() {
        try {
            MapPort[] mapPortArray = this.getPorts(true);
            for (int i = 0; i < mapPortArray.length; ++i) {
                if (db.on()) {
                    db.println("DMN::Destroy() port: " + mapPortArray[i]);
                }
                mapPortArray[i].destroy();
            }
            MapLine[] mapLineArray = this.getLines();
            for (int i = 0; i < mapLineArray.length; ++i) {
                if (db.on()) {
                    db.println("DMN::Destroy() line: " + (Object)((Object)mapLineArray[i]));
                }
                mapLineArray[i].destroy();
            }
            MapSelector[] mapSelectorArray = this.getSelectors();
            for (int i = 0; i < mapSelectorArray.length; ++i) {
                if (db.on()) {
                    db.println("DMN::Destroy() selector: " + mapSelectorArray[i]);
                }
                mapSelectorArray[i].destroy();
            }
            AbstractInternalPG[] abstractInternalPGArray = this.getInternalPGs();
            for (int i = 0; i < abstractInternalPGArray.length; ++i) {
                if (db.on()) {
                    db.println("DMN::Destroy() PG: " + abstractInternalPGArray[i]);
                }
                abstractInternalPGArray[i].destroy();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        super.destroy();
    }

    protected void linkToBeRemoved(MapLink mapLink) {
        MapPort mapPort;
        if (db.on()) {
            db.println("link: " + mapLink + " will be removed; notified " + this);
        }
        if (mapLink instanceof DetailedMapLink && (mapPort = this.getPort((DetailedMapLink)mapLink)) != null && this.getLinks(mapPort).length == 1) {
            this.removePort(mapPort);
        }
    }

    public void removePort(MapPort mapPort) {
        int n;
        if (mapPort == null) {
            return;
        }
        this.portToLinkMap.remove(mapPort);
        ArrayList<MapLine> arrayList = new ArrayList<MapLine>();
        MapLine[] mapLineArray = this.getLines();
        for (n = 0; n < mapLineArray.length; ++n) {
            if (mapPort != mapLineArray[n].getStartPoint() && mapPort != mapLineArray[n].getFinishPoint()) continue;
            arrayList.add(mapLineArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            MapLine mapLine = (MapLine)((Object)arrayList.get(n));
            this.removeLine(mapLine);
        }
        if (db.on()) {
            db.println("destroying port " + mapPort + " as part of " + "DMN::removePort()");
        }
        mapPort.destroy();
        this.removeComponent((IlvGraphic)mapPort);
    }

    public void removeLine(MapLine mapLine) {
        if (db.on()) {
            db.println("destroying line " + (Object)((Object)mapLine) + " as part of " + "DMN::removeLine()");
        }
        mapLine.destroy();
        this.removeComponent((IlvGraphic)mapLine);
    }
}

