/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class LinkClassStateDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Collapse/Expand Links";
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int MARGIN = 5;
    private JButton okButton;
    private JButton cancelButton;
    private CheckableList ckList;
    private MapToolkit mtk;
    private boolean ok = false;

    public LinkClassStateDialog(MapToolkit mapToolkit) {
        super(JOptionPane.getFrameForComponent((Component)((Object)mapToolkit)), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LinkClassStateDialog.this.dispose();
            }
        });
        this.mtk = mapToolkit;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getListPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.populateLB();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)mapToolkit));
        this.setVisible(true);
    }

    private JPanel getListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ckList = new CheckableList();
        this.ckList.setVisibleRowCount(6);
        jPanel.add((Component)new JLabel("Select to collapse/Unselect to expand:"), "North");
        jPanel.add((Component)new UScrollPane((Component)this.ckList), "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.ok = true;
        }
        this.dispose();
    }

    boolean isOk() {
        return this.ok;
    }

    private void populateLB() {
        TreeMap treeMap = this.mtk.getLinkClassStateMap();
        ArrayList<CheckableItem> arrayList = new ArrayList<CheckableItem>();
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (!this.mtk.containsLinkClass(string)) continue;
            int n = (Integer)treeMap.get(string);
            boolean bl = false;
            if (n == 1) {
                bl = true;
            }
            arrayList.add(new CheckableItem(string, bl));
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    CheckableItem checkableItem = (CheckableItem)object;
                    CheckableItem checkableItem2 = (CheckableItem)object2;
                    return checkableItem.toString().compareTo(checkableItem2.toString());
                }
            });
        }
        this.ckList.setListData(arrayList.toArray(new CheckableItem[0]));
    }

    TreeMap getLinkClassStateMap() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        ListModel listModel = this.ckList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            int n = checkableItem.isSelected() ? 1 : 2;
            treeMap.put(checkableItem.toString(), new Integer(n));
        }
        return treeMap;
    }
}

