/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.MapObjectAdapter;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolyline;
import java.awt.Color;
import java.awt.geom.Point2D;

public class MapLine
extends IlvPolyline {
    DetailedMapNode parentNode;
    IMapLineEndpoint startPoint;
    IMapLineEndpoint finishPoint;
    private Object userCookie;

    public MapLine(DetailedMapNode detailedMapNode, IMapLineEndpoint iMapLineEndpoint, IMapLineEndpoint iMapLineEndpoint2) {
        super(new IlvPoint[]{new IlvPoint(0.0f, 0.0f), new IlvPoint(1.0f, 0.0f)});
        this.parentNode = detailedMapNode;
        this.startPoint = iMapLineEndpoint;
        this.finishPoint = iMapLineEndpoint2;
    }

    public void init(Object object) {
        this.userCookie = object;
        this.initLine();
    }

    protected void initLine() {
    }

    public IMapLineEndpoint getStartPoint() {
        return this.startPoint;
    }

    public IMapLineEndpoint getFinishPoint() {
        return this.finishPoint;
    }

    public Point2D getPoint(int n) {
        IlvPoint[] ilvPointArray = this.getPoints();
        IlvPoint ilvPoint = ilvPointArray[n];
        return new Point2D.Float((float)ilvPoint.getX(), (float)ilvPoint.getY());
    }

    public int getPointCount() {
        return super.getPoints().length;
    }

    public void addPoint(double d, double d2) {
        super.insertPoint(this.getPoints().length, (float)d, (float)d2, null);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void removePoints(int n) {
        for (int i = 0; i < n; ++i) {
            super.removePoint(0, null);
        }
    }

    public void setMovable(boolean bl) {
        IlvGraphicBag ilvGraphicBag = super.getGraphicBag();
        if (ilvGraphicBag != null && ilvGraphicBag instanceof AbstractGraph) {
            ((AbstractGraph)ilvGraphicBag).setMovable((IlvGraphic)this, bl);
        }
    }

    public void setSelectable(boolean bl) {
        IlvGraphicBag ilvGraphicBag = super.getGraphicBag();
        if (ilvGraphicBag != null && ilvGraphicBag instanceof AbstractGraph) {
            ((AbstractGraph)ilvGraphicBag).setSelectable((IlvGraphic)this, bl);
        }
    }

    public void setColor(Color color) {
        super.setForeground(color);
        this.reDraw();
    }

    public void reDraw() {
        super.reDraw();
    }

    public final String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getToolTipText();
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    void setLocation(double d, double d2) {
        MapObjectAdapter.setLocation(this.parentNode.getGraph(), (IlvGraphic)this, d, d2);
    }

    public void initLocationChange() {
        this.parentNode.setLocation((IlvGraphic)this, 0.0f, 0.0f);
    }

    public void destroy() {
    }
}

