/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;

public class MapLinkBundle
extends Link {
    public static final int COLLAPSED_STATE = 1;
    public static final int EXPANDED_STATE = 2;
    static String DOMAIN_LINK = "DOMAIN";
    public String CMD_EXPAND_SIMILAR_LINKS = "";
    private Vector links = new Vector();
    private int bundleState = 2;
    private boolean domainLink = false;
    private Node src;
    private Node dst;

    public MapLinkBundle(MapToolkit mapToolkit, Node node, Node node2, String string, int n) {
        super(mapToolkit, node, node2, string);
        this.CMD_EXPAND_SIMILAR_LINKS = "Expand " + string + " Links";
        if (string != null && string.equals(DOMAIN_LINK)) {
            this.bundleState = 1;
            this.domainLink = true;
        } else {
            this.bundleState = n;
        }
        this.setLineThickness(3);
        this.refreshUI();
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (!this.domainLink && this.getBundleState() == 1) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, this.CMD_EXPAND_SIMILAR_LINKS, 69);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CMD_EXPAND_SIMILAR_LINKS) {
            this.doExpand();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void doubleClicked() {
        if (!this.domainLink) {
            this.doExpand();
        }
    }

    public synchronized void doExpand() {
        MapLink[] mapLinkArray;
        if (this.domainLink || this.bundleState == 2) {
            return;
        }
        this.bundleState = 2;
        LinkBundle linkBundle = this.mtk.getLinkBundle(this.getBundleKey());
        if (linkBundle != null && (mapLinkArray = this.getLinks()) != null) {
            linkBundle.removeLink(this);
            for (int i = 0; i < mapLinkArray.length; ++i) {
                linkBundle.addLink(mapLinkArray[i]);
                mapLinkArray[i].placeIcons();
            }
            this.mtk.reorderLinksBetweenNodes(linkBundle);
        }
    }

    public synchronized void doCollapse() {
        MapLink[] mapLinkArray;
        if (this.domainLink || this.bundleState == 1) {
            return;
        }
        this.bundleState = 1;
        LinkBundle linkBundle = this.mtk.getLinkBundle(this.getBundleKey());
        if (linkBundle != null && (mapLinkArray = this.getLinks()) != null) {
            for (int i = 0; i < mapLinkArray.length; ++i) {
                linkBundle.removeLink(mapLinkArray[i]);
            }
            linkBundle.addLink(this);
            this.mtk.reorderLinksBetweenNodes(linkBundle);
        }
    }

    public boolean isDomainLink() {
        return this.domainLink;
    }

    public int getBundleState() {
        return this.bundleState;
    }

    String getBundleStateString() {
        if (this.bundleState == 1) {
            return "collapsed";
        }
        return "expanded";
    }

    public boolean isConnectedTo(Node node) {
        return node.isSameNodeAs(this.src) || node.isSameNodeAs(this.dst);
    }

    public String getToolTipText() {
        return "Aggregated link: " + this.links.size() + " link" + (this.links.size() > 1 ? "s" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLink(MapLink mapLink) {
        Vector vector = this.links;
        synchronized (vector) {
            this.links.add(mapLink);
            mapLink.addContainer(this);
            this.refreshUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLink(MapLink mapLink) {
        Vector vector = new Vector(this.links);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            MapLink mapLink2 = (MapLink)iterator.next();
            if (mapLink2.getUserObject() != mapLink.getUserObject()) continue;
            Vector vector2 = this.links;
            synchronized (vector2) {
                this.links.remove(mapLink2);
                mapLink2.removeContainer(this);
                this.refreshUI();
            }
        }
        if (this.links.size() == 0) {
            this.destroy();
        }
    }

    protected void refreshUI() {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        this.removeAllDecorativeIcons();
        MapLink[] mapLinkArray = this.getLinks();
        for (int i = 0; i < mapLinkArray.length; ++i) {
            if (this.getSrc() == mapLinkArray[i].getSrc()) {
                treeMap.putAll(mapLinkArray[i].getSrcDecorativeIcons());
                treeMap2.putAll(mapLinkArray[i].getDstDecorativeIcons());
                continue;
            }
            treeMap.putAll(mapLinkArray[i].getDstDecorativeIcons());
            treeMap2.putAll(mapLinkArray[i].getSrcDecorativeIcons());
        }
        this.addIcons(treeMap, true);
        this.addIcons(treeMap2, false);
    }

    private void addIcons(TreeMap treeMap, boolean bl) {
        Set set = treeMap.keySet();
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            MapImageIcon mapImageIcon;
            Image image;
            String string = (String)iterator.next();
            Object v = treeMap.get(string);
            if (!(v instanceof MapImageIcon) || (image = (mapImageIcon = (MapImageIcon)((Object)v)).getImage()) == null) continue;
            if (bl) {
                this.addSrcDecorativeIcon(string, new MapImageIcon(image));
                continue;
            }
            this.addTargetDecorativeIcon(string, new MapImageIcon(image));
        }
    }

    public MapLink[] getLinks() {
        return this.links.toArray(new MapLink[0]);
    }

    public final void destroy() {
        if (!this.domainLink) {
            this.mtk.removeMapBundle(this);
        }
        super.destroy();
    }
}

