/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapSelector;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class MapMouseAdapter
extends MouseAdapter
implements MouseMotionListener {
    private MapToolkit mtk;
    private boolean mouseDragging = false;

    public MapMouseAdapter(MapToolkit mapToolkit) {
        this.mtk = mapToolkit;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mtk.setHitPosition(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY()));
        Object object = this.mtk.getMapObjectAt(mouseEvent.getX(), mouseEvent.getY());
        if (!(object instanceof LinkBundle)) {
            this.mtk.deselectLinksInLinkBundles();
        }
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggered(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mtk.setHitPosition(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY()));
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggered(mouseEvent);
        } else {
            if (!this.mouseDragging) {
                return;
            }
            this.mouseDragging = false;
            MapGraph mapGraph = (MapGraph)this.mtk.getGraph();
            int n = mapGraph.getSelectedComponentsCount();
            Object[] objectArray = mapGraph.getSelectedComponents();
            Object object = null;
            if (n > 0) {
                object = objectArray[0];
            }
            if (object != null && object instanceof MapNode && n == 1) {
                Object[] objectArray2 = mapGraph.getComponents();
                for (int i = 0; i < this.mtk.getGraph().getComponentsCount(); ++i) {
                    Object object2 = objectArray2[i];
                    if (!(object2 instanceof MapDomain) || !mapGraph.isObjectsIntersected(object, object2)) continue;
                    MapNode mapNode = (MapNode)object;
                    MapDomain mapDomain = (MapDomain)object2;
                    if (!mapNode.canInsertToDomain()) continue;
                    this.mtk.moveNode(mapNode, mapDomain.getName());
                    return;
                }
            }
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof Node)) continue;
                Node node = (Node)objectArray[i];
                node.setCoordinates(node.getCenterX(), node.getCenterY(), true);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mtk.setHitPosition(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY()));
        Object object = this.mtk.getMapObjectAt(mouseEvent.getX(), mouseEvent.getY());
        if (object == null) {
            return;
        }
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        if (mouseEvent.getClickCount() == 2) {
            if (object instanceof Node) {
                ((Node)object).doubleClicked();
            } else if (object instanceof Link) {
                ((Link)object).doubleClicked();
            } else if (object instanceof LinkBundle) {
                ((LinkBundle)object).doubleClicked(mouseEvent);
            } else if (object instanceof MapPort) {
                ((MapPort)object).doubleClicked();
            } else if (object instanceof MapSelector) {
                ((MapSelector)object).doubleClicked();
            }
        } else if (object instanceof Node) {
            ((Node)object).clicked();
        } else if (object instanceof Link) {
            ((Link)object).clicked();
        } else if (object instanceof LinkBundle) {
            ((LinkBundle)object).clicked(mouseEvent);
        } else if (object instanceof MapPort) {
            ((MapPort)object).clicked();
        } else if (object instanceof MapSelector) {
            ((MapSelector)object).clicked();
        }
    }

    private void popupTriggered(MouseEvent mouseEvent) {
        Object object = this.mtk.getMapObjectAt(mouseEvent.getX(), mouseEvent.getY());
        UPopupMenu uPopupMenu = new UPopupMenu();
        if (object == null) {
            this.mtk.onInitPopupMenu(uPopupMenu);
        } else if (object instanceof Node) {
            ((Node)object).onInitPopupMenu(uPopupMenu);
        } else if (object instanceof Link) {
            ((Link)object).onInitPopupMenu(uPopupMenu);
        } else if (object instanceof LinkBundle) {
            ((LinkBundle)object).onInitPopupMenu(uPopupMenu, mouseEvent);
        } else if (object instanceof MapPort) {
            ((MapPort)object).onInitPopupMenu(uPopupMenu);
        } else if (object instanceof MapSelector) {
            ((MapSelector)object).onInitPopupMenu(uPopupMenu);
        }
        if (uPopupMenu != null && uPopupMenu.getComponentCount() > 0) {
            uPopupMenu.show((Component)((Object)this.mtk), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragging = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.toggleCursor(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mtk.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mtk.isSelectZoom()) {
            this.mtk.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    private void toggleCursor(MouseEvent mouseEvent) {
        Object object = this.mtk.getMapObjectAt(mouseEvent.getX(), mouseEvent.getY());
        if (!this.mtk.isSelectZoom()) {
            if (object == null) {
                this.mtk.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.mtk.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }
}

