/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.CoordinateElement;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SuffixAwareFileFilter;
import cerent.util.gui.UFileChooser;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.AutoLayoutDialog;
import com.cisco.ctc.util.map.DomainNameEditDialog;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.LinkClassStateDialog;
import com.cisco.ctc.util.map.MTKDebug;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapLinkInfo;
import com.cisco.ctc.util.map.MapMouseAdapter;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapView;
import com.cisco.ctc.util.map.Node;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;

public class MapToolkit
extends MapView
implements ActionListener {
    public static final String CMD_GOTO_PARENT = "Go To Parent View";
    public static final String CMD_NEW_DOMAIN = "Create New Domain...";
    public static final String CMD_CENTER_VIEW = "Center View";
    public static final String CMD_FIT_VIEW = "Fit Content to View";
    public static final String CMD_RESET_ZOOM = "Reset Zoom";
    public static final String CMD_ZOOM_IN = "Zoom In";
    public static final String CMD_ZOOM_OUT = "Zoom Out";
    public static final String CMD_ZOOM_SEL = "Zoom Selected Area";
    public static final String CMD_SET_BACK_COLOR = "Set Background Color...";
    public static final String CMD_SET_BACK_IMAGE = "Set Background Image...";
    public static final String CMD_REMOVE_BACK_IMAGE = "Remove Background Image";
    public static final String CMD_AUTO_LAYOUT = "Auto Layout...";
    public static final String CMD_COLLAPSE_EXPAND_LINKS = "Collapse/Expand Links...";
    public static final String CMD_SHOW_LINK_ICONS = "Show Link Icons";
    public static final String ICON_ZOOM_OUT = "/images/icons/zoom_out16.gif";
    public static final String ICON_ZOOM_IN = "/images/icons/zoom_in16.gif";
    public static final String ICON_ZOOM_SEL = "/images/icons/zoom_selected.gif";
    public static final String ICON_COLLAPSE_EXPAND_LINKS = "/images/icons/collapse_expand_links.gif";
    public static final String ROOT_DOMAIN = "";
    public boolean enableLinkIcon = true;
    private MapGraph rootGraph;
    private SDebug db;
    private Map nodes = Collections.synchronizedMap(new HashMap());
    private Map links = Collections.synchronizedMap(new HashMap());
    private Map domains = Collections.synchronizedMap(new HashMap());
    protected ActionOrganizer actOrg = null;
    protected IMapFactory mapFactory = null;
    private TreeMap preferredLinkClassBundleStateMap = new TreeMap();
    private TreeMap actualLinkClassBundleStateMap = new TreeMap();
    private TreeMap linkBundleMap = new TreeMap();
    private TreeMap mlbMap = new TreeMap();
    private int seqNum = 0;
    private Rectangle2D.Double coordinatesRect = null;
    private boolean isDetailed = false;
    private int linkOffset = 8;

    public MapToolkit(SDebug sDebug, IMapFactory iMapFactory) {
        this.db = new MTKDebug(sDebug, this);
        this.mapFactory = iMapFactory;
        this.rootGraph = new MapGraph(this);
        this.setGraph(this.rootGraph);
        MapMouseAdapter mapMouseAdapter = new MapMouseAdapter(this);
        this.addMouseListener(mapMouseAdapter);
        this.addMouseMotionListener(mapMouseAdapter);
        this.setPreferredSize(new Dimension(800, 600));
        this.getMapProperty(this, 100);
        this.getMapProperty(this, 109);
        this.enableLinkIcon = this.getMapProperty(this, 110);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeMap getLinkClassStateMap() {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = this.actualLinkClassBundleStateMap;
        synchronized (treeMap2) {
            Iterator iterator = this.actualLinkClassBundleStateMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                treeMap.put(entry.getKey(), entry.getValue());
            }
        }
        return treeMap;
    }

    public void setPreferredLinkClassBundleState(String string, int n) {
        if (n == 1 || n == 2) {
            String string2 = n == 1 ? "Collapsed" : "Expanded";
            this.println("setPreferredLinkClassBundleState: linkClass=" + string + " state=" + n + " stateStr=" + string2);
            this.preferredLinkClassBundleStateMap.put(string, new Integer(n));
        }
    }

    public synchronized MapNode addNode(Object object, String string, double d, double d2, Object object2) {
        MapGraph mapGraph = this.rootGraph;
        this.println("addNode: key=" + object + " domain=" + string + " centerX=" + d + " centerY=" + d2 + " userCookie=" + object2);
        if (string != null && string.length() > 0) {
            MapDomain mapDomain = (MapDomain)this.domains.get(string);
            if (mapDomain == null) {
                mapDomain = this.createDomain(string, d, d2, object2);
            }
            mapGraph = mapDomain.getChildGraph();
        }
        return this.addNode(mapGraph, object, d, d2, object2);
    }

    public synchronized MapDomain createDomain(String string, double d, double d2, Object object) {
        MapDomain mapDomain = this.createDomain(object);
        if (string == null) {
            string = this.makeDomainName();
        }
        this.println("createDomain: " + string + " centerX =" + d + " centerY=" + d2 + " userCookie=" + object);
        mapDomain.setName(string);
        this.rootGraph.add(mapDomain);
        mapDomain.init(null, d, d2, object);
        this.domains.put(string, mapDomain);
        this.domainCreated(mapDomain);
        return mapDomain;
    }

    private String makeDomainName() {
        String string = null;
        int n = 0;
        while (this.domains.containsKey(string = "domain-" + n)) {
            ++n;
        }
        return string;
    }

    private MapNode addNode(MapGraph mapGraph, Object object, double d, double d2, Object object2) {
        if (this.nodes.get(object) != null) {
            this.println("addNode: key already exists:" + object);
            return (MapNode)this.nodes.get(object);
        }
        MapNode mapNode = this.createNode(object2);
        mapNode.setID(++this.seqNum);
        mapGraph.add(mapNode);
        mapNode.init(object, d, d2, object2);
        this.nodes.put(object, mapNode);
        this.nodeCreated(mapNode);
        return mapNode;
    }

    protected boolean duplicateLinkKey(Object object) {
        return this.links.get(object) != null;
    }

    public synchronized MapLink addLink(Object object, Object object2, Object object3, String string, Object object4) {
        if (this.duplicateLinkKey(object)) {
            this.println("addLink: key already exists:" + object);
            return this.getMapLink(object);
        }
        MapLink mapLink = null;
        MapNode mapNode = this.getMapNode(object2);
        MapNode mapNode2 = this.getMapNode(object3);
        if (mapNode == null || mapNode2 == null) {
            this.println("addLink: either src or dst is null");
            return null;
        }
        this.println("adding link = " + object + " between src=" + object2 + " dst=" + object3 + " linkClass=" + string + " cookie=" + object4);
        MapGraph mapGraph = mapNode.getMapGraph();
        MapGraph mapGraph2 = mapNode2.getMapGraph();
        if (mapGraph == mapGraph2) {
            this.println("addLink: both nodes are in the same graph");
            mapLink = this.createMapLink(object, mapNode, mapNode2, string, object4);
            this.addLinkToBundle(mapGraph, mapLink);
            this.links.put(object, mapLink);
            mapNode.linkAdded(mapLink);
            mapNode2.linkAdded(mapLink);
        } else {
            MapLinkInfo mapLinkInfo = null;
            MapLinkBundle mapLinkBundle = null;
            MapNode mapNode3 = null;
            if (!mapGraph.isDomainGraph() || !mapGraph2.isDomainGraph()) {
                MapNode mapNode4 = null;
                MapNode mapNode5 = null;
                MapGraph mapGraph3 = null;
                if (mapGraph.isDomainGraph()) {
                    mapNode4 = mapNode2;
                    mapNode5 = mapNode;
                    mapGraph3 = mapGraph;
                } else {
                    mapNode4 = mapNode;
                    mapNode5 = mapNode2;
                    mapGraph3 = mapGraph2;
                }
                MapDomain mapDomain = (MapDomain)mapGraph3.getOwner();
                mapLinkBundle = this.createDomainLink(mapNode4, mapDomain);
                mapLinkInfo = new MapLinkInfo(mapLinkBundle);
                mapNode3 = this.getVirtualNode(mapGraph3, mapNode4);
                mapLink = mapNode5 == mapNode ? this.createMapLink(object, mapNode5, mapNode3, string, object4) : this.createMapLink(object, mapNode3, mapNode5, string, object4);
                this.addLinkToBundle(mapGraph3, mapLink);
                mapLinkInfo.addLink(mapLink);
                mapLinkBundle.addLink(mapLink);
                mapNode3.linkAdded(mapLink);
                mapNode5.linkAdded(mapLink);
            } else {
                MapDomain mapDomain = (MapDomain)mapGraph.getOwner();
                MapDomain mapDomain2 = (MapDomain)mapGraph2.getOwner();
                mapLinkBundle = this.createDomainLink(mapDomain, mapDomain2);
                mapLinkInfo = new MapLinkInfo(mapLinkBundle);
                mapNode3 = this.getVirtualNode(mapGraph, mapNode2);
                mapLink = this.createMapLink(object, mapNode, mapNode3, string, object4);
                this.addLinkToBundle(mapGraph, mapLink);
                mapLinkInfo.addLink(mapLink);
                mapNode.linkAdded(mapLink);
                mapNode3.linkAdded(mapLink);
                mapNode3 = this.getVirtualNode(mapGraph2, mapNode);
                mapLink = this.createMapLink(object, mapNode3, mapNode2, string, object4);
                this.addLinkToBundle(mapGraph2, mapLink);
                mapLinkInfo.addLink(mapLink);
                mapNode3.linkAdded(mapLink);
                mapNode2.linkAdded(mapLink);
                mapLinkBundle.addLink(mapLink);
            }
            this.links.put(object, mapLinkInfo);
        }
        return mapLink;
    }

    synchronized boolean containsLinkClass(String string) {
        HashMap hashMap = (HashMap)this.mlbMap.get(string);
        return hashMap != null && hashMap.size() > 0;
    }

    synchronized void addLinkToBundle(MapGraph mapGraph, MapLink mapLink) {
        if (this.isDetailed()) {
            mapGraph.add(mapLink);
            return;
        }
        LinkBundle linkBundle = this.getLinkBundle(mapGraph, mapLink);
        MapLinkBundle mapLinkBundle = this.getMapLinkBundle(mapLink);
        mapLinkBundle.addLink(mapLink);
        if (mapLinkBundle.getBundleState() == 1) {
            linkBundle.addLink(mapLinkBundle);
        } else {
            linkBundle.addLink(mapLink);
        }
        this.reorderLinksBetweenNodes(linkBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkBundle getLinkBundle(String string) {
        TreeMap treeMap = this.linkBundleMap;
        synchronized (treeMap) {
            LinkBundle linkBundle = (LinkBundle)this.linkBundleMap.get(string);
            this.println("getLinkBundle: found key=" + string);
            return linkBundle;
        }
    }

    void deselectLinksInLinkBundles() {
        this.deselectLinksInLinkBundles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deselectLinksInLinkBundles(LinkBundle linkBundle) {
        TreeMap treeMap = this.linkBundleMap;
        synchronized (treeMap) {
            Collection collection = this.linkBundleMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                LinkBundle linkBundle2 = (LinkBundle)iterator.next();
                if (linkBundle == linkBundle2) continue;
                linkBundle2.deselectAllLinks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLinkBundle(String string) {
        TreeMap treeMap = this.linkBundleMap;
        synchronized (treeMap) {
            LinkBundle linkBundle = (LinkBundle)this.linkBundleMap.get(string);
            if (linkBundle != null && linkBundle.getLinks().length == 0) {
                this.linkBundleMap.remove(string);
                this.println("removeLinkBundle: from linkBundleMap key=" + string);
                AbstractGraph abstractGraph = linkBundle.getGraph();
                if (abstractGraph != null && abstractGraph.contains(linkBundle)) {
                    abstractGraph.remove((IlvGraphic)linkBundle);
                    this.println("removeLinkBundle: from graph");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkBundle getLinkBundle(MapGraph mapGraph, MapLink mapLink) {
        LinkBundle linkBundle = null;
        String string = mapLink.getBundleKey();
        TreeMap treeMap = this.linkBundleMap;
        synchronized (treeMap) {
            if (this.linkBundleMap.containsKey(string)) {
                linkBundle = (LinkBundle)this.linkBundleMap.get(string);
            } else {
                linkBundle = new LinkBundle(this, mapLink.getSource(), mapLink.getTarget(), string);
                this.linkBundleMap.put(string, linkBundle);
                if (!mapGraph.contains(linkBundle)) {
                    mapGraph.add(linkBundle);
                }
            }
        }
        return linkBundle;
    }

    synchronized MapLinkBundle getMapLinkBundle(MapLink mapLink) {
        HashMap hashMap = null;
        String string = mapLink.getLinkClass();
        if (this.mlbMap.containsKey(string)) {
            hashMap = (HashMap)this.mlbMap.get(string);
        } else {
            hashMap = new HashMap();
            this.mlbMap.put(string, hashMap);
        }
        String string2 = mapLink.getBundleKey();
        MapLinkBundle mapLinkBundle = null;
        if (hashMap.containsKey(string2)) {
            mapLinkBundle = (MapLinkBundle)hashMap.get(string2);
            this.println("getMapLinkBundle: found state=" + mapLinkBundle.getBundleStateString() + " key=" + string2);
        } else {
            int n = this.getLinkClassState(string);
            mapLinkBundle = this.createLinkBundle(mapLink.getSrc(), mapLink.getDst(), string, n);
            this.println("getMapLinkBundle: creating state=" + mapLinkBundle.getBundleStateString() + " key=" + string2);
            mapLinkBundle.init(null, null);
            hashMap.put(string2, mapLinkBundle);
        }
        return mapLinkBundle;
    }

    synchronized void reorderLinksBetweenNodes(LinkBundle linkBundle) {
        Vector vector;
        String string;
        TreeMap treeMap = new TreeMap();
        Link[] linkArray = linkBundle.getLinks();
        if (linkArray == null) {
            return;
        }
        for (int i = 0; i < linkArray.length; ++i) {
            Link link = linkArray[i];
            string = link.getLinkClass();
            if (string == null) continue;
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new Vector());
            }
            vector = (Vector)treeMap.get(string);
            vector.add(link);
        }
        Set set = treeMap.keySet();
        if (set == null || set.size() == 1) {
            return;
        }
        for (int i = 0; i < linkArray.length; ++i) {
            linkBundle.removeLink(linkArray[i]);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            vector = (Vector)treeMap.get(string);
            if (vector == null) continue;
            for (int i = 0; i < vector.size(); ++i) {
                Link link = (Link)vector.get(i);
                linkBundle.addLink(link);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doCollapseExpandLinks() {
        LinkClassStateDialog linkClassStateDialog = new LinkClassStateDialog(this);
        if (linkClassStateDialog.isOk()) {
            TreeMap treeMap = linkClassStateDialog.getLinkClassStateMap();
            Iterator iterator = treeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                int n = (Integer)entry.getValue();
                this.collapseExpandLinks(string, n);
                TreeMap treeMap2 = this.actualLinkClassBundleStateMap;
                synchronized (treeMap2) {
                    this.actualLinkClassBundleStateMap.put(string, entry.getValue());
                }
                this.mapPropertyChanged(this, 109, string, entry.getValue().toString());
            }
        }
    }

    private void collapseExpandLinks(String string, int n) {
        HashMap hashMap = (HashMap)this.mlbMap.get(string);
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                MapLinkBundle mapLinkBundle = (MapLinkBundle)hashMap.get(k);
                if (n != 1) {
                    mapLinkBundle.doExpand();
                    continue;
                }
                mapLinkBundle.doCollapse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMapBundle(MapLinkBundle mapLinkBundle) {
        TreeMap treeMap = this.mlbMap;
        synchronized (treeMap) {
            HashMap hashMap = (HashMap)this.mlbMap.get(mapLinkBundle.getLinkClass());
            if (hashMap != null) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (hashMap.get(string) != mapLinkBundle) continue;
                    hashMap.remove(string);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLinkClassState(String string) {
        int n = 2;
        TreeMap treeMap = this.actualLinkClassBundleStateMap;
        synchronized (treeMap) {
            if (this.actualLinkClassBundleStateMap.containsKey(string)) {
                return (Integer)this.actualLinkClassBundleStateMap.get(string);
            }
            if (this.preferredLinkClassBundleStateMap.containsKey(string)) {
                n = (Integer)this.preferredLinkClassBundleStateMap.get(string);
            }
            this.actualLinkClassBundleStateMap.put(string, new Integer(n));
        }
        return n;
    }

    public void moveNode(MapNode mapNode) {
        if (mapNode != null) {
            this.moveNode(this.rootGraph, mapNode);
        }
    }

    public synchronized void moveNode(MapNode mapNode, String string) {
        if (string.equals(ROOT_DOMAIN)) {
            this.moveNode(mapNode);
            return;
        }
        MapDomain mapDomain = (MapDomain)this.domains.get(string);
        if (mapNode != null && mapDomain != null) {
            this.moveNode(mapDomain.getChildGraph(), mapNode);
        }
    }

    private synchronized void moveNode(MapGraph mapGraph, MapNode mapNode) {
        MapLink mapLink;
        Object object;
        if (mapGraph == mapNode.getMapGraph()) {
            return;
        }
        if (mapNode.isVirtual()) {
            return;
        }
        String string = mapNode.getDomainName();
        HashSet<MapLink> hashSet = new HashSet<MapLink>();
        Object object2 = this.links.keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            mapLink = this.getMapLink(object);
            if (!mapLink.isConnectedTo(mapNode)) continue;
            hashSet.add(mapLink);
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (MapLink)object2.next();
            this.deleteLink(((Link)object).getUserObject());
        }
        this.nodes.remove(mapNode.getUserObject());
        object2 = this.addNode(mapGraph, mapNode.getUserObject(), mapNode.getCenterX(), mapNode.getCenterY(), mapNode.getUserCookie());
        mapNode.destroy();
        object = hashSet.iterator();
        while (object.hasNext()) {
            mapLink = (MapLink)object.next();
            this.println("adding link key=" + mapLink.getUserObject() + " " + mapLink.getSource().getUserObject() + "/" + mapLink.getTarget().getUserObject());
            this.addLink(mapLink.getUserObject(), mapLink.getSourceNode().getUserObject(), mapLink.getTargetNode().getUserObject(), mapLink.getLinkClass(), mapLink.getUserCookie());
        }
        this.db.finest("Notifying about domain change");
        this.mapPropertyChanged(object2, 103, string, ((MapNode)object2).getDomainName());
        this.reDraw();
    }

    public synchronized void deleteLink(Object object) {
        Object v = this.links.get(object);
        if (v == null) {
            return;
        }
        if (v instanceof MapLinkInfo) {
            MapLinkInfo mapLinkInfo = (MapLinkInfo)v;
            mapLinkInfo.destroy();
        } else {
            MapLink mapLink = (MapLink)v;
            MapNode mapNode = mapLink.getSourceNode();
            MapNode mapNode2 = mapLink.getTargetNode();
            if (mapNode != null) {
                mapNode.linkToBeRemoved(mapLink);
                mapNode2.linkToBeRemoved(mapLink);
            }
            mapLink.destroy();
        }
        this.links.remove(object);
    }

    public void reInitMap() {
        this.deleteAllObjects();
        this.isDetailed = false;
    }

    public void reInitMapToDetailed() {
        this.deleteAllObjects();
        this.isDetailed = true;
    }

    protected synchronized void deleteAllLinks() {
        Object[] objectArray = this.links.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.deleteLink(objectArray[i]);
        }
    }

    private synchronized void deleteAllObjects() {
        int n;
        this.deleteAllLinks();
        Object[] objectArray = this.nodes.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            this.deleteNode(objectArray[n]);
        }
        objectArray = this.domains.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            MapDomain mapDomain = (MapDomain)this.domains.remove(objectArray[n]);
            mapDomain.destroy();
        }
    }

    private MapLink createMapLink(Object object, MapNode mapNode, MapNode mapNode2, String string, Object object2) {
        this.println("createMapLink: key=" + object + " src=" + mapNode + " dst=" + mapNode2 + " linkClass=" + string + " userCookie=" + object2);
        MapLink mapLink = this.createLink(mapNode, mapNode2, string, object2);
        mapLink.init(object, object2);
        return mapLink;
    }

    private MapLinkBundle createDomainLink(Node node, Node node2) {
        MapLinkBundle mapLinkBundle = null;
        boolean bl = false;
        MapLinkBundle[] mapLinkBundleArray = this.rootGraph.getDomainLinks();
        for (int i = 0; i < mapLinkBundleArray.length; ++i) {
            mapLinkBundle = mapLinkBundleArray[i];
            if (!(mapLinkBundle instanceof MapLinkBundle) || !mapLinkBundle.matches(node, node2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            mapLinkBundle = this.createLinkBundle(node, node2, MapLinkBundle.DOMAIN_LINK, 1);
            mapLinkBundle.init(null, null);
            this.rootGraph.add(mapLinkBundle);
        }
        return mapLinkBundle;
    }

    public synchronized void deleteNode(Object object) {
        MapNode mapNode = (MapNode)this.nodes.remove(object);
        if (mapNode != null) {
            this.println("disposing " + mapNode);
            mapNode.destroy();
        } else {
            this.println("couldn't find node " + object + " to delete");
        }
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.actOrg = null;
    }

    protected void initPopupMenu(Object object, ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isRootGraph()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_NEW_DOMAIN, 78);
        } else {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_GOTO_PARENT, 71);
        }
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, ICON_ZOOM_IN, CMD_ZOOM_IN, 73);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, ICON_ZOOM_OUT, CMD_ZOOM_OUT, 79);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, ICON_ZOOM_SEL, CMD_ZOOM_SEL, 83);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_RESET_ZOOM, 90);
        this.actOrg.getAbstractButton(CMD_RESET_ZOOM).setEnabled(this.getZoomCount() != 0);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_CENTER_VIEW, 67);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_FIT_VIEW, 70);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_SET_BACK_COLOR, 66);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_SET_BACK_IMAGE, 77);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_REMOVE_BACK_IMAGE, 82);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_AUTO_LAYOUT, 76);
        if (!this.isDetailed()) {
            uPopupMenu.addSeparator();
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_COLLAPSE_EXPAND_LINKS, 76);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(CMD_SHOW_LINK_ICONS);
            jCheckBoxMenuItem.setState(this.enableLinkIcon);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, jCheckBoxMenuItem, null, CMD_SHOW_LINK_ICONS);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_GOTO_PARENT) {
            if (this.getMapGraph().isDomainGraph()) {
                this.doGoToRootGraph();
            }
        } else if (string == CMD_NEW_DOMAIN) {
            if (!this.getMapGraph().isDomainGraph()) {
                this.doCreateDomain();
            }
        } else if (string == CMD_CENTER_VIEW) {
            this.centerView();
        } else if (string == CMD_FIT_VIEW) {
            this.doFitView();
        } else if (string == CMD_RESET_ZOOM) {
            this.doResetZoom();
        } else if (string == CMD_ZOOM_IN) {
            this.doZoomIn();
        } else if (string == CMD_ZOOM_OUT) {
            this.doZoomOut();
        } else if (string == CMD_ZOOM_SEL) {
            this.doSelectZoom();
        } else if (string == CMD_SET_BACK_COLOR) {
            this.doSetBackColor();
        } else if (string == CMD_SET_BACK_IMAGE) {
            this.doSetBackImage();
        } else if (string == CMD_REMOVE_BACK_IMAGE) {
            if (CerentDialog.yesNoDialog((Component)this.getGraphWindow(), (String)"Really remove the background image?", (String)"Confirm Remove")) {
                this.doRemoveBackImage();
            }
        } else if (string == CMD_AUTO_LAYOUT) {
            this.doAutoLayout();
        } else if (string == CMD_COLLAPSE_EXPAND_LINKS) {
            if (!this.isDetailed()) {
                this.doCollapseExpandLinks();
            }
        } else if (string == CMD_SHOW_LINK_ICONS) {
            this.setEnableLinkIcon(!this.enableLinkIcon);
        }
    }

    protected void doAutoLayout() {
        AutoLayoutDialog autoLayoutDialog = new AutoLayoutDialog(this);
        if (autoLayoutDialog.isOk()) {
            Point2D.Double double_;
            Node node;
            int n;
            MapGraph mapGraph = this.getMapGraph();
            Rectangle2D rectangle2D = this.getViewRect();
            HashMap<Node, Point2D.Double> hashMap = new HashMap<Node, Point2D.Double>();
            Node[] nodeArray = mapGraph.getNodes();
            for (n = 0; n < nodeArray.length; ++n) {
                node = nodeArray[n];
                double_ = new Point2D.Double(node.getCenterX(), node.getCenterY());
                hashMap.put(node, double_);
            }
            this.doSpringLayout(rectangle2D);
            this.doUniformLengthEdgesLayout(rectangle2D);
            this.postAutoLayout();
            if (!CerentDialog.yesNoDialog((Component)this.getGraphWindow(), (String)"Accept Auto Layout result?", (String)"Auto Layout")) {
                for (n = 0; n < nodeArray.length; ++n) {
                    node = nodeArray[n];
                    double_ = (Point2D.Double)hashMap.get(node);
                    if (double_ == null) continue;
                    node.setCoordinates(double_.getX(), double_.getY());
                }
                this.reDraw();
            }
        }
    }

    void postAutoLayout() {
        Node[] nodeArray = this.getMapGraph().getNodes();
        if (this.isNodesInView(nodeArray)) {
            return;
        }
        Rectangle2D rectangle2D = this.getRect(nodeArray);
        double d = this.getMapTransformer().getx11();
        double d2 = Math.abs(this.getMapTransformer().getx0() / d);
        double d3 = Math.abs(this.getMapTransformer().gety0() / d);
        double d4 = d2 - rectangle2D.getX();
        double d5 = d3 - rectangle2D.getY();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            node.setCoordinates(node.getCenterX() + d4 + 50.0, node.getCenterY() + d5 + 50.0);
        }
    }

    protected void doCreateDomain() {
        DomainNameEditDialog domainNameEditDialog = new DomainNameEditDialog(this, this.makeDomainName(), 1);
        if (domainNameEditDialog.isOk()) {
            Point2D.Double double_ = this.getWorldPoint(this.hitPosition);
            this.createDomain(domainNameEditDialog.getName(), double_.getX(), double_.getY(), null);
            this.repaint();
        }
    }

    protected void doGoToRootGraph() {
        this.setGraph(this.rootGraph);
    }

    void setGraph(MapGraph mapGraph) {
        super.setGraph(mapGraph);
        this.getMapProperty(this, 111);
    }

    protected void viewChanged() {
        this.mapPropertyChanged(this, 111, null, null);
    }

    protected void doResetZoom() {
        this.resetZoom();
    }

    protected void doZoomIn() {
        this.zoomIn();
    }

    protected void doZoomOut() {
        this.zoomOut();
    }

    protected void doSelectZoom() {
        this.zoomSelectedArea();
    }

    protected void doFitView() {
        this.fitView();
    }

    protected void doGoToNodeDomain(MapNode mapNode) {
        this.jumpToDomain(mapNode.getRealNode().getDomain());
    }

    private void jumpToDomain(MapDomain mapDomain) {
        if (mapDomain == null) {
            this.setGraph(this.rootGraph);
        } else {
            this.setGraph(mapDomain.getChildGraph());
        }
    }

    protected void doRemoveBackImage() {
        MapGraph mapGraph = this.getMapGraph();
        if (mapGraph != null) {
            mapGraph.removeBackgroundImage();
        }
    }

    protected void doSetBackColor() {
        Color color = JColorChooser.showDialog((Component)((Object)this), "Choose Background Color", this.getBackground());
        if (color != null) {
            this.setBackgroundColor(color);
        }
    }

    protected void doSetBackImage() {
        UFileChooser uFileChooser = new UFileChooser("./images/maps");
        uFileChooser.setAcceptAllFileFilterUsed(false);
        uFileChooser.addChoosableFileFilter((FileFilter)new SuffixAwareFileFilter("JPEG files (*.jpg)", "jpg"));
        uFileChooser.addChoosableFileFilter((FileFilter)new SuffixAwareFileFilter("Gif files (*.gif)", "gif"));
        if (uFileChooser.showOpenDialog((Component)this.getParent()) == 0) {
            File file = uFileChooser.getSelectedFile();
            Object var3_3 = null;
            try {
                String string = file.getCanonicalPath();
                MapGraph mapGraph = this.getMapGraph();
                mapGraph.setBackgroundImage(string);
            }
            catch (Exception exception) {
                this.db.finest("Exception in doSetBackImage() " + exception);
            }
        }
        uFileChooser.dispose();
    }

    public synchronized void removeEmptyDomain(String string) {
        MapDomain mapDomain = (MapDomain)this.domains.get(string);
        if (mapDomain != null && mapDomain.getChildrenCount() < 1) {
            this.domains.remove(string);
            mapDomain.destroy();
        }
    }

    public synchronized void deleteDomain(String string) {
        MapDomain mapDomain = (MapDomain)this.domains.get(string);
        if (mapDomain != null) {
            MapNode mapNode;
            LinkedList<MapNode> linkedList = new LinkedList<MapNode>();
            MapNode[] mapNodeArray = mapDomain.getChildGraph().getMapNodes();
            for (int i = 0; i < mapNodeArray.length; ++i) {
                mapNode = mapNodeArray[i];
                if (mapNode.isVirtual()) continue;
                linkedList.add(mapNode);
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                mapNode = (MapNode)iterator.next();
                this.moveNode(this.rootGraph, mapNode);
                this.mapPropertyChanged(mapNode, 104, string, ROOT_DOMAIN);
            }
            this.domains.remove(string);
            mapDomain.destroy();
            this.mapPropertyChanged(mapDomain, 106, null, null);
            this.domainRemoved(mapDomain);
        }
        this.reDraw();
    }

    public synchronized void domainNameChanged(String string, String string2) {
        if (string.equals(ROOT_DOMAIN) || string2.equals(ROOT_DOMAIN) || this.domains.get(string2) != null) {
            return;
        }
        MapDomain mapDomain = (MapDomain)this.domains.get(string);
        if (mapDomain != null) {
            mapDomain.setName(string2);
            this.domains.remove(string);
            this.domains.put(string2, mapDomain);
            MapNode[] mapNodeArray = mapDomain.getNodes();
            for (int i = 0; i < mapNodeArray.length; ++i) {
                MapNode mapNode = mapNodeArray[i];
                if (mapNode.isVirtual()) continue;
                this.mapPropertyChanged(mapNode, 103, string, string2);
            }
            this.mapPropertyChanged(mapDomain, 105, string, string2);
            this.domainNameChanged(mapDomain, string, string2);
            this.reDraw();
        }
    }

    public void setBackground(String string) {
        this.rootGraph.setBackgroundImage(string);
    }

    public void displayDomain(MapDomain mapDomain) {
        this.jumpToDomain(mapDomain);
    }

    public void displayDomain(String string) {
        if (string.equals(ROOT_DOMAIN)) {
            this.doGoToRootGraph();
        } else {
            MapDomain mapDomain = (MapDomain)this.domains.get(string);
            if (mapDomain != null) {
                this.jumpToDomain(mapDomain);
            } else {
                this.doGoToRootGraph();
            }
        }
    }

    public String getCurrentDomainName() {
        MapGraph mapGraph = this.getMapGraph();
        if (mapGraph == this.rootGraph) {
            return ROOT_DOMAIN;
        }
        return mapGraph.getDomainName();
    }

    public MapDomain getCurrentDomain() {
        return (MapDomain)this.domains.get(this.getCurrentDomain());
    }

    void clicked(Node node) {
        if (node instanceof MapNode) {
            this.clicked((MapNode)node);
        } else if (node instanceof MapDomain) {
            this.clicked((MapDomain)node);
        }
    }

    protected void clicked(MapNode mapNode) {
    }

    protected void clicked(MapDomain mapDomain) {
    }

    void doubleClicked(Node node) {
        if (node instanceof MapNode) {
            this.doubleClicked((MapNode)node);
        } else if (node instanceof MapDomain) {
            this.doubleClicked((MapDomain)node);
        }
    }

    protected void doubleClicked(MapNode mapNode) {
    }

    protected void doubleClicked(MapDomain mapDomain) {
        this.displayDomain(mapDomain);
    }

    void selected(Node node, boolean bl) {
        if (node instanceof MapNode) {
            this.nodeSelected((MapNode)node, bl);
        } else if (node instanceof MapDomain) {
            this.nodeSelected((MapDomain)node, bl);
        }
    }

    protected void nodeSelected(MapNode mapNode, boolean bl) {
    }

    protected void nodeSelected(MapDomain mapDomain, boolean bl) {
    }

    void selected(Link link, boolean bl) {
        if (link instanceof MapLink) {
            this.linkSelected((MapLink)link, bl);
        } else if (link instanceof MapLinkBundle) {
            this.linkSelected((MapLinkBundle)link, bl);
        }
    }

    protected void linkSelected(MapLink mapLink, boolean bl) {
    }

    protected void linkSelected(MapLinkBundle mapLinkBundle, boolean bl) {
    }

    void clicked(Link link) {
        if (link instanceof MapLink) {
            this.clicked((MapLink)link);
        }
    }

    void doubleClicked(Link link) {
        if (link instanceof MapLink) {
            this.doubleClicked((MapLink)link);
        }
    }

    protected void clicked(MapLink mapLink) {
    }

    protected void doubleClicked(MapLink mapLink) {
    }

    public void clicked(MapPort mapPort) {
    }

    public void doubleClicked(MapPort mapPort) {
    }

    private MapNode getVirtualNode(MapGraph mapGraph, MapNode mapNode) {
        MapNode mapNode2 = mapGraph.getMapNode(mapNode.getUserObject());
        if (mapNode2 != null && mapNode2.isVirtual()) {
            return mapNode2;
        }
        mapNode2 = this.createNode(null);
        mapNode2.setID(++this.seqNum);
        mapNode2.setRealNode(mapNode);
        mapGraph.add(mapNode2);
        mapNode2.init(mapNode);
        return mapNode2;
    }

    public synchronized boolean containsDomain(String string) {
        return this.domains.containsKey(string);
    }

    public MapNode getMapNode(Object object) {
        return (MapNode)this.nodes.get(object);
    }

    public MapLink getMapLink(Object object) {
        Object v = this.links.get(object);
        if (v instanceof MapLinkInfo) {
            MapLinkInfo mapLinkInfo = (MapLinkInfo)v;
            return mapLinkInfo.getLinks()[0];
        }
        return (MapLink)v;
    }

    MapLinkInfo getMapLinkInfo(Object object) {
        Object v = this.links.get(object);
        if (v instanceof MapLinkInfo) {
            return (MapLinkInfo)v;
        }
        return null;
    }

    public MapNode[] getMapNodes() {
        return this.nodes.values().toArray(new MapNode[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLinkUserObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = this.links;
        synchronized (map) {
            Iterator iterator = this.links.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (k instanceof MapLinkInfo) {
                    MapLinkInfo mapLinkInfo = (MapLinkInfo)k;
                    arrayList.add(mapLinkInfo.getLinks()[0].getUserObject());
                    continue;
                }
                arrayList.add(k);
            }
        }
        return arrayList;
    }

    public void setMapCoordinates(Rectangle2D.Double double_) {
        this.coordinatesRect = double_;
    }

    public double toWorldX(String string) {
        double d = 0.0;
        if (this.rootGraph == null || this.coordinatesRect == null) {
            return d;
        }
        Rectangle2D.Double double_ = this.rootGraph.getBackgroundImageRect();
        double d2 = double_.getWidth() == 0.0 ? (double)MapToolkit.getCanvasWidth() : double_.getWidth();
        double d3 = this.coordinatesRect.getX();
        double d4 = this.coordinatesRect.getWidth();
        try {
            double d5 = CoordinateElement.toDoubleValue(string, 1);
            double d6 = (d4 + d3) / 2.0;
            double d7 = d2 / (d4 - d3);
            d = (d5 - d6) * d7;
            if (this.db.on) {
                this.println("toWorldX longitudeStr=" + string + " longitude=" + d5 + ", worldx=" + d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double toWorldY(String string) {
        double d = 0.0;
        if (this.rootGraph == null) {
            return d;
        }
        Rectangle2D.Double double_ = this.rootGraph.getBackgroundImageRect();
        double d2 = double_.getHeight() == 0.0 ? (double)MapToolkit.getCanvasHeight() : double_.getHeight();
        double d3 = this.coordinatesRect.getY();
        double d4 = this.coordinatesRect.getHeight();
        try {
            double d5 = CoordinateElement.toDoubleValue(string, 0);
            double d6 = (d3 + d4) / 2.0;
            double d7 = d2 / (d3 - d4);
            d = (d5 - d6) * d7;
            if (this.db.on) {
                this.println("toWorldY latitudeStr=" + string + " latitude=" + d5 + ", worldy=" + d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    double clipWorldX(double d) {
        if (d > (double)MapToolkit.getCanvasWidth()) {
            d = MapToolkit.getCanvasWidth();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    double clipWorldY(double d) {
        if (d > (double)MapToolkit.getCanvasHeight()) {
            d = MapToolkit.getCanvasHeight();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public ActionListener getZoomListener() {
        return this;
    }

    protected MapNode createNode(Object object) {
        if (this.mapFactory != null) {
            return this.mapFactory.createNode(this, object);
        }
        return new MapNode(this);
    }

    protected MapDomain createDomain(Object object) {
        return new MapDomain(this);
    }

    protected MapLink createLink(MapNode mapNode, MapNode mapNode2, String string, Object object) {
        if (this.mapFactory != null) {
            return this.mapFactory.createLink(this, mapNode, mapNode2, string, object);
        }
        return new MapLink(this, mapNode, mapNode2, string);
    }

    protected MapLinkBundle createLinkBundle(Node node, Node node2, String string, int n) {
        return new MapLinkBundle(this, node, node2, string, n);
    }

    public boolean isRootGraph() {
        return this.getMapGraph() == this.rootGraph;
    }

    public MapGraph getRootGraph() {
        return this.rootGraph;
    }

    public boolean getMapProperty(Object object, int n) {
        return false;
    }

    public void mapPropertyChanged(Object object, int n, String string, String string2) {
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("MTK::destroy() called.");
        }
        this.deleteAllObjects();
    }

    public boolean isDetailed() {
        return this.isDetailed;
    }

    public void setLinkOffset(int n) {
        this.linkOffset = n;
    }

    public int getLinkOffset() {
        return this.linkOffset;
    }

    public void setSelected(Node node, boolean bl) {
        if (node == null) {
            return;
        }
        AbstractGraph abstractGraph = node.getGraph();
        if (abstractGraph != null) {
            abstractGraph.setSelected((IlvGraphic)node, bl, true);
        }
    }

    public void setSelected(Link link, boolean bl) {
        if (link == null) {
            return;
        }
        AbstractGraph abstractGraph = link.getGraph();
        if (abstractGraph != null) {
            abstractGraph.setSelected((IlvGraphic)link, bl, true);
        } else {
            LinkBundle linkBundle = this.getLinkBundle(link.getBundleKey());
            if (linkBundle != null && linkBundle.contains((IlvLinkImage)link)) {
                linkBundle.setSelected((IlvLinkImage)link, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnableLinkIcon(boolean bl) {
        if (this.enableLinkIcon != bl) {
            this.enableLinkIcon = bl;
            this.mapPropertyChanged(this, 110, null, this.enableLinkIcon ? "true" : "false");
            TreeMap treeMap = this.linkBundleMap;
            synchronized (treeMap) {
                Collection collection = this.linkBundleMap.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    LinkBundle linkBundle = (LinkBundle)iterator.next();
                    linkBundle.placeIcons();
                }
            }
        }
    }

    public boolean isLinkIconEnabled() {
        return this.enableLinkIcon;
    }

    protected void nodeCreated(MapNode mapNode) {
    }

    protected void domainCreated(MapDomain mapDomain) {
    }

    protected void domainRemoved(MapDomain mapDomain) {
    }

    protected void domainNameChanged(MapDomain mapDomain, String string, String string2) {
    }

    protected JButton getAutoLayoutHelpButton() {
        return null;
    }

    private void println(String string) {
        if (this.db.on()) {
            this.db.println(string);
        }
    }

    SDebug getDebug() {
        return this.db;
    }
}

