/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CachedJar;
import cerent.launcher.CachedJarFactory;
import cerent.launcher.ClassLoaderFactory;
import cerent.launcher.CmsClassLoader;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.NoMainClassAttributeException;
import cerent.util.CtcRuntime;
import cerent.util.CtcSecurityManager;
import cerent.util.DebugConsole;
import cerent.util.DebugManager;
import cerent.util.DebugTelnetd;
import cerent.util.DebugWindow;
import cerent.util.EventBus;
import cerent.util.FileDeleteListener;
import cerent.util.FileDeleteMonitor;
import cerent.util.IThirdPartyJar;
import cerent.util.JViews;
import cerent.util.JarFileDeleteEvent;
import cerent.util.JavaHelp;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import cerent.util.RotatingLogOutputStream;
import cerent.util.proxy.CtcProxyFactory;
import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelDialog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.util.Locale;
import javax.swing.JOptionPane;

public class Bootstrap
implements FileDeleteListener {
    public static final String PROP_RELAUNCH = "ctc.relaunch";
    public static final String CONSOLE_AVAILABLE = "ctc.console.available";
    private static final String CTC = "ctc";
    private static final String USE_CURRENT_CLASSPATH = "use.current.classpath";
    private static final String DEBUG_PORT = "telnet.port";
    private static final String TELNET_PSWD = "CISCO15";
    private static final String BOOT_DEBUG = "boot.debug";
    private static final String BOOT_CONSOLE_DEBUG = "boot.console.debug";
    private static final String LOG_DIR = "logFile.directory";
    private static final String LOG_PREFIX = "logFile.prefix";
    private static final String LOG_NUM_LOGS = "logFile.numLogs";
    private static final int DEFAULT_NUM_LOGS = 5;
    private static final String RMI_SECURITY_MGR = "rmisecuritymgr";
    private static KDebug db = null;
    private static String STARTUP_FATAL_STRING = "Fatal error: cannot create NET class loader";
    private static Bootstrap instance;
    private static PrintStream output;
    private static WeakReference icl_;

    public static void main(String[] stringArray) {
        try {
            DebugManager debugManager = DebugManager.instance();
            Bootstrap.initLogging();
            instance = new Bootstrap();
            Bootstrap.begin(stringArray);
        }
        catch (NoMainClassAttributeException noMainClassAttributeException) {
            Bootstrap.fatal("'Main-Class:' missing from JAR manifest", noMainClassAttributeException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Bootstrap.fatal("Load class failed to load a class", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            Bootstrap.fatal("cannot access the 'main(String[])' method", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException);
            Bootstrap.fatal("failed to instantiate a class loader", instantiationException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException + ": " + noSuchMethodException.getMessage());
            Bootstrap.fatal("'setParent(CmsClassLoader)' not in ElementFactory OR 'main(String[])' not in class tagged as Main-Class", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            Bootstrap.fatal("failed to invoke 'main(String[])'", invocationTargetException);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            Bootstrap.fatal("invalid URL parts on command line", malformedURLException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            Bootstrap.fatal("I/O error while caching JAR", iOException);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            Bootstrap.fatal("Error starting CTC", exception);
        }
    }

    private static void initLogging() throws IOException {
        if (!Boolean.getBoolean(CONSOLE_AVAILABLE)) {
            Preferences preferences = Preferences.instance();
            preferences.init();
            String string = preferences.getProperty(CTC, LOG_DIR, System.getProperty("user.home"));
            String string2 = preferences.getProperty(CTC, LOG_PREFIX, "ctc-log");
            int n = preferences.getInt(CTC, LOG_NUM_LOGS, 5);
            System.out.close();
            output = new PrintStream(new RotatingLogOutputStream(string, string2, n));
            System.setOut(output);
            System.setIn(null);
            System.setErr(output);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    if (output != null) {
                        output.close();
                    }
                }
            }));
            preferences.setProperty(CTC, LOG_DIR, string);
            preferences.setProperty(CTC, LOG_PREFIX, string2);
            preferences.setInt(CTC, LOG_NUM_LOGS, n);
        }
    }

    private Bootstrap() {
        Bootstrap.initDebug();
    }

    protected static void initDebug() {
        if (db == null) {
            db = new BootDebug();
        }
    }

    private static void initParameters(String[] stringArray, ParametersHolder parametersHolder) throws IOException {
        String[] stringArray2;
        String string;
        String string2;
        Preferences.instance().init();
        if (stringArray.length > 1) {
            string2 = stringArray[0];
            string = stringArray[1];
            stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
        } else if (stringArray.length == 1) {
            String string3 = stringArray[0];
            if (string3.startsWith("http://") || string3.startsWith("file://")) {
                string2 = string3;
                string = null;
            } else {
                string2 = null;
                string = string3;
            }
            stringArray2 = stringArray;
        } else {
            string2 = null;
            string = null;
            stringArray2 = stringArray;
        }
        parametersHolder.host = string;
        parametersHolder.baseUrl = string2;
        parametersHolder.parameters = stringArray2;
        if (string != null) {
            CtcProxyFactory.setPermGne(string);
        }
    }

    public static boolean isUnifiedEle(String string) {
        return string.compareTo("04.70") >= 0;
    }

    public static ClassLoader getIFClassLoader() {
        return icl_ == null ? null : (ClassLoader)icl_.get();
    }

    public static ClassLoader initClassLoaders(String[] stringArray) throws NoMainClassAttributeException, Exception, IOException {
        ParametersHolder parametersHolder = new ParametersHolder();
        Bootstrap.initParameters(stringArray, parametersHolder);
        return Bootstrap.initClassLoaders(parametersHolder);
    }

    private static final ClassLoader initClassLoaders(ParametersHolder parametersHolder) throws NoMainClassAttributeException, Exception, IOException {
        Method method;
        Class[] classArray;
        Object object;
        ClassLoader classLoader;
        Preferences preferences = Preferences.instance();
        String string = parametersHolder.host;
        String string2 = parametersHolder.baseUrl == null ? "http://" + string : parametersHolder.baseUrl;
        Bootstrap.initDebug();
        ClassLoader classLoader2 = Bootstrap.myLoader();
        if (db.on()) {
            db.println("Loading IF.jar from " + string2);
        }
        CachedJarFactory cachedJarFactory = new CachedJarFactory(string2, "IF", string);
        ClassLoader classLoader3 = ClassLoaderFactory.getClassLoader(cachedJarFactory, classLoader2);
        icl_ = new WeakReference<ClassLoader>(classLoader3);
        db.println("IF CL=" + classLoader3);
        if (classLoader3 instanceof CmsClassLoader) {
            classLoader = (CmsClassLoader)classLoader3;
            db.println("IF CL jar=" + ((CmsClassLoader)classLoader).getCachedJar().myValues());
        }
        if (db.on()) {
            db.println("Loading NET.jar from " + string2);
        }
        cachedJarFactory = new CachedJarFactory(string2, "NET", string);
        classLoader = ClassLoaderFactory.getClassLoader(cachedJarFactory, classLoader3);
        db.println("NET CL=" + classLoader);
        if (classLoader instanceof CmsClassLoader) {
            object = classLoader;
            db.println("NET CL jar=" + ((CmsClassLoader)object).getCachedJar().myValues());
        }
        object = classLoader.loadClass("cerent.cms.loader.ElementFactory");
        if (parametersHolder.baseUrl != null) {
            classArray = new Class[]{String.class};
            method = ((Class)object).getMethod("setBaseUrl", classArray);
            method.setAccessible(true);
            Object[] objectArray = new Object[]{parametersHolder.baseUrl};
            method.invoke(null, objectArray);
        }
        classArray = new Class[]{classLoader3.getClass()};
        method = ((Class)object).getMethod("setParent", classArray);
        method.setAccessible(true);
        boolean bl = preferences.getBoolean(CTC, RMI_SECURITY_MGR, false);
        if (bl) {
            System.setSecurityManager(new CtcSecurityManager(){

                public void checkConnect(String string, int n) {
                }

                public void checkConnect(String string, int n, Object object) {
                }

                public void checkRead(FileDescriptor fileDescriptor) {
                }

                public void checkRead(String string) {
                }

                public void checkRead(String string, Object object) {
                }

                public void checkPropertiesAccess() {
                }

                public void checkPropertyAccess(String string) {
                }

                public void checkPermission(Permission permission) {
                }

                public void checkPermission(Permission permission, Object object) {
                }
            });
        }
        Object[] objectArray = new Object[]{classLoader3};
        method.invoke(null, objectArray);
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootstrapDebug() {
        int n = Preferences.instance().getInt(CTC, DEBUG_PORT, -1);
        if (n > 0) {
            DebugTelnetd debugTelnetd = new DebugTelnetd(DebugManager.instance().getRoot(), n, TELNET_PSWD, false);
            debugTelnetd.start();
        }
        boolean bl = Preferences.instance().getBoolean(CTC, BOOT_DEBUG, false);
        boolean bl2 = Preferences.instance().getBoolean(CTC, BOOT_CONSOLE_DEBUG, false);
        if (bl || bl2 && Boolean.getBoolean(CONSOLE_AVAILABLE)) {
            if (bl2 && Boolean.getBoolean(CONSOLE_AVAILABLE)) {
                DebugConsole.startInstance();
            }
            if (bl) {
                DebugWindow.instance().display();
            }
            db.println("Bootstrap paused, type \"Bootstrap resume\" to resume.");
            db.println("To avoid modal dialog blocking, it is recommended to");
            db.println("start telnetd \"telnetd <password> [<port>]\" before resuming");
            KDebug kDebug = db;
            synchronized (kDebug) {
                try {
                    db.wait();
                }
                catch (Exception exception) {
                    db.finest("Exception in bootstrapDebug/db.wait() " + exception);
                }
            }
            db.println("Bootstrap resumed");
        }
    }

    private static void begin(String[] stringArray) throws NoMainClassAttributeException, Exception {
        Object object;
        Preferences preferences = Preferences.instance();
        preferences.init();
        CtcHttpRetriever.useProxy(preferences.getBoolean("ctc.firewall", "enable", true));
        ParametersHolder parametersHolder = new ParametersHolder();
        Bootstrap.initParameters(stringArray, parametersHolder);
        Bootstrap.bootstrapDebug();
        if (!preferences.getBoolean(CTC, USE_CURRENT_CLASSPATH, false)) {
            Bootstrap.initClassPath(parametersHolder);
        }
        instance.monitorClasspathJars();
        boolean bl = preferences.getBoolean(CTC, "sotl1", false);
        if (bl) {
            object = new Tl1TunnelDialog();
            Tl1Tunnel tl1Tunnel = ((Tl1TunnelDialog)object).getTl1Tunnel();
            if (tl1Tunnel != null) {
                InetAddress inetAddress = tl1Tunnel.getPneIp();
                db.println("TL1 Tunnel connected:" + tl1Tunnel + " pneIP=" + inetAddress);
                parametersHolder.host = inetAddress.getHostAddress();
                db.println("Using host=" + parametersHolder.host);
                if (parametersHolder.parameters == null || parametersHolder.parameters.length == 0) {
                    parametersHolder.parameters = new String[1];
                }
                parametersHolder.parameters[0] = parametersHolder.host;
            } else {
                System.exit(0);
            }
        }
        object = null;
        try {
            object = Bootstrap.initClassLoaders(parametersHolder);
        }
        catch (IOException iOException) {
            db.println("failed in initClassLoaders()");
            db.println("ncl = " + object);
            KDebug.printStackTrace(iOException);
            try {
                JOptionPane.showMessageDialog(null, iOException.getMessage(), "Initializing Class Loaders Failed", 0);
            }
            catch (Exception exception) {
                KDebug.printStackTrace(exception);
            }
        }
        if (object != null) {
            ((CmsClassLoader)object).invokeMain(parametersHolder.parameters);
        } else {
            Bootstrap.fatal(STARTUP_FATAL_STRING, null);
        }
    }

    private static ClassLoader myLoader() {
        return Bootstrap.class.getClassLoader();
    }

    private static void fatal(String string, Throwable throwable) {
        db.severe("***Panic: " + string);
        if (throwable != null) {
            KDebug.printStackTrace(throwable);
            throwable.printStackTrace(System.err);
        }
        System.err.println(string);
        System.err.flush();
        System.exit(1);
    }

    private void monitorClasspathJars() {
        URL[] uRLArray = Bootstrap.myLoader() instanceof URLClassLoader ? ((URLClassLoader)Bootstrap.myLoader()).getURLs() : new URL[]{};
        for (int i = 0; i < uRLArray.length; ++i) {
            if (uRLArray[i].getProtocol().equals("file")) {
                FileDeleteMonitor.instance().addListener(this, new File(uRLArray[i].getFile()));
                db.fine("Listening for delete of " + uRLArray[i].toString());
                continue;
            }
            db.fine("Ignoring deletes for " + uRLArray[i].toString());
        }
    }

    private void unmonitorClassPathJar(File file) {
        FileDeleteMonitor.instance().removeListener(this, file);
        db.fine("Deleting listener for " + file.getPath());
    }

    public void fileDeleted(File file) {
        this.unmonitorClassPathJar(file);
        EventBus.instance().notifyEvent("JAR_DELETED", new JarFileDeleteEvent("LAUNCHER/ORB", null, null, file));
        db.fine("Notifying of missing Jar file -- " + file.getPath());
    }

    private static void initClassPath(ParametersHolder parametersHolder) {
        block11: {
            try {
                String string = parametersHolder.baseUrl == null ? "http://" + parametersHolder.host : parametersHolder.baseUrl;
                if (Bootstrap.isClassPathOK()) {
                    db.fine("Loading ORB from " + string);
                    CachedJarFactory cachedJarFactory = new CachedJarFactory(string, "ORB", parametersHolder.host);
                    CachedJar cachedJar = cachedJarFactory.create();
                    ClassLoaderFactory.download(cachedJar);
                    Bootstrap.addUrlToClassPath(cachedJar.toUrl());
                    IThirdPartyJar[] iThirdPartyJarArray = Bootstrap.getThirdPartyJarTypes();
                    for (int i = 0; i < iThirdPartyJarArray.length; ++i) {
                        db.fine("Loading " + iThirdPartyJarArray[i].getFileName() + " from " + string);
                        File file = Bootstrap.getThirdPartyJar(parametersHolder.host, iThirdPartyJarArray[i]);
                        if (file == null) continue;
                        Bootstrap.addUrlToClassPath(file.toURL());
                    }
                    break block11;
                }
                if (Boolean.getBoolean(PROP_RELAUNCH)) {
                    db.fine("FATAL: Cannot relaunch again.");
                    try {
                        JOptionPane.showMessageDialog(null, "Fatal error: the classpath is incorrect and CTC cannot relaunch itself to correct the problem.", "Initializing Classpath Failed", 0);
                    }
                    catch (Exception exception) {
                        KDebug.printStackTrace(exception);
                    }
                    System.exit(0);
                    break block11;
                }
                db.fine("Extra classpath elements, relaunch to clean it up.");
                System.setProperty(PROP_RELAUNCH, "true");
                Preferences.setDefault(Preferences.getDefaultLauncherPrefsFileName(), true);
                CtcRuntime ctcRuntime = new CtcRuntime(parametersHolder.host);
                Process process = ctcRuntime.exec();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
            catch (Exception exception) {
                db.severe("initClassPath");
                KDebug.printStackTrace(exception);
                try {
                    JOptionPane.showMessageDialog(null, "Fatal error: the classpath is incorrect and exception occurred while correcting the problem.\nThe exception message is: " + exception.getMessage(), "Initializing Classpath Failed", 0);
                }
                catch (Exception exception2) {
                    KDebug.printStackTrace(exception2);
                }
            }
        }
    }

    public static IThirdPartyJar[] getThirdPartyJarTypes() {
        return new IThirdPartyJar[]{new JavaHelp(), new JViews()};
    }

    private static File getThirdPartyJar(String string, IThirdPartyJar iThirdPartyJar) {
        try {
            boolean bl = ClassLoaderFactory.showDownloadUi();
            File file = ClassLoaderFactory.forceDownloadThirdPartyJar(iThirdPartyJar.getFileName(), iThirdPartyJar.getVersion(), string, bl);
            return file;
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = KErrorMsg.getString(KEMC.EID_MALFORMED_URL_PARAM_1, iThirdPartyJar.getFileName());
            Bootstrap.errorDialog(string2);
            return null;
        }
        catch (IOException iOException) {
            String string3 = KErrorMsg.getString(KEMC.EID_CANT_DOWNLOAD_PARAM_1, iThirdPartyJar.getFileName());
            Bootstrap.errorDialog(string3);
            return null;
        }
    }

    private static void errorDialog(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    private static boolean isClassPathOK() {
        try {
            URL[] uRLArray = ((URLClassLoader)Bootstrap.myLoader()).getURLs();
            db.fine("Classpath URLS --");
            for (int i = 0; i < uRLArray.length; ++i) {
                db.fine("    " + uRLArray[i].toString());
            }
            if (uRLArray.length == 1 && "file".equals(uRLArray[0].getProtocol()) && uRLArray[0].getFile().toLowerCase(Locale.ENGLISH).indexOf("launcher") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            db.severe("isClassPathOK");
            KDebug.printStackTrace(exception);
        }
        return Boolean.getBoolean("ctc.isClassPathOk");
    }

    private static void addUrlToClassPath(URL uRL) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        URLClassLoader uRLClassLoader = (URLClassLoader)Bootstrap.myLoader();
        Class clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
    }

    static {
        output = null;
        icl_ = null;
    }

    public static class BootDebug
    extends KDebug {
        public BootDebug() {
            super("Bootstrap", true);
        }

        public final synchronized void resume() {
            this.notifyAll();
        }

        public final void debugAtBoot(boolean bl) {
            if (bl) {
                this.display("Bootstrap will pause and display the debug window at next start");
            } else {
                this.display("Bootstrap debug at boot reset (normal setting)");
            }
            Preferences.instance().setBoolean(Bootstrap.CTC, Bootstrap.BOOT_DEBUG, bl);
        }
    }

    protected static class ParametersHolder {
        public String host;
        public String baseUrl;
        public String[] parameters;

        protected ParametersHolder() {
        }
    }
}

