/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CachedJar;
import cerent.launcher.NoMainClassAttributeException;
import cerent.util.EventBus;
import cerent.util.FileDeleteListener;
import cerent.util.FileDeleteMonitor;
import cerent.util.IDebugDiag;
import cerent.util.JarFileDeleteEvent;
import cerent.util.KDebug;
import cerent.version.AbstractInterfaceVersion;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.jar.Attributes;

public class CmsClassLoader
extends URLClassLoader
implements FileDeleteListener {
    private HashSet myClasses = new HashSet();
    private CachedJar myJar;
    private KDebug db;
    public static final String JAR_FILE_DELETED = "JAR_DELETED";
    private AbstractInterfaceVersion interfaceVersion;

    public CmsClassLoader(CachedJar cachedJar, ClassLoader classLoader) throws IOException, MalformedURLException, Exception {
        super(cachedJar.getURLs(), classLoader);
        Object object;
        this.myJar = cachedJar;
        this.db = new CclDebug();
        if (this.db.on()) {
            this.db.println("<init>");
        }
        if (this.db.on()) {
            object = this.getURLs();
            int n = ((URL[])object).length;
            this.db.println("# classpaths: " + n);
            for (int i = 0; i < n; ++i) {
                this.db.println("classpath[" + i + "]: " + object[i]);
            }
        }
        if (classLoader instanceof CmsClassLoader) {
            object = (CmsClassLoader)classLoader;
            AbstractInterfaceVersion abstractInterfaceVersion = ((CmsClassLoader)object).getInterfaceVersion();
            AbstractInterfaceVersion abstractInterfaceVersion2 = this.myJar.getInterfaceVersion();
            if (abstractInterfaceVersion2 != null ? !abstractInterfaceVersion.isCompatibleWith(abstractInterfaceVersion2) : !((CmsClassLoader)object).myJar.isCompatibleWith(this.myJar)) {
                throw new IncompatibleException(this.jarName() + "/" + this.myJar.getSwVersion() + " is incompatible with " + ((CmsClassLoader)object).jarName() + "/" + ((CmsClassLoader)object).myJar.getSwVersion());
            }
            if (this.db.on()) {
                String string = this.myJar.toUrl().toExternalForm();
                String string2 = ((CmsClassLoader)object).myJar.toUrl().toExternalForm();
                this.db.println("[CVM] " + string + " isCompatibleWith " + string2);
            }
        }
        this.monitorJarFiles();
        try {
            object = this.loadClass(this.myJar.getInterfaceVersionClassName());
            this.interfaceVersion = (AbstractInterfaceVersion)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            KDebug.printStackTrace(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            KDebug.printStackTrace(illegalAccessException);
        }
    }

    private void monitorJarFiles() {
        URL[] uRLArray = this.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            if (uRLArray[i].getProtocol().equals("file")) {
                FileDeleteMonitor.instance().addListener(this, new File(uRLArray[i].getFile()));
                this.db.fine("Listening for delete of " + uRLArray[i].toString());
                continue;
            }
            this.db.fine("Ignoring deletes for " + uRLArray[i].toString());
        }
    }

    private void unmonitorJarFile(File file) {
        FileDeleteMonitor.instance().removeListener(this, file);
        this.db.fine("Deleting listener for " + file.getPath());
    }

    public void fileDeleted(File file) {
        this.unmonitorJarFile(file);
        EventBus.instance().notifyEvent(JAR_FILE_DELETED, new JarFileDeleteEvent(this.myJar.fileName(), this.myJar.getSwVersion(), this.myJar.getNeType(), file));
        this.db.fine("Notifying of missing Jar file -- " + file.getPath());
    }

    public String toString() {
        return "CmsClassLoader " + this.myJar.fileName() + " " + this.myJar.getSwVersion();
    }

    public AbstractInterfaceVersion getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public String jarName() {
        String string = this.myJar.sourceName();
        int n = string.lastIndexOf(47);
        return string.substring(n + 1);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = super.findClass(string);
        if (this.db.on()) {
            this.db.println("<<<(" + this.jarName() + ").findClass(" + string + ")");
        }
        this.myClasses.add(clazz.getName());
        return clazz;
    }

    protected void invokeMain(String[] stringArray) throws NoMainClassAttributeException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        this.invokeClass(this.getMainClassName(), stringArray);
    }

    private String getMainClassName() throws NoMainClassAttributeException {
        String string = null;
        URL[] uRLArray = this.getURLs();
        String string2 = this.myJar.fileName();
        String string3 = System.getProperty("ctc.mainclass" + string2);
        if (string3 != null) {
            if (this.db.on()) {
                this.db.println("!(" + string2 + ") Main class configured to " + string3);
            }
            return string3;
        }
        for (int i = 0; string == null && i < uRLArray.length; ++i) {
            try {
                URL uRL = new URL("jar", "", uRLArray[i].toString() + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                Attributes attributes = jarURLConnection.getMainAttributes();
                if (attributes == null) continue;
                string = attributes.getValue(Attributes.Name.MAIN_CLASS);
                continue;
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                this.db.println("Exception in getMainClassName() " + exception);
            }
        }
        if (this.db.on()) {
            this.db.println("getMainClassName result is " + string);
        }
        if (string == null) {
            throw new NoMainClassAttributeException();
        }
        return string;
    }

    public void setMainJar(CachedJar cachedJar) {
        this.myJar = cachedJar;
    }

    private boolean methodOk(Method method) {
        int n = method.getModifiers();
        return method.getReturnType() == Void.TYPE && Modifier.isStatic(n) && Modifier.isPublic(n);
    }

    private void invokeClass(String string, String[] stringArray) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> clazz = this.loadClass(string);
        Class[] classArray = new Class[]{stringArray.getClass()};
        Method method = clazz.getMethod("main", classArray);
        method.setAccessible(true);
        if (!this.methodOk(method)) {
            throw new NoSuchMethodException("main");
        }
        Object[] objectArray = new Object[]{stringArray};
        method.invoke(null, objectArray);
    }

    public String baseUrl() {
        String string = this.myJar.sourceName();
        for (int i = 0; i < 2; ++i) {
            int n = string.lastIndexOf(47);
            string = string.substring(0, n);
        }
        return string;
    }

    public String getSwVersion() {
        URL[] uRLArray = this.getURLs();
        return this.myJar.getCachedSwVersion(uRLArray);
    }

    public String getSwVersionAndDate() {
        return this.myJar.getSwVersionAndDate();
    }

    public void destroy() {
        this.db.dispose();
    }

    public CachedJar getCachedJar() {
        return this.myJar;
    }

    private boolean matches(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public boolean isMyJar(JarFileDeleteEvent jarFileDeleteEvent) {
        if (this.matches(jarFileDeleteEvent.getJarType(), this.myJar.fileName()) && this.matches(jarFileDeleteEvent.getVersion(), this.myJar.getSwVersion()) && this.matches(jarFileDeleteEvent.getNeType(), this.myJar.getNeType())) {
            URL[] uRLArray = this.getURLs();
            String string = jarFileDeleteEvent.getJarFile().getPath();
            for (int i = 0; i < uRLArray.length; ++i) {
                if (!uRLArray[i].getFile().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public class CclDebug
    extends KDebug
    implements IDebugDiag {
        CclDebug() {
            super(new String[]{"CCL", CmsClassLoader.this.myJar.fileName() + "-" + CmsClassLoader.this.myJar.getSwVersion()});
        }

        public final void dumpDiag() {
            URL[] uRLArray;
            if (CmsClassLoader.this.myJar != null) {
                this.println("cachedJar=" + CmsClassLoader.this.myJar.getCachedName());
            }
            if ((uRLArray = CmsClassLoader.this.getURLs()) != null) {
                for (int i = 0; i < uRLArray.length; ++i) {
                    this.println("   " + uRLArray[i].toExternalForm());
                }
            }
        }

        public final void loadClass(String string) throws ClassNotFoundException {
            Class.forName(string, true, CmsClassLoader.this);
        }
    }

    public class IncompatibleException
    extends Exception {
        public IncompatibleException() {
        }

        public IncompatibleException(String string) {
            super(string);
        }
    }
}

