/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.launcher.CtcHttpRetriever;
import cerent.util.CtcSslFactory;
import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.proxy.CtcProxyFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;

public class CtcHttpClient
extends HttpClient {
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int HTTPS_FAIL_TIMER = Preferences.instance().getInt("ctc.https", "fail.timeout", 60000);
    private static final CtcHttpDebug dbg = new CtcHttpDebug();
    private static HashMap sslFailureMap = new HashMap();

    public CtcHttpClient(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, false);
    }

    private CtcHttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        super(uRL, bl);
    }

    protected CtcHttpClient(URL uRL, boolean bl) throws IOException {
        this(uRL, null, -1, bl);
    }

    private CtcHttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    protected Socket doConnect(String string, int n) throws IOException {
        Socket socket = CtcHttpRetriever.useProxy() ? this.getProxiedSocket(string, n) : this.getPlainSocket(string, n);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Socket getProxiedSocket(String var1_1, int var2_2) throws IOException {
        var3_3 = null;
        var4_4 = this.getDefaultHttpsPort();
        if (var2_2 != this.getDefaultPort()) {
            var4_4 = var2_2;
        }
        var6_5 = CtcHttpClient.sslFailureMap;
        synchronized (var6_5) {
            var5_7 = (FailedSslPortTimer)CtcHttpClient.sslFailureMap.get(var1_1);
        }
        if (var5_7 == null || var5_7.isExpired()) {
            try {
                var3_3 = CtcProxyFactory.sslConnect(var1_1, var4_4).getSocket();
                CtcHttpRetriever.addSecureNode(var1_1);
                if (var5_7 != null) {
                    var6_5 = CtcHttpClient.sslFailureMap;
                    synchronized (var6_5) {
                        CtcHttpClient.sslFailureMap.remove(var1_1);
                    }
                    if (CtcHttpClient.dbg.isFinestEnabled()) {
                        CtcHttpClient.dbg.println("Removed SSL port failure timer for " + var1_1);
                    }
                }
                return var3_3;
            }
            catch (IOException var6_6) {
                CtcHttpRetriever.removeSecureNode(var1_1);
                if (var5_7 == null) {
                    var5_7 = new FailedSslPortTimer();
                    var7_9 = CtcHttpClient.sslFailureMap;
                    synchronized (var7_9) {
                        CtcHttpClient.sslFailureMap.put(var1_1, var5_7);
                    }
                    if (!CtcHttpClient.dbg.isFinestEnabled()) ** GOTO lbl51
                    CtcHttpClient.dbg.println("Added SSL port failure timer for " + var1_1);
                }
                var5_7.restart();
                if (!CtcHttpClient.dbg.isFinestEnabled()) ** GOTO lbl51
                CtcHttpClient.dbg.println("Restarted SSL port failure timer for " + var1_1);
            }
        } else if (CtcHttpClient.dbg.isFinestEnabled()) {
            CtcHttpClient.dbg.println("Skipped SSL port probe for " + var1_1);
        }
lbl51:
        // 7 sources

        if (var2_2 != var4_4) {
            var3_3 = CtcProxyFactory.connect(var1_1, var2_2).getSocket();
        }
        return var3_3;
    }

    private Socket getPlainSocket(String string, int n) throws IOException {
        Socket socket;
        int n2 = this.getDefaultHttpsPort();
        if (n != this.getDefaultPort()) {
            n2 = n;
        }
        try {
            socket = CtcSslFactory.getSSLSocketFactory().createSocket();
            socket.connect(new InetSocketAddress(string, n2), CtcProxyFactory.readTimeout());
            if (defaultSoTimeout > 0) {
                socket.setSoTimeout(defaultSoTimeout);
            }
            CtcHttpRetriever.addSecureNode(string);
        }
        catch (IOException iOException) {
            socket = super.doConnect(string, n);
            CtcHttpRetriever.removeSecureNode(string);
        }
        return socket;
    }

    public void openServer(String string, int n) throws IOException {
        super.openServer(string, n);
        this.serverSocket.setKeepAlive(true);
        this.serverSocket.setSoTimeout(60000);
    }

    public void setSoTimeout(int n) throws IOException {
        this.serverSocket.setSoTimeout(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retain(KDebug kDebug) throws IOException {
        KeepAliveCache keepAliveCache = kac;
        synchronized (keepAliveCache) {
            HttpClient httpClient = (HttpClient)kac.get(this.url, null);
            if (kDebug.on()) {
                kDebug.println("CtcHttpClient.retain(): " + httpClient);
            }
            if (httpClient != null) {
                kac.put(this.url, null, httpClient);
                if (HttpClient.New(this.url) != httpClient) {
                    kDebug.println("CtcHttpClient.retain(): client differs");
                }
            }
            return httpClient != null;
        }
    }

    private int getDefaultHttpsPort() {
        return 443;
    }

    public static class CtcHttpDebug
    extends KDebug
    implements IDebugDiag {
        public CtcHttpDebug() {
            super("CtcHttpClient");
        }

        public final void dumpDiag() {
            this.println("SSL Port Failure Map:");
            Iterator iterator = sslFailureMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = sslFailureMap.get(k);
                this.println("   " + k + ": " + v.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void flush() {
            HashMap hashMap = sslFailureMap;
            synchronized (hashMap) {
                sslFailureMap.clear();
            }
        }
    }

    private class FailedSslPortTimer {
        public long expirationTime;

        public FailedSslPortTimer() {
            this.restart();
        }

        public void restart() {
            this.expirationTime = System.currentTimeMillis() + (long)HTTPS_FAIL_TIMER;
        }

        public boolean isExpired() {
            return this.getTtl() <= 0L;
        }

        public long getTtl() {
            return this.expirationTime - System.currentTimeMillis();
        }

        public String toString() {
            long l = this.getTtl();
            if (l <= 0L) {
                return "expired";
            }
            return Long.toString(l) + " ms";
        }
    }
}

