/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.DebugManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;

public class DebugConsole
implements Runnable {
    private static Thread debugConsoleThread;
    private BufferedReader reader;
    private PrintStream writer;
    private long startTime;
    private DebugManager dbm;

    public DebugConsole() {
        this(System.in, System.out);
    }

    public DebugConsole(InputStream inputStream, PrintStream printStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = printStream;
        this.startTime = System.currentTimeMillis() + 500L;
        this.dbm = DebugManager.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startInstance() {
        Class clazz = DebugConsole.class;
        synchronized (clazz) {
            if (debugConsoleThread == null) {
                debugConsoleThread = new Thread((Runnable)new DebugConsole(), "Debug Console");
                debugConsoleThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.dbm.addPrintStream(this.writer);
        boolean bl = false;
        while (!bl) {
            try {
                String string = this.reader.readLine();
                if (this.startTime != 0L && this.startTime >= System.currentTimeMillis()) continue;
                bl = this.dbm.exec(string);
                this.startTime = 0L;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                this.writer.println("Exception occurred: " + exception);
            }
        }
        this.dbm.removePrintStream(this.writer);
        Class clazz = DebugConsole.class;
        synchronized (clazz) {
            debugConsoleThread = null;
        }
    }
}

