/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.DebugManager;
import cerent.util.KDebug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;

public class DebugTelnetd
extends Thread {
    private BufferedReader in;
    private PrintStream outSocket;
    private ServerSocket s;
    private int dbgPort;
    private DebugManager dbm;
    private boolean echoMode;
    private static final String TOGGLE_ECHO = "~echo";
    private String password;
    private boolean singleRun;

    public DebugTelnetd(KDebug kDebug, int n, String string) {
        this(kDebug, n, string, true);
    }

    public DebugTelnetd(KDebug kDebug, int n, String string, boolean bl) {
        super("DebugTelnetd");
        this.singleRun = bl;
        this.password = string;
        this.dbm = DebugManager.instance();
        if (kDebug == null) {
            kDebug = this.dbm.getRoot();
        }
        while (n < 65535) {
            try {
                this.s = new ServerSocket(n);
                break;
            }
            catch (BindException bindException) {
                kDebug.finer("BindException in DebugTelnetd() " + bindException);
            }
            catch (IOException iOException) {
                kDebug.finer("IOException in DebugTelnetd() " + iOException);
            }
            kDebug.display("Port already in use, checking next port " + ++n + "...");
            System.err.println("Port already in use, checking next port " + n + "...");
        }
        kDebug.display("DebugTelnetd:  port is " + n);
        System.err.println("DebugTelnetd:  port is " + n);
        this.dbgPort = n;
        this.setName("DebugTelnetd port " + n);
    }

    public int getDebugPort() {
        return this.dbgPort;
    }

    public void run() {
        do {
            this.runOnce();
        } while (!this.singleRun);
        try {
            if (this.s != null) {
                this.s.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.err.println("DebugTelnetd: remote debugging disabled @ port " + this.dbgPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runOnce() {
        block30: {
            Socket socket;
            block28: {
                socket = null;
                boolean bl = false;
                socket = this.s.accept();
                this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.outSocket = new PrintStream(socket.getOutputStream(), true);
                if (this.password != null) {
                    this.outSocket.println("Please enter password:  ");
                    boolean bl2 = this.echoMode;
                    this.echoMode = false;
                    String string = this.read();
                    this.echoMode = bl2;
                    if (!string.equals(this.password)) {
                        this.outSocket.println("Incorrect password");
                        bl = true;
                    }
                }
                if (!bl) {
                    this.outSocket.println("CTC Debug front-end");
                    this.toggleEcho();
                    this.dbm.addPrintStream(this.outSocket);
                }
                while (!bl) {
                    try {
                        String string = this.read();
                        if (string.equalsIgnoreCase(TOGGLE_ECHO)) {
                            this.toggleEcho();
                            this.dbm.exec("");
                            continue;
                        }
                        bl = this.dbm.exec(string);
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                    catch (Exception exception) {
                        this.outSocket.print("Exception occurred: " + exception);
                    }
                }
                Object var6_9 = null;
                if (this.outSocket == null) break block28;
                this.dbm.removePrintStream(this.outSocket);
                this.outSocket.flush();
                this.outSocket.close();
                this.outSocket = null;
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (socket != null) {
                    socket.close();
                }
                break block30;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block30;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var6_10 = null;
                    if (this.outSocket != null) {
                        this.dbm.removePrintStream(this.outSocket);
                        this.outSocket.flush();
                        this.outSocket.close();
                        this.outSocket = null;
                    }
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block30;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (this.outSocket != null) {
                    this.dbm.removePrintStream(this.outSocket);
                    this.outSocket.flush();
                    this.outSocket.close();
                    this.outSocket = null;
                }
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private String read() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.in.read()) == -1) {
                throw new IOException("EOF");
            }
            if (this.echoMode) {
                this.outSocket.print((char)n);
            }
            if (n == 10) break;
            if (n == 13) continue;
            if (n == 8) {
                if (stringBuffer.length() <= 0) continue;
                stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private void toggleEcho() {
        this.echoMode = !this.echoMode;
        this.outSocket.println("Echo=" + this.echoMode + " To toggle echo mode, type \"" + TOGGLE_ECHO + "\"");
    }
}

