/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MimeHeader {
    private static final KDebug db = new KDebug("MimeHeader");
    private static final String _protocolVersion = "HTTP/1.";
    private static final String _contentTypeTag = "Content-type";
    private static final String _contentLengthTag = "Content-length";
    private String _requestMethod;
    private String _host;
    private String _file;
    private String _contentType;
    private long _contentLength;
    private int _responseCode;
    private TreeMap _properties;

    public MimeHeader() {
        this("GET", "", "", "text/html", 0L);
    }

    public MimeHeader(String string, String string2, String string3, String string4, long l) {
        this._requestMethod = string;
        this._host = string2;
        this._file = string3;
        this._contentType = string4;
        this._contentLength = l;
        this._responseCode = 0;
        this._properties = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    public void reset() {
        this._requestMethod = "GET";
        this._host = "";
        this._file = "";
        this._contentType = "text/html";
        this._contentLength = 0L;
        this._responseCode = 0;
        this._properties.clear();
    }

    public void read(InputStream inputStream) throws IOException {
        this.reset();
        while (true) {
            String string = this.readLine(inputStream);
            if (db.on()) {
                db.println("=> '" + string + "'");
            }
            if (string.startsWith(_protocolVersion)) {
                this.parseStatusLine(string);
                continue;
            }
            if (string.startsWith("GET")) {
                this._requestMethod = "GET";
                this.parseRequest(string);
                continue;
            }
            if (string.startsWith("POST")) {
                this._requestMethod = "POST";
                this.parseRequest(string);
                continue;
            }
            if (string.startsWith(_contentTypeTag)) {
                this.parseContentType(string);
                continue;
            }
            if (string.startsWith(_contentLengthTag)) {
                this.parseContentLength(string);
                continue;
            }
            if (string.length() <= 0) break;
            this.parseProperty(string);
        }
    }

    public void generateResponse(PrintStream printStream) throws IOException {
        printStream.print("HTTP/1.0 " + this._responseCode + " " + this.getResponseText() + "\r\n");
        this.generateTags(printStream);
        printStream.print("\r\n");
        printStream.flush();
    }

    public void generateRequest(PrintStream printStream) throws IOException {
        printStream.print(this._requestMethod + " " + this._file + " HTTP/1.1\r\n");
        this.generateTags(printStream);
        printStream.print("Host: " + this._host + "\r\n");
        printStream.print("Connection: Keep-Alive\r\n");
        printStream.print("\r\n");
        printStream.flush();
    }

    private void generateTags(PrintStream printStream) throws IOException {
        printStream.print("Content-type: " + this._contentType + "\r\n");
        printStream.print("Content-length: " + this._contentLength + "\r\n");
        Iterator iterator = this._properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            printStream.print(entry.getKey() + ": " + entry.getValue() + "\r\n");
        }
    }

    private String getResponseText() {
        switch (this._responseCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Time-out";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Time-out";
            }
            case 505: {
                return "HTTP Version not supported";
            }
        }
        return "N/A";
    }

    public String getRequestMethod() {
        return this._requestMethod;
    }

    public void setRequestMethod(String string) {
        this._requestMethod = string;
    }

    public String getFile() {
        return this._file;
    }

    public void setFile(String string) {
        this._file = string;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public void setResponseCode(int n) {
        this._responseCode = n;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String string) {
        this._contentType = string;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public void setContentLength(int n) {
        this._contentLength = n;
    }

    public String getProperty(String string) {
        if (_contentLengthTag.equals(string)) {
            return Long.toString(this._contentLength);
        }
        if (_contentTypeTag.equals(string)) {
            return this._contentType;
        }
        return (String)this._properties.get(string);
    }

    public void setProperty(String string, String string2) {
        if (_contentLengthTag.equals(string)) {
            this._contentLength = Long.parseLong(string2);
        } else if (_contentTypeTag.equals(string)) {
            this._contentType = string2;
        } else {
            this._properties.put(string, string2);
        }
    }

    public String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                if (db.on()) {
                    db.println("read returned -1, line.length() => " + stringBuffer.length());
                }
                return stringBuffer.toString();
            }
            if (!bl) {
                if (n == 13) {
                    bl = true;
                    continue;
                }
                if (n == 10) {
                    return stringBuffer.toString();
                }
                stringBuffer.append((char)n);
                continue;
            }
            if (n == 10) break;
        }
        return stringBuffer.toString();
    }

    public void parseStatusLine(String string) {
        int n;
        int n2 = string.length();
        for (n = 9; n < n2 && Character.isDigit(string.charAt(n)); ++n) {
        }
        this._responseCode = Integer.parseInt(string.substring(9, n));
    }

    public void parseContentType(String string) {
        this._contentType = string.substring(14);
    }

    public void parseContentLength(String string) {
        int n;
        int n2 = string.length();
        for (n = 16; n < n2 && Character.isDigit(string.charAt(n)); ++n) {
        }
        this._contentLength = Long.parseLong(string.substring(16, n));
    }

    public void parseProperty(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            this._properties.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
        }
    }

    public void parseRequest(String string) {
        int n = string.indexOf(32);
        int n2 = string.lastIndexOf(32);
        this._file = string.substring(n + 1, n2);
    }
}

