/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import cerent.util.Preferences;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MsgMgr {
    protected static Preferences preferences = Preferences.instance();
    public static Locale currentLocale = new Locale(MsgMgr.getLanguage(), MsgMgr.getCountry());
    protected static final KDebug db = new KDebug("MsgMgr");

    protected MsgMgr() {
    }

    protected static String buildMsg(String string, Object[] objectArray, ResourceBundle resourceBundle) {
        String string2 = MsgMgr.getMessageFromCat(string, resourceBundle);
        if (string2 == null) {
            return null;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(currentLocale);
        messageFormat.applyPattern(string2);
        return messageFormat.format(objectArray);
    }

    protected static String getBaseMessageFromCat(String string, ResourceBundle resourceBundle) {
        String string2 = null;
        if (resourceBundle == null) {
            db.severe("MsgMgr.retrieveMessageFromCat(): Error Catalog not loaded.");
            return null;
        }
        try {
            string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            db.severe("MsgMgr.retrieveMessageFromCat(): null pointer " + nullPointerException.getMessage());
        }
        catch (MissingResourceException missingResourceException) {
            db.severe("MsgMgr.retrieveMessageFromCat():Invalid Key " + missingResourceException.getMessage());
        }
        return null;
    }

    protected static String getMessageFromCat(String string, ResourceBundle resourceBundle) {
        return MsgMgr.composeMsg(string, MsgMgr.getBaseMessageFromCat(string, resourceBundle));
    }

    protected static String composeMsg(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        return string + "\n" + string2;
    }

    protected static String getLanguage() {
        String string = MsgMgr.getProperty("Language");
        if (string == null) {
            string = "en";
        }
        return string;
    }

    protected static String getCountry() {
        String string = MsgMgr.getProperty("Country");
        if (string == null) {
            string = "";
        }
        return string;
    }

    protected static String getProperty(String string) {
        String string2;
        String string3 = "ctc.ErrorCatalog";
        try {
            string2 = preferences.getProperty(string3, string, null);
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }
}

