/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import sun.security.provider.PolicyParser;

public class PolicyTool {
    private static final KDebug db = new KDebug("PolicyTool");
    private static final String userPolicyFileName = System.getProperty("user.home") + File.separator + ".java.policy";
    private static final String sysPolicyFileName = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "java.policy";
    private static final String LAUNCHER_CODEBASE = "http://*/fs/LAUNCHER.jar";
    private static final String PREF_PATH = "ctc.ignore.dialogs";
    private static final String PREF_PATH_DESC_EXTENSION = "description";
    private static final String PREF_PATH_VALUE_EXTENSION = "value";
    private static final String SHOW_POLICY_DIALOG = "showPolicyDialog";
    private static final String SHOW_POLICY_DIALOG_DESC = "Suggest removal of modified policy file";
    private static boolean showPolicyDialog = true;
    private static Preferences prefs = Preferences.instance();

    private PolicyTool() {
    }

    public static void run() {
        if (db.on()) {
            db.println("starting...");
        }
        PolicyParser policyParser = PolicyTool.loadPolicyFile(userPolicyFileName);
        PolicyParser policyParser2 = PolicyTool.loadPolicyFile(sysPolicyFileName);
        showPolicyDialog = prefs.getBoolean("ctc.ignore.dialogs.value", SHOW_POLICY_DIALOG, true);
        if (!showPolicyDialog) {
            return;
        }
        PolicyParser.GrantEntry grantEntry = PolicyTool.getLauncherGE(policyParser);
        if (grantEntry != null && PolicyTool.isOKToChangePolicy()) {
            db.println("policy in .java.policy");
            policyParser.remove(grantEntry);
            PolicyTool.savePolicyFile(userPolicyFileName, policyParser);
        }
        if ((grantEntry = PolicyTool.getLauncherGE(policyParser2)) != null && PolicyTool.isOKToChangePolicy()) {
            db.println("policy in system policy");
            policyParser2.remove(grantEntry);
            PolicyTool.savePolicyFile(sysPolicyFileName, policyParser2);
        }
        if (db.on()) {
            db.println("ending...");
        }
    }

    private static PolicyParser.GrantEntry getLauncherGE(PolicyParser policyParser) {
        PolicyParser.GrantEntry grantEntry = null;
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry("java.security.AllPermission", null, null);
        if (policyParser == null) {
            return null;
        }
        Enumeration<PolicyParser.GrantEntry> enumeration = policyParser.grantElements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                PolicyParser.GrantEntry grantEntry2 = enumeration.nextElement();
                if (grantEntry2.codeBase == null || !grantEntry2.codeBase.equals(LAUNCHER_CODEBASE) || grantEntry2.signedBy != null && !grantEntry2.signedBy.equals("") || !grantEntry2.contains(permissionEntry)) continue;
                grantEntry = grantEntry2;
            }
        }
        return grantEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolicyParser loadPolicyFile(String string) {
        if (db.on()) {
            db.println("loading policy from " + string);
        }
        File file = new File(string);
        PolicyParser policyParser = new PolicyParser();
        if (file.exists() && file.canRead()) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                policyParser.read(fileReader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                KDebug.printStackTrace(fileNotFoundException);
            }
            catch (PolicyParser.ParsingException parsingException) {
                KDebug.printStackTrace(parsingException);
            }
            catch (IOException iOException) {
                KDebug.printStackTrace(iOException);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        KDebug.printStackTrace(iOException);
                    }
                }
            }
        } else {
            return null;
        }
        if (db.on()) {
            db.println("load complete");
        }
        return policyParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePolicyFile(String string, PolicyParser policyParser) {
        if (db.on()) {
            db.println("saving policy to " + string);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            policyParser.write(fileWriter);
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
            PolicyTool.errorDialog(string);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    KDebug.printStackTrace(iOException);
                }
            }
        }
        if (db.on()) {
            db.println("save complete");
        }
    }

    private static void errorDialog(String string) {
        String string2 = KErrorMsg.getString(KEMC.EID_CANT_WRITE_TO_FILE_PARAM_1, string);
        JOptionPane.showMessageDialog(null, string2, "Error", 0);
    }

    private static boolean isOKToChangePolicy() {
        String string = "CTC has detected a modified policy file.\n\nPrevious versions of CTC required this\npolicy file modification to launch\nproperly.\n\nCisco has determined that removing the\nmodified policy in this file will\nimprove system security.\n\nIf older versions of CTC are no longer\nin use on this computer, it is safe\nto remove the modified policy.\n\nRemove the modified policy?";
        JCheckBox jCheckBox = new JCheckBox("Don't show this message again.", false);
        boolean bl = false;
        if (showPolicyDialog) {
            int n = JOptionPane.showConfirmDialog(null, new Object[]{string, jCheckBox}, "Change Policy File", 0);
            bl = n == 0;
            if (jCheckBox.isSelected()) {
                PolicyTool.setPrefAndSave();
            } else {
                PolicyTool.deletePrefAndSave();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPrefAndSave() {
        Preferences preferences = prefs;
        synchronized (preferences) {
            prefs.setBoolean("ctc.ignore.dialogs.value", SHOW_POLICY_DIALOG, false);
            prefs.setProperty("ctc.ignore.dialogs.description", SHOW_POLICY_DIALOG, SHOW_POLICY_DIALOG_DESC);
            try {
                prefs.store();
            }
            catch (FileNotFoundException fileNotFoundException) {
                db.println("Cannot save prefs, FileNotFoundException");
            }
            catch (InterruptedIOException interruptedIOException) {
                db.println("Cannot save prefs, InterruptedIOException");
            }
            catch (IOException iOException) {
                db.println("Cannot save prefs, IOException");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePrefAndSave() {
        Preferences preferences = prefs;
        synchronized (preferences) {
            prefs.removeProperty("ctc.ignore.dialogs.value", SHOW_POLICY_DIALOG);
            prefs.removeProperty("ctc.ignore.dialogs.description", SHOW_POLICY_DIALOG);
            try {
                prefs.store();
            }
            catch (FileNotFoundException fileNotFoundException) {
                db.println("Cannot save prefs, FileNotFoundException");
            }
            catch (InterruptedIOException interruptedIOException) {
                db.println("Cannot save prefs, InterruptedIOException");
            }
            catch (IOException iOException) {
                db.println("Cannot save prefs, IOException");
            }
        }
    }
}

