/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.orb.sckfwd;

import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.CtcServerProxy;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocket;

class ServerSocket
extends java.net.ServerSocket {
    private CtcServerProxy proxy;
    private boolean secure;

    public ServerSocket(int n) throws IOException {
        this(n, 50, null, false);
    }

    public ServerSocket(int n, boolean bl) throws IOException {
        this(n, 50, null, bl);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this(n, n2, null, false);
    }

    public ServerSocket(int n, int n2, boolean bl) throws IOException {
        this(n, n2, null, bl);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this(n, n2, inetAddress, false);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress, boolean bl) throws IOException {
        super(n, n2, inetAddress);
        super.close();
        this.secure = bl;
        if (inetAddress == null) {
            inetAddress = InetAddress.getLocalHost();
        }
        this.proxy = CtcProxyFactory.bind(inetAddress.getHostAddress(), n, bl);
    }

    public InetAddress getInetAddress() {
        return this.proxy.getSocket().getInetAddress();
    }

    public int getLocalPort() {
        return this.proxy.getSocket().getLocalPort();
    }

    public Socket accept() throws IOException {
        Socket socket = this.proxy.accept();
        if (this.secure && socket instanceof SSLSocket) {
            ((SSLSocket)socket).setUseClientMode(false);
            ((SSLSocket)socket).setEnabledCipherSuites(new String[]{"SSL_RSA_WITH_RC4_128_MD5"});
            ((SSLSocket)socket).startHandshake();
        }
        return socket;
    }

    public void close() throws IOException {
        if (this.proxy != null) {
            this.proxy.close();
        }
    }

    public void setSoTimeout(int n) throws SocketException {
        this.proxy.getSocket().setSoTimeout(n);
    }

    public int getSoTimeout() throws IOException {
        return this.proxy.getSocket().getSoTimeout();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        return "sckfwd.ServerSocket[" + this.proxy.toString() + "]";
    }
}

