/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.CtcSslFactory;
import cerent.util.proxy.CtcBinding;
import cerent.util.proxy.CtcProxy;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdRequestReply;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CtcServerProxy {
    private String _targetHost;
    private int _targetPort;
    private ServerSocket _socket;
    private boolean _expired;
    private HashMap _bindings;
    private ArrayList _queue;
    private Thread _acceptor;
    private boolean _secure;

    public CtcServerProxy(String string, int n, boolean bl) throws IOException, UnknownHostException {
        this._targetHost = string;
        this._secure = bl;
        this._socket = new ServerSocket(n, 50, InetAddress.getByName("0.0.0.0"));
        this._targetPort = this._socket.getLocalPort();
        this._expired = false;
        this._bindings = new HashMap();
        this._queue = new ArrayList();
        this._acceptor = new Thread((Runnable)new AcceptorV3(), "AcceptorV3:" + this);
        this._acceptor.start();
    }

    public CtcProxy accept(String string) throws IOException {
        CtcProxy ctcProxy;
        int n = CtcProxyFactory.makeAddr(string);
        String string2 = CtcProxyFactory.proxyFor(n);
        if (string2 == null) {
            block6: {
                try {
                    Sckfwd sckfwd = CtcProxyFactory.getServer(string);
                    ctcProxy = new CtcProxy(string, this._targetHost, this._targetPort, null, sckfwd, sckfwd.getLocalHost(), this._targetPort);
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("direct accept NAT(ok): " + ctcProxy);
                    }
                }
                catch (IOException iOException) {
                    ctcProxy = new CtcProxy(string, this._targetHost, this._targetPort, null, null, CtcProxyFactory.bindAddress(this._targetHost), this._targetPort);
                    if (!CtcProxyFactory.debug()) break block6;
                    CtcProxyFactory.println("direct accept NAT(not-ok): " + ctcProxy);
                }
            }
            CtcProxyFactory.addProxy(ctcProxy);
        } else {
            ctcProxy = this.accept(string2, string);
        }
        if (this._secure) {
            ctcProxy.setSecure(true);
        }
        return ctcProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CtcProxy accept(String string, String string2) throws IOException {
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            CtcProxy ctcProxy;
            CtcBinding ctcBinding = (CtcBinding)this._bindings.get(string);
            if (ctcBinding == null) {
                ctcBinding = new CtcBinding(string);
                this._bindings.put(string, ctcBinding);
            }
            if ((ctcProxy = ctcBinding.get(string2)) != null && ctcProxy.expired()) {
                ctcBinding.remove(string2);
                ctcProxy = null;
            }
            if (ctcProxy == null) {
                SckfwdRequestReply sckfwdRequestReply;
                Object object;
                Sckfwd sckfwd = CtcProxyFactory.getServer(string);
                if (sckfwd.proxiesReusable()) {
                    object = ctcBinding.any();
                    if (object == null) {
                        sckfwdRequestReply = sckfwd.bind(this._targetHost, this._targetPort);
                        ctcProxy = new CtcProxy(string2, this._targetHost, this._targetPort, null, sckfwd, sckfwdRequestReply.getHost(), sckfwdRequestReply.getPort());
                        if (CtcProxyFactory.debug()) {
                            CtcProxyFactory.println("proxy accept new binding: " + ctcProxy);
                        }
                    } else {
                        ctcProxy = new CtcProxy(string2, this._targetHost, this._targetPort, (CtcProxy)object);
                        if (CtcProxyFactory.debug()) {
                            CtcProxyFactory.println("proxy accept old binding: " + ctcProxy);
                        }
                    }
                } else {
                    object = sckfwd.createIo();
                    ((SckfwdIo)object).writeBind(sckfwd.getLocalHost(), this._targetPort);
                    sckfwdRequestReply = new SckfwdRequestReply((SckfwdIo)object);
                    ctcProxy = new CtcProxy(string2, this._targetHost, this._targetPort, (SckfwdIo)object, sckfwd, sckfwdRequestReply.getHost(), sckfwdRequestReply.getPort());
                    new Thread((Runnable)new AcceptorV5(ctcProxy), "AcceptorV5:" + ctcProxy).start();
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("proxy accept binding: " + ctcProxy);
                    }
                }
                object = this._bindings.values().iterator();
                while (object.hasNext()) {
                    ((CtcBinding)object.next()).remove(string2);
                }
                ctcBinding.put(string2, ctcProxy);
                CtcProxyFactory.addProxy(ctcProxy);
            }
            if (this._secure) {
                ctcProxy.setSecure(true);
            }
            return ctcProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Object object) {
        ArrayList arrayList = this._queue;
        synchronized (arrayList) {
            this._queue.add(object);
            this._queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object dequeue() throws IOException {
        ArrayList arrayList = this._queue;
        synchronized (arrayList) {
            while (this._queue.size() == 0) {
                try {
                    this._queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.getMessage());
                }
            }
            return this._queue.remove(0);
        }
    }

    public Socket accept() throws IOException {
        Object object = this.dequeue();
        if (object instanceof Socket) {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("xxx accept(): got a " + object);
            }
            return (Socket)object;
        }
        if (object instanceof IOException) {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("xxx accept(): got an " + object);
            }
            throw (IOException)object;
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("xxx accept(): bad entry in queue " + object);
        }
        throw new IOException("Invalid type in accept queue.");
    }

    public boolean expired() {
        return this._expired;
    }

    public void expire() {
        this._expired = true;
    }

    public void close() throws IOException {
        this.expire();
        Thread thread = this._acceptor;
        if (thread != null) {
            this._acceptor = null;
            thread.interrupt();
        }
        this._socket.close();
        this._socket = null;
    }

    public String getHost() {
        return this._targetHost;
    }

    public int getPort() {
        return this._targetPort;
    }

    public String getKey() {
        return Integer.toString(this._targetPort);
    }

    public ServerSocket getSocket() {
        return this._socket;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._bindings.values().iterator();
        stringBuffer.append('(');
        while (iterator.hasNext()) {
            CtcBinding ctcBinding = (CtcBinding)iterator.next();
            stringBuffer.append(ctcBinding.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        stringBuffer.append(") -> ");
        stringBuffer.append(CtcProxyFactory.key(this._targetHost, this._targetPort));
        return stringBuffer.toString();
    }

    private class AcceptorV5
    implements Runnable {
        private CtcProxy _proxy;

        AcceptorV5(CtcProxy ctcProxy) {
            this._proxy = ctcProxy;
        }

        private void fail(Exception exception) {
            block3: {
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("xxx AcceptorV5: no req reply " + exception);
                }
                try {
                    this._proxy.getIo().close();
                }
                catch (IOException iOException) {
                    if (!CtcProxyFactory.debug()) break block3;
                    CtcProxyFactory.println("xxx AcceptorV5: close " + iOException);
                }
            }
        }

        public void run() {
            int n = CtcProxyFactory.readTimeout();
            int n2 = n > 0 ? CtcProxyFactory.acceptTimeout() / n : 1;
            int n3 = 0;
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("xxx AcceptorV5(" + this._proxy + ") started");
            }
            while (CtcServerProxy.this._acceptor != null) {
                try {
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("xxx AcceptorV5: reading reply " + this._proxy);
                    }
                    SckfwdRequestReply sckfwdRequestReply = new SckfwdRequestReply(this._proxy.getIo());
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("xxx AcceptorV5: request reply " + sckfwdRequestReply);
                        CtcProxyFactory.println("xxx AcceptorV5: enqueuing " + this._proxy);
                    }
                    Socket socket = this._proxy.getSocket();
                    socket.setSoTimeout(0);
                    CtcServerProxy.this.enqueue(socket);
                    break;
                }
                catch (InterruptedIOException interruptedIOException) {
                    ++n3;
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("xxx AcceptorV5(" + this._proxy + ") " + n3 + " of " + n2 + " timeouts");
                    }
                    if (n3 < n2) continue;
                    this.fail(interruptedIOException);
                    CtcServerProxy.this.enqueue(interruptedIOException);
                    break;
                }
                catch (IOException iOException) {
                    this.fail(iOException);
                    CtcServerProxy.this.enqueue(iOException);
                    break;
                }
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("xxx AcceptorV5(" + this._proxy + ") stopped");
            }
        }
    }

    private class AcceptorV3
    implements Runnable {
        private AcceptorV3() {
        }

        public void run() {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("xxx AcceptorV3(" + CtcServerProxy.this + ") started");
            }
            while (CtcServerProxy.this._acceptor != null) {
                try {
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("xxx AcceptorV3: waiting for connection");
                    }
                    Socket socket = CtcServerProxy.this._socket.accept();
                    if (CtcServerProxy.this._secure) {
                        socket = CtcSslFactory.getSSLSocketFactory().createSocket(socket, socket.getInetAddress().toString(), socket.getPort(), true);
                    }
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("xxx AcceptorV3: enqueuing " + socket);
                    }
                    socket.setSoTimeout(0);
                    CtcServerProxy.this.enqueue(socket);
                }
                catch (IOException iOException) {
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("xxx AcceptorV3: enqueuing " + iOException);
                    }
                    CtcServerProxy.this.enqueue(iOException);
                }
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("xxx AcceptorV3(" + CtcServerProxy.this + ") stopped");
            }
        }
    }
}

