/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdBid;
import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdClientsReply;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdMethodReply;
import cerent.util.proxy.SckfwdRequestReply;
import cerent.util.proxy.SckfwdResetReply;
import cerent.util.proxy.SckfwdStatusReply;
import cerent.util.proxy.SckfwdTopologyReply;
import cerent.util.proxy.SckfwdUnsupportedCommandException;
import cerent.util.proxy.SckfwdWhoamiReply;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Sckfwd {
    static final int SCKFWD_VER = 3;
    static final int SCKFWD_V5 = 5;
    static final int SCKFWD_V6 = 6;
    static final int SCKFWD_NO_AUTH = 0;
    static final int SCKFWD_GSSAPI = 1;
    static final int SCKFWD_UIDPWD = 2;
    static final int SCKFWD_CISCO_NOAUTH = 3;
    static final int SCKFWD_NONE = 255;
    static final int SCKFWD_CONNECT = 1;
    static final int SCKFWD_BIND = 2;
    static final int SCKFWD_UDP = 3;
    static final int SCKFWD_WHOAMI = 4;
    static final int SCKFWD_CLIENTS = 5;
    static final int SCKFWD_TOPOLOGY = 6;
    static final int SCKFWD_SUPPORTED = 7;
    static final int SCKFWD_RESET = 8;
    static final int SCKFWD_IPV4 = 1;
    static final int SCKFWD_NAME = 3;
    static final int SCKFWD_IPV6 = 4;
    static final int SCKFWD_SUCCEEDED = 0;
    static final int SCKFWD_FAILED = 1;
    static final int SCKFWD_DISALLOWED = 2;
    static final int SCKFWD_UNREACHABLE_NET = 3;
    static final int SCKFWD_UNREACHABLE_HOST = 4;
    static final int SCKFWD_REFUSED = 5;
    static final int SCKFWD_EXPIRED = 6;
    static final int SCKFWD_UNSUPPORTED_COMMAND = 7;
    static final int SCKFWD_UNSUPPORTED_ADDRESS = 8;
    private String _host;
    private int _port;
    private SckfwdIo _io;
    private SckfwdMethodReply _authMethod;
    private SckfwdWhoamiReply _whoami;
    private ArrayList _clients;
    private long _lastUpdated;
    private int _failures;
    private int _usage;
    private static final String ERR = "Argument to setClients() must be a String or a SckfwdClient.";

    public Sckfwd(String string, int n) throws IOException {
        this._host = string;
        this._port = n;
        this._io = new SckfwdIo(3, this.getHost(), this.getPort());
        try {
            this._authMethod = this.authMethod();
            this._whoami = this.whoami();
            this._clients = this.clients();
        }
        catch (IOException iOException) {
            this._io.close();
            throw iOException;
        }
        this.closeIfNotReusable();
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        this._usage = 0;
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println(this.toString() + " changed");
        }
    }

    public Sckfwd(String string, int n, Collection collection) throws IOException {
        this._host = string;
        this._port = n;
        this._io = new SckfwdIo(3, this.getHost(), this.getPort());
        try {
            this._authMethod = this.authMethod();
            this._whoami = this.whoami();
            this._clients = this.toSckfwdClients(collection);
        }
        catch (IOException iOException) {
            this._io.close();
            throw iOException;
        }
        this.closeIfNotReusable();
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        this._usage = 0;
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println(this.toString() + " changed");
        }
    }

    private synchronized SckfwdMethodReply authMethod() throws IOException {
        int[] nArray = new int[]{0, 3};
        this._io.writeMethods(nArray);
        return new SckfwdMethodReply(this._io, nArray);
    }

    private synchronized SckfwdWhoamiReply whoami() throws IOException {
        this._io.writeWhoami();
        return new SckfwdWhoamiReply(this._io);
    }

    private ArrayList toSckfwdClients(Collection collection) {
        ArrayList<SckfwdClient> arrayList = new ArrayList<SckfwdClient>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SckfwdClient sckfwdClient;
            Object e = iterator.next();
            if (e instanceof String) {
                sckfwdClient = new SckfwdClient((String)e, CtcProxyFactory.defaultCost());
            } else if (e instanceof SckfwdClient) {
                sckfwdClient = new SckfwdClient((SckfwdClient)e);
            } else {
                throw new IllegalArgumentException(ERR);
            }
            arrayList.add(sckfwdClient);
        }
        return arrayList;
    }

    private Collection potentialServers(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SckfwdClient sckfwdClient = (SckfwdClient)iterator.next();
            if (!sckfwdClient.isPotentialServer()) continue;
            arrayList.add(sckfwdClient.getHost());
        }
        return arrayList;
    }

    private synchronized ArrayList clients() throws IOException {
        ArrayList arrayList;
        if (this.hasProxiesWithCost()) {
            try {
                this._io.writeTopology();
                SckfwdTopologyReply sckfwdTopologyReply = new SckfwdTopologyReply(this._io);
                arrayList = sckfwdTopologyReply.clients();
                this._usage = sckfwdTopologyReply.getUsage();
            }
            catch (SckfwdUnsupportedCommandException sckfwdUnsupportedCommandException) {
                this._io.writeClients();
                arrayList = new SckfwdClientsReply(this._io).clients();
            }
        } else {
            this._io.writeClients();
            arrayList = new SckfwdClientsReply(this._io).clients();
        }
        CtcProxyFactory.discover(this.potentialServers(arrayList));
        return arrayList;
    }

    private synchronized void closeIfNotReusable() {
        if (!this.proxiesReusable()) {
            block3: {
                try {
                    this._io.close();
                }
                catch (IOException iOException) {
                    if (!CtcProxyFactory.debug()) break block3;
                    CtcProxyFactory.println("closeIfNotReusable: " + iOException);
                }
            }
            this._io = null;
        }
    }

    String getHost() {
        return this._host;
    }

    int getPort() {
        return this._port;
    }

    String getLocalHost() {
        return this._whoami.getHost();
    }

    int getFailures() {
        return ++this._failures;
    }

    int getUsage() {
        return this._usage;
    }

    void incrementUsage() {
        ++this._usage;
    }

    void decrementUsage() {
        --this._usage;
    }

    void expire() {
        this.clearClients();
        this._lastUpdated = 0L;
    }

    boolean expired() {
        long l = System.currentTimeMillis() - this._lastUpdated;
        return l > CtcProxyFactory.timeout();
    }

    synchronized boolean validate() throws IOException {
        boolean bl = false;
        if (this.expired()) {
            ArrayList arrayList;
            SckfwdWhoamiReply sckfwdWhoamiReply;
            try {
                if (this._io == null) {
                    this._io = new SckfwdIo(3, this.getHost(), this.getPort());
                    this._authMethod = this.authMethod();
                }
                sckfwdWhoamiReply = this.whoami();
                arrayList = this.clients();
            }
            catch (IOException iOException) {
                if (this._io != null) {
                    this._io.close();
                    this._io = null;
                }
                throw iOException;
            }
            if (!this._whoami.equals(sckfwdWhoamiReply)) {
                this._whoami = sckfwdWhoamiReply;
            }
            if (!this._clients.equals(arrayList)) {
                this._clients = arrayList;
                bl = true;
            }
            this.closeIfNotReusable();
            this._lastUpdated = System.currentTimeMillis();
            this._failures = 0;
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println(this.toString() + (bl ? " changed" : " no change"));
            }
        }
        return bl;
    }

    synchronized SckfwdBid willProxyFor(int n) {
        if (this.expired()) {
            return null;
        }
        Iterator iterator = this._clients.iterator();
        SckfwdClient sckfwdClient = null;
        while (iterator.hasNext()) {
            SckfwdClient sckfwdClient2 = (SckfwdClient)iterator.next();
            if (!sckfwdClient2.matches(n)) continue;
            if (sckfwdClient == null) {
                sckfwdClient = sckfwdClient2;
                continue;
            }
            if (sckfwdClient2.getCost() >= sckfwdClient.getCost()) continue;
            sckfwdClient = sckfwdClient2;
        }
        if (sckfwdClient != null) {
            return new SckfwdBid(this.getHost(), sckfwdClient.getCost(), this._usage);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int reset(String string, String string2, String string3, int n) throws IOException {
        SckfwdIo sckfwdIo = null;
        try {
            sckfwdIo = new SckfwdIo(3, this.getHost(), this.getPort());
            int[] nArray = new int[]{2, 3};
            sckfwdIo.writeMethods(nArray);
            SckfwdMethodReply sckfwdMethodReply = new SckfwdMethodReply(sckfwdIo, nArray);
            int n2 = sckfwdIo.getVersion();
            sckfwdIo.setVersion(1);
            sckfwdIo.writeUidPwd(string, string2);
            SckfwdStatusReply sckfwdStatusReply = new SckfwdStatusReply(sckfwdIo);
            sckfwdIo.setVersion(n2);
            sckfwdIo.writeReset(string3, n);
            SckfwdResetReply sckfwdResetReply = new SckfwdResetReply(sckfwdIo);
            int n3 = sckfwdResetReply.getReset();
            return n3;
        }
        finally {
            if (sckfwdIo != null) {
                sckfwdIo.close();
            }
        }
    }

    boolean proxiesReusable() {
        return this._authMethod.getVersion() == 3;
    }

    boolean hasProxiesWithCost() {
        return this._authMethod.getVersion() >= 6;
    }

    SckfwdIo createIo() throws IOException {
        SckfwdIo sckfwdIo = new SckfwdIo(this._authMethod.getVersion(), this.getHost(), this.getPort());
        int[] nArray = new int[]{0, 3};
        sckfwdIo.writeMethods(nArray);
        new SckfwdMethodReply(sckfwdIo, nArray);
        return sckfwdIo;
    }

    synchronized Collection getClients() throws IOException {
        this.expire();
        this.validate();
        ArrayList<SckfwdClient> arrayList = new ArrayList<SckfwdClient>();
        Iterator iterator = this._clients.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new SckfwdClient((SckfwdClient)iterator.next()));
        }
        return arrayList;
    }

    synchronized void setClients(Collection collection) throws IOException {
        this._clients = this.toSckfwdClients(collection);
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println(this.toString() + " changed");
        }
    }

    synchronized void clearClients() {
        this._clients.clear();
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println(this.toString() + " changed");
        }
    }

    synchronized SckfwdRequestReply connect(String string, int n) throws IOException {
        this._io.writeConnect(string, n);
        return new SckfwdRequestReply(this._io);
    }

    synchronized SckfwdRequestReply bind(String string, int n) throws IOException {
        this._io.writeBind(this._whoami.getHost(), n);
        return new SckfwdRequestReply(this._io);
    }

    public String toString() {
        long l = System.currentTimeMillis() - this._lastUpdated;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHost());
        stringBuffer.append(":");
        stringBuffer.append(this.getPort());
        stringBuffer.append(" f=");
        stringBuffer.append(this._failures);
        stringBuffer.append(" u=");
        stringBuffer.append(this._usage);
        stringBuffer.append(" w=");
        stringBuffer.append(this._whoami.getHost());
        stringBuffer.append(" a=");
        stringBuffer.append(l);
        stringBuffer.append("ms");
        return stringBuffer.toString();
    }

    public String toClientString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._clients.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            while (iterator.hasNext()) {
                stringBuffer.append(" ");
                stringBuffer.append(iterator.next().toString());
            }
        }
        return stringBuffer.toString();
    }
}

