/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.util.KDebug;
import cerent.version.IBuildInformation;
import cerent.version.Ngrp;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public abstract class AbstractJarBuildInformation
implements IBuildInformation {
    private static final String JAR_COVERAGE_OUTPUT_FILE = "Emma-Output-File";
    private static final String JAR_BUILD_INFORMATION_SECTION = "Build-version";
    private static final String JAR_BUILD_INFORMATION_VERSION = "Implementation-version";
    private static final String JAR_VERSION_VIEW = "Version-View";
    private static final String JAR_VERSION_TSTAMP = "Version-Timestamp";
    private static final String JAR_SOURCE_TYPE = "Source-type";
    private static final String NGRP_MAJOR_RLS = "NGRP-Major-Release";
    private static final String NGRP_MAINT_RLS = "NGRP-Maintenance-Release";
    private static final String NGRP_INTERIM_VER = "NGRP-Interim-Version-Number";
    private static final String NGRP_MAJOR_REBUILD_DES = "NGRP-Major-Rebuild-Designator";
    private static final String NGRP_MAJOR_TECH_RLS_DES = "NGRP-Technology-Release-Designator";
    private static final String NGRP_REBUILD_DES = "NGRP-Rebuild-Designator";
    static final String ELEMENT_MANIFEST = "element";
    static final String INTERFACE_MANIFEST = "interface";
    static final String LAUNCHER_MANIFEST = "bootstrap";
    static final String NETWORK_MANIFEST = "network";
    private static final String UNKNOWN = "???";
    protected static KDebug db = new KDebug("AbstractJarBuildInformation");
    private String sourceType;
    private String branchPath;
    private long timeStamp;
    private Ngrp ngrp;

    public AbstractJarBuildInformation(String string) {
        this(string, null);
    }

    public AbstractJarBuildInformation(String string, ClassLoader classLoader) {
        Manifest manifest = this.getManifest(string, classLoader);
        if (manifest != null) {
            try {
                Attributes attributes = manifest.getAttributes(JAR_BUILD_INFORMATION_SECTION);
                String string2 = this.getAttribute(attributes, JAR_BUILD_INFORMATION_VERSION);
                if (!string2.equals("1.0")) {
                    throw new InvalidImplVersionException(string);
                }
                this.sourceType = this.getAttribute(attributes, JAR_SOURCE_TYPE);
                this.branchPath = this.getAttribute(attributes, JAR_VERSION_VIEW);
                this.timeStamp = Long.decode(this.getAttribute(attributes, JAR_VERSION_TSTAMP));
                this.ngrp = this.getNgrpFromAttr(attributes);
                try {
                    String string3 = this.getAttribute(attributes, JAR_COVERAGE_OUTPUT_FILE);
                    System.setProperty("emma.coverage.out.file", string3);
                }
                catch (AttrNotPresentException attrNotPresentException) {
                }
                catch (Exception exception) {
                    db.fine(exception.getMessage());
                }
            }
            catch (InvalidImplVersionException invalidImplVersionException) {
                db.fine(invalidImplVersionException.getMessage());
                this.makeEmptyBuildInformation();
            }
            catch (AttrNotPresentException attrNotPresentException) {
                db.fine(attrNotPresentException.getMessage());
                this.makeEmptyBuildInformation();
            }
            catch (Exception exception) {
                db.fine(exception.getMessage());
                this.makeEmptyBuildInformation();
            }
        } else {
            this.makeEmptyBuildInformation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(String string, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            db.fine("Looking for manifest for " + string);
            while (enumeration.hasMoreElements()) {
                Manifest manifest;
                URL uRL = enumeration.nextElement();
                db.fine("Checking " + uRL.toString());
                InputStream inputStream = null;
                try {
                    manifest = new Manifest();
                    inputStream = uRL.openStream();
                    manifest.read(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                Attributes attributes = manifest.getMainAttributes();
                if (attributes != null) {
                    String string2 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    if (string2 != null && (string == null || string2.toLowerCase(Locale.ENGLISH).indexOf(string) != -1)) {
                        db.fine("Manifest found");
                        return manifest;
                    }
                    if (string2 != null) continue;
                    db.fine("No Specification-Title in manifest");
                    continue;
                }
                db.fine("No attrs in manifest");
            }
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
        }
        db.fine("Manifest not found");
        return null;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Date getDate() {
        return new Date(this.timeStamp * 1000L);
    }

    public String getBranchPath() {
        return this.branchPath;
    }

    public Ngrp getNgrp() {
        return this.ngrp;
    }

    private String getAttribute(Attributes attributes, String string) throws AttrNotPresentException {
        Attributes.Name name = new Attributes.Name(string);
        if (!attributes.containsKey(name)) {
            throw new AttrNotPresentException(string);
        }
        return attributes.getValue(name);
    }

    private Ngrp getNgrpFromAttr(Attributes attributes) throws AttrNotPresentException {
        String string = this.getAttribute(attributes, NGRP_MAJOR_RLS);
        String string2 = this.getAttribute(attributes, NGRP_MAINT_RLS);
        String string3 = this.getAttribute(attributes, NGRP_INTERIM_VER);
        String string4 = this.getAttribute(attributes, NGRP_MAJOR_REBUILD_DES);
        String string5 = this.getAttribute(attributes, NGRP_MAJOR_TECH_RLS_DES);
        String string6 = this.getAttribute(attributes, NGRP_REBUILD_DES);
        return new Ngrp(string, string2, string3, string4, string5, string6);
    }

    private void makeEmptyBuildInformation() {
        this.sourceType = UNKNOWN;
        this.branchPath = UNKNOWN;
        this.timeStamp = Long.MIN_VALUE;
        this.ngrp = new Ngrp(UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN);
    }

    private class InvalidImplVersionException
    extends Exception {
        InvalidImplVersionException() {
            this(AbstractJarBuildInformation.UNKNOWN);
        }

        InvalidImplVersionException(String string) {
            super("The version is incorrect for the " + string + " jar file.");
        }
    }

    private class AttrNotPresentException
    extends Exception {
        AttrNotPresentException() {
            this(AbstractJarBuildInformation.UNKNOWN);
        }

        AttrNotPresentException(String string) {
            super("The attribute " + string + " was not found in the manifest.");
        }
    }
}

