/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.DownloadArea;
import com.cisco.ctc.core.IFutureProofer;
import com.cisco.ctc.core.INgrp;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class DownloadAreas {
    private static final Debug db = new Debug("DownloadAreas");
    private static final Preferences prefs = Preferences.instance();
    private Map das = new HashMap();
    private Set nodas = new HashSet();
    private HashMap coreMapping = new HashMap();
    private static final Preferences ctcApplPrefs = DownloadAreas.getCtcApplPrefs();
    private static DownloadAreas instance = new DownloadAreas();
    public static Map initialConfiguredDas = instance.getConfiguredDownloadAreas(ctcApplPrefs);

    private static Preferences getCtcApplPrefs() {
        Preferences preferences = !Preferences.defaultIsLauncher() ? prefs : Preferences.instance(Preferences.getDefaultCtcPrefsFileName());
        return preferences;
    }

    public static DownloadAreas instance() {
        return instance;
    }

    private DownloadAreas() {
    }

    public DownloadArea getCoreMapping(Comparable comparable) {
        return (DownloadArea)this.coreMapping.get(comparable);
    }

    public boolean addCoreMapping(Comparable comparable, DownloadArea downloadArea) {
        DownloadArea downloadArea2 = this.coreMapping.put(comparable, downloadArea);
        return downloadArea2 == null;
    }

    public DownloadArea removeCoreMapping(Comparable comparable) {
        DownloadArea downloadArea = (DownloadArea)this.coreMapping.remove(comparable);
        return downloadArea;
    }

    public DownloadArea locateDownloadArea(String string) {
        if (string == null) {
            return null;
        }
        if (this.nodas.contains(string)) {
            if (db.isFinerEnabled()) {
                db.println("NE s/w version: " + string + " has no viable download area");
            }
            return null;
        }
        DownloadArea downloadArea = (DownloadArea)this.das.get(string);
        if (downloadArea == null) {
            Exception exception = null;
            try {
                downloadArea = new DownloadArea(string);
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (CoreException coreException) {
                exception = coreException;
            }
            if (exception != null) {
                if (db.isFinerEnabled()) {
                    db.println("NE s/w version: " + string + " failed download area discovery");
                    Debug.printStackTrace(exception);
                }
                this.nodas.add(string);
            } else {
                if (db.on()) {
                    db.println("NE s/w version: " + string + " has new discovered download area: " + downloadArea);
                }
                this.das.put(string, downloadArea);
            }
        }
        return downloadArea;
    }

    public void unlocateDownloadArea(String string) {
        this.das.remove(string);
        this.nodas.remove(string);
    }

    public void clear() {
        this.das.clear();
        this.nodas.clear();
    }

    public void cleanupDownloadArea(String string) {
        DownloadArea downloadArea = this.locateDownloadArea(string);
        this.cleanupDownloadArea(downloadArea);
    }

    public void cleanupDownloadArea(DownloadArea downloadArea) {
        if (downloadArea != null) {
            Exception exception = null;
            try {
                downloadArea.cleanArea();
                downloadArea.removeDirPreference();
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (CoreException coreException) {
                exception = coreException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            catch (InstantiationException instantiationException) {
                exception = instantiationException;
            }
            catch (InvocationTargetException invocationTargetException) {
                exception = invocationTargetException;
            }
            if (exception != null && db.on()) {
                Debug.printStackTrace(exception);
            }
        }
    }

    public void cleanupAllDownloadAreas() {
        Collection collection = initialConfiguredDas.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DownloadArea downloadArea = (DownloadArea)iterator.next();
            this.cleanupDownloadArea(downloadArea);
        }
    }

    public Map getConfiguredDownloadAreas() {
        return this.getConfiguredDownloadAreas(null);
    }

    public synchronized void refreshConfiguredDownloadAreas() {
        ctcApplPrefs.checkForFileChange();
        initialConfiguredDas = this.getConfiguredDownloadAreas(ctcApplPrefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getConfiguredDownloadAreas(Preferences preferences) {
        int n;
        if (db.isFinerEnabled()) {
            db.finer("entering getConfiguredDownloadAreas with prefs: " + preferences);
        }
        SortedMap<String, DownloadArea> sortedMap = null;
        String[] stringArray = DownloadArea.getPrefItems(preferences);
        if (stringArray == null) {
            return sortedMap;
        }
        if (db.on()) {
            n = stringArray == null ? 0 : stringArray.length;
            db.println("# of prefItems found: " + n);
        }
        sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            String string2 = DownloadArea.getPrefNameFromPrefItem(string);
            String string3 = DownloadArea.getDownloadListUriFromPrefItem(string);
            String string4 = DownloadArea.getLauncherUriFromPrefItem(string);
            ZipFile zipFile = null;
            try {
                DownloadArea downloadArea = new DownloadArea(preferences, string2, string3, string4);
                IFutureProofer iFutureProofer = downloadArea.getFutureProofer();
                String string5 = downloadArea.getLauncherPath();
                File file = new File(string5);
                zipFile = new JarFile(file);
                Manifest manifest = ((JarFile)zipFile).getManifest();
                INgrp iNgrp = iFutureProofer.getNgrp(manifest, string5);
                Comparable comparable = iNgrp.getManifestVersionOrdinal();
                sortedMap.put("8.0", downloadArea);
                continue;
            }
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.printStackTrace(classNotFoundException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                Debug.printStackTrace(instantiationException);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Debug.printStackTrace(invocationTargetException);
                continue;
            }
            catch (CoreException coreException) {
                Debug.printStackTrace(coreException);
                continue;
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return sortedMap;
    }

    public static void main(String[] stringArray) {
        instance.cleanupAllDownloadAreas();
    }

    public static class Debug
    extends KDebug {
        public Debug(String string) {
            super(string);
        }

        public final void dumpDiag() {
            instance;
            Map map = initialConfiguredDas;
            int n = map == null ? 0 : map.size();
            this.println("# download areas: " + n);
            if (n == 0) {
                return;
            }
            Iterator iterator = map.keySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Comparable comparable = (Comparable)iterator.next();
                db.println(Integer.toString(n2) + "  VO: " + comparable + " - " + map.get(comparable));
                ++n2;
            }
        }
    }
}

