/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import java.nio.ByteBuffer;

public class Base64 {
    private static final int BASE64_ASC_BLOCK = 4;
    private static final int BASE64_RAW_BLOCK = 3;
    private static final int BASE64_PADDING = 64;
    private static final byte[] BASE64_COD_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61};
    private static final int[] BASE64_DEC_TABLE = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 62, 255, 255, 255, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 255, 255, 255, 64, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 255, 255, 255, 255, 255};

    public static ByteBuffer encode(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n;
        int n2;
        int n3 = (n2 + 3 - 1) / 3 * 4;
        for (n2 = byteBuffer.remaining(); n2 > 0; n2 -= n) {
            int n4;
            int n5;
            n = n2 < 3 ? n2 : 3;
            byte by = byteBuffer.get();
            int n6 = (by & 0xFC) >> 2;
            int n7 = (by & 3) << 4;
            if (n > 1) {
                by = byteBuffer.get();
                n7 |= (by & 0xF0) >> 4;
                n5 = (by & 0xF) << 2;
                if (n > 2) {
                    by = byteBuffer.get();
                    n5 |= (by & 0xC0) >> 6;
                    n4 = by & 0x3F;
                } else {
                    n4 = 64;
                }
            } else {
                n5 = 64;
                n4 = 64;
            }
            byteBuffer2.put(BASE64_COD_TABLE[n6]);
            byteBuffer2.put(BASE64_COD_TABLE[n7]);
            byteBuffer2.put(BASE64_COD_TABLE[n5]);
            byteBuffer2.put(BASE64_COD_TABLE[n4]);
        }
        return byteBuffer2;
    }

    public static ByteBuffer decode(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = byteBuffer.remaining();
        if (n3 == 0) {
            return byteBuffer2;
        }
        if (n3 % 4 != 0) {
            throw new Exception("Src length must be a multiple of 4, size=" + n3);
        }
        while (n3 > 0) {
            int n4 = byteBuffer.get();
            int n5 = byteBuffer.get();
            n = byteBuffer.get();
            n2 = byteBuffer.get();
            n4 = BASE64_DEC_TABLE[n4];
            n5 = BASE64_DEC_TABLE[n5];
            n = BASE64_DEC_TABLE[n];
            n2 = BASE64_DEC_TABLE[n2];
            if (!(n4 <= 63 && n5 <= 63 && n <= 63 && n2 <= 63 || (n3 -= 4) == 0 && n <= 64 && n2 <= 64)) {
                throw new Exception("Src contains invalid tokens");
            }
            byteBuffer2.put((byte)((n4 & 0x3F) << 2 | (n5 & 0x30) >> 4));
            if (n >= 64) continue;
            byteBuffer2.put((byte)((n5 & 0xF) << 4 | (n & 0x3C) >> 2));
            if (n2 >= 64) continue;
            byteBuffer2.put((byte)((n & 3) << 6 | n2 & 0x3F));
        }
        return byteBuffer2;
    }
}

