/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Tl1TunnelAddr {
    private static final String DELIMITER = ",";
    public static final int TL1_ENCODING_LV = 0;
    public static final int TL1_ENCODING_RAW = 1;
    public static final int TL1_ENCODING_TELNET = 2;
    public static final int TL1_BASE_PORT = 3081;
    public static final int TL1_DATA_B64 = 0;
    public static final int TL1_DATA_RAW = 128;
    public InetAddress ip;
    public String host;
    public String pneTid;
    public String gneTid;
    public int encoding;
    public int gneTl1Port;
    public String gneUsername;
    public String gnePassword;

    public Tl1TunnelAddr(InetAddress inetAddress, String string, int n) {
        this(inetAddress, string, n, null, 0, null, null);
    }

    public Tl1TunnelAddr(String string, String string2, int n, String string3, int n2, String string4, String string5) throws UnknownHostException {
        this(InetAddress.getByName(string), string2, n, string3, n2, string4, string5);
        this.host = string;
    }

    public Tl1TunnelAddr(InetAddress inetAddress, String string, int n, String string2, int n2, String string3, String string4) {
        this.ip = inetAddress;
        this.pneTid = string.toUpperCase();
        if (string2 != null) {
            this.gneTid = this.normalizeString(string2.toUpperCase());
        }
        this.encoding = n;
        this.gneTl1Port = n2 <= 0 ? 3081 + n : n2;
        this.gneUsername = this.normalizeString(string3);
        this.gnePassword = this.normalizeString(string4);
        this.host = this.ip.getHostAddress();
    }

    private String normalizeString(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public Tl1TunnelAddr(String string) throws UnknownHostException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        this.host = stringTokenizer.nextToken();
        this.ip = InetAddress.getByName(this.host);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        this.pneTid = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        this.encoding = Integer.parseInt(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        this.gneTl1Port = Integer.parseInt(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            this.gneTid = stringTokenizer.nextToken().toUpperCase();
        }
        this.gneUsername = "";
        this.gnePassword = "";
        int n = this.encoding & 3;
        if (this.pneTid.length() == 0 || n < 0 || n > 1 || this.gneTl1Port <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public int getPort() {
        return this.gneTl1Port;
    }

    public final boolean isLV() {
        return (this.encoding & 3) == 0;
    }

    public final boolean isTelnet() {
        return (this.encoding & 3) == 2;
    }

    public final boolean isRaw() {
        return (this.encoding & 3) == 1;
    }

    public final boolean isDataBase64() {
        return (this.encoding & 0x80) == 0;
    }

    public String getEncoding() {
        return this.isLV() ? (this.isDataBase64() ? "LV+Base64" : "LV+Binary") : (this.isRaw() ? "RAW" : "Telnet");
    }

    public boolean isDefaultPort() {
        return this.gneTl1Port == 3081 + (this.encoding & 3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GNE IP=" + this.ip.toString());
        stringBuffer.append(":" + this.gneTl1Port);
        stringBuffer.append(" TID=" + this.pneTid);
        stringBuffer.append(" mode=" + this.getEncoding());
        if (this.gneUsername != null) {
            stringBuffer.append(" uname=" + this.gneUsername);
        }
        if (this.gneTid != null) {
            stringBuffer.append(" gneTid=" + this.gneTid);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Tl1TunnelAddr) {
            Tl1TunnelAddr tl1TunnelAddr = (Tl1TunnelAddr)object;
            return tl1TunnelAddr.ip.equals(this.ip) && tl1TunnelAddr.pneTid.equals(this.pneTid);
        }
        return false;
    }

    protected String getPersistedValue() {
        return this.host + DELIMITER + this.pneTid + DELIMITER + this.encoding + DELIMITER + this.gneTl1Port + DELIMITER + (this.gneTid == null ? "" : this.gneTid);
    }
}

