/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import com.cisco.sot.LimitXpSocket;
import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelAddr;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Observer;

public class Tl1TunnelFactory
implements Runnable {
    private static Tl1TunnelFactory instance;
    private static final int MAX_TUNNELS = 32;
    private KDebug dbg = new TTDebug();
    private ArrayList tunnels = new ArrayList();
    private Selector selector;
    private boolean inited = false;
    private Thread selectThread;
    private LinkedList selTunnelList = new LinkedList();

    public static synchronized Tl1TunnelFactory instance() {
        if (instance == null) {
            instance = new Tl1TunnelFactory();
        }
        return instance;
    }

    private Tl1TunnelFactory() {
    }

    private synchronized void init() throws IOException {
        if (!this.inited) {
            this.selector = Selector.open();
            this.selectThread = new Thread((Runnable)this, "TL1 Tunnels Selector");
            this.selectThread.start();
            this.inited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tl1Tunnel createTl1Tunnel(Tl1TunnelAddr tl1TunnelAddr, int n, Observer observer) throws IOException {
        Tl1Tunnel tl1Tunnel = null;
        this.init();
        ArrayList arrayList = this.tunnels;
        synchronized (arrayList) {
            if (this.tunnels.size() >= 32) {
                throw new IOException("Too many tunnels open, max is 32");
            }
            tl1Tunnel = new Tl1Tunnel();
            this.tunnels.add(tl1Tunnel);
        }
        try {
            if (observer != null) {
                tl1Tunnel.addObserver(observer);
            }
            tl1Tunnel.openTunnel(tl1TunnelAddr, n, this.selector);
        }
        catch (IOException iOException) {
            this.removeTl1Tunnel(tl1Tunnel);
            throw iOException;
        }
        finally {
            if (observer != null) {
                tl1Tunnel.deleteObserver(observer);
            }
        }
        return tl1Tunnel;
    }

    public Tl1Tunnel createTl1Tunnel(Tl1TunnelAddr tl1TunnelAddr, int n) throws IOException {
        return this.createTl1Tunnel(tl1TunnelAddr, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTl1Tunnel(Tl1Tunnel tl1Tunnel) {
        ArrayList arrayList = this.tunnels;
        synchronized (arrayList) {
            this.tunnels.remove(tl1Tunnel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tl1Tunnel getTunnel(Tl1TunnelAddr tl1TunnelAddr) {
        Tl1Tunnel tl1Tunnel = null;
        ArrayList arrayList = this.tunnels;
        synchronized (arrayList) {
            for (int i = 0; i < this.tunnels.size(); ++i) {
                Tl1Tunnel tl1Tunnel2 = (Tl1Tunnel)this.tunnels.get(i);
                if (tl1Tunnel2.getAddress() != tl1TunnelAddr) continue;
                tl1Tunnel = tl1Tunnel2;
                break;
            }
        }
        return tl1Tunnel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Tl1Tunnel tl1Tunnel = null;
        Object object = this.tunnels;
        synchronized (object) {
            for (int i = 0; i < this.tunnels.size(); ++i) {
                Tl1Tunnel tl1Tunnel2 = (Tl1Tunnel)this.tunnels.get(i);
                if (!tl1Tunnel2.canTunnelFor(inetAddress)) continue;
                tl1Tunnel = tl1Tunnel2;
                break;
            }
        }
        object = null;
        if (tl1Tunnel != null) {
            object = tl1Tunnel.createSocket(inetAddress, n, n2);
        } else {
            object = new Socket();
            if (LimitXpSocket.isNeededForThisOs()) {
                if (this.dbg.isFinerEnabled()) {
                    this.dbg.finer("creating windows XP socket-limiting socket for: " + inetAddress + "/" + n);
                }
                object = new LimitXpSocket((Socket)object);
            }
            ((Socket)object).connect(new InetSocketAddress(inetAddress, n), n2);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectCallback(Tl1Tunnel tl1Tunnel) {
        if (Thread.currentThread() == this.selectThread) {
            tl1Tunnel.selectCallback();
        } else {
            LinkedList linkedList = this.selTunnelList;
            synchronized (linkedList) {
                this.selTunnelList.add(tl1Tunnel);
                this.selector.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        try {
            block8: while (true) {
                var1_1 = this.selector.select();
                var2_4 = this.selTunnelList;
                synchronized (var2_4) {
                    while (!this.selTunnelList.isEmpty()) {
                        var3_5 = (Tl1Tunnel)this.selTunnelList.removeFirst();
                        var3_5.selectCallback();
                    }
                }
                if (var1_1 <= 0) continue;
                var2_4 = this.selector.selectedKeys().iterator();
                while (true) {
                    if (var2_4.hasNext()) ** break;
                    continue block8;
                    var3_5 = (SelectionKey)var2_4.next();
                    var2_4.remove();
                    try {
                        if (!var3_5.isValid()) continue;
                        var4_6 = (Tl1Tunnel)var3_5.attachment();
                        if (var3_5.isWritable()) {
                            var4_6.processWrite();
                        }
                        if (!var3_5.isValid() || !var3_5.isReadable()) continue;
                        var4_6.processRead();
                    }
                    catch (CancelledKeyException var4_8) {
                        KDebug.printStackTrace(var4_8);
                    }
                }
                break;
            }
        }
        catch (IOException var1_2) {
            KDebug.printStackTrace(var1_2);
        }
        catch (ClosedSelectorException var1_3) {
        }
    }

    public class TTDebug
    extends KDebug
    implements IDebugDiag {
        TTDebug() {
            super("Tl1TunnelFactory");
        }

        public final void dumpDiag() {
            this.println("----- TL1 Tunnel Factory Dump Start");
            for (int i = 0; i < Tl1TunnelFactory.this.tunnels.size(); ++i) {
                Tl1Tunnel tl1Tunnel = (Tl1Tunnel)Tl1TunnelFactory.this.tunnels.get(i);
                if (tl1Tunnel == null) continue;
                tl1Tunnel.dump();
            }
            this.println("----- TL1 Tunnel Factory Dump End");
        }

        public final void resetStats() {
            for (int i = 0; i < Tl1TunnelFactory.this.tunnels.size(); ++i) {
                Tl1Tunnel tl1Tunnel = (Tl1Tunnel)Tl1TunnelFactory.this.tunnels.get(i);
                if (tl1Tunnel == null) continue;
                tl1Tunnel.resetStats();
            }
            this.println("--- All tunnel stats reset");
        }
    }
}

