/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.version.AbstractInterfaceVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;

public class CachedJar {
    protected static final String incompatibleVersion = "99.98";
    public static final String PROPERTY_PATH = "ctc.launcher";
    protected static final String OLD_PROP_PATH = "ctc_launcher";
    protected static final String PREFIX = "ctc-jar-";
    protected static final String BACKUP_PREFIX = "preupgrade-ctc-jar-";
    protected static final String CTC_PROPERTY = "ctc";
    protected static final String CLURL_PROPERTY = "clurl";
    protected static final String CLURL_PROP = "ctc.clurl";
    private final String _baseUrl;
    private final String _fileName;
    private final String _fromHost;
    private String _bldVersion;
    private String _swVersion;
    private String _neSwVersion;
    private String _neType;
    private String _cacheName;
    private DownloadState _state;
    private URL[] myUrlArray;
    private static final HashMap _versionMapping = new HashMap();
    protected static final KDebug db;

    public CachedJar(String string, String string2, String string3) throws IOException {
        this(string, string2, null, string3);
    }

    public CachedJar(String string, String string2, String string3, String string4) throws IOException {
        if (db.on()) {
            db.print("<init>: ");
        }
        this._baseUrl = string;
        this._fileName = string2;
        this._fromHost = string4;
        this._neType = string3;
        this._cacheName = null;
        this._state = new DownloadState("");
        this.myUrlArray = this.makeUrls();
        if (db.on()) {
            db.println(this.myValues());
        }
    }

    protected boolean isUnifiedEle() {
        try {
            return new CtcHttpRetriever().supports(new URL(this._baseUrl + "/fs/ELE.jgz"), null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private String stateName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getSwBuildVersion();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (this._fileName != null) {
            stringBuffer.append(" (");
            stringBuffer.append(this._fileName);
            stringBuffer.append(")");
        }
        if (this._neType != null) {
            stringBuffer.append(" for a CISCO ONS ");
            stringBuffer.append(this._neType);
        }
        if (this._baseUrl != null) {
            stringBuffer.append(" from ");
            stringBuffer.append(this._baseUrl);
        }
        return stringBuffer.toString();
    }

    public String getCachedName() {
        return this._cacheName;
    }

    public DownloadState getDownloadState() {
        return this._state;
    }

    private boolean deleteFile(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            bl = file.delete();
        }
        catch (SecurityException securityException) {
            db.severe("SecurityException when deleting " + string);
            KDebug.printStackTrace(securityException);
        }
        return bl;
    }

    public void init() throws IOException, MalformedURLException {
        this.init(true);
    }

    public void init(boolean bl) throws IOException, MalformedURLException {
        if (db.on()) {
            db.fine("init: " + this._fileName);
        }
        Object var2_2 = null;
        if (this.isCachingPermitted()) {
            db.info("jar caching to be attempted");
            if (this._cacheName == null) {
                this._cacheName = this.cachedName(false);
            }
            db.info("Trying to use cache: " + this._cacheName);
            boolean bl2 = this.doesCacheFileExist(this._cacheName);
            if (!bl2 || !this.useCachedVersion()) {
                if (!CachedJar.isDownloadingPermitted()) {
                    String string = this.toSourceUrl().getFile();
                    db.severe("init: " + this._fileName + " caching permitted/no downloading permitted and " + string + " not found");
                    throw new FileNotFoundException(string);
                }
                if (bl) {
                    this.cleanUnusableCacheData();
                } else if (!bl2) {
                    this.deleteFile(this._cacheName);
                }
                this.downloadToCache(this._cacheName, bl);
                this.myUrlArray = new URL[]{new File(this._cacheName).toURL()};
            }
            if (db.on()) {
                db.println("Using cached jar:" + this._cacheName);
            }
            this.adjustSwVersionFromCache();
            this.deleteBackupJarFiles();
        } else {
            this.initNoCaching();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUnusableCacheData() throws IOException {
        Preferences preferences;
        Preferences preferences2 = preferences = Preferences.instance();
        synchronized (preferences2) {
            String string = this.propertyName().toLowerCase(Locale.ENGLISH);
            preferences.removeProperty(PROPERTY_PATH, string);
            preferences.removeProperty(OLD_PROP_PATH, string);
            preferences.store();
            if (CachedJar.db.on) {
                db.println("init(): cleared property/removing jar file" + string + "=" + this._cacheName);
            }
        }
        this.deleteFile(this._cacheName);
    }

    private void downloadToCache(String string, boolean bl) throws IOException {
        this._cacheName = this.cachedName(true);
        db.info("Downloading a fresh copy into " + this._cacheName);
        try {
            this.cache(this._cacheName);
            if (bl) {
                this.storeJarPreference(this._cacheName, Preferences.instance(), false, false);
            }
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
            throw iOException;
        }
    }

    private void adjustSwVersionFromCache() {
        String string = this.getCachedSwVersion();
        if (string != null && !string.equals(this._swVersion)) {
            db.severe("Overwriting version " + this._swVersion + " with cached version " + string);
            this._swVersion = string;
        }
    }

    private void deleteBackupJarFiles() {
        Preferences preferences = Preferences.instance();
        String string = preferences.getProperty(PROPERTY_PATH, this.backupPropertyName(), null);
        if (string != null) {
            this.deleteFile(string);
            preferences.removeProperty(PROPERTY_PATH, this.backupPropertyName());
        }
    }

    private void initNoCaching() throws IOException {
        String string = this.toSourceUrl().getFile();
        if (this.myUrlArray.length == 0 && !this.doesCacheFileExist(string)) {
            db.severe("init: " + this._fileName + " no caching permitted and " + string + " not found");
            throw new FileNotFoundException(string);
        }
        String string2 = this.getCachedSwVersion(this.getURLs());
        if (string2 == null) {
            db.severe("Cannot get version from cache:" + this.myValues());
            throw new FileNotFoundException(string);
        }
        if (!string2.equals(this._swVersion)) {
            db.severe("Overwriting version " + this._swVersion + " with cached version " + string2);
            this._swVersion = string2;
        }
    }

    public String getInterfaceVersionClassName() {
        String string = "cerent.version." + this.getInterfaceVersionName() + "InterfaceVersion";
        return string;
    }

    private String getInterfaceVersionPathName() {
        String string = "/cerent/version/" + this.getInterfaceVersionName() + "InterfaceVersion.class";
        return string;
    }

    private String getInterfaceVersionName() {
        String string = this._fileName.toLowerCase(Locale.ENGLISH);
        string = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
        return string;
    }

    public AbstractInterfaceVersion getInterfaceVersion() {
        AbstractInterfaceVersion abstractInterfaceVersion = null;
        String string = this.getInterfaceVersionClassName();
        if (db.on()) {
            db.println("Trying to load " + string + " from " + this.myValues());
        }
        if (this.myUrlArray.length > 0) {
            String string2 = this.myUrlArray[0].getProtocol();
            if (string2.equals("file")) {
                abstractInterfaceVersion = this.loadInterfaceVersion(string, this.myUrlArray);
            } else if (string2.equals("http")) {
                try {
                    String string3 = this.getInterfaceVersionPathName();
                    URL uRL = new URL(this.downloadClass(this.myUrlArray[0], string3));
                    if (db.on()) {
                        db.println("[CVM] downloaded to " + uRL);
                    }
                    abstractInterfaceVersion = this.loadInterfaceVersion(string, new URL[]{uRL});
                }
                catch (IOException iOException) {
                    KDebug.printStackTrace(iOException);
                }
            } else {
                db.severe("getInterfaceVersion, unknown protocol:" + string2);
            }
        }
        if (db.on()) {
            db.println("getInterfaceVersion " + this._fileName + "=" + abstractInterfaceVersion);
        }
        return abstractInterfaceVersion;
    }

    private AbstractInterfaceVersion loadInterfaceVersion(String string, URL[] uRLArray) {
        AbstractInterfaceVersion abstractInterfaceVersion = null;
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
        try {
            Class<?> clazz = uRLClassLoader.loadClass(string);
            abstractInterfaceVersion = (AbstractInterfaceVersion)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            KDebug.printStackTrace(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            KDebug.printStackTrace(illegalAccessException);
        }
        return abstractInterfaceVersion;
    }

    private String downloadClass(URL uRL, String string) throws MalformedURLException, IOException, FileNotFoundException {
        CtcHttpRetriever ctcHttpRetriever = new CtcHttpRetriever();
        DownloadState downloadState = new DownloadState(uRL.toExternalForm());
        File file = File.createTempFile("temp", ".ctc");
        file.deleteOnExit();
        String string2 = this.buildLocalPath(file.getParent(), string);
        ctcHttpRetriever.transferContent(uRL, string2, downloadState);
        return file.getParent();
    }

    private String buildLocalPath(String string, String string2) {
        System.out.println("***AH root=" + string + " filename=" + string2);
        int n = string2.lastIndexOf("/");
        String string3 = string2.substring(n + 1);
        String string4 = string2.substring(0, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
        do {
            string = string + File.separatorChar + stringTokenizer.nextToken();
            File file = new File(string);
            file.mkdir();
        } while (stringTokenizer.hasMoreTokens());
        string = string + File.separatorChar + string3;
        return string;
    }

    public boolean isCompatibleWith(CachedJar cachedJar) throws IOException, MalformedURLException {
        boolean bl;
        String string;
        String string2 = this.getSwVersion();
        String string3 = string = cachedJar != null ? cachedJar.getSwVersion() : null;
        if (string2 == null) {
            bl = false;
        } else if (string == null) {
            bl = false;
        } else {
            String string4;
            String string5 = this.mapVersion(this, CtcHttpRetriever.version(string2));
            bl = string5.compareTo(string4 = this.mapVersion(cachedJar, CtcHttpRetriever.version(string))) >= 0;
            db.info(this._fileName + ": " + string2 + " as " + string5 + " isCompatibleWith(" + cachedJar._fileName + " " + string + " as " + string4 + ") => " + bl);
        }
        return bl;
    }

    public URL toUrl() throws MalformedURLException {
        URL uRL = null;
        if (this.isCachingPermitted()) {
            if (this._cacheName == null) {
                this._cacheName = this.cachedName(false);
            }
            try {
                File file = new File(this._cacheName);
                uRL = file.toURL();
            }
            catch (IOException iOException) {
                KDebug.printStackTrace(iOException);
            }
        } else {
            uRL = this.toSourceUrl();
        }
        return uRL;
    }

    public URL toSourceUrl() throws MalformedURLException {
        return new URL(this.sourceName());
    }

    public String fileName() {
        return this._fileName;
    }

    public String sourceName() {
        return this._baseUrl + "/fs/" + this.fileName() + ".jar";
    }

    public String sourceGzipName() {
        return this._baseUrl + "/fs/" + this.fileName() + ".jgz";
    }

    protected URL[] getDefaultBuildInfoUrls() throws MalformedURLException, ClassNotFoundException, IOException {
        db.fine("getBuildInfo: entered");
        if (this.isCachingPermitted() && !this.doesCacheFileExist(this._cacheName)) {
            db.severe("getBuildInfo: " + this.myValues() + " does not exist");
            throw new ClassNotFoundException("Caching permitted but no cache file with build information" + this._cacheName);
        }
        URL[] uRLArray = new URL[]{this.toUrl()};
        return uRLArray;
    }

    protected Class getBuildInfo(URL[] uRLArray) throws MalformedURLException, ClassNotFoundException, IOException {
        Class<?> clazz = null;
        if (uRLArray == null) {
            uRLArray = this.getDefaultBuildInfoUrls();
            db.fine("getBuildInfo: " + this.myValues() + " loading from " + uRLArray[0]);
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, null);
        try {
            clazz = uRLClassLoader.loadClass("cerent.util.BuildInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = uRLClassLoader.loadClass("cerent.util.ORBBuildInfo");
        }
        return clazz;
    }

    protected Class getBuildInfo() throws MalformedURLException, ClassNotFoundException, IOException {
        return this.getBuildInfo(null);
    }

    public String getCachedSwVersion(URL[] uRLArray) {
        String string;
        block2: {
            string = null;
            try {
                Class clazz = this.getBuildInfo(uRLArray);
                Field field = clazz.getField("version");
                string = (String)field.get(null);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.severe("getCachedSwVersion: " + this.myValues() + " exception " + exception);
                KDebug.printStackTrace(exception);
            }
        }
        db.info("getCachedSwVersion: " + this.myValues() + " => " + string);
        return string;
    }

    public String getCachedSwVersion() {
        return this.getCachedSwVersion(null);
    }

    public String getCachedSwDate(URL[] uRLArray) {
        String string;
        block2: {
            string = null;
            try {
                Class clazz = this.getBuildInfo(uRLArray);
                Field field = clazz.getField("date");
                string = (String)field.get(null);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.severe("getCachedSwDate: " + this.myValues() + " exception " + exception);
                KDebug.printStackTrace(exception);
            }
        }
        db.info("getCachedSwDate: " + this._fileName + " => " + string);
        return string;
    }

    public String getSwVersionAndDate(URL[] uRLArray) {
        String string;
        block2: {
            string = null;
            try {
                Class clazz = this.getBuildInfo(uRLArray);
                Field field = clazz.getField("version");
                Field field2 = clazz.getField("date");
                string = CtcHttpRetriever.version((String)field.get(null)) + " - " + (String)field2.get(null);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.severe("getSwVersionAndDate: exception " + exception);
                KDebug.printStackTrace(exception);
            }
        }
        db.info("getSwVersionAndDate: " + this._fileName + " => " + string);
        return string;
    }

    public String getSwVersionAndDate() {
        return this.getSwVersionAndDate(null);
    }

    private boolean doesCacheFileExist(String string) {
        boolean bl;
        block4: {
            bl = false;
            try {
                File file = new File(string);
                if (file.exists()) {
                    JarFile jarFile = new JarFile(file);
                    JarEntry jarEntry = jarFile.getJarEntry("cerent/util/BuildInfo.class");
                    if (jarEntry == null) {
                        jarEntry = jarFile.getJarEntry("cerent/util/ORBBuildInfo.class");
                    }
                    bl = jarEntry != null;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.severe("doesCacheFileExist: exception " + exception);
                KDebug.printStackTrace(exception);
            }
        }
        db.info("doesCacheFileExist: " + this._fileName + " " + string + " => " + bl);
        return bl;
    }

    protected String propertyName() {
        return PREFIX + this._fileName;
    }

    protected String backupPropertyName() {
        return (BACKUP_PREFIX + this._fileName).toLowerCase(Locale.ENGLISH);
    }

    public String getNeType() {
        return this._neType;
    }

    private String getSwBuildVersion() {
        block3: {
            if (this._bldVersion == null) {
                try {
                    this._bldVersion = CtcHttpRetriever.getSwVersion(this._fromHost);
                }
                catch (IOException iOException) {
                    if (!db.on()) break block3;
                    db.println(this._fileName + ": getSwBuildVersion() " + iOException);
                }
            }
        }
        return this._bldVersion;
    }

    public String getSwVersion() {
        block3: {
            if (this._swVersion == null) {
                try {
                    this._swVersion = CtcHttpRetriever.getApiVersion(this._fromHost);
                }
                catch (IOException iOException) {
                    if (!db.on()) break block3;
                    db.println(this._fileName + ": getSwVersion() " + iOException);
                }
            }
        }
        return this._swVersion;
    }

    public String getNeSwVersion() {
        block4: {
            if (this._neSwVersion == null) {
                try {
                    this._neSwVersion = CtcHttpRetriever.getApiVersion(this._fromHost);
                    int n = this._neSwVersion.indexOf(45);
                    if (n >= 0) {
                        this._neSwVersion = this._neSwVersion.substring(0, n);
                    }
                }
                catch (IOException iOException) {
                    if (!db.on()) break block4;
                    db.println(this._fileName + ": getNeSwVersion() " + iOException);
                }
            }
        }
        return this._neSwVersion == null ? "" : this._neSwVersion;
    }

    protected String myValues() {
        String string = this._swVersion != null ? CtcHttpRetriever.version(this._swVersion) : null;
        String string2 = "[" + this._fromHost + " name=" + this._fileName + " swVersion=" + string + " neType=" + this._neType + " cacheName=" + this._cacheName + " URL=";
        if (this.myUrlArray != null) {
            int n = 0;
            while (true) {
                string2 = string2 + this.myUrlArray[n].toExternalForm();
                if (++n >= this.myUrlArray.length) break;
                string2 = string2 + ";";
            }
        }
        return string2 + "]";
    }

    protected boolean useVersionMap() {
        return false;
    }

    protected String mapVersion(CachedJar cachedJar, String string) {
        HashMap hashMap;
        String string2 = null;
        if (cachedJar.useVersionMap() && (hashMap = (HashMap)_versionMapping.get(cachedJar.getNeType())) != null && (string2 = (String)hashMap.get(string)) == null) {
            System.out.println("*** No version mapping found for neType=" + this._neType + " and version=" + string);
            System.out.println("    Update cerent.launcher.CachedJar._versionMapping");
            System.out.println("    Current mappings are:");
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)hashMap.get(string3);
                System.out.println("       " + string3 + " mapsTo " + string4);
            }
            string2 = incompatibleVersion;
        }
        if (string2 == null) {
            string2 = string;
        }
        if (db.on() && cachedJar._cacheName != null && !cachedJar._cacheName.equals(string2)) {
            db.info(cachedJar._fileName + ":" + cachedJar._cacheName + " mapVersion(" + string + ") => " + string2);
        }
        return string2;
    }

    protected boolean useCachedVersion() {
        boolean bl;
        String string = this.getCachedSwVersion();
        if (!CachedJar.isDownloadingPermitted()) {
            bl = true;
            db.fine(this._fileName + ": download not permitted => " + bl);
        } else {
            String string2 = this.getSwVersion();
            if (string2 == null) {
                bl = true;
                db.fine(this._fileName + ": getSwVersion() is null => " + bl);
            } else if (this._baseUrl == null) {
                bl = true;
                db.fine(this._fileName + ": _baseUrl is null => " + bl);
            } else if (string == null) {
                bl = false;
                db.fine(this._fileName + ": cachedVer is null => " + bl);
            } else {
                String string3;
                String string4 = this.mapVersion(this, CtcHttpRetriever.version(string2));
                boolean bl2 = bl = string4.compareTo(string3 = this.mapVersion(this, CtcHttpRetriever.version(string))) <= 0;
                if (db.on()) {
                    db.println(this._fileName + ": checking (cache version " + string3 + " == NE version " + string4 + ") =>" + bl);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cachedName(boolean bl) {
        String string;
        block8: {
            string = null;
            try {
                if (this.isCachingPermitted()) {
                    Preferences preferences;
                    String string2 = this.propertyName().toLowerCase(Locale.ENGLISH);
                    Preferences preferences2 = preferences = Preferences.instance();
                    synchronized (preferences2) {
                        string = preferences.getProperty(PROPERTY_PATH, string2, null);
                        if (string == null && (string = preferences.getProperty(OLD_PROP_PATH, string2, null)) != null && !bl) {
                            preferences.removeProperty(OLD_PROP_PATH, string2);
                            preferences.setProperty(PROPERTY_PATH, string2, string);
                            preferences.store();
                        }
                        if (string == null || bl) {
                            File file = File.createTempFile("ctc-" + this._fileName, ".jar");
                            string = file.getCanonicalPath();
                        }
                        break block8;
                    }
                }
                string = this.toSourceUrl().getFile();
            }
            catch (IOException iOException) {
                KDebug.printStackTrace(iOException);
            }
        }
        db.fine("cachedName: " + this.myValues() + " => " + string);
        return string;
    }

    public boolean isCachingPermitted() {
        return Preferences.instance().getBoolean(CTC_PROPERTY, "cachejars", true);
    }

    public static boolean isDownloadingPermitted() {
        return Preferences.instance().getBoolean(CTC_PROPERTY, "downloadjars", true);
    }

    private void cache(String string) throws FileNotFoundException, IOException, MalformedURLException {
        CtcHttpRetriever ctcHttpRetriever = new CtcHttpRetriever();
        try {
            String string2 = this.sourceGzipName();
            db.info("Caching from " + string2);
            this._state.reset(this.stateName());
            ctcHttpRetriever.transferContent(new URL(string2), GZIPInputStream.class, string, this._state);
        }
        catch (FileNotFoundException fileNotFoundException) {
            db.info("Caught " + fileNotFoundException.toString());
            db.info("Trying regular jar file");
            try {
                URL uRL = this.toSourceUrl();
                db.info("Caching from " + uRL);
                ctcHttpRetriever.transferContent(uRL, string, this._state);
                db.info("cache: " + this.myValues() + " downloaded");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                db.severe("cache: " + this.myValues() + " file not found");
                this.deleteFile(this._cacheName);
                throw new FileNotFoundException(fileNotFoundException.getMessage() + "\nand/or " + fileNotFoundException2.getMessage());
            }
            catch (IOException iOException) {
                db.severe("cache: " + this.myValues() + " reading " + iOException);
                this.deleteFile(this._cacheName);
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJarPreference(String string, Preferences preferences, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        Preferences preferences2 = preferences;
        synchronized (preferences2) {
            String string2 = this.propertyName().toLowerCase(Locale.ENGLISH);
            String string3 = preferences.getProperty(PROPERTY_PATH, string2, null);
            if (string3 == null && (string3 = preferences.getProperty(OLD_PROP_PATH, string2, null)) != null) {
                preferences.removeProperty(OLD_PROP_PATH, string2);
                preferences.setProperty(PROPERTY_PATH, string2, string);
                preferences.store();
            }
            if (string3 == null || bl) {
                if (string3 != null && bl2) {
                    preferences.setProperty(PROPERTY_PATH, this.backupPropertyName(), string3);
                }
                preferences.setProperty(PROPERTY_PATH, string2, string);
                preferences.store();
                db.fine("cache(): stored ctc_launcher." + string2 + "=" + string);
            } else if (string != string3) {
                db.fine("cache(): " + string + "/" + string3 + " mismatch : redundant jar files?");
            }
        }
    }

    public String getPropertyKey() {
        return this.fileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCachedJar(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        Preferences preferences2 = preferences;
        synchronized (preferences2) {
            preferences.removeAllProperties(PROPERTY_PATH, PREFIX);
            preferences.removeAllProperties(OLD_PROP_PATH, PREFIX);
            try {
                preferences.store();
            }
            catch (IOException iOException) {
                KDebug.printStackTrace(iOException);
            }
        }
    }

    private URL[] makeUrls() throws IOException, MalformedURLException {
        URL uRL;
        int n = 0;
        String string = this.getPropertyKey();
        String[] stringArray = this.getPropertyBasedClasspaths();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n2 = 0;
        if (string != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                int n3 = stringTokenizer.countTokens();
                for (int j = 0; j < n3; ++j) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = string3;
                    if (!string4.endsWith(".jar") && !string4.endsWith("/")) {
                        string4 = string4 + "/";
                    }
                    arrayList.add(new URL(string4));
                    ++n2;
                    ++n;
                }
            }
        }
        if ((this.isCachingPermitted() || arrayList.size() == 0) && (uRL = this.toUrl()) != null) {
            arrayList.add(uRL);
        }
        URL[] uRLArray = arrayList.toArray(new URL[0]);
        return uRLArray;
    }

    private String[] getPropertyBasedClasspaths() {
        int n;
        String string = this.getPropertyKey();
        String string2 = string;
        if (string2 != null && (n = string2.indexOf("-")) >= 0) {
            string2 = string2.substring(0, n);
        }
        String string3 = Preferences.instance().getProperty(CTC_PROPERTY, CLURL_PROPERTY + string, null);
        String string4 = Preferences.instance().getProperty(CTC_PROPERTY, CLURL_PROPERTY + string2, null);
        String string5 = Preferences.instance().getProperty(CTC_PROPERTY, CLURL_PROPERTY, null);
        if (string3 != null) {
            string4 = null;
        }
        String[] stringArray = new String[]{string3, string4, string5};
        return stringArray;
    }

    public URL[] getURLs() {
        return this.myUrlArray;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("01.00", "03.31");
        _versionMapping.put("15600", hashMap);
        db = new KDebug("CachedJar");
    }
}

