/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class BuildInfo {
    public static final String version;
    public static final String date;
    public static final String developmentVersion = "DEV";

    public static String sanitize(String string) {
        String string2 = "";
        String string3 = string;
        int n = string.lastIndexOf(" ");
        if (n >= 0) {
            string2 = string.substring(0, n + 1);
            string = string.substring(n + 1);
        }
        if (string.length() > 6 && string.charAt(2) == '.') {
            string3 = string.charAt(0) == '0' ? string2 + string.substring(1, 4) : string2 + string.substring(0, 4);
            string3 = string3 + "." + string.substring(4, 5) + " (" + string + ")";
        }
        return string3;
    }

    public static String getShortVersionString() {
        String string = BuildInfo.sanitize(version);
        try {
            string = string.substring(0, string.indexOf(" "));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getBuildVersion(Attributes attributes) {
        String string = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        if (string == null) {
            System.err.println("Cannot find version information");
            System.exit(0);
        }
        return string;
    }

    private static String getBuildDate(Attributes attributes) {
        String string = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (string == null) {
            System.err.println("Cannot find build date information");
            System.exit(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getAttributes() {
        Attributes attributes = null;
        ClassLoader classLoader = BuildInfo.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            URL uRL = uRLClassLoader.findResource("META-INF/MANIFEST.MF");
            if (uRL != null) {
                InputStream inputStream = null;
                try {
                    inputStream = uRL.openStream();
                    Manifest manifest = new Manifest(inputStream);
                    attributes = manifest.getMainAttributes();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                    iOException.printStackTrace(System.err);
                    System.exit(0);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.toString());
                            iOException.printStackTrace(System.err);
                            System.exit(0);
                        }
                    }
                }
                if (attributes == null) {
                    System.err.println("Cannot get attributes for " + uRL.toString());
                    System.exit(0);
                }
            } else {
                System.err.println("Cannot get manifest");
                System.exit(0);
            }
        } else {
            System.err.println("Classloader is not a URLClassLoader");
            System.exit(0);
        }
        return attributes;
    }

    static {
        Attributes attributes = BuildInfo.getAttributes();
        version = BuildInfo.getBuildVersion(attributes);
        date = BuildInfo.getBuildDate(attributes);
    }
}

