/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClassDiffUtil
implements Comparator {
    private static final String[] stringArrayTemplate = new String[0];
    private static HashMap nonloadableClasses;
    private static HashMap primitiveClasses;
    private static HashMap unprimitiveClasses;
    ClassLoader lhsLoader;
    ClassLoader rhsLoader;
    boolean quietMode;
    File echoFile;
    PrintWriter echoWriter;
    String className;
    boolean printedHeader;
    boolean leftonly;
    boolean rightonly;
    static String classdebugTestDir;
    static String[] classdebugSuffixes;
    static String runCTCTestDir;
    static String[] runCTCSuffixes;

    private ClassDiffUtil(ClassLoader classLoader, ClassLoader classLoader2, boolean bl, File file, boolean bl2, boolean bl3) throws IOException {
        this.lhsLoader = classLoader;
        this.rhsLoader = classLoader2;
        this.quietMode = bl;
        this.echoFile = file;
        this.leftonly = bl2;
        this.rightonly = bl3;
        if (file != null) {
            this.echoWriter = new PrintWriter(new FileWriter(file));
        }
    }

    private static String[] filterModels(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("cerent.cms.model.I") || stringArray[i].indexOf("$") >= 0) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(stringArrayTemplate);
    }

    private void diff(String string, URLClassLoader uRLClassLoader) {
        if (string.equals("model")) {
            System.out.println("computing loadable model classes...standby");
            String[] stringArray = ClassDiffUtil.filterModels(this.getSomeClassNames(uRLClassLoader, "cerent.cms.model.", "Model"));
            System.out.println("done...");
            this.diff(stringArray);
        } else {
            this.diff(string, 0);
        }
    }

    private void diff(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.diff(stringArray[i], 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int diff(String string, int n) {
        File file;
        int n2 = 0;
        int n3 = 0;
        if (string.endsWith(".java")) {
            string = string.substring(0, string.lastIndexOf(".java"));
        }
        if ((file = new File(string)).exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    try {
                        while (true) {
                            String string2;
                            if ((string2 = bufferedReader.readLine()).startsWith(" ") || string2.startsWith("#")) {
                                continue;
                            }
                            string2 = string2.trim();
                            ++n3;
                            n2 += this.diff(string2, n + 1);
                        }
                    }
                    catch (IOException iOException) {
                        bufferedReader.close();
                    }
                }
                catch (Throwable throwable) {
                    bufferedReader.close();
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        } else if (this._diff(string)) {
            ++n2;
            ++n3;
        }
        if (!(n != 0 || n2 <= 0 && this.quietMode)) {
            this.println("# " + n2 + " diffs found in " + n3 + " classes processed ");
        }
        return n2;
    }

    private boolean _diff(String string) {
        Class<?> clazz;
        Class<?> clazz2;
        this.className = string;
        boolean bl = false;
        String string2 = "cerent.cms.model.";
        this.printedHeader = false;
        this.printHeader();
        String string3 = this.className;
        try {
            clazz2 = this.lhsLoader.loadClass(string3);
        }
        catch (Exception exception) {
            try {
                string3 = string2 + this.className;
                clazz2 = this.lhsLoader.loadClass(string3);
            }
            catch (Exception exception2) {
                this.printHeader(true);
                this.println("class " + string3 + " now missing from left");
                this.println("");
                return true;
            }
        }
        string3 = this.className;
        try {
            clazz = this.rhsLoader.loadClass(string3);
        }
        catch (Exception exception) {
            try {
                string3 = string2 + this.className;
                clazz = this.rhsLoader.loadClass(string3);
            }
            catch (Exception exception3) {
                this.printHeader(true);
                this.println("class " + string3 + " new to left");
                this.println("");
                return true;
            }
        }
        Method[] methodArray = clazz2.getMethods();
        Method[] methodArray2 = clazz.getMethods();
        methodArray = this.sort(methodArray);
        methodArray2 = this.sort(methodArray2);
        return this.diff(methodArray, methodArray2);
    }

    private void printHeader(boolean bl) {
        if (!(this.quietMode && !bl || this.printedHeader)) {
            this.println("# processing class: " + this.className);
            this.printedHeader = true;
        }
    }

    private void printHeader() {
        this.printHeader(false);
    }

    private Method[] sort(Method[] methodArray) {
        if (methodArray == null || methodArray.length <= 1) {
            return methodArray;
        }
        int n = methodArray.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(methodArray, 0, objectArray, 0, n);
        Arrays.sort(objectArray, this);
        Method[] methodArray2 = new Method[n];
        System.arraycopy(objectArray, 0, methodArray2, 0, n);
        return methodArray2;
    }

    private boolean diff(Method[] methodArray, Method[] methodArray2) {
        int n = methodArray.length;
        int n2 = methodArray2.length;
        int n3 = n <= n2 ? n : n2;
        int n4 = 0;
        int n5 = 0;
        Method[] methodArray3 = null;
        int n6 = 0;
        int n7 = 0;
        String string = null;
        boolean bl = false;
        while (n4 < n3 && n5 < n3) {
            Method method = methodArray[n4];
            Method method2 = methodArray2[n5];
            if (!this.instanceMethod(method)) {
                ++n4;
                continue;
            }
            if (!this.instanceMethod(method2)) {
                ++n5;
                continue;
            }
            int n8 = this.compare(method, method2);
            if (n8 < 0) {
                if (!this.rightonly) {
                    bl = true;
                    this.report("left only: ", method);
                }
                ++n4;
                continue;
            }
            n8 = this.compare(method, method2);
            if (n8 > 0) {
                if (!this.leftonly) {
                    bl = true;
                    this.report("right only: ", method2);
                }
                ++n5;
                continue;
            }
            ++n4;
            ++n5;
        }
        if (n < n2) {
            methodArray3 = methodArray2;
            n6 = n5;
            n7 = n2;
            string = "right only: ";
        } else if (n > n2) {
            methodArray3 = methodArray;
            n6 = n4;
            n7 = n2;
            string = "left only: ";
        }
        if (methodArray3 != null) {
            for (n4 = n6; n4 < n7; ++n4) {
                if (!this.instanceMethod(methodArray3[n4])) continue;
                bl = true;
                this.report(string, methodArray3[n4]);
            }
        }
        if (bl) {
            this.println("");
        }
        return bl;
    }

    private boolean instanceMethod(Method method) {
        int n = method.getModifiers();
        boolean bl = (n & 1) != 0 && (n & 8) == 0;
        return bl;
    }

    private boolean constant(Field field) {
        int n = field.getModifiers();
        boolean bl = (n & 1) != 0 && (n & 0x10) != 0;
        return bl;
    }

    private void report(String string, Method method) {
        this.printHeader(true);
        this.print(string);
        this.println(this.signatureString(method));
    }

    private void dumpMethods(Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            this.println(this.signatureString(method));
        }
    }

    public String signatureString(Method method) {
        String string = method.getClass().getName();
        String string2 = method.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassDiffUtil.fromJvmClassname(method.getReturnType().getName()));
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        Class<?>[] classArray = method.getParameterTypes();
        stringBuffer.append("(");
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ClassDiffUtil.fromJvmClassname(classArray[i].getName()));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String signatureString(Field field) {
        String string = field.getClass().getName();
        String string2 = field.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassDiffUtil.fromJvmClassname(field.getType().getName()));
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return true;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof Method) {
            Method method = (Method)object;
            Method method2 = (Method)object2;
            return this.compare(method, method2);
        }
        if (object instanceof Field) {
            Field field = (Field)object;
            Field field2 = (Field)object2;
            return this.compare(field, field2);
        }
        return 0;
    }

    private int compare(Method method, Method method2) {
        int n;
        if (method == null && method2 != null) {
            n = -1;
        } else if (method != null && method2 == null) {
            n = 1;
        } else {
            String string;
            Class<?> clazz = method.getClass();
            Class<?> clazz2 = method2.getClass();
            String string2 = clazz.getName();
            String string3 = clazz2.getName();
            String string4 = string2 + "." + method.getName();
            n = string4.compareTo(string = string3 + "." + method2.getName());
            if (n == 0) {
                String string5;
                String string6;
                Class<?>[] classArray = method.getParameterTypes();
                Class<?>[] classArray2 = method2.getParameterTypes();
                int n2 = classArray.length;
                int n3 = classArray2.length;
                for (int i = 0; i < n2 && i < n3 && (n = (string6 = classArray[i].getName()).compareTo(string5 = classArray2[i].getName())) == 0; ++i) {
                }
                if (n == 0) {
                    n = n2 - n3;
                }
                if (n == 0) {
                    n = method.getReturnType().getName().compareTo(method2.getReturnType().getName());
                }
            }
        }
        return n;
    }

    private int compare(Field field, Field field2) {
        int n;
        if (field == null && field2 != null) {
            n = -1;
        } else if (field != null && field2 == null) {
            n = 1;
        } else {
            String string;
            Class<?> clazz = field.getClass();
            Class<?> clazz2 = field2.getClass();
            String string2 = clazz.getName();
            String string3 = clazz2.getName();
            String string4 = string2 + "." + field.getName();
            n = string4.compareTo(string = string3 + "." + field2.getName());
            if (n == 0) {
                n = field.getType().getName().compareTo(field2.getType().getName());
            }
            if (n == 0 && this.constant(field) && this.constant(field2)) {
                n = this.compareConstValues(field, field2);
            }
        }
        return n;
    }

    private int compareConstValues(Field field, Field field2) {
        Number number = null;
        Number number2 = null;
        try {
            number = (Number)field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            number2 = (Number)field2.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        long l = number.longValue() - number2.longValue();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    static String urlPath(String string) {
        if (!string.endsWith(".jar") && !string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    static URL createUrl(String string) {
        URL uRL = null;
        try {
            uRL = new URL(ClassDiffUtil.urlPath(string));
        }
        catch (Exception exception) {
            System.out.println("bad URL: " + string);
        }
        return uRL;
    }

    static URL[] makeUsefulUrls(String string, String string2, String[] stringArray) {
        String string3;
        File file;
        URL[] uRLArray = null;
        File file2 = new File(string);
        if (file2.exists() && (file = new File(string3 = string + "/" + string2)).exists()) {
            uRLArray = new URL[stringArray.length];
            for (int i = 0; i < uRLArray.length; ++i) {
                uRLArray[i] = ClassDiffUtil.createUrl("file:///" + string3 + "/" + stringArray[i]);
            }
        }
        return uRLArray;
    }

    static URL[] makeUsefulUrls(String string) {
        URL[] uRLArray = null;
        if (string.startsWith("file") || string.startsWith("http")) {
            URL[] uRLArray2;
            uRLArray = uRLArray2 = new URL[]{ClassDiffUtil.createUrl(string)};
        }
        if (uRLArray == null) {
            uRLArray = ClassDiffUtil.makeUsefulUrls(string, classdebugTestDir, classdebugSuffixes);
        }
        if (uRLArray == null) {
            uRLArray = ClassDiffUtil.makeUsefulUrls(string, runCTCTestDir, runCTCSuffixes);
        }
        return uRLArray;
    }

    static URL[] makeUrls(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            URL[] uRLArray = ClassDiffUtil.makeUsefulUrls(string);
            try {
                for (int i = 0; i < uRLArray.length; ++i) {
                    arrayList.add(uRLArray[i]);
                }
            }
            catch (Exception exception) {
                System.out.println("bad URL: " + string2);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    private void print(String string) {
        System.out.print(string);
        if (this.echoWriter != null) {
            this.echoWriter.print(string);
            this.echoWriter.flush();
        }
    }

    private void println(String string) {
        System.out.println(string);
        if (this.echoWriter != null) {
            this.echoWriter.println(string);
            this.echoWriter.flush();
        }
    }

    public String[] getSomeClassNames(URLClassLoader uRLClassLoader, String string, String string2) {
        String[] stringArray = ClassDiffUtil.getClassNames(uRLClassLoader.getURLs());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string) || !stringArray[i].endsWith(string2)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(stringArrayTemplate);
    }

    public String[] getClassNames(URLClassLoader uRLClassLoader) {
        return ClassDiffUtil.getClassNames(uRLClassLoader.getURLs());
    }

    public static String[] getClassNames(URL[] uRLArray) {
        int n = uRLArray.length;
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            URL uRL = uRLArray[i];
            try {
                if (ClassDiffUtil.isJarLike(uRL)) {
                    ClassDiffUtil.addZipClasses(hashSet, uRL);
                    continue;
                }
                ClassDiffUtil.addDirectoryClasses(hashSet, uRL);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hashSet.toArray(new String[0]);
    }

    protected static boolean isJarLike(URL uRL) {
        String string = uRL.toString();
        return string.endsWith(".jar") || string.endsWith(".zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addZipClasses(Collection collection, URL uRL) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(uRL.openStream());
            while (zipInputStream.available() != 0) {
                String string;
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null || !(string = zipEntry.getName()).endsWith(".class")) continue;
                ClassDiffUtil.addRawEntry(collection, string);
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    protected static void addDirectoryClasses(Collection collection, URL uRL) {
        ClassDiffUtil.addDirectoryClasses(collection, new File(uRL.getFile()));
    }

    protected static void addDirectoryClasses(Collection collection, File file) {
        ClassDiffUtil.addDirectoryClasses(collection, file, file.toString());
    }

    protected static void addDirectoryClasses(Collection collection, File file, String string) {
        File[] fileArray = file.listFiles();
        String string2 = file.toString();
        int n = string.length() + 1;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                ClassDiffUtil.addDirectoryClasses(collection, file2, string);
                continue;
            }
            String string3 = file2.toString();
            if (!string3.endsWith(".class")) continue;
            string3 = string3.substring(n);
            ClassDiffUtil.addRawEntry(collection, string3);
        }
    }

    protected static void addRawEntry(Collection collection, String string) {
        string = string.replace('/', '.');
        string = string.replace('\\', '.');
        int n = string.lastIndexOf(".class");
        string = string.substring(0, n);
        collection.add(string);
    }

    private static String fromJvmClassname(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = 0;
        while (string.startsWith("[")) {
            string = string.substring(1);
            ++n;
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        boolean bl = (string2 = (String)unprimitiveClasses.get(string)) != null;
        int n2 = n;
        if (bl) {
            string = string2;
        }
        if (n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("[]");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static void usage() {
        System.out.println("usage: ClassDiffUtil [-q] [-f filename] left-classpath right-classpath files...");
        System.out.println("where -q is quiet mode and -f echoes output to filename");
        System.out.println("The run this application requires only that ClassDiffUtil be in the system");
        System.out.println("class path. The run line is generally of the form:\n");
        System.out.println("<left class path> <right class path> classes...\n");
        System.out.println("Class path can be a directory of .JAR file. Multiple paths are separated");
        System.out.println(");by a ;. For example:\n");
        System.out.println("\"file:///D:/projects/myclasses/myelementclasses;file:///D:/projects/myclasses/myelementidlclasses;file:///D:/projects/myclasses/myinterfaceclasses;file:///D:/projects/myclasses;file:///D:/projects/myclasses/vbjorb.jar\" \"file:///U:/pacwan/CTC/ELE15454.jar;file:///U:/pacwan/CTC/IF.jar;file:///U:/pacwan/CTC/LAUNCHER.jar;file:///U:/pacwan/CTC/vbjorb.jar\" d:\files1.txt");
        System.out.println("d:\files1.txt is classname file list");
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            ClassDiffUtil.usage();
            return;
        }
        int n = 0;
        try {
            boolean bl = false;
            File file = null;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.equals("-q")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (string.equals("-f")) {
                    String string2 = stringArray[++i];
                    file = new File(string2);
                    n += 2;
                    continue;
                }
                if (string.equals("-l")) {
                    bl2 = true;
                    ++n;
                    continue;
                }
                if (!string.equals("-r")) continue;
                bl3 = true;
                ++n;
            }
            if (n > 0) {
                String[] stringArray2 = new String[stringArray.length - n];
                System.arraycopy(stringArray, n, stringArray2, 0, stringArray.length - n);
                stringArray = stringArray2;
            }
            URL[] uRLArray = ClassDiffUtil.makeUrls(stringArray[0]);
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            URL[] uRLArray2 = ClassDiffUtil.makeUrls(stringArray[1]);
            URLClassLoader uRLClassLoader2 = new URLClassLoader(uRLArray2);
            ClassDiffUtil classDiffUtil = new ClassDiffUtil(uRLClassLoader, uRLClassLoader2, bl, file, bl2, bl3);
            if (stringArray.length <= 2) {
                classDiffUtil.diff("model", uRLClassLoader);
            } else {
                for (int i = 2; i < stringArray.length; ++i) {
                    classDiffUtil.diff(stringArray[i], null);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    static {
        classdebugTestDir = "myclasses";
        classdebugSuffixes = new String[]{"myelementclasses", "myelementidlclasses", "myinterfaceclasses", "", "vbjorb.jar"};
        runCTCTestDir = "pacwan";
        runCTCSuffixes = new String[]{"CTC/ELE15454.jar", "CTC/IF.jar", "CTC/LAUNCHER.jar", "CTC/vbjorb.jar"};
        primitiveClasses = new HashMap();
        primitiveClasses.put("byte", "B");
        primitiveClasses.put("char", "C");
        primitiveClasses.put("double", "D");
        primitiveClasses.put("float", "F");
        primitiveClasses.put("int", "I");
        primitiveClasses.put("long", "J");
        primitiveClasses.put("short", "S");
        primitiveClasses.put("boolean", "Z");
        unprimitiveClasses = new HashMap();
        Set set = primitiveClasses.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)primitiveClasses.get(string);
            unprimitiveClasses.put(string2, string);
        }
        nonloadableClasses = new HashMap();
        nonloadableClasses.put("B", Byte.TYPE);
        nonloadableClasses.put("C", Character.TYPE);
        nonloadableClasses.put("D", Double.TYPE);
        nonloadableClasses.put("F", Float.TYPE);
        nonloadableClasses.put("I", Integer.TYPE);
        nonloadableClasses.put("J", Long.TYPE);
        nonloadableClasses.put("S", Short.TYPE);
        nonloadableClasses.put("Z", Boolean.TYPE);
        nonloadableClasses.put("void", Void.TYPE);
    }
}

