/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.ui.JreInfoPane;
import cerent.launcher.Bootstrap;
import cerent.launcher.CachedJar;
import cerent.launcher.CachedJarFactory;
import cerent.launcher.ClassLoaderFactory;
import cerent.launcher.CtcLauncherApplet;
import cerent.util.IThirdPartyJar;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import cerent.version.AbstractInterfaceVersion;
import cerent.version.JreProxyInterfaceVersion;
import cerent.version.LauncherInterfaceVersion;
import cerent.version.Ngrp;
import com.cisco.ctc.core.ClientFutureProofer;
import com.cisco.ctc.core.DownloadAreas;
import com.cisco.ctc.core.IJreReqs;
import com.cisco.ctc.core.IJreVersion;
import com.cisco.ctc.core.JreVersion;
import com.cisco.ctc.core.launcher.JreChooser;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class CtcRuntime {
    private static final String PROP_RELAUNCH = "ctc.relaunch";
    private static final String CTC = "ctc";
    private static final String CONSOLE_AVAILABLE = "ctc.console.available";
    private static final String USE_TERMINAL = "use.terminal";
    private static final String BASE_URL_PARM = "ctc.launcher.baseurl";
    private static final String FUTURELAUNCHER_PATH = "ctc-jar-futurelauncher";
    private static final String FUTURELAUNCHER_VER = "ctc-jar-futurelauncher-version";
    private static final String CTC_HEAP_VAR = "CTC_HEAP";
    private static final int CTC_MIN_HEAP = 32;
    private static final String MAX_PERM_SIZE_HEAP_VAR = "CTC_MAX_PERM_SIZE_HEAP";
    private static final String sep = File.separator;
    private static final String lineSep = System.getProperty("line.separator");
    private static final String os = System.getProperty("os.name");
    private static final String userHome = System.getProperty("user.home");
    private static final String WINDOWS_JRE = "C:" + sep + "Program Files" + sep + "JavaSoft" + sep + "JRE";
    private static final String UNIX_JRE = sep + "usr" + sep + "bin";
    public static final String PREF_PATH = "ctc.launcher";
    private static final String PREF_IGNORE_PATH = "ctc.ignore.dialogs";
    private static final String PREF_DESC = "description";
    private static final String PREF_VALUE = "value";
    private static final String WARN_JRE = "warnJre";
    private static final String WARN_JRE_DESC = "Warn JRE version used is not the recommended version";
    private static final String CTC_UPPER = "CTC";
    private static final String CURRENT_JRE_VER = System.getProperty("java.version");
    public static String JRE_PREF_KEY;
    private static final String JRE_KEY = ".jre";
    private static final String MORE_JVM_ARGS = "MORE_JVM_ARGS";
    private static final String SEL_JRE = "Please select a JRE to use for launching CTC.";
    private static final String CLASS_BASED_DEBUG = "debug.classbased";
    private static Preferences preferences;
    private String winBatFile;
    private String nodeName;
    private String urlStr;
    private String baseURL;
    private HashMap cachedEnv = null;
    private static Object validationResult;
    private static JreProxyInterfaceVersion recommended;
    private static cerent.version.JreVersion CURRENT_JRE_VERSION;
    private static String userJreVer;
    private CtcLauncherApplet applet = null;
    private boolean relaunch = Boolean.getBoolean("ctc.relaunch");
    public static final boolean isWindowsXp;
    protected static final KDebug db;

    public static String getJREPreferencesKey() {
        if (JRE_PREF_KEY == null) {
            JRE_PREF_KEY = CTC_UPPER + CtcRuntime.getVersionNumber() + JRE_KEY;
        }
        return JRE_PREF_KEY;
    }

    public static boolean isCiscoHost() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (string.endsWith(".cisco.com")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWindows() {
        return !sep.equals("/");
    }

    public static boolean isWin9x() {
        if (!CtcRuntime.isWindows()) {
            return false;
        }
        return !os.endsWith("NT") && !os.endsWith("2000") && !os.endsWith("XP");
    }

    public CtcRuntime(String string) {
        this(string, null);
    }

    public CtcRuntime(String string, CtcLauncherApplet ctcLauncherApplet) {
        this.baseURL = this.getProp(BASE_URL_PARM);
        this.nodeName = string;
        this.applet = ctcLauncherApplet;
        this.urlStr = this.baseURL != null ? this.baseURL : "http://" + string;
        CURRENT_JRE_VERSION = new cerent.version.JreVersion(CURRENT_JRE_VER);
    }

    private boolean isConsoleEnabled() {
        return preferences.getBoolean(CTC, USE_TERMINAL, false) && !CtcRuntime.isWin9x();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFutureLauncherPath() {
        String string = preferences.getProperty(PREF_PATH, FUTURELAUNCHER_PATH, "");
        File file = new File(string);
        if (file.exists()) {
            return string;
        }
        Preferences preferences = CtcRuntime.preferences;
        synchronized (preferences) {
            CtcRuntime.preferences.removeProperty(PREF_PATH, FUTURELAUNCHER_PATH);
            CtcRuntime.preferences.removeProperty(PREF_PATH, FUTURELAUNCHER_VER);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process exec() throws SecurityException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.baseURL != null) {
            arrayList.add(this.baseURL);
        }
        arrayList.add(this.nodeName);
        Process process = null;
        System.gc();
        Object object = preferences;
        synchronized (object) {
            preferences.checkForFileChange();
        }
        object = this.getFutureLauncherPath();
        if (object != null) {
            String string = preferences.getProperty(PREF_PATH, FUTURELAUNCHER_VER, "");
            ArrayList arrayList2 = this.getFutureLauncherCommonArgs((String)object, string);
            if (db.on()) {
                db.println("exec calling Runtime.exec with args... ");
                for (int i = 0; i < arrayList2.size(); ++i) {
                    db.print(arrayList2.get(i).toString() + " ");
                }
            }
            process = Runtime.getRuntime().exec(arrayList2.toArray(new String[0]));
            return process;
        }
        ArrayList arrayList3 = this.getCommonArgs(arrayList);
        if (arrayList3 != null) {
            ArrayList arrayList4 = CtcRuntime.isWindows() ? this.getWindowsArgs(arrayList3) : this.getUnixArgs(arrayList3);
            if (db.on()) {
                db.print("exec(): args = ");
                Iterator iterator = arrayList4.iterator();
                while (iterator.hasNext()) {
                    db.print((String)iterator.next() + " ");
                }
                db.println("");
            }
            process = Runtime.getRuntime().exec(arrayList4.toArray(new String[0]));
        } else if (db.on()) {
            db.println("exec(): args = null");
        }
        return process;
    }

    public void deleteBatchFiles() {
        if (CtcRuntime.isWindows()) {
            this.deleteFiles(new BatchFilter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCache() {
        block5: {
            this.deleteFiles(new JarFilter());
            try {
                DownloadAreas.instance().refreshConfiguredDownloadAreas();
                DownloadAreas.instance().cleanupAllDownloadAreas();
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                KDebug.printStackTrace(exception);
            }
        }
        Preferences preferences = Preferences.instance();
        Preferences preferences2 = Preferences.instance(Preferences.getDefaultCtcPrefsFileName());
        Class clazz = Preferences.class;
        synchronized (clazz) {
            preferences.checkForFileChange();
            CachedJar.clearCachedJar(preferences);
            preferences2.checkForFileChange();
            CachedJar.clearCachedJar(preferences2);
            Preferences.storeAllPreferences();
        }
    }

    private void deleteFiles(FilenameFilter filenameFilter) {
        int n = 0;
        boolean bl = true;
        String string = null;
        String string2 = System.getProperty("java.io.tmpdir");
        File file = new File(string2);
        File[] fileArray = file.listFiles(filenameFilter);
        for (n = 0; fileArray != null && n < fileArray.length; ++n) {
            try {
                fileArray[n].delete();
                continue;
            }
            catch (Exception exception) {
                bl = false;
                string = exception.getMessage();
            }
        }
        if (!bl) {
            String string3 = KErrorMsg.getString(KEMC.EID_PROBLEM_DELETING_CTC_CACHE_PARAM_2, string2, string);
            this.errorDialog(string3);
        }
    }

    private ArrayList getUnixArgs(ArrayList arrayList) {
        if (this.isConsoleEnabled()) {
            arrayList.add(0, "xterm");
            arrayList.add(1, "-iconic");
            arrayList.add(2, "-sb");
            arrayList.add(3, "-sl");
            arrayList.add(4, "4096");
            arrayList.add(5, "-e");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getWindowsArgs(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        OutputStreamWriter outputStreamWriter = null;
        try {
            String string = System.getProperty("java.io.tmpdir");
            File file = new File(string, CTC + (this.relaunch ? "-relaunch" : "") + ".bat");
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write("@echo off" + lineSep);
            outputStreamWriter.write("start ");
            if (CtcRuntime.isWin9x()) {
                outputStreamWriter.write("/m ");
                arrayList2.add("command.com");
                arrayList2.add("/C");
            } else {
                if (this.isConsoleEnabled()) {
                    outputStreamWriter.write("/min cmd /c \"");
                } else {
                    outputStreamWriter.write("/B \"\"");
                }
                arrayList2.add("cmd");
                arrayList2.add("/c");
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                outputStreamWriter.write(" ");
                outputStreamWriter.write((String)iterator.next());
            }
            if (this.isConsoleEnabled()) {
                outputStreamWriter.write("\"");
            }
            outputStreamWriter.write(lineSep);
            outputStreamWriter.close();
            arrayList2.add("\"" + file.getCanonicalPath() + "\"");
            this.winBatFile = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.errorDialog(KErrorMsg.getString(KEMC.EID_CANT_WRITE_TO_FILE_PARAM_1, "CTC batch"));
            ArrayList arrayList3 = null;
            return arrayList3;
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFutureLauncherJVMName(ClientFutureProofer clientFutureProofer, String string) throws IOException {
        JreVersion jreVersion;
        Object object;
        Object object2;
        Object object3;
        IJreReqs iJreReqs = clientFutureProofer.getJreReqs();
        String string2 = preferences.getProperty(PREF_PATH, CtcRuntime.getJREPreferencesKey(), "");
        if (!string2.equals("")) {
            int n = string2.lastIndexOf("bin" + sep + "java");
            object3 = string2.substring(0, n);
            try {
                object2 = JreChooser.getRtJarVer(new File((String)object3));
                if (object2 != null && iJreReqs.meetsReqs((IJreVersion)object2)) {
                    return string2;
                }
            }
            catch (Exception exception) {
                object = preferences;
                synchronized (object) {
                    preferences.removeProperty(PREF_PATH, CtcRuntime.getJREPreferencesKey());
                }
            }
        }
        if (!iJreReqs.meetsReqs(jreVersion = new JreVersion(CURRENT_JRE_VER))) {
            object3 = JOptionPane.getFrameForComponent(this.applet);
            object2 = new JreChooser((Frame)object3, iJreReqs, string);
            ((Dialog)object2).setVisible(true);
            object = ((JreChooser)object2).getJavaVersion();
            String string3 = "";
            if (object != null) {
                try {
                    string3 = ((JreChooser)object2).getJavaDirectory().getCanonicalPath();
                }
                catch (IOException iOException) {
                    KDebug.printStackTrace(iOException);
                    string3 = ((JreChooser)object2).getJavaDirectory().getAbsolutePath();
                }
                String string4 = CtcRuntime.adjustUserJre(string3);
                Preferences preferences = CtcRuntime.preferences;
                synchronized (preferences) {
                    CtcRuntime.preferences.setProperty(PREF_PATH, CtcRuntime.getJREPreferencesKey(), string4);
                    CtcRuntime.preferences.store();
                }
                return string4;
            }
            throw new IOException("No JRE selected to run CTC.");
        }
        return this.getJVMName();
    }

    private ArrayList getFutureLauncherCommonArgs(String string, String string2) throws IOException {
        ArrayList arrayList = new ArrayList();
        try {
            ClientFutureProofer clientFutureProofer = new ClientFutureProofer(string);
            String string3 = this.getFutureLauncherJVMName(clientFutureProofer, string2);
            arrayList.add(string3);
            arrayList = clientFutureProofer.ctcExecArgs(arrayList, string, System.getProperties());
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Exception in getNewestLauncherCommonArgs");
                KDebug.printStackTrace(exception);
            }
            throw new IOException("Failed to launch the CTC using the updated version.");
        }
        if (arrayList != null) {
            arrayList.add(this.nodeName);
        }
        return arrayList;
    }

    private ArrayList getCommonArgs(ArrayList arrayList) throws IOException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(this.getJVMName());
        arrayList2.add(this.getHeapValue());
        arrayList2.add(this.getMaxPermSize());
        String string = this.getMoreJvmArgs();
        if (string != null) {
            arrayList2.add(string);
        }
        if (this.relaunch) {
            arrayList2.add("-Dctc.relaunch=true");
        }
        if (this.isConsoleEnabled()) {
            arrayList2.add("-Dctc.console.available=true");
        }
        arrayList2.add("-jar");
        StringBuffer stringBuffer = new StringBuffer();
        if (CtcRuntime.isWindows()) {
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getLauncherName());
        if (CtcRuntime.isWindows()) {
            stringBuffer.append("\"");
        }
        arrayList2.add(stringBuffer.toString());
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    protected boolean isJreVersionValid(String string) {
        return JreProxyInterfaceVersion.meetsMinimumJreRequirements(new cerent.version.JreVersion(string));
    }

    protected boolean isJreVersionSupported(String string) {
        return JreProxyInterfaceVersion.isSupportedJre(new cerent.version.JreVersion(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJVMName() throws IOException {
        Object object;
        String string;
        Object object2 = System.getProperty("java.home") + sep + "bin" + sep + "java";
        preferences.checkForFileChange();
        boolean bl = false;
        if (JreProxyInterfaceVersion.isSupportedJre(CURRENT_JRE_VERSION)) {
            bl = true;
        }
        if (!(string = preferences.getProperty(PREF_PATH, CtcRuntime.getJREPreferencesKey(), "")).equals("") && CtcRuntime.isValidUserJre(string)) {
            object2 = string;
            object = CtcRuntime.getRtJarVer(string);
            bl = JreProxyInterfaceVersion.isSupportedJre((cerent.version.JreVersion)object);
            if (this.applet != null) {
                this.applet.setActualJre(userJreVer, (String)object2);
            }
        }
        validationResult = new JreInfoPane();
        ((JreInfoPane)validationResult).setBottomLabel("CTC can be configured to run with any supported JRE version.  The setting is independent\nof the browser Java plug-in version.  You can select a different JRE version that is \nalready installed on your workstation or use the current JRE version.\n\nPlease select a JRE to use for launching CTC.");
        object = "";
        while (!bl) {
            Preferences preferences;
            Object[] objectArray = new Object[]{"Select a different JRE", "Select current JRE", "Quit"};
            int n = JOptionPane.showOptionDialog(null, validationResult, "Select JRE", 1, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                object = this.promptForJreSelection();
                if (!CtcRuntime.isValidUserJre((String)object)) continue;
                bl = true;
                object2 = object;
                preferences = CtcRuntime.preferences;
                synchronized (preferences) {
                    CtcRuntime.preferences.setProperty(PREF_PATH, CtcRuntime.getJREPreferencesKey(), (String)object2);
                    CtcRuntime.preferences.store();
                }
                if (!JreProxyInterfaceVersion.isRecommendedJre(userJreVer)) {
                    this.showJreWarning();
                }
                if (this.applet == null) continue;
                this.applet.setActualJre(userJreVer, (String)object2);
                continue;
            }
            if (n == 1) {
                if (!CtcRuntime.isValidUserJre((String)object2)) continue;
                bl = true;
                preferences = CtcRuntime.preferences;
                synchronized (preferences) {
                    CtcRuntime.preferences.setProperty(PREF_PATH, CtcRuntime.getJREPreferencesKey(), (String)object2);
                    CtcRuntime.preferences.store();
                }
                this.showJreWarning();
                continue;
            }
            db.warning("User opted to quit the JRE selection process");
            throw new IOException("No Java Runtime Enviornment selected.");
        }
        if (CtcRuntime.isWindows()) {
            object2 = CtcRuntime.isCiscoHost() || this.isConsoleEnabled() ? "\"" + (String)object2 + "\"" : "\"" + (String)object2 + "w\"";
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showJreWarning() throws IOException {
        boolean bl = preferences.getBoolean("ctc.ignore.dialogs.value", WARN_JRE, true);
        if (bl) {
            JCheckBox jCheckBox = new JCheckBox("Do not show this message again", false);
            JOptionPane.showMessageDialog(null, new Object[]{KErrorMsg.getString(KEMC.WID_JRE_VERSION_NOT_RECOMMENDED), jCheckBox}, "JRE Version Not Recommended", 2);
            if (jCheckBox.isSelected()) {
                Preferences preferences = CtcRuntime.preferences;
                synchronized (preferences) {
                    CtcRuntime.preferences.setBoolean("ctc.ignore.dialogs.value", WARN_JRE, false);
                    CtcRuntime.preferences.setProperty("ctc.ignore.dialogs.description", WARN_JRE, WARN_JRE_DESC);
                    CtcRuntime.preferences.store();
                }
            }
        }
    }

    public static File getJavaBin(String string) throws IOException {
        File file = CtcRuntime.isWindows() ? new File(string + "w.exe") : new File(string);
        return file;
    }

    public static File getRtJar(String string) throws IOException {
        String string2;
        File file = null;
        int n = string.lastIndexOf("bin" + sep + "java");
        if (n > -1 && !(file = new File(string2 = string.substring(0, n) + "jre" + sep + "lib" + sep + "rt.jar")).exists()) {
            string2 = string.substring(0, n) + "lib" + sep + "rt.jar";
            file = new File(string2);
        }
        return file;
    }

    public static cerent.version.JreVersion getRtJarVer(String string) {
        cerent.version.JreVersion jreVersion = new cerent.version.JreVersion(null);
        try {
            File file = CtcRuntime.getRtJar(string);
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            jreVersion = new cerent.version.JreVersion(attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
        }
        catch (IOException iOException) {
            db.warning("Unable to find rt.jar for " + string);
        }
        catch (NullPointerException nullPointerException) {
            db.warning("Invalid jre path specified for use: " + string);
        }
        return jreVersion;
    }

    public static cerent.version.JreVersion getRtJarVer(File file) throws IOException {
        cerent.version.JreVersion jreVersion = null;
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        jreVersion = new cerent.version.JreVersion(attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
        return jreVersion;
    }

    public static boolean isValidUserJre(String string) throws IOException {
        Comparable comparable;
        File file = CtcRuntime.getJavaBin(string);
        if (!file.exists()) {
            validationResult = "The directory you selected does not contain java" + (CtcRuntime.isWindows() ? "w.exe.\n\n" : ".\n\n") + SEL_JRE;
            return false;
        }
        File file2 = CtcRuntime.getRtJar(string);
        if (null != file2 && !file2.exists()) {
            validationResult = "The directory you selected does not contain rt.jar.\n\nPlease select a JRE to use for launching CTC.";
            return false;
        }
        String string2 = "";
        try {
            comparable = CtcRuntime.getRtJarVer(file2);
            string2 = ((cerent.version.JreVersion)comparable).getVersion();
        }
        catch (Exception exception) {
            validationResult = "The JRE version could not be validated.\n\nPlease select a JRE to use for launching CTC.";
            return false;
        }
        if (CtcRuntime.canLaunchWithJre(string2)) {
            userJreVer = string2;
            return true;
        }
        comparable = new StringBuffer("The selected JRE version ");
        ((StringBuffer)comparable).append(string2);
        ((StringBuffer)comparable).append(" is not supported.  The minimum JRE supported is ");
        ((StringBuffer)comparable).append(cerent.version.JreVersion.MINIMUM_VERSION.getVersion());
        ((StringBuffer)comparable).append(".\n\n");
        ((StringBuffer)comparable).append(SEL_JRE);
        validationResult = ((StringBuffer)comparable).toString();
        return false;
    }

    private static boolean canLaunchWithJre(String string) {
        boolean bl = false;
        JreProxyInterfaceVersion jreProxyInterfaceVersion = null;
        cerent.version.JreVersion jreVersion = new cerent.version.JreVersion(string);
        try {
            recommended = (JreProxyInterfaceVersion)AbstractInterfaceVersion.instance("cerent.version.JreProxyInterfaceVersion", CtcRuntime.class.getClassLoader());
            jreProxyInterfaceVersion = (JreProxyInterfaceVersion)AbstractInterfaceVersion.instance("cerent.version.JreProxyInterfaceVersion", CtcRuntime.class.getClassLoader());
            jreProxyInterfaceVersion.setVersion(jreVersion);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            bl = false;
        }
        if (recommended != null && recommended.isCompatibleWith(jreProxyInterfaceVersion)) {
            if (JreProxyInterfaceVersion.meetsMinimumJreRequirements(jreVersion)) {
                bl = true;
            }
        }
        return bl;
    }

    private String promptForJreSelection() throws IOException {
        int n;
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        File file = new File(CtcRuntime.isWindows() ? WINDOWS_JRE : UNIX_JRE);
        if (file.exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if ((n = jFileChooser.showOpenDialog(null)) != 0) {
            throw new IOException("No JRE selected to run CTC.");
        }
        string = CtcRuntime.adjustUserJre(jFileChooser.getSelectedFile().toString());
        return string;
    }

    public static String adjustUserJre(String string) {
        String string2 = "";
        if (!string.equals("")) {
            string2 = string.endsWith("bin" + sep + "java") ? string : (string.endsWith("bin") ? string + sep + "java" : string + sep + "bin" + sep + "java");
        }
        return string2;
    }

    private String getHeapValue() {
        String string = this.getFromEnvironment(CTC_HEAP_VAR);
        String string2 = "-Xmx256m";
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n >= 32) {
                    string2 = "-Xmx" + n + "m";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string2;
    }

    private String getLauncherName() {
        CachedJar cachedJar;
        CachedJarFactory cachedJarFactory = new CachedJarFactory(this.urlStr, "LAUNCHER", this.nodeName);
        try {
            cachedJar = cachedJarFactory.create();
            ClassLoaderFactory.download(cachedJar);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorDialog(KErrorMsg.getString(KEMC.EID_MALFORMED_URL_PARAM_1, "LAUNCHER.jar"));
            return null;
        }
        catch (IOException iOException) {
            this.errorDialog(KErrorMsg.getString(KEMC.EID_CANT_DOWNLOAD_PARAM_1, "LAUNCHER.jar"));
            return null;
        }
        return cachedJar.getCachedName();
    }

    private String getFromEnvironment(String string) {
        if (this.cachedEnv == null) {
            this.cachedEnv = this.importEnvironment();
        }
        return (String)this.cachedEnv.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap importEnvironment() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = CtcRuntime.isWindows() ? "cmd /c set" : "sh -c env";
        BufferedReader bufferedReader = null;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(string);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                hashMap.put(string3, string4);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hashMap;
    }

    private String getProp(String string) {
        int n;
        String string2 = System.getProperty(string);
        if (string2 == null && (n = string.indexOf(46)) != -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            string2 = preferences.getProperty(string3, string4, null);
        }
        return string2;
    }

    private void errorDialog(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    private static String getVersionNumber() {
        Ngrp ngrp = new LauncherInterfaceVersion().getBuildInformation().getNgrp();
        return ngrp.getMajorReleaseNumber() + ngrp.getMaintenanceReleaseNumber();
    }

    private String getMaxPermSize() {
        String string = this.getFromEnvironment(MAX_PERM_SIZE_HEAP_VAR);
        String string2 = "-XX:MaxPermSize=64m";
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                string2 = "-XX:MaxPermSize=" + n + "m";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string2;
    }

    private String getMoreJvmArgs() {
        String string = preferences.getProperty(PREF_PATH, MORE_JVM_ARGS, null);
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        CtcRuntime ctcRuntime = new CtcRuntime("vikings4");
        ctcRuntime.deleteCache();
    }

    static {
        preferences = Preferences.instance();
        recommended = null;
        isWindowsXp = os.equals("Windows XP");
        db = new KDebug("CtcRuntime");
    }

    private class BatchFilter
    implements FilenameFilter {
        private BatchFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".bat") && string.startsWith("ctc-");
        }
    }

    private class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        private boolean isJarFile(String string) {
            return string.endsWith(".jar");
        }

        private boolean isCoreJar(String string) {
            return string.startsWith("ctc-") || string.startsWith("LAUNCHER");
        }

        private boolean isThirdPartyJar(String string) {
            IThirdPartyJar[] iThirdPartyJarArray = Bootstrap.getThirdPartyJarTypes();
            boolean bl = false;
            for (int i = 0; !bl && i < iThirdPartyJarArray.length; ++i) {
                if (!string.startsWith(iThirdPartyJarArray[i].getFileName())) continue;
                bl = true;
            }
            return bl;
        }

        public boolean accept(File file, String string) {
            return this.isJarFile(string) && (this.isCoreJar(string) || this.isThirdPartyJar(string));
        }
    }
}

