/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IDebugDiag;
import cerent.util.KDebug;

public class DebugSys
extends KDebug
implements IDebugDiag {
    public static final String Hmem = "Show memory usage and run GC";
    public static final String HlsThreads = "List all threads";
    public static final String HdumpThread = "Dump the stack of the specified thread";

    public DebugSys() {
        super("Sys");
    }

    public final void mem() {
        long l;
        long l2;
        Runtime runtime = Runtime.getRuntime();
        long l3 = runtime.totalMemory();
        long l4 = l2 = runtime.freeMemory();
        int n = 0;
        do {
            l = l2;
            runtime.gc();
            l2 = runtime.freeMemory();
            ++n;
        } while (l2 > l);
        this.println("Used= " + (l3 - l2) + ". Free= " + l2 + ". Total= " + l3);
    }

    public final void lsThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        this.printThreads(threadGroup);
    }

    public final void dumpThread(int n) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        this.dumpThreadStack(threadGroup, n);
    }

    private final void printThreads(ThreadGroup threadGroup) {
        String string = System.getProperty("line.separator");
        if (threadGroup != null && threadGroup.activeCount() > 0) {
            Thread[] threadArray = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadArray);
            this.println("Num  Thread                                   Priority    " + string + "----------------------------------------------------------");
            for (int i = 0; i < threadArray.length; ++i) {
                if (threadArray[i] == null) continue;
                String string2 = threadArray[i].getName() != null ? threadArray[i].getName() : "Unknown";
                String string3 = i < 10 ? " " : "";
                this.print("[" + string3 + i + "] " + string2);
                for (int j = 0; j < 44 - string2.length(); ++j) {
                    this.print(" ");
                }
                this.println("" + threadArray[i].getPriority());
            }
            ThreadGroup[] threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount()];
            for (int i = 0; i < threadGroupArray.length; ++i) {
                this.printThreads(threadGroupArray[i]);
            }
        }
    }

    private final void dumpThreadStack(ThreadGroup threadGroup, int n) {
        if (threadGroup != null && threadGroup.activeCount() > 0) {
            Thread[] threadArray = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadArray);
            if (n >= 0 && n < threadArray.length) {
                this.println("Dumping Stack for " + threadArray[n].getName());
                Thread cfr_ignored_0 = threadArray[n];
                Thread.dumpStack();
            } else {
                this.println("There is no thread number " + n + ", use lsThreads.");
            }
        }
    }

    public final void dumpDiag() {
        this.display("JVM Version:" + System.getProperty("java.version"));
        this.display("JVM Vendor:" + System.getProperty("java.vendor"));
        this.display("OS:" + System.getProperty("os.name") + System.getProperty("os.version"));
        this.display("User:" + System.getProperty("user.name"));
        this.mem();
        this.lsThreads();
    }
}

