/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import cerent.util.SortableProperties;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class Preferences {
    private static final String PROP_INI_FILE = "ctc.ini.file";
    private static final String OLD_PROP_INI_FILE = "cms.ini.file";
    private static final char arrayDelim = '\n';
    private static final String CmsPreferencesPrefix = "CTC";
    private static final String defaultPcFileName = "CTC.ini";
    private static final String defaultUnixFileName = ".ctcrc";
    private static final String defaultPcLauncherFileName = "CTCLauncher.ini";
    private static final String defaultUnixLauncherFileName = ".ctclaunchrc";
    private static final String defaultFilePath = System.getProperty("user.home");
    private static final String preferencesFileHeader = "CTC Preferences File";
    private static final String version = "2.3";
    private static final String title = "Cisco Transport Controller (CTC)";
    private static final String fileKey = "PreferencesFileName";
    private static final String versionKey = "version";
    private static final String includeKey = "include";
    private static final String titleKey = "title";
    private static final char pathDelim = '.';
    private static final String separator = System.getProperty("file.separator");
    private static String defaultInstanceFileName;
    private static boolean defaultIsLauncher;
    private static HashMap prefsInstances;
    private static final KDebug sdb;
    private KDebug db;
    private String fileName;
    private long fileLastModified;
    private Properties prefs;
    private SortableProperties originalPrefs;
    private boolean isOriginalPrefFile;
    private HashSet includeFileSet;
    private Vector listeners;
    protected Properties defaults;

    private Preferences() {
        this.fileName = null;
        this.fileLastModified = 0L;
        this.prefs = null;
        this.originalPrefs = null;
        this.isOriginalPrefFile = false;
        this.includeFileSet = null;
    }

    private Preferences(String string) {
        block3: {
            this.fileName = null;
            this.fileLastModified = 0L;
            this.prefs = null;
            this.originalPrefs = null;
            this.isOriginalPrefFile = false;
            this.includeFileSet = null;
            this.db = new KDebug("Preferences-" + string);
            if (prefsInstances.containsKey(string)) {
                throw new RuntimeException("Fatal Error: Multiple Preferences instances for " + string + " present!");
            }
            this.prefs = new Properties(this.initDefaults(string));
            try {
                this.fileName = string;
                this.init();
                prefsInstances.put(string, this);
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                this.db.println("Preferences.init() failed with " + exception.getMessage());
                KDebug.printStackTrace(exception);
            }
        }
    }

    public static synchronized Preferences instance() {
        if (defaultInstanceFileName == null) {
            String string = null;
            string = System.getProperty(PROP_INI_FILE);
            if (string == null) {
                string = System.getProperty(OLD_PROP_INI_FILE);
            }
            defaultInstanceFileName = string != null ? string : Preferences.getDefaultCtcPrefsFileName();
        }
        return Preferences.instance(defaultInstanceFileName);
    }

    public static synchronized Preferences instance(String string) {
        if (!prefsInstances.containsKey(string)) {
            return new Preferences(string);
        }
        return (Preferences)prefsInstances.get(string);
    }

    public static synchronized Preferences setDefault(String string) {
        return Preferences.setDefault(string, false);
    }

    public static synchronized Preferences setDefault(String string, boolean bl) {
        Preferences preferences = Preferences.instance(string);
        defaultInstanceFileName = string;
        if (!defaultIsLauncher) {
            defaultIsLauncher = bl;
        }
        return preferences;
    }

    public static boolean defaultIsLauncher() {
        return defaultIsLauncher;
    }

    public void init() throws IOException, FileNotFoundException {
        if (this.db.on()) {
            this.db.println("init");
        }
        File file = new File(this.fileName);
        this.fileLastModified = file.lastModified();
        if (this.db.on()) {
            this.db.println(this.fileName + " was last modified " + this.fileLastModified);
        }
        this.prefs = new Properties(this.defaults);
        this.originalPrefs = new SortableProperties(this.defaults);
        this.isOriginalPrefFile = true;
        this.includeFileSet = new HashSet();
        this.init(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void init(String var1_1) throws IOException, FileNotFoundException {
        var2_2 = null;
        var3_3 = new Properties();
        try {
            if (this.isOriginalPrefFile) {
                try {
                    var2_2 = new BufferedInputStream(new FileInputStream(var1_1));
                    if (!this.db.on()) ** GOTO lbl14
                    this.db.println("Loaded new prefs: " + var1_1);
                }
                catch (FileNotFoundException var4_4) {
                    this.db.println("Could not load prefs:" + var1_1);
                    throw var4_4;
                }
            } else {
                var2_2 = new BufferedInputStream(new FileInputStream(var1_1));
            }
lbl14:
            // 3 sources

            try {
                var3_3.load(var2_2);
                if (this.isOriginalPrefFile) {
                    if (this.db.on()) {
                        this.db.println("loading preferences from " + var1_1);
                    }
                    this.originalPrefs.putAll((Map<?, ?>)var3_3);
                    this.isOriginalPrefFile = false;
                }
                this.includeFileSet.add(var1_1);
                if (var3_3.containsKey("CTC.include") && !this.includeFileSet.contains(var4_5 = var3_3.getProperty("CTC.include"))) {
                    this.init(var4_5);
                }
                this.prefs.putAll((Map<?, ?>)var3_3);
            }
            catch (IOException var4_6) {
                throw new IOException("Unable to read CTC Preferences from file: " + var1_1 + "\n" + var4_6.toString());
            }
        }
        catch (FileNotFoundException var4_8) {
            if (this.db.on()) {
                this.db.println(var4_8.toString());
            }
            this.store();
        }
        finally {
            if (var2_2 != null) {
                try {
                    var2_2.close();
                }
                catch (IOException var4_9) {
                    KDebug.printStackTrace(var4_9);
                }
            }
        }
    }

    public void checkForFileChange() {
        block6: {
            if (new File(this.fileName).lastModified() != this.fileLastModified) {
                if (this.db.on()) {
                    this.db.println("***** checkForFileChange -> " + this.fileName + " has changed. *****");
                }
                try {
                    this.init();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.db.on()) {
                        this.db.println(fileNotFoundException.toString());
                    }
                }
                catch (IOException iOException) {
                    if (!this.db.on()) break block6;
                    this.db.println(iOException.toString());
                }
            }
        }
    }

    private Properties initDefaults(String string) {
        Properties properties = new Properties();
        properties.setProperty("CTC.PreferencesFileName", string);
        properties.setProperty("CTC.title", title);
        properties.setProperty("CTC.version", version);
        return properties;
    }

    public static String getFullName(String string, String string2) {
        return string + '.' + string2;
    }

    public static String getKeyFromFullName(String string, String string2) {
        if (string.startsWith(string2 = string2 + '.')) {
            return string.substring(string2.length());
        }
        return "";
    }

    public Vector getListeners() {
        return this.listeners;
    }

    private String getProperty(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = this.prefs.getProperty(string);
        }
        return string2;
    }

    public boolean propertyExist(String string, String string2) {
        return this.getProperty(Preferences.getFullName(string, string2)) != null;
    }

    private String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (this.db.on()) {
            this.db.println("getting property " + string + " <- " + (string3 != null ? string3 : string2));
        }
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public String getProperty(String string, String string2, String string3) {
        return this.getProperty(Preferences.getFullName(string, string2), string3);
    }

    public boolean getBoolean(String string, String string2, boolean bl) {
        String string3 = this.getProperty(string, string2, null);
        if (string3 != null) {
            return new Boolean(string3);
        }
        return bl;
    }

    public int getInt(String string, String string2, int n) {
        String string3 = this.getProperty(string, string2, null);
        if (string3 != null) {
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    public String[] getPropertyArray(String string, String string2, String[] stringArray) {
        String string3 = this.getProperty(Preferences.getFullName(string, string2));
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.db.on()) {
            this.db.println("getPropertyArray for " + Preferences.getFullName(string, string2) + " <- " + (string3 != null ? string3 : stringArray[0]));
        }
        if (string3 == null) {
            return stringArray;
        }
        int n = string3.length();
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            if ((n4 = (n3 = string3.indexOf(10, n2)) != -1 ? n3 - n2 : n - n2) > 0) {
                arrayList.add(string3.substring(n2, n2 + n4));
            }
            if (n3 == -1) break;
            n2 = n3 + 1;
        }
        return arrayList.toArray(new String[0]);
    }

    private void setProperty(String string, String string2) {
        if (this.db.on()) {
            this.db.println("setting property " + string + " -> " + string2);
        }
        this.prefs.setProperty(string, string2);
        this.originalPrefs.setProperty(string, string2);
    }

    public void setProperty(String string, String string2, String string3) {
        this.setProperty(Preferences.getFullName(string, string2), string3);
    }

    public void setBoolean(String string, String string2, boolean bl) {
        this.setProperty(string, string2, new Boolean(bl).toString());
    }

    public void setInt(String string, String string2, int n) {
        this.setProperty(string, string2, Integer.toString(n));
    }

    public void setPropertyArray(String string, String string2, String[] stringArray) {
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = i == 0 ? stringArray[i] : string3 + '\n' + stringArray[i];
        }
        this.setProperty(string, string2, string3);
    }

    public List getMatchingPropertyKeys(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = Preferences.getFullName(string, string2);
        Iterator<Object> iterator = this.prefs.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (!string4.startsWith(string3)) continue;
            linkedList.add(string4);
        }
        return linkedList;
    }

    public void removeAllProperties(String string, String string2) {
        List list = this.getMatchingPropertyKeys(string, string2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.removeProperty((String)iterator.next());
        }
    }

    private void removeProperty(String string) {
        if (this.db.on()) {
            this.db.println("removing property " + string);
        }
        this.prefs.remove(string);
        this.originalPrefs.remove(string);
    }

    public void removeProperty(String string, String string2) {
        this.removeProperty(Preferences.getFullName(string, string2));
    }

    public Enumeration propertyNames() {
        return this.prefs.propertyNames();
    }

    public void list(PrintStream printStream) {
        this.prefs.list(printStream);
    }

    public void list(PrintWriter printWriter) {
        this.prefs.list(printWriter);
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        if (this.db.on()) {
            this.db.println("store called ->" + this.fileName);
        }
        this.originalPrefs.setSortedKeys(true);
        this.originalPrefs.store(outputStream, string);
        this.originalPrefs.setSortedKeys(false);
    }

    public void store(String string, String string2) throws FileNotFoundException, InterruptedIOException, IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.store(fileOutputStream, string2);
            fileOutputStream.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Unable to find directory for CTC Preferences to file: " + string + "\n" + fileNotFoundException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            throw new IOException("Unable to write to CTC Preferences file: " + string + "\n" + iOException.toString());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public void store() throws FileNotFoundException, InterruptedIOException, IOException {
        this.store(this.fileName, preferencesFileHeader);
    }

    public static synchronized void storeAllPreferences() {
        Iterator iterator = prefsInstances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Preferences preferences = (Preferences)prefsInstances.get(string);
            try {
                preferences.store();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!sdb.on()) continue;
                sdb.println("Caught FileNotFoundException storing " + string);
                KDebug.printStackTrace(fileNotFoundException);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!sdb.on()) continue;
                sdb.println("Caught InterruptedIOException storing " + string);
                KDebug.printStackTrace(interruptedIOException);
            }
            catch (IOException iOException) {
                if (!sdb.on()) continue;
                sdb.println("Caught IOException storing " + string);
                KDebug.printStackTrace(iOException);
            }
        }
    }

    public void finalize() throws Throwable {
        if (this.db.on()) {
            this.db.println("finalize called");
        }
        this.store();
        this.listeners.clear();
        super.finalize();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String string) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        object = new PropertyChangeEvent(this, string, null, null);
        for (int i = 0; i < vector.size(); ++i) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(i);
            propertyChangeListener.propertyChange((PropertyChangeEvent)object);
        }
    }

    public static String getDefaultLauncherPrefsFileName() {
        String string = separator.equals("/") ? defaultFilePath + separator + defaultUnixLauncherFileName : defaultFilePath + separator + defaultPcLauncherFileName;
        return string;
    }

    public static String getDefaultCtcPrefsFileName() {
        String string = separator.equals("/") ? defaultFilePath + separator + defaultUnixFileName : defaultFilePath + separator + defaultPcFileName;
        return string;
    }

    public String toString() {
        return "Preferences-" + this.fileName;
    }

    static {
        prefsInstances = new HashMap();
        sdb = new KDebug("Preferences");
    }
}

