/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.CtcSslFactory;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdRequestReply;
import com.cisco.sot.SotSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class CtcProxy {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static WeakHashMap sockets = new WeakHashMap();
    private String _bindHost;
    private String _targetHost;
    private int _targetPort;
    private int _addr;
    private boolean _expired;
    private SckfwdIo _sckfwdIo;
    private Sckfwd _proxy;
    private String _proxyHost;
    private int _proxyPort;
    private long _created;
    private boolean _secure;
    private static SotSocketFactory _socketFactory = new SotSocketFactory();

    CtcProxy(String string, int n) throws IOException {
        block6: {
            this._bindHost = null;
            this._targetHost = string;
            this._targetPort = n;
            this._addr = CtcProxyFactory.makeAddr(string);
            this._expired = false;
            this._sckfwdIo = null;
            this._secure = false;
            try {
                CtcProxyFactory.getServer(string);
            }
            catch (IOException iOException) {
                if (!CtcProxyFactory.debug()) break block6;
                CtcProxyFactory.println(string + ": no SOCKS server");
            }
        }
        String string2 = CtcProxyFactory.proxyFor(this._addr);
        if (string2 == null) {
            this._proxy = null;
            this._proxyHost = string;
            this._proxyPort = n;
        } else {
            SckfwdRequestReply sckfwdRequestReply;
            this._proxy = CtcProxyFactory.getServer(string2);
            if (this._proxy.proxiesReusable()) {
                sckfwdRequestReply = this._proxy.connect(string, n);
            } else {
                this._sckfwdIo = this._proxy.createIo();
                this._sckfwdIo.writeConnect(string, n);
                sckfwdRequestReply = new SckfwdRequestReply(this._sckfwdIo);
                this._expired = true;
            }
            this._proxyHost = sckfwdRequestReply.getHost();
            this._proxyPort = sckfwdRequestReply.getPort();
        }
        this._created = System.currentTimeMillis();
    }

    CtcProxy(String string, String string2, int n, SckfwdIo sckfwdIo, Sckfwd sckfwd, String string3, int n2) {
        this._bindHost = string;
        this._targetHost = string2;
        this._targetPort = n;
        this._addr = CtcProxyFactory.makeAddr(this._bindHost);
        this._expired = sckfwdIo != null;
        this._sckfwdIo = sckfwdIo;
        this._proxy = sckfwd;
        this._proxyHost = string3;
        this._proxyPort = n2;
        this._created = System.currentTimeMillis();
        this._secure = false;
    }

    CtcProxy(String string, String string2, int n, CtcProxy ctcProxy) {
        this(string, string2, n, null, ctcProxy._proxy, ctcProxy._proxyHost, ctcProxy._proxyPort);
    }

    public boolean secured() {
        return this._secure;
    }

    public void setSecure(boolean bl) {
        this._secure = bl;
    }

    public boolean expired() {
        if (!this._expired) {
            long l;
            this._expired = this._proxy == null ? (l = System.currentTimeMillis() - this._created) > CtcProxyFactory.timeout() : !CtcProxyFactory.willProxyFor(this._proxy, this._addr);
        }
        return this._expired;
    }

    public void expire() {
        this._expired = true;
    }

    public String getKey() {
        if (this._bindHost == null) {
            return CtcProxyFactory.key(this._targetHost, this._targetPort);
        }
        return this._bindHost + "->" + CtcProxyFactory.key(this._targetHost, this._targetPort);
    }

    public String getHost() {
        return this._proxyHost;
    }

    public int getPort() {
        return this._proxyPort;
    }

    Sckfwd getProxy() {
        return this._proxy;
    }

    SckfwdIo getIo() {
        return this._sckfwdIo;
    }

    public boolean isProxying() {
        return !this._proxyHost.equals(this._targetHost) || this._proxyPort != this._targetPort;
    }

    private Socket openSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket;
        if (inetAddress != null) {
            socket = new Socket();
            socket.bind(new InetSocketAddress(inetAddress, n));
            socket.connect(new InetSocketAddress(this._proxyHost, this._proxyPort), CtcProxyFactory.readTimeout());
        } else {
            socket = _socketFactory.createSocket(this._proxyHost, this._proxyPort, CtcProxyFactory.readTimeout());
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getSockets() {
        HashMap hashMap = null;
        WeakHashMap weakHashMap = sockets;
        synchronized (weakHashMap) {
            hashMap = new HashMap(sockets);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSocketHistory() {
        WeakHashMap weakHashMap = sockets;
        synchronized (weakHashMap) {
            sockets.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this._sckfwdIo != null ? this._sckfwdIo.getSocket() : this.openSocket(inetAddress, n);
        if (this._secure) {
            socket = CtcSslFactory.getSSLSocketFactory().createSocket(socket, this._targetHost, this._targetPort, true);
        }
        if (CtcProxyFactory.isSocketHistoryEnabled()) {
            Date date = new Date();
            String string = sdf.format(date);
            String string2 = this.getBindHost() == null ? "ctc->ne" : "ne->ctc";
            WeakHashMap weakHashMap = sockets;
            synchronized (weakHashMap) {
                sockets.put(socket, new Exception("for " + string2 + " proxy: " + this.toString(false) + " created " + date));
            }
        }
        return socket;
    }

    public Socket getSocket() throws IOException, UnknownHostException {
        return this.getSocket(null, -1);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._bindHost == null) {
            if (this.isProxying()) {
                stringBuffer.append(CtcProxyFactory.key(this._proxyHost, this._proxyPort));
            } else {
                stringBuffer.append("no-proxy");
            }
        } else if (this.isProxying()) {
            stringBuffer.append(this._bindHost);
            stringBuffer.append("->");
            stringBuffer.append(CtcProxyFactory.key(this._proxyHost, this._proxyPort));
        } else {
            stringBuffer.append("no-proxy(");
            stringBuffer.append(this._bindHost);
            stringBuffer.append(")");
        }
        stringBuffer.append("->");
        stringBuffer.append(CtcProxyFactory.key(this._targetHost, this._targetPort));
        if (bl) {
            if (this._proxy == null) {
                stringBuffer.append(" (");
                stringBuffer.append(System.currentTimeMillis() - this._created);
                stringBuffer.append("ms)");
            } else {
                stringBuffer.append(" (");
                stringBuffer.append(this._proxy.toString());
                stringBuffer.append(")");
            }
            if (this._expired) {
                stringBuffer.append(" (expired)");
            }
        }
        return stringBuffer.toString();
    }

    String getBindHost() {
        return this._bindHost;
    }

    String proxyString() {
        return CtcProxyFactory.key(this._proxyHost, this._proxyPort);
    }
}

