/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.CtcRuntime;
import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.proxy.CtcProxy;
import cerent.util.proxy.CtcServerProxy;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdBid;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CtcProxyFactory {
    private static final String PROXY_PREF = "ctc.proxy";
    private static final String PROXY_DESGNE = "designatedgnes";
    private static final String SOCKET_HISTORY = "sockethistory";
    static final String CTC_NE_DIR = "ctc->ne";
    static final String NE_CTC_DIR = "ne->ctc";
    private static final long _timeout = Preferences.instance().getInt("ctc.proxy", "timeout", 60000);
    private static final int _connectTimeout = Preferences.instance().getInt("ctc.proxy", "connect", 5000);
    private static final int _readTimeout = Preferences.instance().getInt("ctc.proxy", "read", 60000);
    private static final int _acceptTimeout = Preferences.instance().getInt("ctc.proxy", "accept", 120000);
    private static final String _bindAddress = Preferences.instance().getProperty("ctc.proxy", "bindAddress", null);
    private static final int _defaultCost = Preferences.instance().getInt("ctc.proxy", "defaultCost", 500);
    public static final int SCKFWD_PORT = 1080;
    private static final Debug _debug = new Debug("CtcProxyFactory");
    private static final int _numWorkerThreads = Preferences.instance().getInt("ctc.proxy", "workerThreads", CtcRuntime.isWindows() ? 5 : 16);
    private static Workers _workers = new Workers("CtcProxy worker", _numWorkerThreads);
    private static HashMap _sckfwdServers = new HashMap();
    private static HashMap _failedServers = new HashMap();
    private static OnePerKey _serverGetters = new OnePerKey();
    private static HashMap _proxies = new HashMap();
    private static HashMap _serverProxies = new HashMap();
    private static OnePerKey _proxyGetters = new OnePerKey();
    private static HashSet _designatedGnes = new HashSet();
    private static InetAddress permGne = null;

    public static boolean debug() {
        return _debug.on();
    }

    public static void println(String string) {
        _debug.println(string);
    }

    static long timeout() {
        return _timeout;
    }

    public static int connectTimeout() {
        return _connectTimeout;
    }

    public static int readTimeout() {
        return _readTimeout;
    }

    static int acceptTimeout() {
        return _acceptTimeout;
    }

    static String bindAddress(String string) {
        return _bindAddress != null ? _bindAddress : string;
    }

    static int defaultCost() {
        return _defaultCost;
    }

    private CtcProxyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDesignatedGnes(String[] stringArray, boolean bl) throws IOException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    hashSet.add(inetAddress);
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    Debug.printStackTrace(unknownHostException);
                }
            }
        }
        HashSet hashSet2 = _designatedGnes;
        synchronized (hashSet2) {
            _designatedGnes.clear();
            _designatedGnes.addAll(hashSet);
            if (bl) {
                if (stringArray == null || stringArray.length == 0) {
                    Preferences.instance().removeProperty(PROXY_PREF, PROXY_DESGNE);
                } else {
                    Preferences.instance().setPropertyArray(PROXY_PREF, PROXY_DESGNE, stringArray);
                }
                Preferences.instance().store();
            }
        }
    }

    public static Collection getDesignatedGnes() {
        HashSet hashSet = new HashSet(_designatedGnes);
        return hashSet;
    }

    public static String[] getDesignatedGnesFromPrefs() {
        String[] stringArray = Preferences.instance().getPropertyArray(PROXY_PREF, PROXY_DESGNE, new String[0]);
        return stringArray;
    }

    public static void setPermGne(String string) throws UnknownHostException {
        permGne = InetAddress.getByName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDesignatedGne(InetAddress inetAddress) {
        HashSet hashSet = _designatedGnes;
        synchronized (hashSet) {
            boolean bl;
            boolean bl2 = bl = _designatedGnes.isEmpty() || _designatedGnes.contains(inetAddress) || inetAddress.equals(permGne);
            if (_debug.isFinestEnabled()) {
                _debug.println("   isDesignatedGne " + inetAddress + "=" + bl);
            }
            return bl;
        }
    }

    public static boolean isDesignatedGne(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return CtcProxyFactory.isDesignatedGne(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }

    public static Sckfwd getServer(String string) throws IOException {
        String string2 = InetAddress.getByName(string).getHostAddress();
        SckfwdGetter sckfwdGetter = new SckfwdGetter(string2, 1080);
        _serverGetters.run(string2, sckfwdGetter);
        return sckfwdGetter.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expire(CtcProxy ctcProxy) {
        HashMap hashMap = _proxies;
        synchronized (hashMap) {
            Sckfwd sckfwd;
            ctcProxy.expire();
            _proxies.remove(ctcProxy.getKey());
            if (ctcProxy.isProxying() && (sckfwd = ctcProxy.getProxy()) != null) {
                sckfwd.decrementUsage();
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("expire-proxy-deleting: " + ctcProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expire(CtcServerProxy ctcServerProxy) {
        HashMap hashMap = _serverProxies;
        synchronized (hashMap) {
            ctcServerProxy.expire();
            _serverProxies.remove(ctcServerProxy.getKey());
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("expire-server-deleting: " + ctcServerProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expire(Sckfwd sckfwd) {
        HashMap hashMap = _proxies;
        synchronized (hashMap) {
            Iterator iterator = _proxies.values().iterator();
            while (iterator.hasNext()) {
                CtcProxy ctcProxy = (CtcProxy)iterator.next();
                if (ctcProxy.getProxy() != sckfwd) continue;
                ctcProxy.expire();
                iterator.remove();
                if (ctcProxy.isProxying()) {
                    sckfwd.decrementUsage();
                }
                if (!CtcProxyFactory.debug()) continue;
                CtcProxyFactory.println("expire-sckfwd-deleting: " + ctcProxy);
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("expiring proxy server: " + sckfwd);
            }
        }
        hashMap = _sckfwdServers;
        synchronized (hashMap) {
            if (sckfwd.getFailures() > 15) {
                _sckfwdServers.remove(CtcProxyFactory.key(sckfwd.getHost(), sckfwd.getPort()));
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("removing proxy server: " + sckfwd);
                }
            }
        }
    }

    private static String proxyFor(HashSet hashSet, int n) {
        SckfwdBid sckfwdBid = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            SckfwdBid sckfwdBid2 = ((Sckfwd)iterator.next()).willProxyFor(n);
            if (sckfwdBid == null) {
                sckfwdBid = sckfwdBid2;
                continue;
            }
            if (sckfwdBid2 == null || sckfwdBid2.compareTo(sckfwdBid) >= 0) continue;
            sckfwdBid = sckfwdBid2;
        }
        if (sckfwdBid != null) {
            return sckfwdBid.getHost();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String proxyFor(int n) {
        HashSet hashSet;
        Object object = _sckfwdServers;
        synchronized (object) {
            hashSet = new HashSet(_sckfwdServers.values());
        }
        object = CtcProxyFactory.proxyFor(hashSet, n);
        if (object == null) {
            Validator validator;
            ArrayList<Validator> arrayList = new ArrayList<Validator>();
            Iterator<Object> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                validator = new Validator((Sckfwd)iterator.next());
                _workers.submit(validator);
                arrayList.add(validator);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                validator = (Validator)iterator.next();
                validator.join();
            }
            object = CtcProxyFactory.proxyFor(hashSet, n);
        }
        return object;
    }

    static void discover(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            _workers.submit(new Discoverer((String)iterator.next()));
        }
    }

    static boolean willProxyFor(Sckfwd sckfwd, int n) {
        try {
            sckfwd.validate();
            return sckfwd.willProxyFor(n) != null;
        }
        catch (IOException iOException) {
            CtcProxyFactory.expire(sckfwd);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addProxy(String string, CtcProxy ctcProxy) {
        HashMap hashMap = _proxies;
        synchronized (hashMap) {
            Sckfwd sckfwd;
            _proxies.put(string, ctcProxy);
            if (ctcProxy.isProxying() && (sckfwd = ctcProxy.getProxy()) != null) {
                sckfwd.incrementUsage();
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("creating: " + ctcProxy);
            }
        }
    }

    static void addProxy(CtcProxy ctcProxy) {
        CtcProxyFactory.addProxy(ctcProxy.getKey(), ctcProxy);
    }

    public static CtcProxy connect(String string, int n) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println(" ctcProxy connect(" + string + ", " + n + "): enter");
        }
        CtcProxy ctcProxy = null;
        try {
            String string2 = InetAddress.getByName(string).getHostAddress();
            ProxyGetter proxyGetter = new ProxyGetter(string2, n);
            _proxyGetters.run(string2, proxyGetter);
            CtcProxy ctcProxy2 = ctcProxy = proxyGetter.getProxy();
            return ctcProxy2;
        }
        catch (Throwable throwable) {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("Throwable Exception in connect " + throwable.getMessage());
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable.getMessage());
        }
        finally {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("connect(" + string + ", " + n + "): exit with, " + ctcProxy);
            }
        }
    }

    public static CtcProxy sslConnect(String string, int n) throws IOException {
        CtcProxy ctcProxy = CtcProxyFactory.connect(string, n);
        ctcProxy.setSecure(true);
        return ctcProxy;
    }

    public static CtcServerProxy bind(String string, int n) throws IOException {
        return CtcProxyFactory.bind(string, n, false);
    }

    public static CtcServerProxy bind(String string, int n, boolean bl) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("bind(" + string + ", " + n + ", " + bl + "): enter");
        }
        try {
            String string2 = InetAddress.getByName(string).getHostAddress();
            ServerProxyGetter serverProxyGetter = new ServerProxyGetter(string2, n, bl);
            _proxyGetters.run(string2, serverProxyGetter);
            CtcServerProxy ctcServerProxy = serverProxyGetter.getProxy();
            return ctcServerProxy;
        }
        catch (Throwable throwable) {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("Throwable Exception in connect " + throwable.getMessage());
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable.getMessage());
        }
        finally {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("bind(" + string + ", " + n + ", " + bl + "): exit");
            }
        }
    }

    public static CtcProxy accept(String string, int n, String string2) throws IOException {
        return CtcProxyFactory.accept(string, n, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CtcProxy accept(String string, int n, String string2, boolean bl) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("accept(" + string + ", " + n + ", " + string2 + ", " + bl + "): enter");
        }
        try {
            CtcProxy ctcProxy = CtcProxyFactory.bind(string, n, bl).accept(string2);
            return ctcProxy;
        }
        finally {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("accept(" + string + ", " + n + ", " + string2 + ", " + bl + "): exit");
            }
        }
    }

    public static Collection getClients(String string) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("getClients(" + string + "): enter");
        }
        try {
            Sckfwd sckfwd = CtcProxyFactory.getServer(string);
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("getClients(" + string + "): server=" + sckfwd);
            }
            try {
                Collection collection = sckfwd.getClients();
                return collection;
            }
            catch (IOException iOException) {
                CtcProxyFactory.expire(sckfwd);
                throw iOException;
            }
        }
        finally {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("getClients(" + string + "): exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClients(String string, Collection collection) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("setClients(" + string + "): enter");
        }
        try {
            String string2 = InetAddress.getByName(string).getHostAddress();
            SckfwdClientGetter sckfwdClientGetter = new SckfwdClientGetter(string2, 1080, collection);
            _serverGetters.run(string2, sckfwdClientGetter);
        }
        finally {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("setClients(" + string + "): exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(String string, String string2, String string3, String string4, int n) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("reset(" + string + ", " + string2 + ", " + string4 + ", " + n + "): enter");
        }
        try {
            String string5 = InetAddress.getByName(string).getHostAddress();
            SckfwdReset sckfwdReset = new SckfwdReset(string5, 1080, string2, string3, string4, n);
            _serverGetters.run(string5, sckfwdReset);
        }
        finally {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("reset(" + string + ", " + string2 + ", " + string4 + ", " + n + "): exit");
            }
        }
    }

    static String key(String string, int n) {
        return string + ":" + n;
    }

    static int makeAddr(String string) {
        int n = 0;
        try {
            byte[] byArray = InetAddress.getByName(string).getAddress();
            n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        }
        catch (UnknownHostException unknownHostException) {
            CtcProxyFactory.println("cannot convert " + string);
        }
        return n;
    }

    static int makeMask(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 |= 1 << 31 - i;
        }
        return n2;
    }

    static boolean isSocketHistoryEnabled() {
        return _debug.isSocketHistoryEnabled();
    }

    static {
        String[] stringArray = CtcProxyFactory.getDesignatedGnesFromPrefs();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                _designatedGnes.add(inetAddress);
                if (!_debug.on()) continue;
                CtcProxyFactory.println("Adding designated GNE " + inetAddress);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                CtcProxyFactory.println("Designated GNE is invalid: " + string);
            }
        }
    }

    private static class Discoverer
    extends NamedRunnable {
        private String _host;

        Discoverer(String string) {
            this._host = string;
        }

        public void run() {
            try {
                CtcProxyFactory.getServer(this._host);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getName() {
            return "CtcProxy discoverer for " + this._host + ":" + 1080;
        }
    }

    private static class Validator
    extends NamedRunnable {
        private Sckfwd _server;

        Validator(Sckfwd sckfwd) {
            this._server = sckfwd;
        }

        public void run() {
            try {
                this._server.validate();
            }
            catch (IOException iOException) {
                CtcProxyFactory.expire(this._server);
            }
        }

        public String getName() {
            return "CtcProxy validator for " + this._server.getHost() + ":" + this._server.getPort();
        }
    }

    private static class ServerProxyGetter
    extends Getter {
        private CtcServerProxy _proxy = null;
        private boolean _secure;

        public ServerProxyGetter(String string, int n, boolean bl) {
            super(string, n);
            this._secure = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            String string = Integer.toString(this.getPort()) + "/" + Boolean.toString(this._secure);
            HashMap hashMap = _serverProxies;
            synchronized (hashMap) {
                this._proxy = (CtcServerProxy)_serverProxies.get(string);
                if (this._proxy != null && this._proxy.expired()) {
                    CtcProxyFactory.expire(this._proxy);
                    this._proxy = null;
                }
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("getServerProxy(" + string + "): " + this._proxy);
                }
            }
            if (this._proxy == null) {
                this._proxy = new CtcServerProxy(this.getHost(), this.getPort(), this._secure);
                hashMap = _serverProxies;
                synchronized (hashMap) {
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("creating: " + this._proxy);
                    }
                    if (this.getPort() == 0) {
                        string = Integer.toString(this._proxy.getPort()) + "/" + Boolean.toString(this._secure);
                    }
                    _serverProxies.put(string, this._proxy);
                }
            }
        }

        public CtcServerProxy getProxy() {
            return this._proxy;
        }
    }

    private static class ProxyGetter
    extends Getter {
        private CtcProxy _proxy = null;

        public ProxyGetter(String string, int n) {
            super(string, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            String string = CtcProxyFactory.key(this.getHost(), this.getPort());
            HashMap hashMap = _proxies;
            synchronized (hashMap) {
                this._proxy = (CtcProxy)_proxies.get(string);
                if (this._proxy != null && this._proxy.expired()) {
                    CtcProxyFactory.expire(this._proxy);
                    this._proxy = null;
                }
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("getProxy(" + string + "): " + this._proxy);
                }
            }
            if (this._proxy == null) {
                this._proxy = new CtcProxy(this.getHost(), this.getPort());
                CtcProxyFactory.addProxy(string, this._proxy);
            }
        }

        public CtcProxy getProxy() {
            return this._proxy;
        }
    }

    private static class SckfwdReset
    extends SckfwdGetter {
        private String _username;
        private String _password;
        private String _ene;
        private int _cost;

        public SckfwdReset(String string, int n, String string2, String string3, String string4, int n2) {
            super(string, n);
            this._username = string2;
            this._password = string3;
            this._ene = string4;
            this._cost = n2;
        }

        public void run() throws IOException {
            super.run();
            Sckfwd sckfwd = this.getServer();
            if (sckfwd != null) {
                try {
                    sckfwd.reset(this._username, this._password, this._ene, this._cost);
                }
                catch (IOException iOException) {
                    CtcProxyFactory.expire(sckfwd);
                    throw iOException;
                }
            }
        }
    }

    private static class SckfwdClientGetter
    extends SckfwdGetter {
        private Collection _clients;

        public SckfwdClientGetter(String string, int n, Collection collection) {
            super(string, n);
            this._clients = collection;
        }

        public void run() throws IOException {
            super.run();
            Sckfwd sckfwd = this.getServer();
            if (sckfwd != null) {
                try {
                    sckfwd.setClients(this._clients);
                }
                catch (IOException iOException) {
                    CtcProxyFactory.expire(sckfwd);
                    throw iOException;
                }
            }
        }
    }

    private static class SckfwdGetter
    extends Getter {
        private Sckfwd _server = null;

        public SckfwdGetter(String string, int n) {
            super(string, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            block20: {
                Long l;
                String string = CtcProxyFactory.key(this.getHost(), this.getPort());
                HashMap hashMap = _sckfwdServers;
                synchronized (hashMap) {
                    this._server = (Sckfwd)_sckfwdServers.get(string);
                    l = (Long)_failedServers.get(string);
                }
                if (this._server == null) {
                    if (l != null && System.currentTimeMillis() > l) {
                        hashMap = _sckfwdServers;
                        synchronized (hashMap) {
                            _failedServers.remove(string);
                        }
                        l = null;
                    }
                    if (l == null) {
                        if (!CtcProxyFactory.isDesignatedGne(this.getHost())) {
                            throw new IOException("Not a designated GNE: " + this.getHost());
                        }
                        try {
                            this._server = new Sckfwd(this.getHost(), this.getPort());
                            hashMap = _sckfwdServers;
                            synchronized (hashMap) {
                                if (CtcProxyFactory.debug()) {
                                    CtcProxyFactory.println("adding proxy server: " + this._server);
                                }
                                _sckfwdServers.put(string, this._server);
                                break block20;
                            }
                        }
                        catch (IOException iOException) {
                            l = new Long(System.currentTimeMillis() + CtcProxyFactory.timeout());
                            HashMap hashMap2 = _sckfwdServers;
                            synchronized (hashMap2) {
                                _failedServers.put(string, l);
                            }
                            throw iOException;
                        }
                    }
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("SOCKS server unavailable: " + string);
                    }
                    throw new IOException("SOCKS server unavailable");
                }
            }
        }

        public Sckfwd getServer() {
            return this._server;
        }
    }

    private static class OnePerKey {
        private final HashMap _locks = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String string, Getter getter) throws IOException {
            RefCount refCount;
            Object object = this._locks;
            synchronized (object) {
                refCount = (RefCount)this._locks.get(string);
                if (refCount == null) {
                    refCount = new RefCount(string);
                    this._locks.put(string, refCount);
                }
                refCount.reference();
            }
            try {
                object = refCount;
                synchronized (object) {
                    getter.run();
                }
            }
            finally {
                object = this._locks;
                synchronized (object) {
                    if (refCount.dereference() == 0) {
                        this._locks.remove(string);
                    }
                }
            }
        }
    }

    private static abstract class Getter {
        private String _host;
        private int _port;

        public Getter(String string, int n) {
            this._host = string;
            this._port = n;
        }

        public String getHost() {
            return this._host;
        }

        public int getPort() {
            return this._port;
        }

        public abstract void run() throws IOException;
    }

    private static class RefCount {
        private String _key;
        private int _count;

        public RefCount(String string) {
            this._key = string;
            this._count = 0;
        }

        public int count() {
            return this._count;
        }

        public void reference() {
            ++this._count;
        }

        public int dereference() {
            return --this._count;
        }

        public String toString() {
            return "#<" + this._key + ", " + this._count + ">";
        }
    }

    private static class Workers {
        private boolean _active = true;
        private LinkedList _jobs = new LinkedList();
        private LinkedList _workers = new LinkedList();

        public Workers(String string, int n) {
            for (int i = 0; i < n; ++i) {
                Thread thread = new Thread((Runnable)new Worker(), this.workerName(string, i));
                thread.setDaemon(true);
                this._workers.add(thread);
                thread.start();
            }
        }

        public void destroy() {
            this._active = false;
            Iterator iterator = this._workers.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
        }

        private String workerName(String string, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = Integer.toString(n);
            stringBuffer.append(string);
            for (int i = string2.length(); i < 3; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
            stringBuffer.append(": idle");
            return stringBuffer.toString();
        }

        public synchronized void submit(NamedRunnable namedRunnable) {
            this._jobs.add(namedRunnable);
            this.notify();
        }

        private synchronized NamedRunnable next() throws InterruptedException {
            while (true) {
                try {
                    return (NamedRunnable)this._jobs.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.wait();
                    continue;
                }
                break;
            }
        }

        private class Worker
        implements Runnable {
            private Worker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread thread = Thread.currentThread();
                    while (Workers.this._active) {
                        try {
                            NamedRunnable namedRunnable = Workers.this.next();
                            String string = thread.getName();
                            try {
                                thread.setName(namedRunnable.getName());
                                namedRunnable.run();
                            }
                            catch (Throwable throwable) {
                                _debug.println("Worker job exception: " + throwable);
                                _debug;
                                Debug.printStackTrace(throwable);
                            }
                            finally {
                                namedRunnable.done();
                                thread.setName(string);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            _debug.println("Worker interrupted: " + interruptedException);
                        }
                        catch (Throwable throwable) {
                            _debug.println("Worker loop exception: " + throwable);
                            _debug;
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    _debug.println("Worker run exception: " + throwable);
                    _debug;
                    Debug.printStackTrace(throwable);
                }
                finally {
                    _debug.println("Worker exiting: _active=" + Workers.this._active);
                }
            }
        }
    }

    private static abstract class NamedRunnable
    implements Runnable {
        private boolean _running = true;

        NamedRunnable() {
        }

        public abstract String getName();

        protected synchronized void done() {
            this._running = false;
            this.notify();
        }

        public synchronized void join() {
            while (this._running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class Debug
    extends KDebug
    implements IDebugDiag {
        private boolean socketHistory = Preferences.instance().getBoolean("ctc.proxy", "sockethistory", false);

        public Debug(String string) {
            super(string);
        }

        public final void sockets() {
            this.sockets(true);
        }

        public final void sockets(boolean bl) {
            this.sockets(bl, false);
        }

        public final void sockets(boolean bl, boolean bl2) {
            if (!this.socketHistory) {
                this.println("CtcProxy socket history collection disabled. Try ssetting CTC preference: ctc.proxy.sockethistory=true ");
                return;
            }
            this.println("CtcProxy socket history: ");
            Map map = CtcProxy.getSockets();
            Set set = map.keySet();
            int n = 0;
            int n2 = 0;
            int n3 = set.size();
            if (bl) {
                this.println("list of connected sockets");
            } else {
                this.println("list of sockets in any state");
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Socket socket = (Socket)iterator.next();
                Exception exception = (Exception)map.get(socket);
                boolean bl3 = socket.isClosed();
                if (!bl3) {
                    ++n;
                } else if (bl) continue;
                String string = bl3 ? "CLOSED" : (socket.isInputShutdown() ? "INPUT CLOSED" : (socket.isConnected() ? "CONNECTED" : "UNCONNECTED"));
                this.print("socket on port " + socket.getLocalPort() + " in " + string + " state;");
                String string2 = exception.getMessage();
                if (string2.indexOf(CtcProxyFactory.CTC_NE_DIR) >= 0) {
                    ++n2;
                }
                this.println(" " + string2 + " with type " + socket.getClass().getName());
                if (!bl2) continue;
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    this.println("  " + stackTraceElementArray[i]);
                }
            }
            this.println("# of ctc->ne sockets in any state: " + n2);
            this.println("# of ne->ctc sockets in any state: " + (n3 - n2));
            this.println("# of connected sockets in either direction: " + n);
            this.println("# of sockets in any state: " + n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void proxies() {
            Object object;
            String string;
            Map.Entry entry;
            Iterator iterator;
            this.println("CtcProxy list (CTC->NE connection): ");
            HashMap hashMap = _proxies;
            synchronized (hashMap) {
                iterator = _proxies.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    string = (String)entry.getKey();
                    object = (CtcProxy)entry.getValue();
                    this.println("  " + string + " " + object);
                }
            }
            this.println("CtcServerProxy list (NE->CTC connection): ");
            hashMap = _serverProxies;
            synchronized (hashMap) {
                iterator = _serverProxies.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    string = (String)entry.getKey();
                    object = (CtcServerProxy)entry.getValue();
                    this.println("  " + string + " " + object);
                }
            }
        }

        public final void enableSocketHistory() {
            this.socketHistory = true;
        }

        public final void disableSocketHistory() {
            this.socketHistory = false;
        }

        public final void socketHistoryEnabled() {
            this.println(Boolean.toString(this.socketHistory));
        }

        public boolean isSocketHistoryEnabled() {
            return this.socketHistory;
        }

        public final void clearSocketHistory() {
            CtcProxy.clearSocketHistory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void flush() {
            HashSet hashSet;
            Object object = _sckfwdServers;
            synchronized (object) {
                hashSet = new HashSet(_sckfwdServers.values());
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                CtcProxyFactory.expire((Sckfwd)object.next());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpDiag() {
            boolean bl = this.on();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Iterator iterator;
                HashSet hashSet;
                this.set(false);
                Object object = _sckfwdServers;
                synchronized (object) {
                    hashSet = new HashSet(_sckfwdServers.values());
                }
                object = hashSet.iterator();
                while (object.hasNext()) {
                    iterator = (Sckfwd)object.next();
                    stringBuffer.append(((Sckfwd)((Object)iterator)).toString());
                    stringBuffer.append(": ");
                    stringBuffer.append(((Sckfwd)((Object)iterator)).toClientString());
                    this.println(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                this.println("Failed servers:");
                iterator = _sckfwdServers;
                synchronized (iterator) {
                    long l = System.currentTimeMillis();
                    Iterator iterator2 = _failedServers.keySet().iterator();
                    while (iterator2.hasNext()) {
                        String string = (String)iterator2.next();
                        Long l2 = (Long)_failedServers.get(string);
                        long l3 = l2 - l;
                        if (l3 < 0L) {
                            this.println("   " + string + " expired (last accessed " + (CtcProxyFactory.timeout() - l3) / 1000L + " sec. ago)");
                            continue;
                        }
                        this.println("   " + string + " TTL=" + l3 + " ms");
                    }
                }
                this.println("Designated GNEs:");
                if (_designatedGnes != null) {
                    iterator = _designatedGnes.iterator();
                    while (iterator.hasNext()) {
                        InetAddress inetAddress = (InetAddress)iterator.next();
                        this.println("   " + inetAddress);
                    }
                }
                this.println("Permanent GNE:" + permGne);
            }
            finally {
                this.set(bl);
            }
        }
    }
}

