/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.CtcProxyFactory;

public class SckfwdClient
implements Comparable {
    private String _host;
    private int _maskLength;
    private int _cost;
    private int _flags;
    private int _addr;
    private int _maskBits;

    public SckfwdClient(String string, int n) {
        this(string, 32, n, 170);
    }

    public SckfwdClient(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, CtcProxyFactory.makeMask(n), CtcProxyFactory.makeAddr(string));
    }

    public SckfwdClient(SckfwdClient sckfwdClient) {
        this(sckfwdClient._host, sckfwdClient._maskLength, sckfwdClient._cost, sckfwdClient._flags, sckfwdClient._maskBits, sckfwdClient._addr);
    }

    private SckfwdClient(String string, int n, int n2, int n3, int n4, int n5) {
        this._host = string;
        this._maskLength = n;
        this._cost = n2;
        this._flags = n3;
        this._maskBits = n4;
        this._addr = n5 & n4;
    }

    public String getHost() {
        return this._host;
    }

    public String getMask() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._maskBits >>> 24 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(this._maskBits >>> 16 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(this._maskBits >>> 8 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(this._maskBits & 0xFF);
        return stringBuffer.toString();
    }

    public int getMaskLength() {
        return this._maskLength;
    }

    public int getCost() {
        return this._cost;
    }

    public int getFlags() {
        return this._flags;
    }

    boolean isPotentialServer() {
        int n = this._flags & 0x30;
        return this._maskLength == 32 && (n == 16 || n == 32) && CtcProxyFactory.isDesignatedGne(this._host);
    }

    public String toString() {
        return this._host + "/" + this._maskLength + "/0x" + Integer.toHexString(this._flags) + "/" + this._cost + "/" + Integer.toHexString(this._addr) + "/" + Integer.toHexString(this._maskBits);
    }

    public boolean matches(int n) {
        return this._addr == (n & this._maskBits);
    }

    public int compareTo(Object object) {
        SckfwdClient sckfwdClient = (SckfwdClient)object;
        int n = this._host.compareTo(sckfwdClient._host);
        if (n == 0) {
            n = this._maskLength < sckfwdClient._maskLength ? -1 : (this._maskLength > sckfwdClient._maskLength ? 1 : (this._cost < sckfwdClient._cost ? -1 : (this._cost > sckfwdClient._cost ? 1 : (this._flags < sckfwdClient._flags ? -1 : (this._flags > sckfwdClient._flags ? 1 : 0)))));
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this._host.hashCode() + this._maskLength + this._cost + this._flags;
    }
}

