/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdReply;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class SckfwdTopologyReply
extends SckfwdReply
implements Comparable {
    private String _server;
    private int _usage;
    private ArrayList _clients;

    SckfwdTopologyReply(SckfwdIo sckfwdIo) throws IOException {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        this.readVersion(sckfwdIo);
        int n5 = sckfwdIo.readByte();
        if (n5 != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.requestException(n5);
        }
        int n6 = sckfwdIo.readByte();
        if (n6 != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.protocolError("reserved byte (" + n6 + ") not zero");
        }
        int n7 = sckfwdIo.readByte();
        this._server = sckfwdIo.readAddress(n7);
        int n8 = sckfwdIo.readByte();
        if (n8 != 1 && n8 != 2) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.protocolError("topology version (" + n8 + ") not supported");
        }
        this._usage = sckfwdIo.readShort();
        this._clients = new ArrayList();
        int n9 = sckfwdIo.readShort();
        for (n4 = 0; n4 < n9; ++n4) {
            string = sckfwdIo.readAddress(n7);
            n3 = 32;
            n2 = sckfwdIo.readByte();
            n = sckfwdIo.readShort();
            this._clients.add(new SckfwdClient(string, n3, n, n2));
        }
        if (n8 == 2) {
            n9 = sckfwdIo.readShort();
            for (n4 = 0; n4 < n9; ++n4) {
                string = sckfwdIo.readAddress(n7);
                n3 = sckfwdIo.readShort();
                n2 = sckfwdIo.readByte();
                n = sckfwdIo.readShort();
                this._clients.add(new SckfwdClient(string, n3, n, n2));
            }
        }
        Collections.sort(this._clients);
    }

    String getServer() {
        return this._server;
    }

    int getUsage() {
        return this._usage;
    }

    ArrayList clients() {
        return (ArrayList)this._clients.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<topology");
        Iterator iterator = this._clients.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" ");
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        int n = 0;
        Iterator iterator = this._clients.iterator();
        Iterator iterator2 = ((SckfwdTopologyReply)object)._clients.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            n = ((SckfwdClient)iterator.next()).compareTo(iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            n = 1;
        } else if (iterator2.hasNext()) {
            n = -1;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this._clients.hashCode();
    }
}

