/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.util.KDebug;
import cerent.version.IBuildInformation;
import java.util.Locale;

public class InternalLayerVersion {
    public static final int UNAVAILABLE = -1;
    public static final int MMX = 330;
    public static final int HAWK = 400;
    public static final int EURO = 410;
    public static final int BLUESTEEL = 430;
    public static final int CHIEF = 450;
    public static final int PATRIOT = 460;
    public static final int MAVERICK = 500;
    public static final int MARINER = 700;
    public static final int LARKSPUR = 720;
    public static final String IF = "if";
    public static final String NET = "net";
    public static final String ELE = "ele";
    public static final String ORB = "orb";
    public static final String LAUNCHER = "launcher";
    public static final String COMPAT = "compat";
    public static final String NE = "ne";
    private String name;
    private int sequence;
    private static final KDebug db = new KDebug("InternalLayerVersion");

    public InternalLayerVersion(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Layer name cannot be null.");
        }
        this.name = string;
        this.sequence = n;
    }

    public InternalLayerVersion(String string, IBuildInformation iBuildInformation) {
        String string2 = iBuildInformation.getNgrp().getMajorReleaseNumber() + iBuildInformation.getNgrp().getMaintenanceReleaseNumber();
        String string3 = string2.substring(0, 2) + string2.substring(3);
        this.name = string;
        try {
            this.sequence = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            db.println("InternalLayerVersion(" + string + "," + iBuildInformation + ") failed to parse: ver=" + string2 + "/seq=" + string3);
            this.sequence = Integer.MIN_VALUE;
        }
    }

    public String getLayerName() {
        return this.name;
    }

    public int getLayerVersion() {
        return this.sequence;
    }

    public int hashCode() {
        int n = 7;
        n = 13 * n + this.name.hashCode();
        n = 13 * n + this.sequence;
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof InternalLayerVersion) {
            InternalLayerVersion internalLayerVersion = (InternalLayerVersion)object;
            return this.getLayerName().equals(internalLayerVersion.getLayerName()) && this.getLayerVersion() == internalLayerVersion.getLayerVersion();
        }
        return bl;
    }

    public boolean isCoreJarFile() {
        boolean bl = false;
        if (this.name.equals(ORB) || this.name.equals(LAUNCHER) || this.name.equals(IF) || this.name.equals(NET)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.getLayerName().toUpperCase(Locale.ENGLISH) + ".v." + this.getLayerVersion();
    }
}

