/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.util.KDebug;
import cerent.version.AbstractInterfaceVersion;
import cerent.version.Compatibility;
import cerent.version.IBuildInformation;
import cerent.version.InvalidScopeException;
import cerent.version.JreVersion;
import cerent.version.Ngrp;
import java.util.Date;

public class JreProxyInterfaceVersion
extends AbstractInterfaceVersion {
    private static JreVersion jre = JreVersion.RECOMMENDED_VERSION;
    private static JreProxyInterfaceVersionDebug db;

    public Object getVersion() {
        return jre;
    }

    public void setVersion(JreVersion jreVersion) {
        jre = jreVersion;
    }

    public IBuildInformation getBuildInformation() {
        return new JreProxyBuildInformation();
    }

    public boolean isNewerThan(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        JreVersion jreVersion = (JreVersion)abstractInterfaceVersion.getVersion();
        return jre.getVersion().compareTo(jreVersion.getVersion()) > 0;
    }

    public boolean isSameVersionAs(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        JreVersion jreVersion = (JreVersion)abstractInterfaceVersion.getVersion();
        return jre.getVersion().equals(jreVersion.getVersion());
    }

    public static boolean isRecommendedJre(String string) {
        JreVersion jreVersion = new JreVersion(string);
        return JreProxyInterfaceVersion.isRecommendedJre(jreVersion);
    }

    public static boolean isRecommendedJre(JreVersion jreVersion) {
        return JreVersion.RECOMMENDED_VERSION.equals(jreVersion);
    }

    public static boolean isSupportedJre(JreVersion jreVersion) {
        return JreProxyInterfaceVersion.meetsMinimumJreRequirements(jreVersion) && JreVersion.SUPPORTED_VERSIONS.contains(jreVersion);
    }

    public static boolean meetsMinimumJreRequirements(JreVersion jreVersion) {
        int n = jreVersion.compareTo(JreVersion.MINIMUM_VERSION);
        return n >= 0;
    }

    public Compatibility getCompatibilityWith(AbstractInterfaceVersion abstractInterfaceVersion) {
        Compatibility compatibility = Compatibility.INCOMPATIBLE;
        JreVersion jreVersion = (JreVersion)abstractInterfaceVersion.getVersion();
        if (JreProxyInterfaceVersion.meetsMinimumJreRequirements(jreVersion)) {
            compatibility = Compatibility.COMPATIBLE;
        }
        return compatibility;
    }

    private class JreProxyBuildInformation
    implements IBuildInformation {
        private JreProxyBuildInformation() {
        }

        public String getSourceType() {
            return null;
        }

        public long getTimeStamp() {
            return Long.MIN_VALUE;
        }

        public Date getDate() {
            return null;
        }

        public String getBranchPath() {
            return null;
        }

        public Ngrp getNgrp() {
            return null;
        }
    }

    public static class JreProxyInterfaceVersionDebug
    extends KDebug {
        public JreProxyInterfaceVersionDebug(String string) {
            super(string);
        }

        public final void getRecommendedVersion() {
            this.println("CTC JRE recommended version: " + jre);
        }

        public final void getSupportedVersions() {
            this.println("Supported JRE versions: " + JreVersion.SUPPORTED_VERSIONS);
        }

        public void dispose() {
            super.dispose();
        }
    }
}

