/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class JreVersion
implements Comparable {
    private static final String jvm = System.getProperty("java.version");
    public static final Set SUPPORTED_VERSIONS;
    public static final JreVersion RECOMMENDED_VERSION;
    public static final JreVersion MAXIMUM_VERSION;
    public static final JreVersion MINIMUM_VERSION;
    private static final String _USER_VERSION;
    public static final JreVersion USER_VERSION;
    private String version;

    public static String trimRevisionNumber(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        if (string.indexOf(95) > 0) {
            return string.substring(0, string.indexOf(95));
        }
        if (string.indexOf(45) > 0) {
            return string.substring(0, string.indexOf(45));
        }
        return string;
    }

    public JreVersion(String string) {
        this.version = JreVersion.trimRevisionNumber(string);
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int n = 7;
        n = 13 * n + this.version.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JreVersion) {
            JreVersion jreVersion = (JreVersion)object;
            return this.getVersion().equals(jreVersion.getVersion());
        }
        return bl;
    }

    public int compareTo(Object object) {
        JreVersion jreVersion = (JreVersion)object;
        return this.getVersion().compareTo(jreVersion.getVersion());
    }

    public String toString() {
        return this.getVersion().toUpperCase(Locale.ENGLISH);
    }

    static {
        MINIMUM_VERSION = new JreVersion("1.4.2");
        MAXIMUM_VERSION = new JreVersion("1.5.0");
        RECOMMENDED_VERSION = new JreVersion("1.4.2");
        SUPPORTED_VERSIONS = new HashSet(3);
        SUPPORTED_VERSIONS.add(RECOMMENDED_VERSION);
        SUPPORTED_VERSIONS.add(MAXIMUM_VERSION);
        SUPPORTED_VERSIONS.add(MINIMUM_VERSION);
        _USER_VERSION = JreVersion.trimRevisionNumber(jvm);
        USER_VERSION = new JreVersion(_USER_VERSION);
    }
}

