/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CtcHttpRetriever;
import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.ctc.core.ClientFutureProofer;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.DownloadAreaConstants;
import com.cisco.ctc.core.DownloadItem;
import com.cisco.ctc.core.IDownloadItem;
import com.cisco.ctc.core.IFutureProofer;
import com.cisco.ctc.core.IJreReqs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DownloadArea
implements Comparable {
    private static final String CTC_PREF = "ctc";
    private static final String CTC_DOWNLOAD_AREA_PREF_LIST = "downloadareas";
    private static final String DA_PREF_SEP = "-";
    private static final String PREF_TRIPLET_ITEM_SEP = ";";
    private static final String[] StringArrayTemplate = new String[0];
    private Preferences prefs;
    private String downloadHostname;
    private final File downloadDir;
    private final String downloadDirPath;
    private final String neSwVersion;
    private final DownloadItem launcherItem;
    private String prefName;
    private String downloadListUri;
    private String launcherUri;
    private String launcherPath;
    private IFutureProofer fp;
    private IDownloadItem[] downloadItems;
    private static final KDebug db = new KDebug("DownloadArea");

    private static File realizeTempDir(String string, String string2) throws IOException {
        File file;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            string3 = System.getProperty("java.io.tmpdir");
        }
        if (string2 != null) {
            string3 = string3 + "/" + string2;
        }
        if ((file = new File(string3)).exists()) {
            if (!file.isDirectory()) {
                throw new IOException("tempdir: " + string3 + " must be directory");
            }
        } else if (!file.mkdirs()) {
            throw new IOException("tempdir: " + string3 + " directory creation attempt failed");
        }
        return file;
    }

    public DownloadArea(String string, String string2) throws IOException, CoreException {
        this.prefs = Preferences.instance();
        if (string2 == null) {
            throw new IllegalArgumentException("neSwVersion may not be null");
        }
        this.neSwVersion = string2;
        this.downloadHostname = string;
        if (string != null) {
            String string3 = this.prefs.getProperty(CTC_PREF, "download.temp.dir", "");
            this.downloadDir = DownloadArea.realizeTempDir(string3, string);
        } else {
            this.prefName = DownloadArea.getDownloadAreaPreferenceName(string2);
            String string4 = this.getDirPreference();
            if (string4 == null) {
                throw new CoreException("preference not set/does not exist");
            }
            this.downloadListUri = "getCtcFiles";
            this.downloadDir = DownloadArea.realizeTempDir(string4, null);
            File file = this.createFileFromUri(this.downloadListUri);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.setDownloadItems(DownloadItem.readDownloadItems(this.downloadDir, fileInputStream));
            }
        }
        this.downloadDirPath = this.downloadDir.getCanonicalPath();
        this.launcherUri = "fs/LAUNCHER.JAR";
        this.launcherItem = new DownloadItem(this.downloadDir, this.launcherUri);
        this.launcherPath = this.launcherItem.getFile().getCanonicalPath();
    }

    public DownloadArea(String string, String string2, String string3) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        this(Preferences.instance(), string, string2, string3);
    }

    public DownloadArea(Preferences preferences, String string, String string2, String string3) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        String string4;
        this.prefs = preferences;
        int n = string == null ? -1 : string.indexOf(DA_PREF_SEP);
        String string5 = string4 = n < 0 ? null : string.substring(n + 1);
        if (string4 == null) {
            throw new IllegalArgumentException("neSwVersion may not be null");
        }
        this.neSwVersion = string4;
        this.downloadHostname = null;
        this.prefName = string;
        String string6 = preferences.getProperty(CTC_PREF, string, null);
        if (string6 == null) {
            throw new CoreException("preference not set/does not exist");
        }
        this.downloadDir = new File(string6);
        this.downloadListUri = string2;
        this.downloadDirPath = this.downloadDir.getCanonicalPath();
        this.launcherUri = string3;
        this.launcherItem = new DownloadItem(this.downloadDir, string3);
        this.launcherPath = this.launcherItem.getFile().getCanonicalPath();
        try {
            this.fp = new ClientFutureProofer(this.launcherPath);
        }
        catch (ClassNotFoundException classNotFoundException) {
            db.println("launcher path: " + this.launcherPath);
            throw classNotFoundException;
        }
        File file = this.createFileFromUri(string2);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.setDownloadItems(this.fp.readCtcCoreFileList(this.downloadDir, fileInputStream));
        }
    }

    public DownloadArea(String string) throws IOException, CoreException {
        this(null, string);
    }

    public static String getDownloadAreaPreferenceName(String string) {
        return DownloadAreaConstants.getDownloadAreaPreferenceName(string);
    }

    public String getDownloadHostname() {
        return this.downloadHostname;
    }

    public void setDownloadHostname(String string) {
        if (this.downloadHostname == null) {
            throw new IllegalArgumentException("Cannot set a download hostname if the original one was null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Cannot set a null download hostname");
        }
        this.downloadHostname = string;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public String getCoreVersion() {
        return this.neSwVersion;
    }

    public String getDirPreference() {
        return this.prefs.getProperty(CTC_PREF, this.prefName, null);
    }

    public String getLauncherPath() {
        return this.launcherPath;
    }

    public IFutureProofer getFutureProofer() {
        return this.fp;
    }

    public IDownloadItem[] getDownloadItems() {
        return this.downloadItems;
    }

    public void storeDirPreference() throws IOException, FileNotFoundException {
        this.prefs.setProperty(CTC_PREF, this.prefName, this.downloadDirPath);
        this.addPreferenceToList(this.prefName, this.downloadListUri, this.launcherUri);
        this.prefs.store();
    }

    public void removeDirPreference() throws IOException, FileNotFoundException {
        if (db.isFinerEnabled()) {
            db.finer("entering removeDirPreference");
        }
        this.prefs.removeProperty(CTC_PREF, this.prefName);
        this.removePreferenceFromList(this.prefName, this.downloadListUri, this.launcherUri);
        this.prefs.store();
    }

    private static String getPrefItem(String string, String string2, String string3) {
        return string + PREF_TRIPLET_ITEM_SEP + string2 + PREF_TRIPLET_ITEM_SEP + string3;
    }

    private static int findPrefItem(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] addPreferenceToList(String string, String string2, String string3) {
        String string4 = DownloadArea.getPrefItem(string, string2, string3);
        String[] stringArray = this.prefs.getPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, StringArrayTemplate);
        int n = DownloadArea.findPrefItem(stringArray, string4);
        if (n < 0) {
            int n2 = stringArray == null ? 0 : stringArray.length;
            String[] stringArray2 = new String[n2 + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            stringArray = stringArray2;
            stringArray[n2] = string4;
            this.prefs.setPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, stringArray);
        }
        return stringArray;
    }

    private String[] removePreferenceFromList(String string, String string2, String string3) {
        String string4 = DownloadArea.getPrefItem(string, string2, string3);
        String[] stringArray = this.prefs.getPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, StringArrayTemplate);
        int n = DownloadArea.findPrefItem(stringArray, string4);
        if (n >= 0) {
            int n2 = stringArray.length;
            if (n2 > 1) {
                String[] stringArray2 = new String[n2 - 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                System.arraycopy(stringArray, n + 1, stringArray2, n, n2 - (n + 1));
                stringArray = stringArray2;
                this.prefs.setPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, stringArray);
            } else {
                this.prefs.removeProperty(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST);
            }
        }
        return stringArray;
    }

    public static String[] getPrefItems(Preferences preferences) {
        if (preferences == null) {
            preferences = Preferences.instance();
        }
        String[] stringArray = preferences.getPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, StringArrayTemplate);
        return stringArray;
    }

    public static String[] getPrefItems() {
        return DownloadArea.getPrefItems(null);
    }

    public static String getPrefNameFromPrefItem(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(PREF_TRIPLET_ITEM_SEP);
        return n < 0 ? null : string.substring(0, n);
    }

    public static String getDownloadListUriFromPrefItem(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(PREF_TRIPLET_ITEM_SEP);
        if (n2 < 0) {
            return null;
        }
        return (n = string.indexOf(PREF_TRIPLET_ITEM_SEP, ++n2)) < 0 ? null : string.substring(n2, n);
    }

    public static String getLauncherUriFromPrefItem(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.indexOf(PREF_TRIPLET_ITEM_SEP);
        if (n3 < 0) {
            return null;
        }
        if ((n2 = string.indexOf(PREF_TRIPLET_ITEM_SEP, (n = string.indexOf(PREF_TRIPLET_ITEM_SEP, ++n3)) + 1)) < 0) {
            n2 = string.length();
        }
        return n < 0 ? null : string.substring(n + 1, n2);
    }

    public boolean isAreaComplete() {
        boolean bl;
        boolean bl2 = bl = this.downloadItems != null;
        if (bl) {
            for (int i = 0; i < this.downloadItems.length && bl; ++i) {
                IDownloadItem iDownloadItem = this.downloadItems[i];
                if (iDownloadItem != null && iDownloadItem.getFile().exists()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void completeArea() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        boolean bl;
        if (this.downloadHostname == null) {
            if (this.isAreaComplete()) {
                return;
            }
            throw new IOException("download area incomplete but download host is null");
        }
        boolean bl2 = db.isFinestEnabled();
        if (bl2) {
            db.finest("About to try downloading LAUNCHER.jar (if needed) from NE: " + this.downloadHostname);
        }
        this.downloadLauncher();
        if (bl2) {
            db.finest("About to try downloading the CTC core file list (if needed)");
        }
        this.downloadCoreFileList(true);
        boolean bl3 = bl = this.downloadItems != null;
        if (bl) {
            for (int i = 0; i < this.downloadItems.length; ++i) {
                IDownloadItem iDownloadItem = this.downloadItems[i];
                if (bl2) {
                    db.finest("About to try downloading the CTC core file item (if needed)" + iDownloadItem);
                }
                this.downloadItem(iDownloadItem);
            }
        }
        if (bl2) {
            db.finest("Done w/ completing area!");
        }
    }

    public void cleanArea() throws ClassNotFoundException, InstantiationException, InvocationTargetException, IOException, CoreException {
        File file;
        boolean bl;
        boolean bl2 = bl = this.downloadItems != null;
        if (!bl) {
            if (this.fp == null && this.downloadListUri == null) {
                File file2 = new File(this.launcherPath);
                if (file2.exists()) {
                    file2.delete();
                }
                this.downloadLauncher();
            }
            try {
                this.downloadCoreFileList(false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
            boolean bl3 = bl = this.downloadItems != null;
        }
        if (this.fp != null) {
            try {
                ((ClientFutureProofer)this.fp).dispose();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                KDebug.printStackTrace(noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                KDebug.printStackTrace(illegalAccessException);
            }
            catch (RuntimeException runtimeException) {
                KDebug.printStackTrace(runtimeException);
            }
        }
        System.gc();
        if (bl) {
            int n = 0;
            System.out.println("# download items: " + this.downloadItems.length);
            for (int i = 0; i < this.downloadItems.length; ++i) {
                IDownloadItem iDownloadItem = this.downloadItems[i];
                if (iDownloadItem == null) continue;
                File file3 = iDownloadItem.getFile();
                if (file3.exists()) {
                    if (file3.delete()) {
                        this.downloadItems[i] = null;
                        ++n;
                    } else {
                        System.out.println("# couldn't delete: " + iDownloadItem);
                    }
                } else {
                    this.downloadItems[i] = null;
                    ++n;
                }
                this.rmdirs(file3);
            }
            if (n == this.downloadItems.length) {
                System.out.println("all download items DELETED!");
                this.downloadItems = null;
            }
        }
        if ((file = this.createFileFromUri(this.downloadListUri)).exists()) {
            file.delete();
        } else {
            System.out.println("attempting to handle stray LAUNCHER.jar...");
            File file4 = new File(this.launcherPath);
            if (file4.exists()) {
                file4.delete();
                this.rmdirs(file4);
            }
        }
        this.rmdirs(file);
    }

    private void rmdirs(File file) {
        File file2;
        if (file == null) {
            return;
        }
        File file3 = file2 = file.isDirectory() ? file : file.getParentFile();
        if (file2.delete()) {
            this.rmdirs(file2.getParentFile());
        }
    }

    private String determineDownloadListUri() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        return this.fp.getCtcCoreFileListUri();
    }

    private void downloadLauncher() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        this.downloadItem(this.launcherItem);
        if (this.fp == null) {
            this.fp = new ClientFutureProofer(this.launcherPath);
            String string = this.fp.isCoreSoftwareUpgradePossible((Comparable)((Object)this.neSwVersion));
            if (string != null) {
                throw new CoreException(string);
            }
            if (this.prefName == null) {
                this.prefName = this.fp.getDownloadAreaPreferenceName(this.neSwVersion);
            }
        }
    }

    private void downloadItem(IDownloadItem iDownloadItem) throws IOException {
        File file = iDownloadItem.getFile();
        if (file.exists()) {
            return;
        }
        Serializable serializable = file.getParentFile();
        if (serializable != null && !serializable.exists()) {
            serializable.mkdirs();
        }
        serializable = iDownloadItem.getDownloadURL(this.downloadHostname);
        this._downloadItem((URL)serializable, file);
    }

    private void _downloadItem(URL uRL, File file) throws IOException {
        InputStream inputStream = CtcHttpRetriever.createTransferContentInputStream(uRL, null);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.streamCopy(inputStream, fileOutputStream, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void streamCopy(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        long l = 0L;
        int n2 = 0;
        try {
            int n3 = 0;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n2);
                l += (long)n2;
                ++n3;
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private File createFileFromUri(String string) throws IOException {
        File file;
        String string2;
        String string3;
        int n;
        if (string == null) {
            throw new IOException("uri cannot be null");
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.lastIndexOf("/")) >= 0) {
            string3 = string.substring(0, n);
            string3 = string3.replaceAll("/", File.separator);
            string2 = string.substring(n + 1);
        } else {
            string3 = null;
            string2 = string;
        }
        if (string3 != null) {
            File file2 = new File(this.downloadDir, string3);
            file2.mkdirs();
            file = new File(file2, string2);
        } else {
            file = new File(this.downloadDir, string2);
        }
        return file;
    }

    private void setDownloadItems(IDownloadItem[] iDownloadItemArray) {
        this.downloadItems = iDownloadItemArray;
    }

    private boolean createParentDirs(File file) {
        File file2 = file.getParentFile();
        boolean bl = true;
        if (file2 != null && !file2.exists()) {
            bl = file2.mkdirs();
        }
        return bl;
    }

    private void downloadCoreFileList(boolean bl) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        File file;
        if (this.downloadListUri == null) {
            this.downloadListUri = this.determineDownloadListUri();
        }
        if ((file = this.createFileFromUri(this.downloadListUri)).exists()) {
            if (this.downloadItems == null) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.setDownloadItems(this.fp.readCtcCoreFileList(this.downloadDir, fileInputStream));
            }
            return;
        }
        this.createParentDirs(file);
        if (this.downloadHostname == null) {
            throw new IOException("Core download file list is missing and download host is null");
        }
        if (!bl) {
            return;
        }
        try {
            String string = this.downloadListUri;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            URL uRL = new URL("http", this.downloadHostname, string);
            InputStream inputStream = CtcHttpRetriever.createTransferContentInputStream(uRL, null);
            this.setDownloadItems(this.fp.readCtcCoreFileList(this.downloadDir, inputStream));
            File file2 = new File(this.downloadDir, this.downloadListUri);
            this.createParentDirs(file2);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.fp.writeCtcCoreFileList(this.downloadItems, fileOutputStream);
        }
        catch (IOException iOException) {
            if (db.on()) {
                KDebug.printStackTrace(iOException);
            }
            this.setDownloadItems(null);
            if (file.exists()) {
                System.gc();
                file.delete();
            }
            throw iOException;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("download area: ");
        if (this.downloadHostname != null) {
            stringBuffer.append("host: " + this.downloadHostname + "; ");
        }
        if (this.prefName != null) {
            stringBuffer.append("version: " + this.prefName);
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        int n;
        int n2 = n = this == object ? 0 : -1;
        if (n != 0 && object instanceof DownloadArea) {
            DownloadArea downloadArea = (DownloadArea)object;
            n = this.neSwVersion.compareTo(downloadArea.neSwVersion);
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.neSwVersion.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            db.println("usage: java " + DownloadArea.class.getName() + " downloadhost");
            System.exit(1);
        }
        String string = stringArray[0];
        boolean bl = false;
        try {
            Object object;
            String[] stringArray2;
            String string2 = CtcHttpRetriever.getSwVersion(string);
            DownloadArea downloadArea = new DownloadArea(string, string2);
            downloadArea.removeDirPreference();
            downloadArea.cleanArea();
            bl = downloadArea.isAreaComplete();
            System.out.println("old-core " + downloadArea + " is initially incomplete? " + !bl);
            try {
                downloadArea.completeArea();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
            bl = downloadArea.isAreaComplete();
            System.out.println("old-core " + downloadArea + " complete? " + bl);
            if (bl) {
                downloadArea.storeDirPreference();
            }
            downloadArea.removeDirPreference();
            downloadArea.cleanArea();
            bl = downloadArea.isAreaComplete();
            System.out.println("old-core " + downloadArea + " after cleaning is incomplete? " + !bl);
            try {
                downloadArea.completeArea();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
            bl = downloadArea.isAreaComplete();
            System.out.println("old-core " + downloadArea + " complete? " + bl);
            IFutureProofer iFutureProofer = downloadArea.getFutureProofer();
            IJreReqs iJreReqs = iFutureProofer.getJreReqs();
            String string3 = ((Object)iJreReqs).toString();
            System.out.println("downloaded core in " + downloadArea + " - jre reqs: " + string3);
            String string4 = downloadArea.getLauncherPath();
            File file = new File(string4);
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                stringArray2 = jarFile.getManifest();
                object = iFutureProofer.getNgrp((Manifest)stringArray2, string4);
                System.out.println("ngrp for launcher in da is: " + object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace(System.out);
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            if (bl) {
                downloadArea.storeDirPreference();
            }
            stringArray2 = DownloadArea.getPrefItems();
            object = stringArray2[0];
            String string5 = DownloadArea.getPrefNameFromPrefItem((String)object);
            String string6 = DownloadArea.getDownloadListUriFromPrefItem((String)object);
            String string7 = DownloadArea.getLauncherUriFromPrefItem((String)object);
            DownloadArea downloadArea2 = new DownloadArea(string5, string6, string7);
            System.out.println("present-core discovery download area " + downloadArea2);
            try {
                DownloadArea downloadArea3 = new DownloadArea(string2);
                bl = downloadArea3.isAreaComplete();
                System.out.println("present-core " + downloadArea3 + " complete? " + bl);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
            System.out.println("unit test done!");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        System.exit(0);
    }
}

