/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CachedJarFactory;
import cerent.launcher.ClassLoaderFactory;
import cerent.launcher.CmsClassLoader;
import cerent.launcher.NoMainClassAttributeException;
import cerent.util.CtcSecurityManager;
import cerent.util.DebugManager;
import cerent.util.DebugTelnetd;
import cerent.util.DebugWindow;
import cerent.util.KDebug;
import cerent.util.Preferences;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.Permission;

public class CTMBootstrap {
    private static final String JARFILE_PARM = "ctc.orb.jarfile";
    private static final String JARFILEDOWNLOAD_PARM = "ctc.orb.jarfiledownload";
    private static final String CTC = "ctc";
    private static final String DEBUG_PORT = "telnet.port";
    private static final String TELNET_PSWD = "CISCO15";
    private static final String BOOT_DEBUG = "boot.debug";
    private static KDebug db = null;
    private static WeakReference icl_ = null;
    private static final String RMI_SECURITY_MGR = "rmisecuritymgr";
    private static final String BOOT_DEBUG_NAME = "boot.debug.name";
    private String bootDebugName = "CTMBootstrap";

    public static void main(String[] stringArray) {
        try {
            DebugManager debugManager = DebugManager.instance();
            CTMBootstrap cTMBootstrap = new CTMBootstrap();
            cTMBootstrap.begin(stringArray);
        }
        catch (NoMainClassAttributeException noMainClassAttributeException) {
            CTMBootstrap.fatal("'Main-Class:' missing from JAR manifest");
        }
        catch (ClassNotFoundException classNotFoundException) {
            CTMBootstrap.fatal("Load class failed to load a class..." + classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            CTMBootstrap.fatal("cannot access the 'main(String[])' method");
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException);
            CTMBootstrap.fatal("failed to instantiate a class loader");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException + ": " + noSuchMethodException.getMessage());
            CTMBootstrap.fatal("'setParent(CmsClassLoader)' not in ElementFactory OR 'main(String[])' not in class tagged as Main-Class");
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            CTMBootstrap.fatal("failed to invoke 'main(String[])'");
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
            malformedURLException.printStackTrace();
            CTMBootstrap.fatal("invalid URL parts on command line");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            CTMBootstrap.fatal("I/O error while caching JAR");
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            CTMBootstrap.fatal("Error starting CTC");
        }
    }

    private CTMBootstrap() {
        if (Preferences.instance().propertyExist(CTC, BOOT_DEBUG_NAME)) {
            this.bootDebugName = this.bootDebugName.concat(":" + Preferences.instance().getProperty(CTC, BOOT_DEBUG_NAME, "Debug"));
        }
        db = new BsClass(this.bootDebugName);
    }

    public static ClassLoader getIFClassLoader() {
        return icl_ == null ? null : (ClassLoader)icl_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin(String[] stringArray) throws NoMainClassAttributeException, Exception {
        Object object;
        boolean bl;
        Preferences preferences = Preferences.instance();
        preferences.init();
        String string = null;
        String string2 = null;
        string2 = null;
        string = null;
        String[] stringArray2 = stringArray;
        int n = Preferences.instance().getInt(CTC, DEBUG_PORT, -1);
        if (n > 0) {
            DebugTelnetd debugTelnetd = new DebugTelnetd(DebugManager.instance().getRoot(), n, TELNET_PSWD, false);
            debugTelnetd.start();
        }
        if (bl = Preferences.instance().getBoolean(CTC, BOOT_DEBUG, false)) {
            DebugWindow.instance().display();
            db.println(this.bootDebugName + " paused, type \"" + this.bootDebugName + " resume\" to resume.");
            db.println("To avoid modal dialog blocking, it is recommended to");
            db.println("start telnetd \"telnetd <password> [<port>]\" before resuming");
            object = db;
            synchronized (object) {
                try {
                    db.wait();
                }
                catch (Exception exception) {
                    db.finest("Exception in begin() " + exception);
                }
            }
            db.println(this.bootDebugName + " resumed");
        }
        ClassLoader classLoader = this.myLoader();
        if (db.on()) {
            db.println("Loading IF.jar from " + string2);
        }
        object = new CachedJarFactory(string2, "IF", string);
        ClassLoader classLoader2 = ClassLoaderFactory.getClassLoader((CachedJarFactory)object, classLoader);
        icl_ = new WeakReference<ClassLoader>(classLoader2);
        if (CTMBootstrap.db.on) {
            db.println("Loading NET.jar from " + string2);
        }
        object = new CachedJarFactory(string2, "NET", string);
        ClassLoader classLoader3 = ClassLoaderFactory.getClassLoader((CachedJarFactory)object, classLoader2);
        Class<?> clazz = classLoader3.loadClass("cerent.cms.loader.ElementFactory");
        Class[] classArray = new Class[]{classLoader2.getClass()};
        Method method = clazz.getMethod("setParent", classArray);
        method.setAccessible(true);
        boolean bl2 = preferences.getBoolean(CTC, RMI_SECURITY_MGR, false);
        if (bl2) {
            System.setSecurityManager(new CtcSecurityManager(){

                public void checkConnect(String string, int n) {
                }

                public void checkConnect(String string, int n, Object object) {
                }

                public void checkRead(FileDescriptor fileDescriptor) {
                }

                public void checkRead(String string) {
                }

                public void checkRead(String string, Object object) {
                }

                public void checkPropertiesAccess() {
                }

                public void checkPropertyAccess(String string) {
                }

                public void checkPermission(Permission permission) {
                }

                public void checkPermission(Permission permission, Object object) {
                }
            });
        }
        Object[] objectArray = new Object[]{classLoader2};
        method.invoke(null, objectArray);
        ((CmsClassLoader)classLoader3).invokeMain(stringArray2);
    }

    private ClassLoader myLoader() {
        return this.getClass().getClassLoader();
    }

    private static void fatal(String string) {
        System.err.println(string);
        System.err.flush();
        System.exit(1);
    }

    public class BsClass
    extends KDebug {
        BsClass(String string) {
            super(string);
        }

        public final synchronized void resume() {
            this.notifyAll();
        }

        public final void debugAtBoot(boolean bl) {
            if (bl) {
                this.display(this.getName() + " will pause and display the debug window at next start");
            } else {
                this.display(this.getName() + " debug at boot reset (normal setting)");
            }
            Preferences.instance().setBoolean(CTMBootstrap.CTC, CTMBootstrap.BOOT_DEBUG, bl);
        }
    }
}

