/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CachedJar;
import cerent.launcher.CachedJarFactory;
import cerent.launcher.CmsClassLoader;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.launcher.DownloadView;
import cerent.util.DebugManager;
import cerent.util.FRMap;
import cerent.util.KDebug;
import cerent.util.Preferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class ClassLoaderFactory {
    private static FRMap classLoaders = new FRMap();
    private static HashMap loaderLocks = new HashMap();
    private static int uniqueLockId = 0;
    private static String DWLD_UI_PROP = "ctc.download";
    private static String DWLD_UI_KEY = "showui";
    protected static final KDebug db = new KDebug("ClassLoaderFactory");

    public static ClassLoader getClassLoader(CachedJarFactory cachedJarFactory, ClassLoader classLoader) throws IOException, MalformedURLException, Exception {
        return ClassLoaderFactory.getClassLoader(null, cachedJarFactory, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoader(String string, CachedJarFactory cachedJarFactory, ClassLoader classLoader) throws IOException, MalformedURLException, Exception {
        CachedJar cachedJar;
        String string2;
        ClassLoader classLoader2 = null;
        String string3 = null;
        if (string != null) {
            string3 = CtcHttpRetriever.getSwVersion(string);
        }
        if ((classLoader2 = ClassLoaderFactory.findClassLoader(string2 = (cachedJar = cachedJarFactory.create()).propertyName())) == null) {
            Integer n = null;
            Serializable serializable = loaderLocks;
            synchronized (serializable) {
                if (loaderLocks.containsKey(string2)) {
                    n = (Integer)loaderLocks.get(string2);
                    if (db.on()) {
                        db.println("getClassLoader: ipAddr=" + string + " key=" + string2 + " found old lock=" + n);
                    }
                } else {
                    n = new Integer(++uniqueLockId);
                    loaderLocks.put(string2, n);
                    if (db.on()) {
                        db.println("getClassLoader: ipAddr=" + string + " key=" + string2 + " added new lock=" + n);
                    }
                }
            }
            serializable = n;
            synchronized (serializable) {
                classLoader2 = ClassLoaderFactory.findClassLoader(string2);
                if (classLoader2 == null) {
                    ClassLoaderFactory.download(cachedJar);
                    classLoader2 = new CmsClassLoader(cachedJar, classLoader);
                    ClassLoaderFactory.addClassLoader(string2, classLoader2);
                    if (db.on()) {
                        db.println("getClassLoader: ipAddr=" + string + " key=" + string2 + " created new loader");
                    }
                } else if (db.on()) {
                    db.println("getClassLoader: ipAddr=" + string + " key=" + string2 + " reusing new loader");
                }
            }
        }
        if (db.on()) {
            db.println("getClassLoader: ipAddr=" + string + " key=" + string2 + " reusing existing loader");
        }
        return classLoader2;
    }

    public static void removeClassLoader(ClassLoader classLoader) throws Exception {
        ClassLoaderFactory.removeClassLoader(ClassLoaderFactory.findKey(classLoader));
    }

    private static String findKey(ClassLoader classLoader) {
        return (String)classLoaders.get(classLoader);
    }

    public static void setShowDownloadUi(boolean bl) {
        Preferences.instance().setProperty(DWLD_UI_PROP, DWLD_UI_KEY, String.valueOf(bl));
    }

    public static boolean showDownloadUi() {
        boolean bl = true;
        Preferences preferences = Preferences.instance();
        if (preferences.getProperty(DWLD_UI_PROP, DWLD_UI_KEY, "true").equals("false")) {
            bl = false;
        }
        return bl;
    }

    private static void forceDownload(CachedJar cachedJar) throws MalformedURLException, IOException {
        ClassLoaderFactory.forceDownload(cachedJar, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceDownload(CachedJar cachedJar, boolean bl) throws MalformedURLException, IOException {
        if (db.on()) {
            db.println("forceDownload( " + cachedJar + " )");
        }
        boolean bl2 = ClassLoaderFactory.showDownloadUi();
        DownloadView downloadView = null;
        if (bl2) {
            downloadView = new DownloadView(cachedJar.getDownloadState());
        }
        try {
            cachedJar.init(bl);
        }
        finally {
            if (bl2 && downloadView != null) {
                downloadView.fini();
            }
        }
    }

    public static void download(CachedJar cachedJar) throws MalformedURLException, IOException {
        ClassLoaderFactory.download(cachedJar, true, ClassLoaderFactory.showDownloadUi());
    }

    public static void download(CachedJar cachedJar, boolean bl, boolean bl2) throws MalformedURLException, IOException {
        if (db.on()) {
            db.println("download( " + cachedJar + " )");
        }
        if (cachedJar.isCachingPermitted() && bl2) {
            ClassLoaderFactory.forceDownload(cachedJar, bl);
        } else {
            cachedJar.init(bl);
        }
    }

    public static String downloadThisJarfile(String string, String string2, String string3) throws Exception {
        String string4 = null;
        try {
            File file = new File(string2);
            String string5 = file.getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ".");
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
            if (string == null) {
                string = "http://" + string3;
            }
            String string6 = CtcHttpRetriever.getSwVersion(string3);
            CachedJar cachedJar = new CachedJar(string, string5, string6);
            ClassLoaderFactory.forceDownload(cachedJar);
            string4 = cachedJar.cachedName(false);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("error in downloadThisJarFile: " + exception.getMessage());
            }
            KDebug.printStackTrace(exception);
            throw exception;
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File forceDownloadThirdPartyJar(String string, String string2, String string3, boolean bl) throws MalformedURLException, FileNotFoundException, IOException {
        String string4 = "http://" + string3;
        String string5 = string4 + "/fs/" + string + ".jgz";
        String string6 = string4 + "/fs/" + string + ".jar";
        File file = new File(System.getProperty("java.io.tmpdir"));
        File file2 = new File(file, string + string2 + ".jar");
        String string7 = file2.getAbsolutePath();
        if (file2.exists() && file2.length() > 0L) {
            return file2;
        }
        DownloadView downloadView = null;
        DownloadState downloadState = new DownloadState(string6);
        if (db.on()) {
            db.println("Downloading the " + string6 + " ver: " + string2 + " jar file from " + string4 + ".");
            db.println("Saving to: " + string7);
        }
        try {
            if (bl) {
                downloadView = new DownloadView(downloadState);
            }
            CtcHttpRetriever ctcHttpRetriever = new CtcHttpRetriever();
            ctcHttpRetriever.transferContent(new URL(string5), GZIPInputStream.class, string7, downloadState);
            File file3 = file2;
            return file3;
        }
        finally {
            if (bl && downloadView != null) {
                downloadView.fini();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader findClassLoader(String string) {
        ClassLoader classLoader = null;
        FRMap fRMap = classLoaders;
        synchronized (fRMap) {
            classLoader = (ClassLoader)classLoaders.get(string);
            if (db.on()) {
                db.println("findClassLoader: key=" + string + " result=" + classLoader);
            }
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addClassLoader(String string, ClassLoader classLoader) throws Exception {
        FRMap fRMap = classLoaders;
        synchronized (fRMap) {
            if (classLoaders.containsKey(string)) {
                throw new Exception("ClassLoaderFactory.classLoaders already contains a ClassLoader for " + string);
            }
            if (db.on()) {
                db.println("addClassLoader: key=" + string + " cl=" + classLoader);
            }
            classLoaders.put(string, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeClassLoader(String string) throws Exception {
        FRMap fRMap = classLoaders;
        synchronized (fRMap) {
            if (!classLoaders.containsKey(string)) {
                throw new Exception("ClassLoaderFactory.classLoaders does not contain a ClassLoader for " + string);
            }
            CmsClassLoader cmsClassLoader = (CmsClassLoader)classLoaders.get(string);
            if (db.on()) {
                db.println("removeClassLoader: key=" + string + " cl=" + cmsClassLoader);
            }
            DebugManager.instance().disposeClassLoader(cmsClassLoader);
            classLoaders.remove(string);
            if (db.on()) {
                db.println("removeClassLoader: key=" + string + " cl=" + cmsClassLoader);
            }
            cmsClassLoader.destroy();
        }
    }

    private ClassLoaderFactory() {
    }
}

