/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CtcHttpErrorInfo;
import cerent.launcher.DownloadState;
import cerent.launcher.HttpResponseException;
import cerent.util.ChunkedInputStream;
import cerent.util.CtcHttpURLConnection;
import cerent.util.CtcURLStreamHandler;
import cerent.util.KDebug;
import cerent.util.MimeHeader;
import cerent.util.Preferences;
import cerent.util.PrematureEOFException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.misc.BASE64Encoder;

public class CtcHttpRetriever {
    private static final int _responseTimeout = 0;
    private static final HashMap _contents = new HashMap();
    private static final HashMap _supports = new HashMap();
    private static final HashMap _retrievers = new HashMap();
    private static Set secureNodes = Collections.synchronizedSet(new HashSet());
    private static boolean firewallEnable = Preferences.instance().getBoolean("ctc.firewall", "enable", true);
    public static final int DONOTCARE = -1;
    public static final int MINHIST = 0;
    public static final int MAX15HIST = 32;
    public static final int MAXDAYHIST = 1;
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static boolean _useProxy = true;
    private boolean aborted = false;
    public static final int INCOMPLETE_TRANSFER = 1001;
    public static final int CONNECTION_REFUSED = 1002;
    private static final Debug db = new Debug("CtcHttpRetriever");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidate(String string, HashMap hashMap) {
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                if (!uRL.getHost().equals(string)) continue;
                iterator.remove();
            }
        }
    }

    public static Set getSecureNodes() {
        return secureNodes;
    }

    public static boolean addSecureNode(String string) {
        if (!secureNodes.contains(string)) {
            CtcHttpRetriever.invalidate(string);
        }
        return secureNodes.add(string);
    }

    public static boolean removeSecureNode(String string) {
        if (secureNodes.contains(string)) {
            CtcHttpRetriever.invalidate(string);
        }
        return secureNodes.remove(string);
    }

    public static void invalidate(String string) {
        if (db.isFineEnabled()) {
            db.fine("invalidating " + string);
        }
        CtcHttpRetriever.invalidate(string, _contents);
        CtcHttpRetriever.invalidate(string, _supports);
    }

    public static URL makeUrl(String string) throws MalformedURLException {
        return CtcHttpRetriever.makeUrl(string, "");
    }

    public static URL makeUrl(String string, String string2) throws MalformedURLException {
        return new URL(HTTP, string, -1, string2);
    }

    public static String getSwVersion(String string) throws IOException {
        return CtcHttpRetriever.getContentFrom(CtcHttpRetriever.makeUrl(string, "/getSwVersion"));
    }

    public static String getApiVersion(String string) throws IOException {
        try {
            int n;
            String string2;
            String string3 = CtcHttpRetriever.getContentFrom(CtcHttpRetriever.makeUrl(string, "/getApiVersion"));
            if (string3 != null && string3.indexOf("-") < 0 && (string2 = CtcHttpRetriever.getSwVersion(string)) != null && (n = string2.indexOf("-")) >= 0) {
                string3 = string3 + string2.substring(n);
            }
            return string3;
        }
        catch (IOException iOException) {
            return CtcHttpRetriever.getSwVersion(string);
        }
    }

    public static String getNodeId(String string) throws IOException {
        try {
            return CtcHttpRetriever.getContentFrom(CtcHttpRetriever.makeUrl(string, "/getNodeId"));
        }
        catch (IOException iOException) {
            if (db.on()) {
                Debug.printStackTrace(iOException);
            }
            throw iOException;
        }
    }

    public static String getFullSwVersion(String string) throws IOException {
        return CtcHttpRetriever.getSwVersion(string);
    }

    public static String getNeType(String string) throws IOException {
        String string2;
        block6: {
            URL uRL = CtcHttpRetriever.makeUrl(string, "/getNeType");
            try {
                string2 = CtcHttpRetriever.getContentFrom(uRL);
                int n = string2.lastIndexOf(" ");
                if (n > 0) {
                    string2 = string2.substring(n + 1);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                string2 = "15454";
                if (db.on()) {
                    Debug.printStackTrace(fileNotFoundException);
                }
            }
            catch (IOException iOException) {
                if (CtcHttpRetriever.version(CtcHttpRetriever.getSwVersion(string)).compareTo("02.30") >= 0) {
                    throw iOException;
                }
                string2 = "15454";
                if (!db.on()) break block6;
                Debug.printStackTrace(iOException);
            }
        }
        return string2;
    }

    public static String getLegalDisclaimer(String string) throws IOException {
        return CtcHttpRetriever.getContentFrom(CtcHttpRetriever.makeUrl(string, "/getLegalDisclaimer"));
    }

    public static URL getPMStatsURL(String string, Interval interval, int n, String string2) throws IllegalArgumentException, MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer("/pm/");
        if (db.on()) {
            db.println("int history: " + n);
        }
        if (interval != null) {
            stringBuffer.append(interval.toString());
            stringBuffer.append("/");
            if (n != -1) {
                switch (interval.value()) {
                    case 1: {
                        if (n >= 0 || n <= 1) {
                            stringBuffer.append(Integer.toString(n));
                            break;
                        }
                        throw new IllegalArgumentException("Day PM history value out of range(0,1)");
                    }
                    case 0: {
                        if (n >= 0 || n <= 32) {
                            stringBuffer.append(Integer.toString(n));
                            break;
                        }
                        throw new IllegalArgumentException("15Minute PM history value out of range(0-32)");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid interval, must be 0 or 1 ");
                    }
                }
            }
        }
        URL uRL = CtcHttpRetriever.makeUrl(string, stringBuffer.toString());
        if (db.on()) {
            db.println("getPMStatsURL: " + uRL);
        }
        return uRL;
    }

    public static CtcHttpErrorInfo getPMStats(String string, Interval interval, int n, String string2) throws IllegalArgumentException, MalformedURLException {
        int n2;
        URL uRL = CtcHttpRetriever.getPMStatsURL(string, interval, n, string2);
        if (db.on()) {
            db.println("getPMStats url: " + uRL);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DownloadState downloadState = new DownloadState("getPMStats");
        try {
            n2 = new CtcHttpRetriever().transferContent(uRL, null, string2, byteArrayOutputStream, downloadState);
        }
        catch (IOException iOException) {
            db.println("getPMStats(" + uRL + ") failed: " + iOException);
            n2 = 1001;
        }
        return new CtcHttpErrorInfo(n2, byteArrayOutputStream.toString());
    }

    public static void useProxy(boolean bl) {
        _useProxy = bl;
    }

    public static boolean useProxy() {
        return _useProxy;
    }

    private static URLConnection ctcURLConnection(URL uRL) throws IOException {
        String string = uRL.getProtocol();
        if (string.equals(HTTP) || string.equals(HTTPS)) {
            uRL = new URL(string, uRL.getHost(), uRL.getPort(), uRL.getFile(), new CtcURLStreamHandler());
        }
        return uRL.openConnection();
    }

    public static String getIOR(String string, String string2) throws IOException {
        String string3;
        block3: {
            URL uRL = CtcHttpRetriever.makeUrl(string, "/" + string2);
            string3 = null;
            try {
                String string4 = CtcHttpRetriever.getContentFrom(uRL);
                int n = string4.indexOf("IOR:");
                if (n > 0) {
                    string4 = string4.substring(n);
                }
                string3 = string4;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!db.on()) break block3;
                Debug.printStackTrace(fileNotFoundException);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readChunkedBody(InputStream inputStream) throws IOException {
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = CtcHttpRetriever.getReader(inputStream, new MimeHeader());
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2 + "\n";
                string2 = bufferedReader.readLine();
            }
        }
        catch (PrematureEOFException prematureEOFException) {
            if (db.on()) {
                Debug.printStackTrace(prematureEOFException);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return string;
    }

    private static String readNonChunkedBody(InputStream inputStream, long l) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        if (l > 0L) {
            int n2;
            while (l > 0L && (n2 = inputStream.read(byArray, 0, n = (long)byArray.length < l ? byArray.length : (int)l)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                l -= (long)n2;
            }
        } else {
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        String string = byteArrayOutputStream.toString();
        byteArrayOutputStream.close();
        if (db.on()) {
            db.println("content => " + string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RefCount getHostLock(String string) {
        RefCount refCount;
        HashMap hashMap = _retrievers;
        synchronized (hashMap) {
            refCount = (RefCount)_retrievers.get(string);
            if (refCount == null) {
                refCount = new RefCount();
                _retrievers.put(string, refCount);
            }
            refCount.reference();
        }
        return refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putHostLock(String string, RefCount refCount) {
        HashMap hashMap = _retrievers;
        synchronized (hashMap) {
            if (refCount.dereference() == 0) {
                _retrievers.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimedEntry getCachedContent(URL uRL) {
        HashMap hashMap = _contents;
        synchronized (hashMap) {
            TimedEntry timedEntry = (TimedEntry)_contents.get(uRL);
            if (timedEntry != null) {
                if (timedEntry.expired()) {
                    _contents.remove(uRL);
                    timedEntry = null;
                } else if (db.on()) {
                    db.println("using cache for " + uRL + " content => " + timedEntry.value());
                }
            }
            return timedEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContentFrom(URL uRL) throws IOException {
        TimedEntry timedEntry = CtcHttpRetriever.getCachedContent(uRL);
        if (timedEntry == null) {
            String string = uRL.getHost();
            RefCount refCount = CtcHttpRetriever.getHostLock(string);
            URLConnection uRLConnection = null;
            boolean bl = false;
            InputStream inputStream = null;
            try {
                RefCount refCount2 = refCount;
                synchronized (refCount2) {
                    timedEntry = CtcHttpRetriever.getCachedContent(uRL);
                    if (timedEntry == null) {
                        Object object;
                        if (db.on()) {
                            db.println("getContentFrom(" + uRL + ")");
                        }
                        uRLConnection = CtcHttpRetriever.ctcURLConnection(uRL);
                        bl = uRLConnection instanceof HttpURLConnection;
                        inputStream = CtcHttpRetriever.getInputStream(uRLConnection, bl);
                        if (bl) {
                            object = (HttpURLConnection)uRLConnection;
                            CtcHttpErrorInfo ctcHttpErrorInfo = CtcHttpRetriever.getCtcHttpErrorInfo((HttpURLConnection)object);
                            if (ctcHttpErrorInfo.httpStatusCode() == 200) {
                                timedEntry = new TimedEntry(CtcHttpRetriever.read((HttpURLConnection)object, inputStream, -1L));
                            } else {
                                throw new IOException(ctcHttpErrorInfo.httpResponseMsg());
                            }
                        }
                        object = _contents;
                        synchronized (object) {
                            _contents.put(uRL, timedEntry);
                        }
                    }
                }
            }
            finally {
                if (bl) {
                    ((HttpURLConnection)uRLConnection).disconnect();
                }
                CtcHttpRetriever.putHostLock(string, refCount);
            }
        }
        return (String)timedEntry.value();
    }

    public void transferContent(URL uRL, String string, DownloadState downloadState) throws IOException {
        this.transferContent(uRL, null, new FileOutputStream(string), downloadState);
    }

    public void transferContent(URL uRL, Class clazz, String string, DownloadState downloadState) throws FileNotFoundException, IOException, MalformedURLException {
        this.transferContent(uRL, clazz, null, new FileOutputStream(string), downloadState);
    }

    public int transferContent(URL uRL, String string, OutputStream outputStream, DownloadState downloadState) throws IOException, MalformedURLException {
        return this.transferContent(uRL, null, string, outputStream, downloadState);
    }

    private void setAuthorization(URLConnection uRLConnection, String string) {
        if (string != null) {
            int n;
            if (string.startsWith("|") && (n = string.indexOf("|", 1)) != -1) {
                uRLConnection.setRequestProperty("X-ONS-SESSION", string.substring(1, n));
                string = string.substring(n + 1);
            }
            uRLConnection.setRequestProperty("AUTHORIZATION", "Basic " + new BASE64Encoder().encode(string.getBytes()));
        }
    }

    private InputStream wrapStream(Class clazz, URLConnection uRLConnection, boolean bl) throws IOException {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(InputStream.class);
            return (InputStream)constructor.newInstance(CtcHttpRetriever.getInputStream(uRLConnection, bl));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Caught NoSuchMethodException wrapping  InputStream as a " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw new IOException("Caught IOException wrapping  InputStream as a " + string + ": " + throwable);
            }
            throw new IOException("Caught InvocationTargetException  wrapping InputStream as a " + string + ": " + throwable);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Caught InstantiationException wrapping  InputStream as a " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Caught IllegalAccessException wrapping  InputStream as a " + string);
        }
    }

    public static InputStream createTransferContentInputStream(URL uRL, DownloadState downloadState) throws FileNotFoundException, IOException, MalformedURLException {
        URLConnection uRLConnection;
        CtcHttpErrorInfo ctcHttpErrorInfo;
        InputStream inputStream;
        block7: {
            inputStream = null;
            ctcHttpErrorInfo = new CtcHttpErrorInfo(200, null);
            uRLConnection = CtcHttpRetriever.ctcURLConnection(uRL);
            uRLConnection.setUseCaches(false);
            try {
                inputStream = uRLConnection.getInputStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!(uRLConnection instanceof HttpURLConnection)) {
                    throw fileNotFoundException;
                }
                HttpResponseException httpResponseException = new HttpResponseException(uRL, new CtcHttpErrorInfo(404, "File not found"));
                httpResponseException.initCause(fileNotFoundException);
                throw httpResponseException;
            }
            catch (IOException iOException) {
                if (uRLConnection instanceof HttpURLConnection) break block7;
                throw iOException;
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            ctcHttpErrorInfo = CtcHttpRetriever.getCtcHttpErrorInfo((HttpURLConnection)uRLConnection);
            if (ctcHttpErrorInfo.httpStatusCode() != 200) {
                throw new HttpResponseException(uRL, ctcHttpErrorInfo);
            }
            long l = uRLConnection.getContentLength();
            if (downloadState != null) {
                downloadState.setMaximum(l);
            }
        }
        return new URLConnectionInputStream(uRLConnection, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transferContent(URL uRL, Class clazz, String string, OutputStream outputStream, DownloadState downloadState) throws IOException, MalformedURLException {
        InputStream inputStream = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = 1;
        CtcHttpErrorInfo ctcHttpErrorInfo = new CtcHttpErrorInfo(200, null);
        URLConnection uRLConnection = null;
        boolean bl = false;
        try {
            uRLConnection = CtcHttpRetriever.ctcURLConnection(uRL);
            bl = uRLConnection instanceof HttpURLConnection;
            uRLConnection.setUseCaches(false);
            string = this.setDbTypes(uRLConnection, string);
            this.setAuthorization(uRLConnection, string);
            if (clazz != null) {
                inputStream = this.wrapStream(clazz, uRLConnection, bl);
                n2 = 4;
            } else {
                inputStream = CtcHttpRetriever.getInputStream(uRLConnection, bl);
            }
            if (bl) {
                ctcHttpErrorInfo = CtcHttpRetriever.getCtcHttpErrorInfo((HttpURLConnection)uRLConnection);
            }
            if (ctcHttpErrorInfo.httpStatusCode() == 200) {
                long l = uRLConnection.getContentLength();
                if (db.on()) {
                    db.println("Content Length is " + l);
                }
                if (l > 0L) {
                    downloadState.setMaximum(l * (long)n2);
                } else if (string != null) {
                    downloadState.setMaximum(256000L);
                }
                n = inputStream.read(byArray, 0, byArray.length);
                while (!this.aborted() && n > 0) {
                    outputStream.write(byArray, 0, n);
                    downloadState.doStep(n);
                    n = inputStream.read(byArray, 0, byArray.length);
                }
                if (this.aborted()) {
                    ctcHttpErrorInfo.httpStatusCode(1001);
                    ctcHttpErrorInfo.httpResponseMsg("aborted");
                } else if (string == null) {
                    downloadState.doFinalStep();
                } else if (downloadState.doFinalStep(l) != 0) {
                    ctcHttpErrorInfo.httpStatusCode(1001);
                    ctcHttpErrorInfo.httpResponseMsg("incomplete transfer");
                }
            }
            int n3 = this.getExpectedErrorCode(ctcHttpErrorInfo);
            return n3;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (bl) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
            if (inputStream != null && clazz != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimedEntry getCachedSupports(URL uRL) {
        HashMap hashMap = _supports;
        synchronized (hashMap) {
            TimedEntry timedEntry = (TimedEntry)_supports.get(uRL);
            if (timedEntry != null) {
                if (timedEntry.expired()) {
                    _supports.remove(uRL);
                    timedEntry = null;
                } else if (db.on()) {
                    db.println("using cache for " + uRL + " supports => " + timedEntry.value());
                }
            }
            return timedEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimedEntry putCachedSupports(URL uRL, Boolean bl) {
        TimedEntry timedEntry = new TimedEntry(bl);
        HashMap hashMap = _supports;
        synchronized (hashMap) {
            _supports.put(uRL, timedEntry);
        }
        return timedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supports(URL uRL, String string) {
        TimedEntry timedEntry;
        String string2 = uRL.getHost();
        RefCount refCount = CtcHttpRetriever.getHostLock(string2);
        CtcHttpErrorInfo ctcHttpErrorInfo = new CtcHttpErrorInfo(200, null);
        URLConnection uRLConnection = null;
        boolean bl = false;
        InputStream inputStream = null;
        try {
            RefCount refCount2 = refCount;
            synchronized (refCount2) {
                timedEntry = CtcHttpRetriever.getCachedSupports(uRL);
                if (timedEntry == null) {
                    boolean bl2 = false;
                    try {
                        uRLConnection = CtcHttpRetriever.ctcURLConnection(uRL);
                        bl = uRLConnection instanceof HttpURLConnection;
                        uRLConnection.setUseCaches(false);
                        string = this.setDbTypes(uRLConnection, string);
                        this.setAuthorization(uRLConnection, string);
                        inputStream = CtcHttpRetriever.getInputStream(uRLConnection, bl);
                        if (bl) {
                            ctcHttpErrorInfo = CtcHttpRetriever.getCtcHttpErrorInfo((HttpURLConnection)uRLConnection);
                        }
                        bl2 = ctcHttpErrorInfo.httpStatusCode() == 200;
                    }
                    catch (IOException iOException) {
                        db.println("supports(" + uRL + "): " + iOException);
                        bl2 = false;
                    }
                    timedEntry = CtcHttpRetriever.putCachedSupports(uRL, new Boolean(bl2));
                    if (db.on()) {
                        db.println("supports(" + uRL + ") => " + timedEntry.value());
                    }
                }
            }
        }
        finally {
            if (bl) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
            CtcHttpRetriever.putHostLock(string2, refCount);
        }
        return (Boolean)timedEntry.value();
    }

    private String setDbTypes(URLConnection uRLConnection, String string) {
        String string2 = string;
        int n = -1;
        if (string != null) {
            String string3;
            int n2;
            n = string.indexOf("?");
            if (n != -1 && (n2 = string.indexOf("?", n + 1)) != -1) {
                string3 = string.substring(n + 1, n2);
                uRLConnection.setRequestProperty("X-ONS-DATABASE", string3);
                string2 = string.substring(0, n) + string.substring(n2 + 1);
            }
            if ((n = string.indexOf("#")) != -1 && (n2 = string.indexOf("#", n + 1)) != -1) {
                string3 = string.substring(n + 1, n2);
                uRLConnection.setRequestProperty("X-COMPLETE-DATABASE", string3);
                string2 = string.substring(0, n) + string.substring(n2 + 1);
            }
        }
        return string2;
    }

    private boolean isContinueOrOk(CtcHttpErrorInfo ctcHttpErrorInfo) {
        int n = ctcHttpErrorInfo.httpStatusCode();
        return n == 100 || n == 200;
    }

    private boolean isContinue(CtcHttpErrorInfo ctcHttpErrorInfo) {
        return ctcHttpErrorInfo.httpStatusCode() == 100;
    }

    private static BufferedReader getReader(InputStream inputStream, MimeHeader mimeHeader) throws IOException {
        return new BufferedReader(new InputStreamReader(new ChunkedInputStream(inputStream, mimeHeader)));
    }

    private boolean isProgressLine(String string) {
        return string != null && string.indexOf("- ") == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readChunked(InputStream inputStream, MimeHeader mimeHeader, DownloadState downloadState, CtcHttpErrorInfo ctcHttpErrorInfo) throws IOException {
        BufferedReader bufferedReader = null;
        long l = 0L;
        if (db.on()) {
            db.println("handling chunked encoding");
        }
        mimeHeader.reset();
        try {
            bufferedReader = CtcHttpRetriever.getReader(inputStream, mimeHeader);
            String string = bufferedReader.readLine();
            if (this.isProgressLine(string)) {
                l = CtcHttpRetriever.getNumber(string, 0);
                downloadState.reset("copying to stby", l);
                while (!this.aborted() && this.isProgressLine(string = bufferedReader.readLine())) {
                    downloadState.doStep(1L);
                }
            } else if (db.on()) {
                db.println("no copy to standby");
            }
            ctcHttpErrorInfo.httpStatusCode(CtcHttpRetriever.getErrorNumber(string, 1001));
            ctcHttpErrorInfo.httpResponseMsg(string);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return l;
    }

    private long readNonChunked(InputStream inputStream, MimeHeader mimeHeader, DownloadState downloadState, CtcHttpErrorInfo ctcHttpErrorInfo) throws IOException {
        long l = 0L;
        if (db.on()) {
            db.println("reading non-chunked encoding");
        }
        if (this.isContinue(ctcHttpErrorInfo)) {
            String string = CtcHttpRetriever.readNonChunkedBody(inputStream, mimeHeader.getContentLength());
            l = CtcHttpRetriever.getNumber(string, 0);
            downloadState.reset("copying to stby", l);
            while (!this.aborted()) {
                this.getCtcHttpErrorInfo(mimeHeader, inputStream, ctcHttpErrorInfo);
                if (this.isContinue(ctcHttpErrorInfo)) {
                    CtcHttpRetriever.readNonChunkedBody(inputStream, mimeHeader.getContentLength());
                    downloadState.doStep(1L);
                    continue;
                }
                break;
            }
        } else if (db.on()) {
            db.println("no copy to standby");
        }
        return l;
    }

    private void writeData(MimeHeader mimeHeader, InputStream inputStream, long l, DownloadState downloadState, InputStream inputStream2, PrintStream printStream) throws IOException {
        byte[] byArray = new byte[1024];
        mimeHeader.setProperty("X-ONS-ENCODING", "chunked");
        mimeHeader.generateRequest(printStream);
        downloadState.setMaximum(l);
        while (l > 0L) {
            int n = (long)byArray.length < l ? byArray.length : (int)l;
            int n2 = inputStream.read(byArray, 0, n);
            if (n2 <= 0) {
                if (!db.on()) break;
                db.println("nread => " + n2);
                break;
            }
            printStream.write(byArray, 0, n2);
            if (printStream.checkError()) {
                if (!db.on()) break;
                db.println("output stream error!");
                break;
            }
            if (this.aborted()) {
                if (!db.on()) break;
                db.println("aborted!");
                break;
            }
            if (inputStream2.available() > 0) {
                if (!db.on()) break;
                db.println("is.available() => " + inputStream2.available());
                break;
            }
            l -= (long)n2;
            downloadState.doStep(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transferContent(URL uRL, String string, InputStream inputStream, long l, DownloadState downloadState) throws IOException {
        InputStream inputStream2 = null;
        PrintStream printStream = null;
        CtcHttpErrorInfo ctcHttpErrorInfo = new CtcHttpErrorInfo(200, null);
        CtcHttpURLConnection ctcHttpURLConnection = null;
        try {
            ctcHttpURLConnection = (CtcHttpURLConnection)CtcHttpRetriever.ctcURLConnection(uRL);
            ctcHttpURLConnection.setSoTimeout(0);
            ctcHttpURLConnection.setRequestMethod("POST");
            ctcHttpURLConnection.setRequestProperty("X-ONS-ENCODING", "chunked");
            string = this.setDbTypes(ctcHttpURLConnection, string);
            this.setAuthorization(ctcHttpURLConnection, string);
            ctcHttpURLConnection.setDoOutput(true);
            CtcHttpRetriever.getInputStream(ctcHttpURLConnection, true);
            ctcHttpErrorInfo = CtcHttpRetriever.getCtcHttpErrorInfo(ctcHttpURLConnection);
            inputStream2 = ctcHttpURLConnection.getStatusStream();
            printStream = ctcHttpURLConnection.getPrintStream();
            boolean bl = ctcHttpURLConnection.retain(db);
            if (db.on()) {
                db.println("Connection " + (bl ? "removed from cache" : "not in cache"));
            }
            if (this.isContinueOrOk(ctcHttpErrorInfo)) {
                MimeHeader mimeHeader = new MimeHeader("POST", uRL.getHost(), uRL.getFile(), "application/binary", l);
                this.writeData(mimeHeader, inputStream, l, downloadState, inputStream2, printStream);
                if (this.aborted() || printStream.checkError()) {
                    ctcHttpErrorInfo.httpStatusCode(1001);
                    ctcHttpErrorInfo.httpResponseMsg("aborted");
                    int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
                    return n;
                }
                printStream.flush();
                this.getCtcHttpErrorInfo(mimeHeader, inputStream2, ctcHttpErrorInfo);
                if (!this.isContinueOrOk(ctcHttpErrorInfo)) {
                    int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
                    return n;
                }
                if (downloadState.doFinalStep(l) != 0) {
                    ctcHttpErrorInfo.httpStatusCode(1001);
                    ctcHttpErrorInfo.httpResponseMsg("incomplete transfer");
                    int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
                    return n;
                }
                if (this.isContinueOrOk(ctcHttpErrorInfo)) {
                    String string2 = mimeHeader.getProperty("Transfer-Encoding");
                    l = string2 != null && string2.equalsIgnoreCase("chunked") ? this.readChunked(inputStream2, mimeHeader, downloadState, ctcHttpErrorInfo) : this.readNonChunked(inputStream2, mimeHeader, downloadState, ctcHttpErrorInfo);
                    if (db.on()) {
                        db.println("len=" + l + " err=" + ctcHttpErrorInfo);
                    }
                    if (this.aborted()) {
                        ctcHttpErrorInfo.httpStatusCode(1001);
                        ctcHttpErrorInfo.httpResponseMsg("aborted");
                        int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
                        return n;
                    }
                    if (this.isContinueOrOk(ctcHttpErrorInfo)) {
                        int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
                        return n;
                    }
                    if (downloadState.doFinalStep(l) != 0) {
                        ctcHttpErrorInfo.httpStatusCode(1001);
                        ctcHttpErrorInfo.httpResponseMsg("incomplete transfer");
                        int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
                        return n;
                    }
                }
            }
            int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
            return n;
        }
        finally {
            inputStream.close();
            if (ctcHttpURLConnection != null) {
                ctcHttpURLConnection.disconnect();
            }
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transferContent(URL uRL, String string) throws IOException {
        CtcHttpErrorInfo ctcHttpErrorInfo = new CtcHttpErrorInfo(200, null);
        URLConnection uRLConnection = null;
        boolean bl = false;
        try {
            uRLConnection = CtcHttpRetriever.ctcURLConnection(uRL);
            bl = uRLConnection instanceof HttpURLConnection;
            uRLConnection.setUseCaches(false);
            this.setAuthorization(uRLConnection, string);
            if (db.on()) {
                db.println("Sending request for activate/revert via HTTP...");
            }
            if (uRLConnection instanceof CtcHttpURLConnection) {
                ((CtcHttpURLConnection)uRLConnection).setSoTimeout(0);
            }
            CtcHttpRetriever.getInputStream(uRLConnection, bl);
            if (bl) {
                ctcHttpErrorInfo = CtcHttpRetriever.getCtcHttpErrorInfo((HttpURLConnection)uRLConnection);
            }
            int n = this.getExpectedErrorCode(ctcHttpErrorInfo);
            return n;
        }
        finally {
            if (bl) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
    }

    public static String version(String string) {
        String string2 = "99.99";
        int n = 5;
        if (string == null) {
            string2 = null;
        } else if (string.length() >= n && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1)) && string.charAt(2) == '.' && Character.isDigit(string.charAt(3)) && Character.isDigit(string.charAt(4))) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public boolean aborted() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    private int getExpectedErrorCode(CtcHttpErrorInfo ctcHttpErrorInfo) throws IOException {
        switch (ctcHttpErrorInfo.httpStatusCode()) {
            case -12400: 
            case -12300: 
            case -12200: 
            case -12100: 
            case -12000: 
            case -11100: 
            case -11000: 
            case -10900: 
            case -10800: 
            case -10700: 
            case -10600: 
            case -10500: 
            case -10400: 
            case -10300: 
            case -10200: 
            case -10100: 
            case -10000: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 1001: {
                if (db.on()) {
                    db.println("getExpectedErrorCode: " + ctcHttpErrorInfo + ", returning actual code");
                }
                return ctcHttpErrorInfo.httpStatusCode();
            }
            case -1: {
                if (db.on()) {
                    db.println("getExpectedErrorCode: " + ctcHttpErrorInfo + ", returning CONNECTION_REFUSED");
                }
                return 1002;
            }
            case 200: {
                if (db.on()) {
                    db.println("getExpectedErrorCode: " + ctcHttpErrorInfo + ", returning OK");
                }
                return 200;
            }
            case 400: {
                if (db.on()) {
                    db.println("getExpectedErrorCode: " + ctcHttpErrorInfo + ", returning BAD_REQUEST");
                }
                return 400;
            }
            case 401: {
                if (db.on()) {
                    db.println("getExpectedErrorCode: " + ctcHttpErrorInfo + ", returning UNAUTHORIZED");
                }
                return 401;
            }
            case 503: {
                if (db.on()) {
                    db.println("getExpectedErrorCode: " + ctcHttpErrorInfo + ", returning UNAVAILABLE");
                }
                return 503;
            }
        }
        if (db.on()) {
            db.println("getExpectedErrorCode:" + ctcHttpErrorInfo + ", throwing IOException");
        }
        throw new IOException(ctcHttpErrorInfo.httpResponseMsg());
    }

    private static int getErrorNumber(String string, int n) {
        int n2 = n;
        if (string.startsWith("ERROR -")) {
            n2 = CtcHttpRetriever.getNumber(string, n);
        } else if (string.startsWith("OK -")) {
            n2 = 200;
        }
        return n2;
    }

    private static int getNumber(String string, int n) {
        int n2 = n;
        if (string != null) {
            int n3;
            int n4;
            int n5 = string.length();
            for (n4 = 0; n4 < n5 && !Character.isDigit(string.charAt(n4)); ++n4) {
            }
            for (n3 = n4 + 1; n3 < n5 && Character.isDigit(string.charAt(n3)); ++n3) {
            }
            if (n4 < n5) {
                int n6 = n4 > 0 && string.charAt(n4 - 1) == '-' ? n4 - 1 : n4;
                n2 = Integer.parseInt(string.substring(n6, n3));
            } else if (string.startsWith("OK -")) {
                n2 = 200;
            }
        }
        return n2;
    }

    private static CtcHttpErrorInfo getCtcHttpErrorInfo(HttpURLConnection httpURLConnection) throws IOException {
        CtcHttpErrorInfo ctcHttpErrorInfo = new CtcHttpErrorInfo();
        if (httpURLConnection == null) {
            if (db.on()) {
                db.println("Could not set error info from c = " + httpURLConnection);
            }
            return ctcHttpErrorInfo;
        }
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            ctcHttpErrorInfo.httpResponseMsg(CtcHttpRetriever.read(httpURLConnection, httpURLConnection.getErrorStream(), (long)httpURLConnection.getContentLength()));
            ctcHttpErrorInfo.httpStatusCode(CtcHttpRetriever.getErrorNumber(ctcHttpErrorInfo.httpResponseMsg(), httpURLConnection.getResponseCode()));
            if (db.on()) {
                db.println("getErrorInfo responseCode " + n);
                db.println("getErrorInfo returning: " + ctcHttpErrorInfo);
            }
            return ctcHttpErrorInfo;
        }
        ctcHttpErrorInfo.httpStatusCode(n);
        int n2 = httpURLConnection.getContentLength();
        if (db.on()) {
            db.println("getErrorInfo content length " + n2);
        }
        if (n2 < -1) {
            MimeHeader mimeHeader = new MimeHeader();
            mimeHeader.read(CtcHttpRetriever.getInputStream(httpURLConnection, true));
            ctcHttpErrorInfo.httpResponseMsg(CtcHttpRetriever.read(mimeHeader, CtcHttpRetriever.getInputStream(httpURLConnection, true), mimeHeader.getContentLength()));
            ctcHttpErrorInfo.httpStatusCode(CtcHttpRetriever.getErrorNumber(ctcHttpErrorInfo.httpResponseMsg(), mimeHeader.getResponseCode()));
        }
        if (db.on()) {
            db.println("getErrorInfo returning: " + ctcHttpErrorInfo);
        }
        return ctcHttpErrorInfo;
    }

    private void getCtcHttpErrorInfo(MimeHeader mimeHeader, InputStream inputStream, CtcHttpErrorInfo ctcHttpErrorInfo) throws IOException {
        if (mimeHeader == null || inputStream == null) {
            if (db.on()) {
                db.println("Could not set error info from header = " + mimeHeader + " and is = " + inputStream);
            }
            return;
        }
        mimeHeader.read(inputStream);
        ctcHttpErrorInfo.httpStatusCode(mimeHeader.getResponseCode());
        if (!this.isContinueOrOk(ctcHttpErrorInfo)) {
            ctcHttpErrorInfo.httpResponseMsg(CtcHttpRetriever.read(mimeHeader, inputStream, mimeHeader.getContentLength()));
            ctcHttpErrorInfo.httpStatusCode(CtcHttpRetriever.getErrorNumber(ctcHttpErrorInfo.httpResponseMsg(), ctcHttpErrorInfo.httpStatusCode()));
        }
        if (db.on()) {
            db.println("getCtcHttpErrorInfo: " + ctcHttpErrorInfo);
        }
    }

    private static InputStream getInputStream(URLConnection uRLConnection, boolean bl) throws IOException {
        InputStream inputStream;
        block4: {
            inputStream = null;
            try {
                inputStream = uRLConnection.getInputStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Cannot get input stream for URL: " + uRLConnection.getURL());
            }
            catch (IOException iOException) {
                if (db.on()) {
                    db.println("getInputStream(" + bl + ") failed: " + iOException);
                }
                if (bl) break block4;
                throw iOException;
            }
        }
        return inputStream;
    }

    private static String read(MimeHeader mimeHeader, InputStream inputStream, long l) throws IOException {
        return CtcHttpRetriever.read(mimeHeader.getProperty("Transfer-Encoding"), inputStream, l);
    }

    private static String read(HttpURLConnection httpURLConnection, InputStream inputStream, long l) throws IOException {
        return CtcHttpRetriever.read(httpURLConnection.getHeaderField("Transfer-Encoding"), inputStream, l);
    }

    private static String read(String string, InputStream inputStream, long l) throws IOException {
        String string2 = string != null && string.equalsIgnoreCase("chunked") ? CtcHttpRetriever.readChunkedBody(inputStream) : CtcHttpRetriever.readNonChunkedBody(inputStream, l);
        return string2;
    }

    public static class Debug
    extends KDebug {
        public final String HpmStats = "retrieve pm stats";

        public Debug(String string) {
            super(string);
        }

        public final void pmStats(String string, int n, int n2, String string2) throws IOException {
            Interval interval = null;
            if (n == 0) {
                interval = Interval.PM15MIN;
            } else if (n == 1) {
                interval = Interval.PMDAY;
            }
            CtcHttpErrorInfo ctcHttpErrorInfo = CtcHttpRetriever.getPMStats(string, interval, n2, string2);
            this.println("Error code: " + new Integer(ctcHttpErrorInfo.httpStatusCode()).toString());
            this.println("Http Response: ");
            this.println(ctcHttpErrorInfo.httpResponseMsg());
        }

        public final void pmStats(String string, int n, int n2) throws IOException {
            Interval interval = null;
            if (n == 0) {
                interval = Interval.PM15MIN;
            } else if (n == 1) {
                interval = Interval.PMDAY;
            }
            CtcHttpErrorInfo ctcHttpErrorInfo = CtcHttpRetriever.getPMStats(string, interval, n2, null);
            this.println("Error code: " + new Integer(ctcHttpErrorInfo.httpStatusCode()).toString());
            this.println("Http Response: ");
            this.println(ctcHttpErrorInfo.httpResponseMsg());
        }

        public final void getNodeId(String string) throws IOException {
            String string2 = CtcHttpRetriever.getNodeId(string);
            this.println("Node Id: " + string2);
        }

        public final void listSecureNodes() {
            Iterator iterator = secureNodes.iterator();
            this.println("Secure Nodes");
            this.println("============");
            while (iterator.hasNext()) {
                this.println((String)iterator.next());
            }
            this.println("");
        }

        public final void setNodeSecure(String string) {
            CtcHttpRetriever.addSecureNode(string);
        }

        public final void setNodeNonSecure(String string) {
            CtcHttpRetriever.removeSecureNode(string);
        }
    }

    public static class Interval {
        private final String name;
        private final int value;
        public static final int _PM15MIN = 0;
        public static final Interval PM15MIN = new Interval("15min", 0);
        public static final int _PMDAY = 1;
        public static final Interval PMDAY = new Interval("day", 1);

        private Interval(String string, int n) {
            this.name = string;
            this.value = n;
        }

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }
    }

    public static class URLConnectionInputStream
    extends InputStream {
        private URLConnection conn;
        private InputStream is;

        public URLConnectionInputStream(URLConnection uRLConnection, InputStream inputStream) {
            this.conn = uRLConnection;
            this.is = inputStream;
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
            if (this.conn instanceof HttpURLConnection) {
                ((HttpURLConnection)this.conn).disconnect();
            }
        }

        public void mark(int n) {
            this.is.mark(n);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.is.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.is.read(byArray, n, n2);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long l) throws IOException {
            return this.is.skip(l);
        }
    }

    private static class TimedEntry {
        private Object _value;
        private long _lastUpdated;

        public TimedEntry(Object object) {
            this._value = object;
            this._lastUpdated = System.currentTimeMillis();
        }

        public boolean expired() {
            return System.currentTimeMillis() > this._lastUpdated + 60000L;
        }

        public Object value() {
            return this._value;
        }
    }

    private static class RefCount {
        private int _count = 0;

        public void reference() {
            ++this._count;
        }

        public int dereference() {
            return --this._count;
        }
    }
}

